/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.api.TechLevel;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;
import net.minecraftforge.common.ToolType;

public class TechPropBuilder {
    public TechLevel techLevel;
    public int miningLevel;
    private int maxStackSize = 64;
    private int maxDamage;
    private Item containerItem;
    private ItemGroup group;
    private Rarity rarity = Rarity.COMMON;
    private Food food;
    private boolean canRepair = true;
    private Map<ToolType, Integer> toolClasses = Maps.newHashMap();
    private Supplier<Callable<ItemStackTileEntityRenderer>> ister;

    public TechPropBuilder(TechLevel techLevel) {
        this.techLevel = techLevel;
        this.miningLevel = techLevel.getHarvestLevel();
    }

    public TechPropBuilder food(Food foodIn) {
        this.food = foodIn;
        return this;
    }

    public TechPropBuilder maxStackSize(int maxStackSizeIn) {
        if (this.maxDamage > 0) {
            throw new RuntimeException("Unable to have damage AND stack.");
        }
        this.maxStackSize = maxStackSizeIn;
        return this;
    }

    public TechPropBuilder defaultMaxDamage(int maxDamageIn) {
        return this.maxDamage == 0 ? this.maxDamage(maxDamageIn) : this;
    }

    public TechPropBuilder maxDamage(int maxDamageIn) {
        this.maxDamage = maxDamageIn;
        this.maxStackSize = 1;
        return this;
    }

    public TechPropBuilder containerItem(Item containerItemIn) {
        this.containerItem = containerItemIn;
        return this;
    }

    public TechPropBuilder group(ItemGroup groupIn) {
        this.group = groupIn;
        return this;
    }

    public TechPropBuilder rarity(Rarity rarityIn) {
        this.rarity = rarityIn;
        return this;
    }

    public TechPropBuilder setNoRepair() {
        this.canRepair = false;
        return this;
    }

    public TechPropBuilder addToolType(ToolType type, int level) {
        this.toolClasses.put(type, level);
        return this;
    }

    public TechPropBuilder setISTER(Supplier<Callable<ItemStackTileEntityRenderer>> ister) {
        this.ister = ister;
        return this;
    }

    public Item.Properties build() {
        Item.Properties props = new Item.Properties();
        props.func_221540_a(this.food);
        props.func_200916_a(this.group);
        props.func_200918_c(this.maxDamage);
        props.func_208103_a(this.rarity);
        if (!this.canRepair) {
            props.setNoRepair();
        }
        props.setISTER(this.ister);
        this.toolClasses.forEach((arg_0, arg_1) -> ((Item.Properties)props).addToolType(arg_0, arg_1));
        props.func_200919_a(this.containerItem);
        props.func_200917_a(this.maxStackSize);
        return props;
    }

    public Item.Properties pickaxeProps() {
        return this.build().addToolType(ToolType.PICKAXE, this.miningLevel).func_234689_a_();
    }

    public Item.Properties axeProps() {
        return this.build().addToolType(ToolType.AXE, this.miningLevel).func_234689_a_();
    }

    public Item.Properties shovelProps() {
        return this.build().addToolType(ToolType.SHOVEL, this.miningLevel).func_234689_a_();
    }

    public Item.Properties staffProps() {
        return this.build().addToolType(ToolType.PICKAXE, this.miningLevel).addToolType(ToolType.AXE, this.miningLevel).addToolType(ToolType.SHOVEL, this.miningLevel).func_234689_a_();
    }
}

