/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.lib.DLResourceLocation;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;

public class ThreadedImageDownloader
extends SimpleTexture {
    private static final Logger LOGGER = LogHelperBC.logger;
    private DLResourceLocation dlLocation = null;
    @Nullable
    private final File cacheFile;
    private final String imageUrl;
    @Nullable
    private CompletableFuture<?> future;
    private boolean textureUploaded;

    public ThreadedImageDownloader(File cacheFile, String imageUrl, DLResourceLocation textureLocation) {
        super((ResourceLocation)textureLocation);
        this.cacheFile = cacheFile;
        this.imageUrl = imageUrl;
    }

    public void setDlLocation(DLResourceLocation dlLocation) {
        this.dlLocation = dlLocation;
    }

    private void upload(NativeImage imageIn) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
        imageIn.func_195697_a(0, 0, 0, true);
    }

    private void setImage(NativeImage nativeImageIn) {
        Minecraft.func_71410_x().execute(() -> {
            this.textureUploaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(nativeImageIn));
            } else {
                this.upload(nativeImageIn);
            }
        });
        this.dlLocation.width = nativeImageIn.func_195702_a();
        this.dlLocation.height = nativeImageIn.func_195714_b();
        this.dlLocation.sizeSet = true;
        this.dlLocation.dlFailed = false;
        this.dlLocation.dlFinished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195413_a(IResourceManager manager) throws IOException {
        if (!this.textureUploaded) {
            ThreadedImageDownloader threadedImageDownloader = this;
            synchronized (threadedImageDownloader) {
                super.func_195413_a(manager);
                this.textureUploaded = true;
            }
        }
        if (this.future == null) {
            NativeImage nativeimage;
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", (Object)this.cacheFile);
                FileInputStream fileinputstream = new FileInputStream(this.cacheFile);
                nativeimage = this.loadTexture(fileinputstream);
            } else {
                nativeimage = null;
            }
            if (nativeimage != null) {
                this.setImage(nativeimage);
            } else {
                this.future = CompletableFuture.runAsync(() -> {
                    HttpURLConnection httpurlconnection = null;
                    LOGGER.debug("Downloading http texture from {} to {}", (Object)this.imageUrl, (Object)this.cacheFile);
                    try {
                        httpurlconnection = (HttpURLConnection)new URL(this.imageUrl).openConnection(Minecraft.func_71410_x().func_110437_J());
                        httpurlconnection.setDoInput(true);
                        httpurlconnection.setDoOutput(false);
                        httpurlconnection.connect();
                        if (httpurlconnection.getResponseCode() / 100 == 2) {
                            InputStream inputstream;
                            if (this.cacheFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)this.cacheFile);
                                inputstream = new FileInputStream(this.cacheFile);
                            } else {
                                inputstream = httpurlconnection.getInputStream();
                            }
                            Minecraft.func_71410_x().execute(() -> {
                                NativeImage nativeimage1 = this.loadTexture(inputstream);
                                if (nativeimage1 != null) {
                                    this.setImage(nativeimage1);
                                }
                            });
                            return;
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Couldn't download http texture", (Throwable)exception);
                        return;
                    }
                    finally {
                        if (httpurlconnection != null) {
                            httpurlconnection.disconnect();
                        }
                    }
                }, Util.func_215072_e());
            }
        }
    }

    @Nullable
    private NativeImage loadTexture(InputStream inputStreamIn) {
        NativeImage nativeimage = null;
        try {
            nativeimage = NativeImage.func_195713_a((InputStream)inputStreamIn);
        }
        catch (IOException ioexception) {
            LOGGER.warn("Error while loading the skin texture", (Throwable)ioexception);
        }
        return nativeimage;
    }
}

