/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IDataManager;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class AbstractManagedData<T>
implements IManagedData {
    private boolean isDirty = true;
    protected int index = 0;
    protected String name = "";
    protected DataFlags flags = DataFlags.NONE;
    protected IDataManager dataManager;
    protected boolean ccscsFlag = false;
    protected List<Consumer<T>> valueListeners = new ArrayList<Consumer<T>>();

    public AbstractManagedData(String name, DataFlags ... flags) {
        this.name = name;
        if (flags.length > 0) {
            this.flags = flags.length == 1 ? flags[0] : new DataFlags(flags);
        }
    }

    @Override
    public void init(IDataManager dataManager, int index) {
        this.dataManager = dataManager;
        this.index = index;
    }

    public void addFlags(DataFlags ... newFlags) {
        this.flags = new DataFlags(this.flags, newFlags);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void markDirty() {
        this.validate();
        this.isDirty = true;
        this.dataManager.markDirty();
    }

    @Override
    public boolean isDirty(boolean reset) {
        boolean ret = this.isDirty;
        if (reset) {
            this.isDirty = false;
        }
        return ret;
    }

    @Override
    public IDataManager getDataManager() {
        return this.dataManager;
    }

    @Override
    public DataFlags flags() {
        return this.flags;
    }

    public void setCCSCS() {
        this.ccscsFlag = true;
    }

    public void addValueListener(Consumer<T> listener) {
        this.valueListeners.add(listener);
    }

    public void removeValueListener(Consumer<T> listener) {
        this.valueListeners.remove(listener);
    }

    protected void notifyListeners(T newValue) {
        this.valueListeners.forEach(listener -> listener.accept(newValue));
    }
}

