/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;

public class ManagedByte
extends AbstractManagedData<Byte> {
    private byte value;
    protected Function<Byte, Byte> validator = null;

    public ManagedByte(String name, byte defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
    }

    public ManagedByte(String name, DataFlags ... flags) {
        this(name, 0, flags);
    }

    public byte set(byte value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            byte prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public byte get() {
        return this.value;
    }

    public ManagedByte setValidator(Function<Byte, Byte> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeByte((int)this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readByte();
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundNBT compound) {
        compound.func_74774_a(this.name, this.value);
    }

    @Override
    public void fromNBT(CompoundNBT compound) {
        this.value = compound.func_74771_c(this.name);
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }

    public byte add(byte add) {
        return this.set((byte)(this.get() + add));
    }

    public byte subtract(byte subtract) {
        return this.set((byte)(this.get() - subtract));
    }

    public byte multiply(byte multiplyBy) {
        return this.set((byte)(this.get() * multiplyBy));
    }

    public byte divide(byte divideBy) {
        return this.set((byte)(this.get() / divideBy));
    }

    public byte zero() {
        return this.set((byte)0);
    }

    public byte inc() {
        return this.add((byte)1);
    }

    public byte dec() {
        return this.subtract((byte)1);
    }
}

