/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class ManagedPos
extends AbstractManagedData<BlockPos> {
    private BlockPos value;
    private BlockPos lastValue;
    protected Function<BlockPos, BlockPos> validator = null;

    public ManagedPos(String name, BlockPos defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.lastValue = new BlockPos((Vector3i)this.value);
    }

    public ManagedPos(String name, DataFlags ... flags) {
        this(name, BlockPos.field_177992_a, flags);
    }

    public BlockPos set(BlockPos value) {
        if (!this.value.equals((Object)value)) {
            boolean set = true;
            BlockPos prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.lastValue = new BlockPos((Vector3i)prev);
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public BlockPos get() {
        return this.value;
    }

    public ManagedPos setValidator(Function<BlockPos, BlockPos> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public boolean isDirty(boolean reset) {
        if (this.lastValue != null && !this.lastValue.equals((Object)this.value)) {
            if (reset) {
                this.lastValue = new BlockPos((Vector3i)this.value);
            }
            return true;
        }
        return super.isDirty(reset);
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writePos(this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readPos();
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundNBT compound) {
        compound.func_218657_a(this.name, (INBT)NBTUtil.func_186859_a((BlockPos)this.value));
    }

    @Override
    public void fromNBT(CompoundNBT compound) {
        this.value = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l(this.name));
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }
}

