/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.functions.TriPredicate;
import com.brandon3055.brandonscore.utils.DataUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InventoryUtils {
    public static boolean hasStack(ItemStack stack, IInventory inventory) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack s = inventory.func_70301_a(i);
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)s) || stack.func_77952_i() != s.func_77952_i() || s.func_190916_E() < stack.func_190916_E()) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeStack(ItemStack stack, IInventory inventory) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack s = inventory.func_70301_a(i);
            if (s.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)s) || stack.func_77952_i() != s.func_77952_i() || s.func_190916_E() < stack.func_190916_E()) continue;
            s.func_190918_g(stack.func_190916_E());
            inventory.func_70296_d();
            return true;
        }
        return false;
    }

    public static void handleHeldStackTransfer(int slot, IInventory inventory, PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!inventory.func_70301_a(slot).func_190926_b()) {
            if (player.func_184614_ca().func_190926_b()) {
                player.func_184611_a(Hand.MAIN_HAND, inventory.func_70301_a(slot));
            } else {
                InventoryUtils.givePlayerStack(player, inventory.func_70301_a(slot));
            }
            inventory.func_70299_a(slot, ItemStack.field_190927_a);
        } else {
            DataUtils.forEach(Hand.values(), enumHand -> {
                ItemStack stack = player.func_184586_b(enumHand);
                if (!stack.func_190926_b() && inventory.func_94041_b(slot, stack) && inventory.func_70301_a(slot).func_190926_b()) {
                    inventory.func_70299_a(slot, stack);
                    player.func_184611_a(enumHand, ItemStack.field_190927_a);
                }
            });
        }
    }

    public static void handleHeldStackTransfer(int slot, IItemHandlerModifiable inventory, PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!inventory.getStackInSlot(slot).func_190926_b()) {
            if (player.func_184614_ca().func_190926_b()) {
                player.func_184611_a(Hand.MAIN_HAND, inventory.getStackInSlot(slot));
            } else {
                InventoryUtils.givePlayerStack(player, inventory.getStackInSlot(slot));
            }
            inventory.setStackInSlot(slot, ItemStack.field_190927_a);
        } else {
            DataUtils.forEach(Hand.values(), enumHand -> {
                ItemStack stack = player.func_184586_b(enumHand);
                if (!stack.func_190926_b() && inventory.isItemValid(slot, stack) && inventory.getStackInSlot(slot).func_190926_b()) {
                    inventory.setStackInSlot(slot, stack);
                    player.func_184611_a(enumHand, ItemStack.field_190927_a);
                }
            });
        }
    }

    public static void consumeHeldItem(PlayerEntity player, ItemStack stack, Hand hand) {
        stack.func_190918_g(1);
        player.func_184611_a(hand, stack.func_190916_E() > 0 ? stack.func_77946_l() : ItemStack.field_190927_a);
    }

    public static void givePlayerStack(PlayerEntity player, ItemStack stack) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        player.field_71071_by.func_70441_a(stack);
        if (stack.func_190916_E() > 0) {
            InventoryUtils.dropItemNoDelay(stack, player.field_70170_p, Vector3.fromEntity((Entity)player));
        }
    }

    public static void dropItemNoDelay(ItemStack stack, World world, Vector3 dropLocation) {
        ItemEntity item = new ItemEntity(world, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.func_213293_j(world.field_73012_v.nextGaussian() * 0.05, world.field_73012_v.nextGaussian() * 0.05 + (double)0.2f, world.field_73012_v.nextGaussian() * 0.05);
        world.func_217376_c((Entity)item);
        item.func_174867_a(0);
    }

    public static int findMatchingStack(IItemHandler itemHandler, TriPredicate<IItemHandler, ItemStack, Integer> predicate) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!predicate.test(itemHandler, itemHandler.getStackInSlot(i), i)) continue;
            return i;
        }
        return -1;
    }
}

