/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.TeleportUtils;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class TargetPos {
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private boolean includeHeading = true;
    private RegistryKey<World> dimension;

    public TargetPos() {
    }

    public TargetPos(Entity entity) {
        this(entity, true);
    }

    public TargetPos(CompoundNBT nbt) {
        this.readFromNBT(nbt);
    }

    public TargetPos(Entity entity, boolean includeHeading) {
        this.update(entity);
        this.includeHeading = includeHeading;
    }

    public TargetPos(double x, double y, double z, RegistryKey<World> dimension) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
        this.pitch = 0.0f;
        this.yaw = 0.0f;
    }

    public TargetPos(double x, double y, double z, RegistryKey<World> dimension, float pitch, float yaw) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public void update(Entity player) {
        this.x = player.func_226277_ct_();
        this.y = player.func_226278_cu_();
        this.z = player.func_226281_cx_();
        this.dimension = player.field_70170_p.func_234923_W_();
        this.pitch = player.field_70125_A;
        this.yaw = player.field_70177_z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public String getReadableName(boolean fullDim) {
        return "X: " + (int)Math.floor(this.x) + ", Y: " + (int)Math.floor(this.y) + ", Z: " + (int)Math.floor(this.z) + ", " + (fullDim ? this.dimension.func_240901_a_() : this.dimension.func_240901_a_().func_110623_a());
    }

    public TargetPos setIncludeHeading(boolean includeHeading) {
        this.includeHeading = includeHeading;
        return this;
    }

    public TargetPos setX(double x) {
        this.x = x;
        return this;
    }

    public TargetPos setY(double y) {
        this.y = y;
        return this;
    }

    public TargetPos setZ(double z) {
        this.z = z;
        return this;
    }

    public TargetPos setDimension(RegistryKey<World> d) {
        this.dimension = d;
        return this;
    }

    public TargetPos setPitch(float p) {
        this.pitch = p;
        return this;
    }

    public TargetPos setYaw(float y) {
        this.yaw = y;
        return this;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        nbt.func_74780_a("x", this.x);
        nbt.func_74780_a("y", this.y);
        nbt.func_74780_a("z", this.z);
        nbt.func_74778_a("dim", this.dimension.func_240901_a_().toString());
        nbt.func_74757_a("heading", this.includeHeading);
        if (this.includeHeading) {
            nbt.func_74776_a("pitch", this.pitch);
            nbt.func_74776_a("yaw", this.yaw);
        }
        return nbt;
    }

    public CompoundNBT writeToNBT() {
        return this.writeToNBT(new CompoundNBT());
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.x = nbt.func_74769_h("x");
        this.y = nbt.func_74769_h("y");
        this.z = nbt.func_74769_h("z");
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("dim")));
        this.includeHeading = nbt.func_74767_n("heading");
        if (this.includeHeading) {
            this.pitch = nbt.func_74760_g("pitch");
            this.yaw = nbt.func_74760_g("yaw");
        }
    }

    public void write(MCDataOutput output) {
        output.writeDouble(this.x);
        output.writeDouble(this.y);
        output.writeDouble(this.z);
        output.writeResourceLocation(this.dimension.func_240901_a_());
        output.writeBoolean(this.includeHeading);
        if (this.includeHeading) {
            output.writeFloat(this.pitch);
            output.writeFloat(this.yaw);
        }
    }

    public void read(MCDataInput input) {
        this.x = input.readDouble();
        this.y = input.readDouble();
        this.z = input.readDouble();
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)input.readResourceLocation());
        this.includeHeading = input.readBoolean();
        if (this.includeHeading) {
            this.pitch = input.readFloat();
            this.yaw = input.readFloat();
        }
    }

    public Entity teleport(Entity entity) {
        if (this.includeHeading) {
            return TeleportUtils.teleportEntity(entity, this.dimension, this.x, this.y, this.z, this.yaw, this.pitch);
        }
        return TeleportUtils.teleportEntity(entity, this.dimension, this.x, this.y, this.z);
    }
}

