/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.net.URI;
import java.text.DecimalFormat;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class Utils {
    public static final String SELECT = "\u00a7";
    private static DecimalFormat energyValue = new DecimalFormat("###,###,###,###,###");
    private static BiMap<Block, Fluid> fluidBlocks = null;

    public static String formatNumber(double value) {
        if (value < 1000.0) {
            return String.valueOf(value);
        }
        if (value < 1000000.0) {
            return Utils.addCommas((int)value);
        }
        if (value < 1.0E9) {
            return String.valueOf((double)Math.round(value / 1000.0) / 1000.0) + "M";
        }
        if (value < 1.0E12) {
            return String.valueOf((double)Math.round(value / 1000000.0) / 1000.0) + "B";
        }
        return String.valueOf((double)Math.round(value / 1.0E9) / 1000.0) + "T";
    }

    public static String formatNumber(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        if (value < 1000000L) {
            return Utils.addCommas(value);
        }
        if (value < 1000000000L) {
            return String.valueOf((double)Math.round(value / 100000L) / 10.0) + "M";
        }
        if (value < 1000000000000L) {
            return String.valueOf((double)Math.round(value / 100000000L) / 10.0) + "G";
        }
        if (value < 1000000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000000L) / 1000.0) + "T";
        }
        if (value < 1000000000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000000000L) / 1000.0) + "P";
        }
        if (value <= Long.MAX_VALUE) {
            return String.valueOf((double)Math.round(value / 1000000000000000L) / 1000.0) + "E";
        }
        return "Something is very broken!!!!";
    }

    public static String addCommas(int value) {
        return energyValue.format(value);
    }

    public static String addCommas(long value) {
        return energyValue.format(value);
    }

    public static double getDistanceAtoB(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double getDistanceAtoB(Vec3D pos1, Vec3D pos2) {
        return Utils.getDistanceAtoB(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z);
    }

    public static int getCardinalDistance(BlockPos pos1, BlockPos pos2) {
        int x = Math.abs(pos2.func_177958_n() - pos1.func_177958_n());
        int y = Math.abs(pos2.func_177956_o() - pos1.func_177956_o());
        int z = Math.abs(pos2.func_177952_p() - pos1.func_177952_p());
        return Math.max(Math.max(x, y), z);
    }

    public static boolean inRangeSphere(BlockPos posA, BlockPos posB, int range) {
        if (Math.abs(posA.func_177958_n() - posB.func_177958_n()) > range || Math.abs(posA.func_177956_o() - posB.func_177956_o()) > range || Math.abs(posA.func_177952_p() - posB.func_177952_p()) > range) {
            return false;
        }
        return Utils.getDistanceSq(posA.func_177958_n(), posA.func_177956_o(), posA.func_177952_p(), posB.func_177958_n(), posB.func_177956_o(), posB.func_177952_p()) <= (double)(range * range);
    }

    public static double getDistanceAtoB(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double getDistanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double getDistanceSq(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return dx * dx + dz * dz;
    }

    public static int determineOrientation(int x, int y, int z, LivingEntity entity) {
        int l;
        if (MathHelper.func_76135_e((float)((float)entity.func_226277_ct_() - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.func_226281_cx_() - (float)z)) < 2.0f) {
            double d0 = entity.func_226278_cu_() + 1.82 - entity.func_70033_W();
            if (d0 - (double)y > 2.0) {
                return 0;
            }
            if ((double)y - d0 > 0.0) {
                return 1;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 3 : (l == 1 ? 4 : (l == 2 ? 2 : (l == 3 ? 5 : 0)));
    }

    public static int toInt(double d) {
        return (int)d;
    }

    public static int parseInt(String s) {
        return Utils.parseInt(s, true);
    }

    public static int parseInt(String s, boolean catchException) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            if (catchException) {
                return 0;
            }
            throw e;
        }
    }

    public static double parseDouble(String s, boolean catchException) {
        if (s == null || s.length() == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            if (catchException) {
                return 0.0;
            }
            throw e;
        }
    }

    public static double parseDouble(String s) {
        return Utils.parseDouble(s, true);
    }

    public static int parseHex(String s) {
        return Utils.parseHex(s, true);
    }

    public static int parseHex(String s, boolean catchException) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        if (catchException) {
            try {
                return (int)Long.parseLong(s, 16);
            }
            catch (Exception e) {
                return 0;
            }
        }
        return (int)Long.parseLong(s, 16);
    }

    public static boolean validInteger(String value) {
        try {
            Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean validDouble(String value) {
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Nullable
    public static PlayerEntity getClosestPlayer(World world, double posX, double posY, double posZ, double distance) {
        return Utils.getClosestPlayer(world, posX, posY, posZ, distance, true);
    }

    @Nullable
    public static PlayerEntity getClosestPlayer(World world, double posX, double posY, double posZ, double distance, boolean includeCreative) {
        return Utils.getClosestPlayer(world, posX, posY, posZ, distance, includeCreative, false);
    }

    @Nullable
    @Deprecated
    public static PlayerEntity getClosestPlayer(World world, double posX, double posY, double posZ, double distance, boolean includeCreative, boolean includeSpectators) {
        double d0 = -1.0;
        PlayerEntity closestPlayer = null;
        for (int i = 0; i < world.func_217369_A().size(); ++i) {
            PlayerEntity player = (PlayerEntity)world.func_217369_A().get(i);
            if (player.func_184812_l_() && !includeCreative || player.func_175149_v() && !includeSpectators) continue;
            double d1 = player.func_70092_e(posX, posY, posZ);
            if (!(distance < 0.0) && !(d1 < distance * distance) || d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            closestPlayer = player;
        }
        return closestPlayer;
    }

    public static boolean checkClassInstanceOf(Class clazz, Class instanceOfThis) {
        if (clazz == null || instanceOfThis == null) {
            return clazz == null && instanceOfThis == null;
        }
        return instanceOfThis.isAssignableFrom(clazz);
    }

    public static String trimString(String input, int length, String trimExtension) {
        if (input.length() <= length) {
            return input;
        }
        return input.substring(0, length) + trimExtension;
    }

    public static String getClipboardString() {
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static void setClipboardString(String copyText) {
        if (!StringUtils.isEmpty((CharSequence)copyText)) {
            try {
                StringSelection stringselection = new StringSelection(copyText);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringselection, null);
            }
            catch (Exception var2) {
                var2.printStackTrace();
            }
        }
    }

    public static void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            LogHelperBC.error("Couldn't open link: {}", throwable == null ? "<UNKNOWN>" : throwable.getMessage());
        }
    }

    public static int parseColourRGB(String value) {
        if (value.startsWith("0x") || value.startsWith("#")) {
            value = value.replace("0x", "").replace("#", "");
            return Utils.parseHex(value, false);
        }
        if (value.contains(",")) {
            String[] vals = value.split(",");
            if (vals.length != 3) {
                throw new NumberFormatException("Number must be a hex using the format 0xRRGGBB or #RRGGBB");
            }
            int r = vals[0].contains(".") ? (int)(Double.parseDouble(vals[0]) * 255.0) : Integer.parseInt(vals[0]);
            int g = vals[1].contains(".") ? (int)(Double.parseDouble(vals[1]) * 255.0) : Integer.parseInt(vals[1]);
            int b = vals[2].contains(".") ? (int)(Double.parseDouble(vals[2]) * 255.0) : Integer.parseInt(vals[2]);
            return r << 16 | g << 8 | b;
        }
        throw new NumberFormatException("Number must be a hex using the format 0xRRGGBB or #RRGGBB");
    }

    public static int parseColourARGB(String value) {
        if (value.startsWith("0x") || value.startsWith("#")) {
            value = value.replace("0x", "").replace("#", "");
            return Utils.parseHex(value, false);
        }
        if (value.contains(",")) {
            int b;
            String[] vals = value.split(",");
            if (vals.length < 3 || vals.length > 4) {
                throw new NumberFormatException("Number must be a hex using the format 0xAARRGGBB or #AARRGGBB");
            }
            int r = vals[0].contains(".") ? (int)(Double.parseDouble(vals[0]) * 255.0) : Integer.parseInt(vals[0]);
            int g = vals[1].contains(".") ? (int)(Double.parseDouble(vals[1]) * 255.0) : Integer.parseInt(vals[1]);
            int n = b = vals[2].contains(".") ? (int)(Double.parseDouble(vals[2]) * 255.0) : Integer.parseInt(vals[2]);
            int a = vals.length == 4 ? (vals[3].contains(".") ? (int)(Double.parseDouble(vals[3]) * 255.0) : Integer.parseInt(vals[3])) : 255;
            return a << 24 | r << 16 | g << 8 | b;
        }
        throw new NumberFormatException("Number must be a hex using the format 0xRRGGBB or #RRGGBB");
    }

    public static Fluid lookupFluidForBlock(Block block) {
        if (fluidBlocks == null) {
            HashBiMap tmp = HashBiMap.create();
            for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
                Block fluidBlock = fluid.func_207188_f().func_206883_i().func_177230_c();
                if (fluidBlock == Blocks.field_150350_a) continue;
                tmp.put((Object)fluidBlock, (Object)fluid);
            }
            fluidBlocks = tmp;
        }
        return (Fluid)fluidBlocks.get((Object)block);
    }

    public static String getTextFormatString(String stringIn) {
        StringBuilder stringbuilder = new StringBuilder();
        int i = -1;
        int j = stringIn.length();
        while ((i = stringIn.indexOf(167, i + 1)) != -1) {
            TextFormatting textformatting;
            if (i >= j - 1 || (textformatting = TextFormatting.func_211165_a((char)stringIn.charAt(i + 1))) == null) continue;
            if (!textformatting.func_96301_b()) {
                stringbuilder.setLength(0);
            }
            if (textformatting == TextFormatting.RESET) continue;
            stringbuilder.append(textformatting);
        }
        return stringbuilder.toString();
    }

    public static boolean isAreaLoaded(World world, BlockPos pos, ChunkHolder.LocationType minimum) {
        ChunkPos chunkPos = new ChunkPos(pos);
        IChunk ichunk = world.func_217353_a(chunkPos.field_77276_a, chunkPos.field_77275_b, ChunkStatus.field_222617_m, false);
        if (!(ichunk instanceof Chunk)) {
            return false;
        }
        ChunkHolder.LocationType locationType = ((Chunk)ichunk).func_217321_u();
        return locationType.func_219065_a(minimum);
    }

    public static long safeAdd(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            return Long.MAX_VALUE;
        }
        return r;
    }
}

