/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.config;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class BooleanProperty
extends ConfigProperty {
    private boolean value;
    private boolean defaultValue;
    private ConfigProperty.BooleanFormatter formatter = ConfigProperty.BooleanFormatter.TRUE_FALSE;
    private Supplier<Boolean> valueOverride;
    private BiConsumer<ItemStack, BooleanProperty> changeListener;

    public BooleanProperty(String name, boolean defaultValue) {
        super(name);
        this.value = this.defaultValue = defaultValue;
    }

    public BooleanProperty(String name, ITextComponent displayName, boolean defaultValue) {
        super(name, displayName);
        this.value = this.defaultValue = defaultValue;
    }

    public boolean getValue() {
        return this.valueOverride == null ? this.value : this.valueOverride.get();
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public void setValueOverride(Supplier<Boolean> valueOverride) {
        this.valueOverride = valueOverride;
    }

    @Override
    public String getDisplayValue() {
        return this.formatter.format(this.getValue());
    }

    public BooleanProperty setFormatter(ConfigProperty.BooleanFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public ConfigProperty.BooleanFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void onValueChanged(ItemStack stack) {
        if (this.changeListener != null) {
            this.changeListener.accept(stack, this);
        }
    }

    @Override
    public void validateValue() {
    }

    @Override
    public ConfigProperty.Type getType() {
        return ConfigProperty.Type.BOOLEAN;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = (stack, t) -> changeListener.run();
    }

    public void setChangeListener(Consumer<ItemStack> changeListener) {
        this.changeListener = (stack, booleanProperty) -> changeListener.accept((ItemStack)stack);
    }

    public void setChangeListener(BiConsumer<ItemStack, BooleanProperty> changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        if (this.value != this.defaultValue) {
            nbt.func_74757_a("value", this.value);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("value")) {
            this.value = nbt.func_74767_n("value");
        }
        super.deserializeNBT(nbt);
    }

    @Override
    public void serializeMCData(MCDataOutput output) {
        super.serializeMCData(output);
        output.writeBoolean(this.value);
    }

    @Override
    public void deSerializeMCData(MCDataInput input) {
        super.deSerializeMCData(input);
        this.value = input.readBoolean();
    }

    @Override
    public void loadData(PropertyData data, ItemStack stack) {
        this.value = data.booleanValue;
        this.onValueChanged(stack);
    }
}

