/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.crafting;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.api.crafting.IFusionInventory;
import com.brandon3055.draconicevolution.api.crafting.IFusionStateMachine;
import com.brandon3055.draconicevolution.api.crafting.IngredientStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public interface IFusionRecipe
extends IRecipe<IFusionInventory> {
    default public ItemStack func_222128_h() {
        if (DraconicAPI.CRAFTING_CORE != null) {
            return new ItemStack((IItemProvider)DraconicAPI.CRAFTING_CORE);
        }
        return new ItemStack((IItemProvider)Blocks.field_150462_ai);
    }

    default public IRecipeType<?> func_222127_g() {
        return DraconicAPI.FUSION_RECIPE_TYPE;
    }

    public TechLevel getRecipeTier();

    public long getEnergyCost();

    default public NonNullList<Ingredient> func_192400_c() {
        return this.fusionIngredients().stream().map(IFusionIngredient::get).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }

    public List<IFusionIngredient> fusionIngredients();

    public Ingredient getCatalyst();

    default public boolean matches(IFusionInventory inv, World world) {
        if (!this.getCatalyst().test(inv.getCatalystStack())) {
            return false;
        }
        ArrayList<IFusionInjector> injectors = new ArrayList<IFusionInjector>(inv.getInjectors());
        for (Ingredient ingredient : this.func_192400_c()) {
            IFusionInjector match = injectors.stream().filter(e -> ingredient.test(e.getInjectorStack())).findFirst().orElse(null);
            if (match == null) {
                return false;
            }
            injectors.remove(match);
        }
        return injectors.stream().allMatch(e -> e.getInjectorStack().func_190926_b());
    }

    default public void tickFusionState(IFusionStateMachine stateMachine, IFusionInventory inv, World world) {
        switch (stateMachine.getFusionState()) {
            case START: {
                if (!this.matches(inv, world)) {
                    stateMachine.cancelCraft();
                    return;
                }
                long itemEnergy = this.getEnergyCost() / (long)this.fusionIngredients().size() + (long)inv.getInjectors().size();
                inv.getInjectors().stream().filter(e -> !e.getInjectorStack().func_190926_b()).forEach(e -> e.setEnergyRequirement(itemEnergy, itemEnergy / (long)DEConfig.fusionChargeTime.get(e.getInjectorTier().index).intValue()));
                stateMachine.setFusionStatus(0.0, (ITextComponent)new TranslationTextComponent("fusion_status.draconicevolution.charging", new Object[]{0}).func_240699_a_(TextFormatting.GREEN));
                stateMachine.setFusionState(IFusionStateMachine.FusionState.CHARGING);
                stateMachine.setCraftAnimation(0.0f, 0);
                break;
            }
            case CHARGING: {
                long totalCharge = inv.getInjectors().stream().mapToLong(IFusionInjector::getInjectorEnergy).sum();
                stateMachine.setFusionStatus((double)totalCharge / (double)this.getEnergyCost(), (ITextComponent)new TranslationTextComponent("fusion_status.draconicevolution.charging", new Object[]{(double)Math.round((double)totalCharge / (double)this.getEnergyCost() * 1000.0) / 10.0}).func_240699_a_(TextFormatting.GREEN));
                if (totalCharge < this.getEnergyCost()) break;
                stateMachine.setFusionStatus(0.0, (ITextComponent)new TranslationTextComponent("fusion_status.draconicevolution.crafting", new Object[]{0}).func_240699_a_(TextFormatting.GREEN));
                stateMachine.setCounter(0);
                int craftTime = DEConfig.fusionCraftTime.get(inv.getMinimumTier().index);
                stateMachine.setCraftAnimation(0.0f, craftTime);
                stateMachine.setFusionState(IFusionStateMachine.FusionState.CRAFTING);
                break;
            }
            case CRAFTING: {
                int craftTime = DEConfig.fusionCraftTime.get(inv.getMinimumTier().index);
                int counter = stateMachine.getCounter();
                stateMachine.setCraftAnimation((float)counter / (float)craftTime, craftTime);
                stateMachine.setCounter(counter + 1);
                stateMachine.setFusionStatus((double)counter / (double)craftTime, (ITextComponent)new TranslationTextComponent("fusion_status.draconicevolution.crafting", new Object[]{(double)Math.round((double)counter / (double)craftTime * 1000.0) / 10.0}).func_240699_a_(TextFormatting.GREEN));
                if (counter < craftTime) break;
                if (inv.getInjectors().stream().anyMatch(e -> !e.validate())) {
                    stateMachine.cancelCraft();
                    return;
                }
                if (!this.matches(inv, world) || !this.canStartCraft(inv, world, null)) {
                    stateMachine.cancelCraft();
                    return;
                }
                IFusionRecipe.completeCraft(inv, world, this);
                stateMachine.completeCraft();
            }
        }
    }

    public static void completeCraft(IFusionInventory inv, World world, IFusionRecipe recipe) {
        ArrayList<IFusionInjector> injectors = new ArrayList<IFusionInjector>(inv.getInjectors());
        block0: for (IFusionIngredient ingredient : recipe.fusionIngredients()) {
            for (IFusionInjector injector : injectors) {
                ItemStack stack = injector.getInjectorStack();
                if (stack.func_190926_b() || !ingredient.get().test(stack) || injector.getInjectorTier().index < recipe.getRecipeTier().index) continue;
                if (!ingredient.consume()) continue block0;
                if (stack.hasContainerItem()) {
                    stack = stack.func_77973_b().getContainerItem(stack);
                } else {
                    stack.func_190918_g(1);
                }
                injector.setInjectorStack(stack);
                injector.setInjectorEnergy(0L);
                injectors.remove(injector);
                continue block0;
            }
        }
        int catCount = 1;
        if (recipe.getCatalyst() instanceof IngredientStack) {
            catCount = ((IngredientStack)recipe.getCatalyst()).getCount();
        }
        ItemStack catalyst = inv.getCatalystStack();
        ItemStack result = recipe.func_77572_b(inv);
        catalyst.func_190918_g(catCount);
        inv.setCatalystStack(catalyst);
        ItemStack outputStack = inv.getOutputStack();
        if (outputStack.func_190926_b()) {
            inv.setOutputStack(result.func_77946_l());
        } else {
            outputStack.func_190917_f(result.func_190916_E());
        }
    }

    default public boolean canStartCraft(IFusionInventory inv, World world, @Nullable Consumer<ITextComponent> userStatus) {
        ItemStack result;
        ItemStack output = inv.getOutputStack();
        if (!(output.func_190926_b() || ItemStack.func_179545_c((ItemStack)output, (ItemStack)(result = this.func_77572_b(inv))) && ItemStack.func_77970_a((ItemStack)output, (ItemStack)result) && output.func_190916_E() + result.func_190916_E() <= result.func_77973_b().getItemStackLimit(result))) {
            if (userStatus != null) {
                userStatus.accept((ITextComponent)new TranslationTextComponent("fusion_status.draconicevolution.output_obstructed").func_240699_a_(TextFormatting.RED));
            }
            return false;
        }
        if (inv.getMinimumTier().index < this.getRecipeTier().index) {
            if (userStatus != null) {
                userStatus.accept((ITextComponent)new TranslationTextComponent("fusion_status.draconicevolution.tier_low").func_240699_a_(TextFormatting.RED));
            }
            return false;
        }
        if (userStatus != null) {
            userStatus.accept((ITextComponent)new TranslationTextComponent("fusion_status.draconicevolution.ready").func_240699_a_(TextFormatting.GREEN));
        }
        return true;
    }

    default public boolean func_194133_a(int width, int height) {
        return true;
    }

    default public boolean func_192399_d() {
        return true;
    }

    public static interface IFusionIngredient {
        public Ingredient get();

        public boolean consume();
    }
}

