/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules;

import codechicken.lib.util.SneakyUtils;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.InstallResult;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public interface ModuleType<T extends ModuleData<T>> {
    default public int maxInstallable() {
        return -1;
    }

    default public InstallResult areModulesCompatible(Module<T> thisModule, Module<?> otherModule) {
        return new InstallResult(InstallResult.InstallResultType.YES, thisModule, null, null);
    }

    default public T getData(Module<?> module) {
        return (T)((ModuleData)SneakyUtils.unsafeCast(module.getData()));
    }

    public int getDefaultWidth();

    public int getDefaultHeight();

    public String getName();

    default public TextComponent getDisplayName() {
        return new TranslationTextComponent("module_type.draconicevolution." + this.getName() + ".name");
    }

    public ModuleEntity createEntity(Module<T> var1);

    default public void getTypeProperties(@Nullable T moduleData, Map<ConfigProperty, Consumer<T>> propertyMap) {
    }

    default public void getAttributeModifiers(@Nullable T moduleData, EquipmentSlotType slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map) {
    }

    public Collection<ModuleCategory> getCategories();
}

