/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleRegistry;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.EnergyData;
import com.brandon3055.draconicevolution.api.modules.data.EnergyShareData;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleHostImpl
implements ModuleHost,
PropertyProvider {
    private static Logger logger = LogManager.getLogger((String)"draconic-modules");
    private int gridWidth;
    private int gridHeight;
    private UUID providerID = null;
    private String providerName;
    private boolean deleteInvalidModules;
    private TechLevel techLevel;
    private EnergyData energyCache = null;
    private ModuleData energyLinkCache = null;
    private EnergyShareData energyShareCache = null;
    private List<ModuleEntity> moduleEntities = new ArrayList<ModuleEntity>();
    private Set<ModuleType<?>> additionalTypeList = new HashSet();
    private Set<ModuleType<?>> typeBlackList = new HashSet();
    private Set<ModuleCategory> categories = new HashSet<ModuleCategory>();
    private List<ConfigProperty> providedProperties = new ArrayList<ConfigProperty>();
    private Map<String, ConfigProperty> propertyMap = new LinkedHashMap<String, ConfigProperty>();
    private Consumer<List<ConfigProperty>> propertyBuilder;
    private Map<ModuleType<?>, Consumer<?>> propertyValidators = new HashMap();

    public ModuleHostImpl(TechLevel techLevel, int gridWidth, int gridHeight, String providerName, boolean deleteInvalidModules, ModuleCategory ... categories) {
        this.techLevel = techLevel;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.providerName = providerName;
        this.deleteInvalidModules = deleteInvalidModules;
        this.categories.addAll(Arrays.asList(categories));
    }

    @Override
    public Stream<Module<?>> getModules() {
        return this.getModuleEntities().stream().map(ModuleEntity::getModule);
    }

    @Override
    public List<ModuleEntity> getModuleEntities() {
        return Collections.unmodifiableList(this.moduleEntities);
    }

    @Override
    public void addModule(ModuleEntity entity, ModuleContext context) {
        this.moduleEntities.add(entity);
        entity.setHost(this);
        this.clearCaches();
        entity.onInstalled(context);
        this.gatherProperties();
    }

    @Override
    public void removeModule(ModuleEntity entity, ModuleContext context) {
        this.moduleEntities.remove(entity);
        this.clearCaches();
        entity.onRemoved(context);
        this.gatherProperties();
    }

    @Override
    public Collection<ModuleCategory> getModuleCategories() {
        return this.categories;
    }

    public ModuleHostImpl addCategories(ModuleCategory ... categories) {
        this.categories.addAll(Arrays.asList(categories));
        return this;
    }

    @Override
    public Collection<ModuleType<?>> getAdditionalTypes() {
        return this.additionalTypeList;
    }

    @Override
    public Collection<ModuleType<?>> getTypeBlackList() {
        return this.typeBlackList;
    }

    public ModuleHostImpl addAdditionalType(ModuleType<?> type) {
        this.additionalTypeList.add(type);
        return this;
    }

    public ModuleHostImpl blackListType(ModuleType<?> type) {
        this.typeBlackList.add(type);
        return this;
    }

    @Override
    public TechLevel getHostTechLevel() {
        return this.techLevel;
    }

    @Override
    public int getGridWidth() {
        return this.gridWidth;
    }

    @Override
    public int getGridHeight() {
        return this.gridHeight;
    }

    @Override
    public void getAttributeModifiers(EquipmentSlotType slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map) {
        this.getInstalledTypes().forEach(t -> t.getAttributeModifiers((ModuleData)SneakyUtils.unsafeCast(this.getModuleData(t)), slot, stack, map));
        this.getModuleEntities().forEach(e -> e.getAttributeModifiers(slot, stack, map));
    }

    @Override
    public void handleTick(ModuleContext context) {
        this.getModuleEntities().forEach(e -> e.tick(context));
    }

    public void addPropertyBuilder(Consumer<List<ConfigProperty>> propertyBuilder) {
        Consumer<List<ConfigProperty>> builder = this.propertyBuilder;
        this.propertyBuilder = builder == null ? propertyBuilder : builder.andThen(propertyBuilder);
        this.gatherProperties();
    }

    @Override
    public UUID getProviderID() {
        if (this.providerID == null) {
            this.regenProviderID();
        }
        return this.providerID;
    }

    @Override
    public String getProviderName() {
        return this.providerName;
    }

    @Override
    public void regenProviderID() {
        this.providerID = UUID.randomUUID();
    }

    @Override
    public Collection<ConfigProperty> getProperties() {
        return this.propertyMap.values();
    }

    @Override
    @Nullable
    public ConfigProperty getProperty(String propertyID) {
        return this.propertyMap.get(propertyID);
    }

    private void gatherProperties() {
        ArrayList gathered = new ArrayList();
        if (this.propertyBuilder != null) {
            this.propertyBuilder.accept(gathered);
        }
        Set<ModuleType> installedTypes = this.getInstalledTypes().collect(Collectors.toSet());
        this.propertyValidators.entrySet().removeIf(e -> !installedTypes.contains(e.getKey()));
        installedTypes.forEach(type -> {
            HashMap<ConfigProperty, Consumer> map = new HashMap<ConfigProperty, Consumer>();
            type.getTypeProperties((ModuleData)SneakyUtils.unsafeCast(this.getModuleData(type)), (Map)SneakyUtils.unsafeCast(map));
            gathered.addAll(map.keySet());
            if (this.propertyValidators.containsKey(type)) {
                this.propertyValidators.get(type).accept(SneakyUtils.unsafeCast(this.getModuleData(type)));
            } else {
                map.forEach((property, consumer) -> {
                    if (consumer != null) {
                        this.propertyValidators.put((ModuleType<?>)type, (Consumer<?>)consumer);
                    }
                });
            }
        });
        Set gatheredNames = gathered.stream().map(ConfigProperty::getName).collect(Collectors.toSet());
        this.providedProperties.removeIf(e -> !gatheredNames.contains(e.getName()));
        Set installedNames = this.providedProperties.stream().map(ConfigProperty::getName).collect(Collectors.toSet());
        this.providedProperties.addAll(gathered.stream().filter(e -> !installedNames.contains(e.getName())).collect(Collectors.toList()));
        this.propertyMap.clear();
        this.providedProperties.forEach(e -> this.propertyMap.put(e.getName(), (ConfigProperty)e));
        this.getModuleEntities().forEach(e -> e.getEntityProperties().forEach(p -> {
            if (this.propertyMap.containsKey(p.getName())) {
                p.generateUnique();
            }
            this.propertyMap.put(p.getName(), (ConfigProperty)p);
        }));
    }

    private void clearCaches() {
        this.energyLinkCache = null;
        this.energyCache = null;
        this.getModuleEntities().forEach(ModuleEntity::clearCaches);
    }

    public ModuleData getEnergyLink() {
        return this.energyLinkCache;
    }

    public EnergyShareData getEnergyShare() {
        if (this.energyShareCache == null) {
            this.energyShareCache = this.getModuleData(ModuleTypes.ENERGY_SHARE, new EnergyShareData(0L));
        }
        return this.energyShareCache;
    }

    public EnergyData getEnergyData() {
        if (this.energyCache == null) {
            this.energyCache = this.getModuleData(ModuleTypes.ENERGY_STORAGE, new EnergyData(0L, 0L));
        }
        return this.energyCache;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT modules = new ListNBT();
        for (ModuleEntity entity : this.moduleEntities) {
            CompoundNBT entityNBT = new CompoundNBT();
            entityNBT.func_74778_a("id", entity.module.getRegistryName().toString());
            entity.writeToNBT(entityNBT);
            modules.add((Object)entityNBT);
        }
        nbt.func_218657_a("modules", (INBT)modules);
        nbt.func_186854_a("provider_id", this.getProviderID());
        CompoundNBT properties = new CompoundNBT();
        this.providedProperties.forEach(e -> properties.func_218657_a(e.getName(), (INBT)e.serializeNBT()));
        nbt.func_218657_a("properties", (INBT)properties);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.clearCaches();
        this.moduleEntities.clear();
        ListNBT modules = nbt.func_150295_c("modules", 10);
        modules.stream().map(inbt -> (CompoundNBT)inbt).forEach(compound -> {
            ResourceLocation id = new ResourceLocation(compound.func_74779_i("id"));
            Module module = (Module)ModuleRegistry.getRegistry().getValue(id);
            if (module == null) {
                logger.warn("Failed to load unregistered module: " + id + " Skipping...");
            } else {
                ModuleEntity entity = module.createEntity();
                entity.readFromNBT((CompoundNBT)compound);
                if (this.deleteInvalidModules && !entity.isPosValid(this.gridWidth, this.gridHeight)) {
                    logger.warn("Deleting module from invalid grid position: " + entity.toString());
                } else {
                    this.moduleEntities.add(entity);
                    entity.setHost(this);
                }
            }
        });
        this.gatherProperties();
        if (nbt.func_186855_b("provider_id")) {
            this.providerID = nbt.func_186857_a("provider_id");
        }
        CompoundNBT properties = nbt.func_74775_l("properties");
        this.providedProperties.forEach(e -> e.deserializeNBT(properties.func_74775_l(e.getName())));
    }
}

