/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import codechicken.lib.raytracer.RayTracer;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePlacedItem;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PlacedItem
extends BlockBCore {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;

    public PlacedItem(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public boolean isBlockFullCube() {
        return false;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TilePlacedItem();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hitIIn) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePlacedItem) {
            BlockRayTraceResult hit = RayTracer.retraceBlock((IBlockReader)world, (PlayerEntity)player, (BlockPos)pos);
            Object subHitResult = null;
            if (subHitResult != null) {
                hit = subHitResult;
            } else if (hit == null) {
                return ActionResultType.SUCCESS;
            }
            ((TilePlacedItem)tile).handleClick(hit.subHit, player);
        }
        return ActionResultType.SUCCESS;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePlacedItem) {
            RayTraceResult hit = target;
            Object subHitResult = null;
            if (subHitResult != null) {
                hit = subHitResult;
            } else if (hit == null) {
                return ItemStack.field_190927_a;
            }
            if (hit.subHit > 0 && ((TilePlacedItem)tile).inventory.func_70301_a(hit.subHit - 1) != null) {
                ItemStack stack = ((TilePlacedItem)tile).inventory.func_70301_a(hit.subHit - 1).func_77946_l();
                if (stack.func_77942_o()) {
                    stack.func_77978_p().func_82580_o("BlockEntityTag");
                }
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack heldStack) {
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePlacedItem) {
            ((TilePlacedItem)tile).breakBlock();
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }
}

