/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.rendering;

import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.api.energy.IENetEffectTile;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBeam;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class ENetFXHandlerClient<T extends TileEntity>
extends ENetFXHandler<T> {
    protected CrystalFXBase staticFX;
    protected LinkedList<CrystalFXBase> beamFXList = new LinkedList();

    public ENetFXHandlerClient(T tile) {
        super(tile);
    }

    @Override
    public void update() {
        if (((IENetEffectTile)this.tile).hasStaticFX()) {
            if (this.staticFX == null || !this.staticFX.func_187113_k()) {
                this.staticFX = ((IENetEffectTile)this.tile).createStaticFX();
                DEParticles.addParticleDirect(this.tile.func_145831_w(), this.staticFX);
            }
            this.staticFX.updateFX(0.5f);
        }
        boolean requiresUpdate = false;
        for (CrystalFXBase beam : this.beamFXList) {
            if (!beam.func_187113_k()) {
                requiresUpdate = true;
            }
            if (((IENetEffectTile)this.tile).getFlowRates().size() <= this.beamFXList.indexOf((Object)beam)) continue;
            beam.updateFX((float)(((IENetEffectTile)this.tile).getFlowRates().get((byte)this.beamFXList.indexOf((Object)beam)) & 0xFF) / 255.0f);
        }
        if (requiresUpdate || ((ICrystalLink)this.tile).getLinks().size() != this.beamFXList.size()) {
            this.reloadConnections();
        }
    }

    @Override
    public void updateReceived(CrystalUpdateBatcher.BatchedCrystalUpdate update) {
        ((ICrystalLink)this.tile).modifyEnergyStored(update.crystalCapacity - ((ICrystalLink)this.tile).getEnergyStored());
        Map<Byte, Byte> flowMap = update.indexToFlowMap;
        for (byte index = 0; index < ((IENetEffectTile)this.tile).getFlowRates().size(); index = (byte)(index + 1)) {
            if (flowMap.containsKey(index)) continue;
            flowMap.put(index, ((IENetEffectTile)this.tile).getFlowRates().get(index));
        }
        ((IENetEffectTile)this.tile).getFlowRates().clear();
        for (byte i = 0; i < flowMap.size(); i = (byte)(i + 1)) {
            if (!flowMap.containsKey(i)) continue;
            ((IENetEffectTile)this.tile).getFlowRates().add(flowMap.get(i));
        }
    }

    @Override
    public void reloadConnections() {
        this.beamFXList.clear();
        for (BlockPos pos : ((ICrystalLink)this.tile).getLinks()) {
            TileEntity target = this.tile.func_145831_w().func_175625_s(pos);
            if (!(target instanceof ICrystalLink)) continue;
            CrystalFXBeam<TileEntity> beam = new CrystalFXBeam<TileEntity>(this.tile.func_145831_w(), this.tile, (ICrystalLink)target);
            this.beamFXList.add(beam);
            DEParticles.addParticleDirect(this.tile.func_145831_w(), beam);
        }
    }

    @Override
    public void tileUnload() {
        super.tileUnload();
    }
}

