/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.rendering;

import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.api.energy.IENetEffectTile;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;

public class ENetFXHandlerServer<T extends TileEntity>
extends ENetFXHandler<T> {
    private CrystalUpdateBatcher.BatchedCrystalUpdate batchedUpdate;
    private Map<Byte, Byte> lastTickIndexToFlow = new HashMap<Byte, Byte>();
    private long lastTickEnergy = -1L;

    public ENetFXHandlerServer(T tile) {
        super(tile);
    }

    @Override
    public void update() {
    }

    @Override
    public void detectAndSendChanges() {
        this.lastTickIndexToFlow.clear();
        CrystalUpdateBatcher.BatchedCrystalUpdate update = new CrystalUpdateBatcher.BatchedCrystalUpdate(((IENetEffectTile)this.tile).getIDHash(), ((ICrystalLink)this.tile).getEnergyStored());
        for (byte i = 0; i < ((IENetEffectTile)this.tile).getFlowRates().size(); i = (byte)(i + 1)) {
            byte flow = ((IENetEffectTile)this.tile).getFlowRates().get(i);
            if (this.lastTickIndexToFlow.containsKey(i) && this.lastTickIndexToFlow.get(i) == flow) continue;
            update.indexToFlowMap.put(i, flow);
            this.lastTickIndexToFlow.put(i, flow);
        }
        if (update.indexToFlowMap.size() > 0 || Math.abs(this.lastTickEnergy - ((ICrystalLink)this.tile).getEnergyStored()) > 100L) {
            this.lastTickEnergy = ((ICrystalLink)this.tile).getEnergyStored();
            this.batchedUpdate = update;
        }
        if (this.batchedUpdate != null) {
            this.queUpdate();
        }
    }

    @Override
    public void reloadConnections() {
        this.lastTickIndexToFlow.clear();
    }

    private void queUpdate() {
        ServerWorld serverWorld = (ServerWorld)this.tile.func_145831_w();
        if (serverWorld != null) {
            serverWorld.func_72863_F().field_217237_a.func_219097_a(new ChunkPos(this.tile.func_174877_v()), false).forEach(player -> CrystalUpdateBatcher.queData(this.batchedUpdate, player));
        }
        this.batchedUpdate = null;
    }
}

