/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.tileentity;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.IActivatableTile;
import com.brandon3055.brandonscore.lib.ITilePlaceListener;
import com.brandon3055.brandonscore.lib.Vec3B;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.api.energy.IENetEffectTile;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerClient;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerServer;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class TileCrystalBase
extends TileBCore
implements ITilePlaceListener,
ICrystalLink,
ITickableTileEntity,
IActivatableTile,
IENetEffectTile {
    private static Map<EnergyCrystal.CrystalType, int[]> MAX_LINKS = new HashMap<EnergyCrystal.CrystalType, int[]>();
    protected int tick = 0;
    protected LinkedList<Vec3B> linkedCrystals = new LinkedList();
    public LinkedList<int[]> transferRatesArrays = new LinkedList();
    public LinkedList<Byte> flowRates = new LinkedList();
    private LinkedList<BlockPos> linkedPosCache = null;
    protected OPStorage opStorage = new OPStorage(0L);
    protected ENetFXHandler fxHandler;
    protected TechLevel techLevel;
    boolean hashCached = false;
    int hashID = 0;
    public Map<Integer, Integer> containerEnergyFlow = new HashMap<Integer, Integer>();

    public TileCrystalBase(TileEntityType<?> tileEntityTypeIn) {
        this(tileEntityTypeIn, TechLevel.DRACONIUM);
    }

    public TileCrystalBase(TileEntityType<?> tileEntityTypeIn, TechLevel techLevel) {
        super(tileEntityTypeIn);
        this.techLevel = techLevel;
        this.fxHandler = DraconicEvolution.proxy.createENetFXHandler(this);
        this.capManager.setInternalManaged("energy", CapabilityOP.OP, (INBTSerializable)this.opStorage).saveBoth().syncContainer();
    }

    public void func_73660_a() {
        super.tick();
        if (this.linkedCrystals.size() != this.transferRatesArrays.size() && !this.field_145850_b.field_72995_K) {
            this.rebuildTransferList();
        }
        this.balanceLinkedDevices();
        this.fxHandler.update();
        if (!this.field_145850_b.field_72995_K && DEEventHandler.serverTicks % 10 == 0) {
            this.flowRates.clear();
            for (int i = 0; i < this.linkedCrystals.size(); ++i) {
                this.flowRates.add(this.calculateFlow(i));
            }
            this.fxHandler.detectAndSendChanges();
        }
        ++this.tick;
    }

    public void balanceLinkedDevices() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (BlockPos linkedPos : this.getLinks()) {
            TileEntity linkedTile = this.field_145850_b.func_175625_s(linkedPos);
            if (!(linkedTile instanceof ICrystalLink)) {
                if (!this.field_145850_b.func_175667_e(linkedPos)) continue;
                this.breakLink(linkedPos);
                return;
            }
            ICrystalLink linkedCrystal = (ICrystalLink)linkedTile;
            double thisCap = (double)this.getEnergyStored() / (double)this.getMaxEnergyStored();
            double thatCap = (double)linkedCrystal.getEnergyStored() / (double)linkedCrystal.getMaxEnergyStored();
            double diff = thisCap - thatCap;
            if (linkedCrystal.balanceMode() == 0 && thatCap < 1.0) {
                this.transferRatesArrays.get((int)this.linkedPosCache.indexOf((Object)linkedPos))[this.tick % 20] = this.balanceTransfer(linkedCrystal, 1.0 - thatCap);
                continue;
            }
            if (diff <= 0.0 || linkedCrystal.balanceMode() == 2) {
                this.transferRatesArrays.get((int)this.linkedPosCache.indexOf((Object)linkedPos))[this.tick % 20] = 0;
                continue;
            }
            this.transferRatesArrays.get((int)this.linkedPosCache.indexOf((Object)linkedPos))[this.tick % 20] = this.balanceTransfer(linkedCrystal, diff);
        }
    }

    protected int balanceTransfer(ICrystalLink sendTo, double capDiff) {
        double minFlow;
        long stored = this.getEnergyStored();
        if (stored <= 0L) {
            return 0;
        }
        double transferCap = Math.min(this.getMaxEnergyStored(), sendTo.getMaxEnergyStored());
        int energyToEqual = (int)(capDiff * (double)sendTo.getMaxEnergyStored() / 2.1);
        double maxFlow = Math.min((double)energyToEqual, Math.min(transferCap, (double)(sendTo.getMaxEnergyStored() - sendTo.getEnergyStored())));
        double flowRate = Math.min(1.0, capDiff * 10.0);
        int transfer = (int)(flowRate * maxFlow);
        if ((double)transfer < (minFlow = 0.002 * transferCap)) {
            transfer = (int)Math.min(minFlow, (double)energyToEqual);
        }
        transfer = (int)this.opStorage.modifyEnergyStored((long)(-transfer));
        sendTo.modifyEnergyStored(transfer);
        return transfer;
    }

    public void rebuildTransferList() {
        this.transferRatesArrays.clear();
        this.flowRates.clear();
        for (int i = 0; i < this.linkedCrystals.size(); ++i) {
            this.transferRatesArrays.add(new int[20]);
            this.flowRates.add((byte)0);
        }
    }

    @Override
    @Nonnull
    public List<BlockPos> getLinks() {
        if (this.linkedPosCache == null || this.linkedPosCache.size() != this.linkedCrystals.size()) {
            this.linkedPosCache = new LinkedList();
            for (Vec3B offset : this.linkedCrystals) {
                this.linkedPosCache.add(this.fromOffset(offset));
            }
            this.fxHandler.reloadConnections();
            this.updateBlock();
        }
        return this.linkedPosCache;
    }

    @Override
    public boolean binderUsed(PlayerEntity player, BlockPos linkTarget, Direction sideClicked) {
        TileEntity te = this.field_145850_b.func_175625_s(linkTarget);
        if (!(te instanceof ICrystalLink)) {
            ChatHelper.sendDeDupeIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.device_invalid").func_240699_a_(TextFormatting.RED), (int)99);
            return false;
        }
        ICrystalLink target = (ICrystalLink)te;
        if (this.getLinks().contains(te.func_174877_v())) {
            this.breakLink(te.func_174877_v());
            target.breakLink(this.field_174879_c);
            ChatHelper.sendDeDupeIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.link_broken").func_240699_a_(TextFormatting.GREEN), (int)99);
            return true;
        }
        if (this.getLinks().size() >= this.maxLinks()) {
            ChatHelper.sendDeDupeIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.link_limit_reached_this").func_240699_a_(TextFormatting.RED), (int)99);
            return false;
        }
        if (target.getLinks().size() >= target.maxLinks()) {
            ChatHelper.sendDeDupeIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.link_limit_reached_target").func_240699_a_(TextFormatting.RED), (int)99);
            return false;
        }
        if (!Utils.inRangeSphere((BlockPos)this.field_174879_c, (BlockPos)linkTarget, (int)this.maxLinkRange())) {
            ChatHelper.sendDeDupeIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.this_range_limit").func_240699_a_(TextFormatting.RED), (int)99);
            return false;
        }
        if (!Utils.inRangeSphere((BlockPos)this.field_174879_c, (BlockPos)linkTarget, (int)target.maxLinkRange())) {
            ChatHelper.sendDeDupeIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.target_range_limit").func_240699_a_(TextFormatting.RED), (int)99);
            return false;
        }
        if (!target.createLink(this)) {
            ChatHelper.sendDeDupeIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.link_failed_unknown").func_240699_a_(TextFormatting.RED), (int)99);
            return false;
        }
        if (!this.createLink(target)) {
            target.breakLink(this.field_174879_c);
            ChatHelper.sendDeDupeIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.link_failed_unknown").func_240699_a_(TextFormatting.RED), (int)99);
            return false;
        }
        ChatHelper.sendDeDupeIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.devices_linked").func_240699_a_(TextFormatting.GREEN), (int)99);
        return true;
    }

    @Override
    public boolean createLink(ICrystalLink otherCrystal) {
        Vec3B offset = this.getOffset(((TileEntity)otherCrystal).func_174877_v());
        this.linkedCrystals.add(offset);
        this.linkedPosCache = null;
        this.updateBlock();
        this.dirtyBlock();
        this.fxHandler.reloadConnections();
        return true;
    }

    @Override
    public void breakLink(BlockPos otherCrystal) {
        Vec3B offset = this.getOffset(otherCrystal);
        if (this.linkedCrystals.contains(offset)) {
            this.linkedCrystals.remove(offset);
        }
        this.linkedPosCache = null;
        this.updateBlock();
        this.dirtyBlock();
        this.fxHandler.reloadConnections();
    }

    @Override
    public int maxLinks() {
        return MAX_LINKS.get((Object)this.getCrystalType())[this.getTier()];
    }

    @Override
    public int maxLinkRange() {
        switch (this.getTier()) {
            case 0: {
                return 32;
            }
            case 1: {
                return 64;
            }
            case 2: {
                return 127;
            }
        }
        return 0;
    }

    @Override
    public int balanceMode() {
        return 1;
    }

    @Override
    public long getEnergyStored() {
        return this.opStorage.getEnergyStored();
    }

    @Override
    public long getMaxEnergyStored() {
        return this.opStorage.getMaxEnergyStored();
    }

    @Override
    public void modifyEnergyStored(long energy) {
        this.opStorage.modifyEnergyStored(energy);
    }

    @Override
    public int getTier() {
        return this.techLevel.index;
    }

    public abstract EnergyCrystal.CrystalType getCrystalType();

    private int getCapacityForTier(int tier) {
        switch (tier) {
            case 0: {
                return 4000000;
            }
            case 1: {
                return 16000000;
            }
            case 2: {
                return 64000000;
            }
        }
        return 0;
    }

    public Vec3B getOffset(BlockPos target) {
        return new Vec3B(this.field_174879_c.func_177973_b((Vector3i)target));
    }

    public BlockPos fromOffset(Vec3B targetOffset) {
        return this.field_174879_c.func_177973_b((Vector3i)targetOffset.getPos());
    }

    public ENetFXHandler getFxHandler() {
        return this.fxHandler;
    }

    public byte calculateFlow(int index) {
        long sum = 0L;
        for (int transfer : this.transferRatesArrays.get(index)) {
            sum += (long)transfer;
        }
        double rf = sum / 20L;
        double d = rf / ((double)this.getMaxEnergyStored() * 0.001 + rf);
        return (byte)(d * 255.0);
    }

    public void getLinkData(List<LinkData> data) {
        for (BlockPos target : this.getLinks()) {
            TileEntity tile = this.field_145850_b.func_175625_s(target);
            if (tile == null) continue;
            LinkData ld = new LinkData();
            ld.displayName = tile.getClass().getSimpleName();
            long sum = 0L;
            for (int transfer : this.transferRatesArrays.get(this.linkedPosCache.indexOf(target))) {
                sum += (long)transfer;
            }
            ld.transferPerTick = (int)(sum / 20L);
            ld.linkTarget = target;
            ld.data = "Data...";
            data.add(ld);
        }
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return true;
    }

    public String getUnlocalizedName() {
        return "tile.draconicevolution:energy_crystal." + this.getCrystalType().func_176610_l() + "." + (this.getTier() == 0 ? "basic" : (this.getTier() == 1 ? "wyvern" : "draconic")) + ".name";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public abstract CrystalFXBase createStaticFX();

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
    }

    public void addDisplayData(List<ITextComponent> displayList) {
        double charge = MathUtils.round((double)((double)this.getEnergyStored() / (double)this.getMaxEnergyStored() * 100.0), (double)100.0);
        displayList.add((ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.hud_charge").func_240702_b_(": " + Utils.formatNumber((long)this.getEnergyStored()) + " / " + Utils.formatNumber((long)this.getMaxEnergyStored()) + " RF [" + charge + "%]").func_240699_a_(TextFormatting.BLUE));
        displayList.add((ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.hud_links").func_240702_b_(": " + this.getLinks().size() + " / " + this.maxLinks()).func_240699_a_(TextFormatting.GREEN));
    }

    @Override
    public ENetFXHandler createServerFXHandler() {
        return new ENetFXHandlerServer<TileCrystalBase>(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ENetFXHandler createClientFXHandler() {
        return new ENetFXHandlerClient<TileCrystalBase>(this);
    }

    public void writeExtraNBT(CompoundNBT compound) {
        compound.func_74774_a("tech_level", (byte)this.techLevel.ordinal());
        ListNBT list = new ListNBT();
        for (Vec3B vec : this.linkedCrystals) {
            list.add((Object)new ByteArrayNBT(new byte[]{vec.x, vec.y, vec.z}));
        }
        compound.func_218657_a("linked_crystals", (INBT)list);
        this.fxHandler.writeToNBT(compound);
        byte[] array = new byte[this.flowRates.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.flowRates.get(i);
        }
        compound.func_74773_a("flow_rates", array);
        super.writeExtraNBT(compound);
    }

    public void readExtraNBT(CompoundNBT compound) {
        this.techLevel = TechLevel.values()[compound.func_74762_e("tech_level")];
        ListNBT list = compound.func_150295_c("linked_crystals", 7);
        this.linkedCrystals.clear();
        for (int i = 0; i < list.size(); ++i) {
            byte[] data = ((ByteArrayNBT)list.get(i)).func_150292_c();
            this.linkedCrystals.add(new Vec3B(data[0], data[1], data[2]));
        }
        if (this.linkedPosCache != null) {
            this.linkedPosCache.clear();
        }
        this.fxHandler.readFromNBT(compound);
        if (compound.func_74764_b("flow_rates")) {
            byte[] array = compound.func_74770_j("flow_rates");
            this.flowRates.clear();
            for (byte b : array) {
                this.flowRates.add(b);
            }
        }
        int cap = this.getCapacityForTier(this.getTier());
        this.opStorage.setCapacity((long)cap).setMaxTransfer((long)cap);
        super.readExtraNBT(compound);
    }

    public void writeToItemStack(CompoundNBT compound, boolean willHarvest) {
        super.writeToItemStack(compound, willHarvest);
    }

    @Nullable
    public void readFromItemStack(CompoundNBT compound) {
        super.readFromItemStack(compound);
    }

    public void onTilePlaced(BlockItemUseContext context, BlockState state) {
        int cap = this.getCapacityForTier(this.getTier());
        this.opStorage.setCapacity((long)cap).setMaxTransfer((long)cap);
    }

    @Override
    public int getIDHash() {
        if (!this.hashCached) {
            this.hashID = this.field_174879_c.hashCode();
            this.hashCached = true;
        }
        return this.hashID;
    }

    public void onLoad() {
        super.onLoad();
        if (!CrystalUpdateBatcher.ID_CRYSTAL_MAP.containsKey(this.getIDHash())) {
            CrystalUpdateBatcher.ID_CRYSTAL_MAP.put(this.getIDHash(), this.field_174879_c);
        }
    }

    public void onChunkUnloaded() {
        if (CrystalUpdateBatcher.ID_CRYSTAL_MAP.containsKey(this.getIDHash())) {
            CrystalUpdateBatcher.ID_CRYSTAL_MAP.remove(this.getIDHash());
        }
        this.fxHandler.tileUnload();
    }

    public void receiveBatchedUpdate(CrystalUpdateBatcher.BatchedCrystalUpdate update) {
        this.fxHandler.updateReceived(update);
    }

    public void detectAndSendContainerChanges(List<IContainerListener> listeners) {
        if (this.linkedCrystals.size() != this.transferRatesArrays.size() && !this.field_145850_b.field_72995_K) {
            this.rebuildTransferList();
        }
        List<BlockPos> positions = this.getLinks();
        ListNBT list = new ListNBT();
        for (BlockPos lPos : positions) {
            int index = positions.indexOf(lPos);
            if (this.containerEnergyFlow.containsKey(index) && this.containerEnergyFlow.get(index).intValue() == this.getLinkFlow(index)) continue;
            this.containerEnergyFlow.put(index, this.getLinkFlow(index));
            CompoundNBT data = new CompoundNBT();
            data.func_74774_a("I", (byte)index);
            data.func_74768_a("E", this.getLinkFlow(index));
            list.add((Object)data);
        }
        if (!list.isEmpty()) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("L", (INBT)list);
            this.sendUpdateToListeners(listeners, this.sendPacketToClient(output -> output.writeCompoundNBT(compound), 0));
        } else if (this.containerEnergyFlow.size() > this.linkedCrystals.size()) {
            this.containerEnergyFlow.clear();
            this.sendUpdateToListeners(listeners, this.sendPacketToClient(output -> {}, 1));
        }
    }

    public void sendUpdateToListeners(List<IContainerListener> listeners, PacketCustom packet) {
        for (IContainerListener listener : listeners) {
            if (!(listener instanceof ServerPlayerEntity)) continue;
            packet.sendToPlayer((ServerPlayerEntity)listener);
        }
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
        if (id == 0) {
            CompoundNBT compound = data.readCompoundNBT();
            ListNBT list = compound.func_150295_c("L", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT tagData = list.func_150305_b(i);
                this.containerEnergyFlow.put(Integer.valueOf(tagData.func_74771_c("I")), tagData.func_74762_e("E"));
            }
        }
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int id) {
        block3: {
            block2: {
                if (id != 10) break block2;
                int intValue = data.readInt();
                if (this.getLinks().size() <= intValue || intValue < 0) break block3;
                BlockPos target = this.getLinks().get(intValue);
                this.breakLink(target);
                TileEntity targetTile = this.field_145850_b.func_175625_s(target);
                if (!(targetTile instanceof ICrystalLink)) break block3;
                ((ICrystalLink)targetTile).breakLink(this.field_174879_c);
                break block3;
            }
            if (id == 20) {
                ArrayList<BlockPos> links = new ArrayList<BlockPos>(this.getLinks());
                for (BlockPos target : links) {
                    this.breakLink(target);
                    TileEntity targetTile = this.field_145850_b.func_175625_s(target);
                    if (!(targetTile instanceof ICrystalLink)) continue;
                    ((ICrystalLink)targetTile).breakLink(this.field_174879_c);
                }
            }
        }
    }

    public int getLinkFlow(int linkIndex) {
        if (this.transferRatesArrays.size() > linkIndex) {
            long sum = 0L;
            for (int i : this.transferRatesArrays.get(linkIndex)) {
                sum += (long)i;
            }
            return (int)(sum / 20L);
        }
        return 0;
    }

    @Override
    public LinkedList<Byte> getFlowRates() {
        return this.flowRates;
    }

    static {
        MAX_LINKS.put(EnergyCrystal.CrystalType.RELAY, new int[]{8, 16, 32});
        MAX_LINKS.put(EnergyCrystal.CrystalType.CRYSTAL_IO, new int[]{2, 3, 4});
        MAX_LINKS.put(EnergyCrystal.CrystalType.WIRELESS, new int[]{4, 8, 16});
    }

    public static class LinkData {
        public String displayName;
        public int transferPerTick;
        public BlockPos linkTarget;
        public String data;

        public LinkData() {
        }

        public LinkData(String displayName, int transferPerTick, BlockPos linkTarget, String data) {
            this.displayName = displayName;
            this.transferPerTick = transferPerTick;
            this.linkTarget = linkTarget;
            this.data = data;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.transferPerTick);
            buf.writeLong(this.linkTarget.func_218275_a());
        }

        public static LinkData fromBytes(ByteBuf buf) {
            LinkData data = new LinkData();
            data.transferPerTick = buf.readInt();
            data.linkTarget = BlockPos.func_218283_e((long)buf.readLong());
            return data;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

