/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor;

import codechicken.lib.util.RotationUtils;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorInjector;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorStabilizer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReactorComponent
extends BlockBCore {
    private static final VoxelShape SHAPE_INJ_DOWN = VoxelShapes.func_197873_a((double)0.0, (double)0.885f, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_INJ_UP = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
    private static final VoxelShape SHAPE_INJ_NORTH = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.885f, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_INJ_SOUTH = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.125);
    private static final VoxelShape SHAPE_INJ_WEST = VoxelShapes.func_197873_a((double)0.885f, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final VoxelShape SHAPE_INJ_EAST = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)1.0);
    private final boolean injector;

    public ReactorComponent(AbstractBlock.Properties properties, boolean injector) {
        super(properties);
        this.injector = injector;
    }

    public boolean isBlockFullCube() {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.injector ? new TileReactorInjector() : new TileReactorStabilizer();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileReactorInjector) {
            switch ((Direction)((TileReactorInjector)tile).facing.get()) {
                case DOWN: {
                    return SHAPE_INJ_DOWN;
                }
                case UP: {
                    return SHAPE_INJ_UP;
                }
                case NORTH: {
                    return SHAPE_INJ_NORTH;
                }
                case SOUTH: {
                    return SHAPE_INJ_SOUTH;
                }
                case WEST: {
                    return SHAPE_INJ_WEST;
                }
                case EAST: {
                    return SHAPE_INJ_EAST;
                }
            }
        }
        return super.func_220053_a(state, world, pos, context);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity te = world.func_175625_s(pos);
        Direction facing = RotationUtils.getPlacedRotation((BlockPos)pos, (LivingEntity)placer).func_176734_d();
        if (te instanceof TileReactorComponent) {
            ((TileReactorComponent)te).facing.set((Enum)facing);
            ((TileReactorComponent)te).onPlaced();
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileReactorComponent) {
            ((TileReactorComponent)te).onActivated(player);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileReactorComponent) {
            ((TileReactorComponent)te).onBroken();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileReactorComponent) {
            return ((TileReactorComponent)tileEntity).rsPower.get();
        }
        return 0;
    }

    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    public boolean addLandingEffects(BlockState state1, ServerWorld worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public boolean addHitEffects(BlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    public boolean addRunningEffects(BlockState state, World world, BlockPos pos, Entity entity) {
        return true;
    }
}

