/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.client.render.effect.EffectTrackerCelestialManipulator;
import com.brandon3055.draconicevolution.client.sound.CelestialModifierSound;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.brandon3055.draconicevolution.utils.ResourceHelperDE;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;

public class TileCelestialManipulator
extends TileBCore
implements ITickableTileEntity,
IChangeListener {
    public final ManagedBool weatherMode = (ManagedBool)this.register((IManagedData)new ManagedBool("weather_mode", true, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool weatherToggleRunning = (ManagedBool)this.register((IManagedData)new ManagedBool("weather_toggle_running", new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedBool timeWarpRunning = (ManagedBool)this.register((IManagedData)new ManagedBool("time_warp_running", new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedBool timeWarpStopping = (ManagedBool)this.register((IManagedData)new ManagedBool("time_warp_stopping", new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedBool redstoneSignal = (ManagedBool)this.register((IManagedData)new ManagedBool("redstone_signal", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte rsMode = (ManagedByte)this.register((IManagedData)new ManagedByte("rs_mode", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public int timer = 0;
    public boolean storm = false;
    public boolean rain = false;
    public long targetTime;
    public OPStorage opStorage = new OPStorage(8000000L, 4000000L, 4000000L);
    @OnlyIn(value=Dist.CLIENT)
    private CelestialModifierSound sound;
    @OnlyIn(value=Dist.CLIENT)
    private List<EffectTrackerCelestialManipulator> effects;
    private String[] ACTIONS = new String[]{"STOP_RAIN", "START_RAIN", "START_STORM", "SUN_RISE", "MID_DAY", "SUN_SET", "MOON_RISE", "MIDNIGHT", "MOON_SET", "SKIP_24"};

    public TileCelestialManipulator() {
        super(DEContent.tile_celestial_manipulator);
        this.capManager.setManaged("energy", CapabilityOP.OP, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
    }

    public void func_73660_a() {
        super.tick();
        if (this.weatherToggleRunning.get()) {
            ++this.timer;
            if (this.field_145850_b.field_72995_K) {
                this.updateWeatherEffects();
            } else if (this.timer >= 230) {
                this.timer = 0;
                this.weatherToggleRunning.set(false);
                this.field_145850_b.func_72912_H().func_76084_b(this.rain);
                ((IServerWorldInfo)this.field_145850_b.func_72912_H()).func_76069_a(this.storm);
                int time = 12000 + this.field_145850_b.field_73012_v.nextInt(24000);
                ((IServerWorldInfo)this.field_145850_b.func_72912_H()).func_76080_g(this.rain ? time : 0);
                ((IServerWorldInfo)this.field_145850_b.func_72912_H()).func_230391_a_(this.rain ? 0 : time);
            }
        } else if (this.timeWarpRunning.get()) {
            ++this.timer;
            if (this.field_145850_b.field_72995_K) {
                this.updateSunEffect();
            }
            if (this.timer > 100) {
                if (this.opStorage.getEnergyStored() > 320) {
                    int extracted = this.opStorage.extractEnergy(16000, true);
                    int ticks = extracted / 320;
                    this.opStorage.extractEnergy(ticks * 320, false);
                    ((IServerWorldInfo)this.field_145850_b.func_72912_H()).func_82572_b(this.field_145850_b.func_82737_E() + (long)ticks);
                }
                if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() >= this.targetTime) {
                    this.stopTimeWarp();
                }
            }
        } else if (this.timeWarpStopping.get()) {
            if (this.timer > 100) {
                this.timer = 100;
            }
            --this.timer;
            if (this.timer <= 0 && !this.field_145850_b.field_72995_K) {
                this.timeWarpStopping.set(false);
            }
            if (this.field_145850_b.field_72995_K && this.timer >= 0) {
                this.updateSunEffect();
            } else if (this.field_145850_b.field_72995_K) {
                if (this.effects != null) {
                    this.effects.clear();
                }
                if (this.sound != null) {
                    this.sound.kill();
                    this.sound = null;
                }
            }
        } else if (this.active.get()) {
            this.active.set(false);
        } else if (this.field_145850_b.field_72995_K) {
            this.standbyParticleEffect();
        }
    }

    public void toggleWeather(boolean rain, boolean storm) {
        if (this.field_145850_b.field_72995_K || this.active.get()) {
            return;
        }
        this.storm = storm;
        this.rain = rain;
        this.timer = 0;
        this.weatherToggleRunning.set(true);
        this.active.set(true);
    }

    public void startTimeWarp(long targetTime) {
        this.active.set(true);
        this.targetTime = targetTime;
        this.timer = 0;
        this.timeWarpRunning.set(true);
    }

    public void stopTimeWarp() {
        this.timeWarpRunning.set(false);
        this.timeWarpStopping.set(true);
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int id) {
        int intValue;
        if (id == 0) {
            this.handleInteract(data.readString(), (PlayerEntity)client);
        } else if (id == 1 && (intValue = data.readInt()) >= 0 && intValue <= 9) {
            this.rsMode.set((byte)intValue);
        }
    }

    public void handleInteract(String action, PlayerEntity player) {
        if (action.endsWith("STOP") && this.active.get() && this.timeWarpRunning.get()) {
            this.stopTimeWarp();
            return;
        }
        if (this.active.get()) {
            this.sendMessage((ITextComponent)new TranslationTextComponent("msg.de.alreadyRunning.txt"), player);
            return;
        }
        switch (action) {
            case "WEATHER_MODE": {
                this.weatherMode.set(true);
                return;
            }
            case "SUN_MODE": {
                this.weatherMode.set(false);
                return;
            }
            case "STOP_RAIN": {
                if (!this.field_145850_b.func_72896_J()) {
                    this.sendMessage((ITextComponent)new TranslationTextComponent("msg.de.notRaining.txt"), player);
                    return;
                }
                if (this.opStorage.getEnergyStored() < 256000) {
                    this.sendMessage((ITextComponent)new TranslationTextComponent("msg.de.insufficientPower.txt").func_240702_b_(" (256000RF)"), player);
                    return;
                }
                this.opStorage.modifyEnergyStored(-256000L);
                this.toggleWeather(false, false);
                LogHelper.info("Stopped rain! Cause: " + this.field_174879_c);
                return;
            }
            case "START_RAIN": {
                if (this.field_145850_b.func_72896_J()) {
                    this.sendMessage((ITextComponent)new TranslationTextComponent("msg.de.alreadyRaining.txt"), player);
                    return;
                }
                if (this.opStorage.getEnergyStored() < 256000) {
                    this.sendMessage((ITextComponent)new TranslationTextComponent("msg.de.insufficientPower.txt").func_240702_b_(" (256000RF)"), player);
                    return;
                }
                this.opStorage.modifyEnergyStored(-256000L);
                this.toggleWeather(true, false);
                LogHelper.info("Started rain! Cause: " + this.field_174879_c);
                return;
            }
            case "START_STORM": {
                if (this.field_145850_b.func_72896_J() && this.field_145850_b.func_72911_I()) {
                    this.sendMessage((ITextComponent)new TranslationTextComponent("msg.de.alreadyStorm.txt"), player);
                    return;
                }
                if (this.opStorage.getEnergyStored() < 384000) {
                    this.sendMessage((ITextComponent)new TranslationTextComponent("msg.de.insufficientPower.txt").func_240702_b_(" (384000RF)"), player);
                    return;
                }
                this.opStorage.modifyEnergyStored(-384000L);
                this.toggleWeather(true, true);
                LogHelper.info("Started storm! Cause: " + this.field_174879_c);
                return;
            }
            case "SUN_RISE": {
                this.startTimeWarp(this.field_145850_b.func_82737_E() + (long)this.calculateTimeTill(0));
                LogHelper.info("Set time to sunrise! Cause: " + this.field_174879_c);
                break;
            }
            case "MID_DAY": {
                this.startTimeWarp(this.field_145850_b.func_82737_E() + (long)this.calculateTimeTill(5900));
                LogHelper.info("Set time to midday! Cause: " + this.field_174879_c);
                break;
            }
            case "SUN_SET": {
                this.startTimeWarp(this.field_145850_b.func_82737_E() + (long)this.calculateTimeTill(12000));
                LogHelper.info("Set time to sunset! Cause: " + this.field_174879_c);
                break;
            }
            case "MOON_RISE": {
                this.startTimeWarp(this.field_145850_b.func_82737_E() + (long)this.calculateTimeTill(13000));
                LogHelper.info("Set time to moonrise! Cause: " + this.field_174879_c);
                break;
            }
            case "MIDNIGHT": {
                this.startTimeWarp(this.field_145850_b.func_82737_E() + (long)this.calculateTimeTill(17900));
                LogHelper.info("Set time to midnight! Cause: " + this.field_174879_c);
                break;
            }
            case "MOON_SET": {
                this.startTimeWarp(this.field_145850_b.func_82737_E() + (long)this.calculateTimeTill(22500));
                LogHelper.info("Set time to moonset! Cause: " + this.field_174879_c);
                break;
            }
            case "SKIP_24": {
                this.startTimeWarp(this.field_145850_b.func_82737_E() + 24000L);
                LogHelper.info("Skipped one day! Cause: " + this.field_174879_c);
            }
        }
    }

    private void sendMessage(ITextComponent message, PlayerEntity player) {
        if (player != null) {
            player.func_145747_a(message, Util.field_240973_b_);
        }
    }

    private int calculateTimeTill(int time) {
        int currentTime = (int)(this.field_145850_b.func_82737_E() % 24000L);
        return currentTime > time ? 24000 - (currentTime - time) : time - currentTime;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startWeatherEffect() {
        this.timer = 0;
        this.effects = new LinkedList<EffectTrackerCelestialManipulator>();
        for (int i = 0; i < 8; ++i) {
            this.effects.add(new EffectTrackerCelestialManipulator(this.field_145850_b, Vec3D.getCenter((BlockPos)this.field_174879_c).add(0.0, 1.5, 0.0), Vec3D.getCenter((BlockPos)this.field_174879_c).add(0.0, 1.5, 0.0)));
        }
        Vec3D vec = Vec3D.getCenter((BlockPos)this.field_174879_c.func_177982_a(0, 1, 0));
        this.sound = new CelestialModifierSound(DESounds.electricBuzz, this.field_174879_c);
        this.sound.updateSound(vec, 0.01f, 0.5f);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.sound);
        this.field_145850_b.func_184134_a(vec.x, vec.y, vec.z, DESounds.fusionComplete, SoundCategory.BLOCKS, this.getSoundVolume(), 0.5f, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateWeatherEffects() {
        if (this.effects == null || this.effects.size() < 8 || this.sound == null) {
            this.startWeatherEffect();
            return;
        }
        double riseEnd = 20.0;
        double expandStart = 60.0;
        double expandEnd = 100.0;
        double ascendStart = 140.0;
        double ascendStop = 200.0;
        double ascendHeight = 500.0;
        double height = Math.min(riseEnd, (double)this.timer) / riseEnd * 3.0;
        double expansion = (double)this.timer > expandStart ? (Math.min(expandEnd, (double)this.timer) - expandStart) / (expandEnd - expandStart) : 0.0;
        double secondaryExpand = 0.0;
        double ascPos = 0.0;
        if ((double)this.timer > ascendStart) {
            ascPos = ((double)this.timer - ascendStart) / (ascendStop - ascendStart);
            height += ascPos * (ascendHeight * ascPos);
            secondaryExpand = ascPos * ascPos * 100.0;
        }
        Vec3D effectFocus = Vec3D.getCenter((BlockPos)this.field_174879_c).add(0.0, height, 0.0);
        if ((double)this.timer == riseEnd) {
            this.field_145850_b.func_184134_a(effectFocus.x, effectFocus.y, effectFocus.z, DESounds.fusionComplete, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        } else if ((double)this.timer == ascendStart) {
            this.field_145850_b.func_184134_a(effectFocus.x, effectFocus.y, effectFocus.z, DESounds.fusionComplete, SoundCategory.BLOCKS, 1.0f, 2.0f, false);
            for (int i = 0; i < 100; ++i) {
            }
        }
        this.sound.updateSound(effectFocus.copy().add(0.0, -(height * 0.8), 0.0), (float)expansion, (float)expansion + 0.5f);
        for (EffectTrackerCelestialManipulator effect : this.effects) {
            effect.onUpdate();
        }
        double rotation = (double)this.timer * (expansion * 0.05);
        for (EffectTrackerCelestialManipulator effect : this.effects) {
            effect.effectFocus = effectFocus;
            effect.scale = (float)expansion * (1.0f + (float)(ascPos * 5.0));
            double indexPos = (double)this.effects.indexOf(effect) / (double)this.effects.size();
            double offset = indexPos * (Math.PI * 2);
            double offsetX = Math.sin(rotation + offset) * expansion * (3.0 + secondaryExpand);
            double offsetZ = Math.cos(rotation + offset) * expansion * (3.0 + secondaryExpand);
            effect.pos = effectFocus.copy().add(offsetX, 0.0, offsetZ);
            offset = (indexPos + 1.0 / (double)this.effects.size()) * (Math.PI * 2);
            offsetX = Math.sin(rotation + offset) * expansion * (3.0 + secondaryExpand);
            offsetZ = Math.cos(rotation + offset) * expansion * (3.0 + secondaryExpand);
            effect.linkPos = effectFocus.copy().add(offsetX, 0.0, offsetZ);
        }
        if (this.timer >= 220) {
            this.field_145850_b.func_184134_a(effectFocus.x, effectFocus.y, effectFocus.z, DESounds.boom, SoundCategory.BLOCKS, DEOldConfig.disableLoudCelestialManipulator ? 1.0f : 100.0f, 1.0f, false);
            this.timer = 0;
            this.weatherToggleRunning.set(false);
            this.effects.clear();
            this.sound.kill();
            this.sound = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startSunEffect() {
        this.timeWarpRunning.set(true);
        this.timeWarpStopping.set(false);
        this.timer = 0;
        this.effects = new LinkedList<EffectTrackerCelestialManipulator>();
        for (int i = 0; i < 12; ++i) {
            this.effects.add(new EffectTrackerCelestialManipulator(this.field_145850_b, Vec3D.getCenter((BlockPos)this.field_174879_c).add(0.0, 1.5, 0.0), Vec3D.getCenter((BlockPos)this.field_174879_c).add(0.0, 1.5, 0.0)));
        }
        this.effects.get((int)0).red = 1.0f;
        this.effects.get((int)0).green = 0.821f;
        this.effects.get((int)0).blue = 0.174f;
        this.effects.get((int)0).renderBolts = false;
        this.effects.get((int)1).red = 1.0f;
        this.effects.get((int)1).green = 1.0f;
        this.effects.get((int)1).blue = 1.0f;
        this.effects.get((int)1).renderBolts = false;
        this.sound = new CelestialModifierSound(DESounds.sunDialEffect, this.field_174879_c);
        this.sound.updateSound(Vec3D.getCenter((BlockPos)this.field_174879_c), this.getSoundVolume(), 0.5f);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.sound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopSunEffect() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateSunEffect() {
        double offset;
        EffectTrackerCelestialManipulator effect;
        if (this.effects == null || this.effects.size() < 2 || this.sound == null) {
            this.startSunEffect();
        }
        double depProg = Math.min((double)((float)this.timer / 100.0f), 1.0);
        Vec3D focus = Vec3D.getCenter((BlockPos)this.field_174879_c).add(0.0, 5.5 * depProg, 0.0);
        this.sound.updateSound(focus, (float)depProg, 0.5f + (float)depProg);
        if (this.timer % 4 == 0) {
            for (int i = 0; i < (this.timer % 20 <= 10 ? 10 : 2); ++i) {
            }
        }
        double rotation = (double)(this.field_145850_b.func_82737_E() % 24000L) / 24000.0;
        for (int i = 0; i < 2; ++i) {
            effect = this.effects.get(i);
            effect.scale = (float)depProg;
            effect.onUpdate();
            offset = rotation * (Math.PI * 2);
            double offsetX = Math.cos(offset) * 2.5 * depProg;
            double offsetY = Math.sin(offset) * 2.5 * depProg;
            effect.pos = focus.copy().add(offsetX, offsetY, 0.0);
            rotation += 0.5;
            effect.effectFocus = focus;
        }
        rotation = (double)this.timer / 50.0;
        double inc = 1.0 / (double)(this.effects.size() - 2);
        for (int i = 2; i < this.effects.size(); ++i) {
            effect = this.effects.get(i);
            offset = rotation * (Math.PI * 2);
            double x = Math.cos(offset) * 1.0 * depProg;
            double z = Math.sin(offset) * 1.0 * depProg;
            effect.scale = (float)depProg;
            effect.onUpdate();
            effect.pos = focus.copy().add(x, (i % 2 == 0 ? x : -x) * 0.8, z);
            if (i % 2 == 0) {
                effect.red = 0.9f;
                effect.green = 0.5f;
                effect.blue = 0.1f;
            } else {
                effect.red = 0.3f;
                effect.green = 0.2f;
                effect.blue = 1.0f;
            }
            effect.effectFocus = focus;
            effect.renderBolts = false;
            rotation += inc;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void standbyParticleEffect() {
        if (this.effects != null) {
            this.effects = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderEffects(float partialTicks) {
        if (this.effects != null) {
            if (this.weatherToggleRunning.get()) {
                ResourceHelperDE.bindTexture("textures/block/fusion_crafting/fusion_particle.png");
            } else {
                ResourceHelperDE.bindTexture("textures/particle/celestial_manipulator.png");
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            RenderSystem.enableBlend();
            RenderSystem.disableLighting();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.alphaFunc((int)516, (float)0.0f);
            for (EffectTrackerCelestialManipulator effect : this.effects) {
                effect.renderEffect(tessellator, partialTicks);
            }
            RenderSystem.disableBlend();
            RenderSystem.enableLighting();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.alphaFunc((int)516, (float)0.1f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void onNeighborChange(BlockPos blockChanged) {
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            if (!this.redstoneSignal.get()) {
                this.redstoneSignal.set(true);
                this.handleInteract(this.ACTIONS[this.rsMode.get()], null);
            }
        } else if (this.redstoneSignal.get()) {
            this.redstoneSignal.set(false);
            if (this.timeWarpRunning.get() && this.rsMode.get() == 9) {
                this.stopTimeWarp();
            }
        }
    }

    private float getSoundVolume() {
        return DEOldConfig.disableLoudCelestialManipulator ? 1.0f : 10.0f;
    }
}

