/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedLong;
import com.brandon3055.brandonscore.lib.datamanager.ManagedPos;
import com.brandon3055.brandonscore.lib.datamanager.ManagedString;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileChaosCrystal
extends TileBCore
implements ITickableTileEntity {
    public int tick = 0;
    public final ManagedBool guardianDefeated = (ManagedBool)this.register((IManagedData)new ManagedBool("guardian_defeated", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedPos parentPos = (ManagedPos)this.register((IManagedData)new ManagedPos("parent_pos", new BlockPos(0, -1, 0), new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedLong posLock = (ManagedLong)this.register((IManagedData)new ManagedLong("pos_lock", -1L, new DataFlags[]{DataFlags.SAVE_NBT}));
    private final ManagedString dimLock = (ManagedString)this.register((IManagedData)new ManagedString("dim_lock", "", new DataFlags[]{DataFlags.SAVE_NBT}));
    private boolean validatePlacement = false;
    private int soundTimer;
    private boolean removing = false;

    public TileChaosCrystal() {
        super(DEContent.tile_chaos_crystal);
    }

    public void func_73660_a() {
        if (this.validatePlacement) {
            this.posLock.set(this.field_174879_c.func_218275_a());
            this.dimLock.set(this.field_145850_b.func_234923_W_().func_240901_a_().toString());
            for (int i = 1; i <= 2; ++i) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177981_b(i), DEContent.chaos_crystal_part.func_176223_P());
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177979_c(i), DEContent.chaos_crystal_part.func_176223_P());
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177981_b(i));
                if (tile instanceof TileChaosCrystal) {
                    ((TileChaosCrystal)tile).parentPos.set(this.field_174879_c);
                }
                if (!((tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177979_c(i))) instanceof TileChaosCrystal)) continue;
                ((TileChaosCrystal)tile).parentPos.set(this.field_174879_c);
            }
            this.validatePlacement = false;
        }
        if (this.func_195044_w().func_177230_c() != DEContent.chaos_crystal) {
            return;
        }
        ++this.tick;
        if (this.tick > 1 && !this.field_145850_b.field_72995_K && this.hasBeenMoved()) {
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
        if (!this.field_145850_b.field_72995_K && this.soundTimer-- <= 0) {
            this.soundTimer = 3600 + this.field_145850_b.field_73012_v.nextInt(1200);
            BCoreNetwork.sendSound((World)this.field_145850_b, (BlockPos)this.field_174879_c, (SoundEvent)DESounds.chaosChamberAmbient, (SoundCategory)SoundCategory.AMBIENT, (float)1.5f, (float)(this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f), (boolean)false);
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b instanceof ServerWorld && this.guardianDefeated.get() && this.field_145850_b.field_73012_v.nextInt(50) == 0) {
            int x = 5 - this.field_145850_b.field_73012_v.nextInt(11);
            int z = 5 - this.field_145850_b.field_73012_v.nextInt(11);
            LightningBoltEntity bolt = new LightningBoltEntity(EntityType.field_200728_aG, this.field_145850_b);
            bolt.func_70107_b((double)(this.field_174879_c.func_177958_n() + x), (double)this.field_145850_b.func_205770_a(Heightmap.Type.WORLD_SURFACE, this.field_174879_c).func_177956_o(), (double)(this.field_174879_c.func_177952_p() + z));
            bolt.field_70158_ak = true;
            this.field_145850_b.func_217376_c((Entity)bolt);
        }
    }

    public void detonate(Entity entity) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.parentPos.get().func_177956_o() != -1) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.parentPos.get());
            if (tile instanceof TileChaosCrystal && !((TileChaosCrystal)tile).removing) {
                ((TileChaosCrystal)tile).detonate(entity);
                this.field_145850_b.func_225521_a_(tile.func_174877_v(), true, entity);
            }
            return;
        }
        this.removing = true;
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), Blocks.field_150350_a.func_176223_P());
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177981_b(2), Blocks.field_150350_a.func_176223_P());
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177977_b(), Blocks.field_150350_a.func_176223_P());
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177979_c(2), Blocks.field_150350_a.func_176223_P());
        if (DEOldConfig.disableChaosIslandExplosion || this.hasBeenMoved()) {
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
    }

    public void setDefeated() {
        this.guardianDefeated.set(true);
        super.tick();
    }

    public void writeExtraNBT(CompoundNBT compound) {
        super.writeExtraNBT(compound);
        if (this.validatePlacement) {
            compound.func_74757_a("validate_placement", true);
        }
    }

    public void readExtraNBT(CompoundNBT compound) {
        super.readExtraNBT(compound);
        this.validatePlacement = compound.func_74764_b("validate_placement") && compound.func_74767_n("validate_placement");
    }

    public void onValidPlacement() {
        this.validatePlacement = true;
    }

    private boolean hasBeenMoved() {
        return this.posLock.get() != this.field_174879_c.func_218275_a() || !this.dimLock.get().equals(this.field_145850_b.func_234923_W_().func_240901_a_().toString());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)).func_72314_b(3.0, 3.0, 3.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 512.0;
    }

    public boolean saveToItem() {
        return false;
    }

    public boolean canBreak() {
        if (this.parentPos.get().func_177956_o() == -1) {
            return this.guardianDefeated.get();
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.parentPos.get());
        if (tile instanceof TileChaosCrystal) {
            return ((TileChaosCrystal)tile).guardianDefeated.get();
        }
        return false;
    }
}

