/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.lib.IActivatableTile;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedLong;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorldReader;

public class TileCreativeOPCapacitor
extends TileBCore
implements ITickableTileEntity,
IActivatableTile {
    private final ManagedLong powerRate = (ManagedLong)this.register((IManagedData)new ManagedLong("power_rate", 1000000000L, new DataFlags[]{DataFlags.SAVE_NBT}));

    public TileCreativeOPCapacitor() {
        super(DEContent.tile_creative_op_capacitor);
        this.capManager.set(CapabilityOP.OP, (Object)new IOPStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return (int)Math.min((long)maxReceive, TileCreativeOPCapacitor.this.powerRate.get());
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return (int)Math.min((long)maxExtract, TileCreativeOPCapacitor.this.powerRate.get());
            }

            public int getEnergyStored() {
                return 0x3FFFFFFF;
            }

            public int getMaxEnergyStored() {
                return Integer.MAX_VALUE;
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return true;
            }

            public long getOPStored() {
                return 0x3FFFFFFFFFFFFFFFL;
            }

            public long getMaxOPStored() {
                return Long.MAX_VALUE;
            }

            public long receiveOP(long maxReceive, boolean simulate) {
                return Math.min(maxReceive, TileCreativeOPCapacitor.this.powerRate.get());
            }

            public long extractOP(long maxExtract, boolean simulate) {
                return Math.min(maxExtract, TileCreativeOPCapacitor.this.powerRate.get());
            }
        }, new Direction[0]);
    }

    public void func_73660_a() {
        super.tick();
        if (!this.field_145850_b.field_72995_K) {
            for (Direction direction : Direction.values()) {
                TileCreativeOPCapacitor.sendEnergyTo((IWorldReader)this.field_145850_b, (BlockPos)this.field_174879_c, (long)this.powerRate.get(), (Direction)direction);
            }
        }
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!this.field_145850_b.field_72995_K) {
            if (player.func_225608_bj_()) {
                this.powerRate.divide(10L);
            } else if (this.powerRate.get() == Long.MAX_VALUE) {
                this.powerRate.set(1L);
            } else {
                this.powerRate.multiply(10L);
            }
            if (this.powerRate.get() < 1L) {
                this.powerRate.set(Long.MAX_VALUE);
            }
            BrandonsCore.proxy.sendIndexedMessage(player, (ITextComponent)new StringTextComponent("Power Rate: " + Utils.addCommas((long)this.powerRate.get()) + " OP/t"), 42);
        }
        return true;
    }
}

