/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.api.ITeleportEndPoint;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.handlers.DislocatorLinkHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileDislocatorPedestal
extends TileBCore
implements ITeleportEndPoint {
    private static final ResourceLocation WOOL_TAG = new ResourceLocation("forge:wool");
    public final ManagedInt rotation = (ManagedInt)this.register((IManagedData)new ManagedInt("rotation", 0, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public TileItemStackHandler itemHandler = new TileItemStackHandler(1);

    public TileDislocatorPedestal() {
        super(DEContent.tile_dislocator_pedestal);
        this.capManager.setManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler, new Direction[0]);
        this.itemHandler.setSlotValidator(0, stack -> stack.func_77973_b() instanceof Dislocator);
    }

    public boolean onBlockActivated(PlayerEntity player) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!player.func_225608_bj_() && !stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof Dislocator) {
                boolean silenced;
                TargetPos location = ((Dislocator)stack.func_77973_b()).getTargetPos(stack, this.field_145850_b);
                if (location == null) {
                    if (DEContent.dislocator_p2p.isValid(stack)) {
                        if (DEContent.dislocator_p2p.isPlayer(stack)) {
                            ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.de.bound_dislocator.cant_find_player").func_240699_a_(TextFormatting.RED), (int)34);
                        } else {
                            ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.de.bound_dislocator.cant_find_player").func_240699_a_(TextFormatting.RED), (int)34);
                        }
                    }
                    return true;
                }
                if (DEContent.dislocator_p2p.isValid(stack)) {
                    location.setYaw(player.field_70177_z);
                    location.setPitch(player.field_70125_A);
                }
                if (!(silenced = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c().getTags().contains(WOOL_TAG))) {
                    BCoreNetwork.sendSound((World)player.field_70170_p, (BlockPos)player.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
                }
                DEContent.dislocator_p2p.notifyArriving(stack, player.field_70170_p, (Entity)player);
                location.teleport((Entity)player);
                if (!silenced) {
                    BCoreNetwork.sendSound((World)player.field_70170_p, (BlockPos)player.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
                }
            }
            return true;
        }
        InventoryUtils.handleHeldStackTransfer((int)0, (IItemHandlerModifiable)this.itemHandler, (PlayerEntity)player);
        if (DEContent.dislocator_p2p.isValid(stack) && !DEContent.dislocator_p2p.isPlayer(stack) && this.itemHandler.getStackInSlot(0).func_190926_b()) {
            DislocatorLinkHandler.updateLink(this.field_145850_b, stack, player);
        }
        this.checkIn();
        this.func_70296_d();
        this.updateBlock();
        return true;
    }

    @Override
    public BlockPos getArrivalPos(String linkID) {
        if (!DEContent.dislocator_p2p.isValid(this.itemHandler.getStackInSlot(0)) || !DEContent.dislocator_p2p.getLinkID(this.itemHandler.getStackInSlot(0)).equals(linkID)) {
            return null;
        }
        return this.func_174877_v();
    }

    @Override
    public void entityArriving(Entity entity) {
    }

    public void checkIn() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (DEContent.dislocator_p2p.isValid(stack) && !DEContent.dislocator_p2p.isPlayer(stack)) {
            DislocatorLinkHandler.updateLink(this.field_145850_b, stack, this.field_174879_c, (RegistryKey<World>)this.field_145850_b.func_234923_W_());
        }
    }
}

