/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.Pair;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.ITeleportEndPoint;
import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.brandon3055.draconicevolution.api.energy.IENetEffectTile;
import com.brandon3055.draconicevolution.blocks.DislocatorReceptacle;
import com.brandon3055.draconicevolution.blocks.Portal;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerClient;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandlerServer;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePortal;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXBase;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.handlers.DislocatorLinkHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileDislocatorReceptacle
extends TileBCore
implements ITickableTileEntity,
ITeleportEndPoint,
ICrystalLink,
IENetEffectTile {
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedBool camo = (ManagedBool)this.register((IManagedData)new ManagedBool("camo", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedBool ltRedstone = (ManagedBool)this.register((IManagedData)new ManagedBool("lt_redstone", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedVec3I spawnPos = (ManagedVec3I)this.register((IManagedData)new ManagedVec3I("spawn_pos", new Vec3I(0, -999, 0), new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedEnum<Direction.Axis> activeAxis = (ManagedEnum)this.register((IManagedData)new ManagedEnum("active_axis", (Enum)Direction.Axis.X, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool isBound = (ManagedBool)this.register((IManagedData)new ManagedBool("is_bound", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedVec3I linkedCrystal = (ManagedVec3I)this.register((IManagedData)new ManagedVec3I("linked_crystal", new Vec3I(0, -999, 0), new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte remoteCrystalTier = (ManagedByte)this.register((IManagedData)new ManagedByte("remote_crystal_tier", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedByte linkedFlowRate = (ManagedByte)this.register((IManagedData)new ManagedByte("linked_flow_rate", new DataFlags[]{DataFlags.SAVE_NBT}));
    public final ManagedVec3I crystalLinkPos = (ManagedVec3I)this.register((IManagedData)new ManagedVec3I("crystal_link+pos", new Vec3I(0, -999, 0), new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public int hiddenTime = 0;
    public boolean igniting = false;
    public boolean frameMoving = false;
    private List<Entity> teleportQ = new ArrayList<Entity>();
    private Map<Integer, Integer> coolDownMap = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> arrivalsMap = new HashMap<Integer, Integer>();
    public TileItemStackHandler itemHandler = new TileItemStackHandler(1);
    private BlockPos remotePosCache = null;
    private RegistryKey<World> remoteDimCache = World.field_234918_g_;
    private int invalidLinkTime = 0;
    protected ENetFXHandler fxHandler;
    boolean hashCached = false;
    int hashID = 0;

    public TileDislocatorReceptacle() {
        super(DEContent.tile_dislocator_receptacle);
        this.capManager.setManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler, new Direction[0]).saveBoth();
        this.itemHandler.setContentsChangeListener(this::onInventoryChange);
        this.itemHandler.setSlotValidator(0, stack -> stack.func_77973_b() instanceof Dislocator);
        this.fxHandler = DraconicEvolution.proxy.createENetFXHandler(this);
    }

    public void func_73660_a() {
        super.tick();
        this.updateHidden(false);
        this.updateCrystalLogic();
        if (this.field_145850_b.field_72995_K && !this.active.get()) {
            this.hiddenTime = 5;
        }
        if (this.frameMoving) {
            if (this.active.get()) {
                this.finishMove(this.field_174879_c, new HashSet<BlockPos>());
            }
            this.frameMoving = false;
            this.checkIn();
        }
        for (Entity entity : this.teleportQ) {
            ItemStack stack = this.itemHandler.getStackInSlot(0);
            if (!(stack.func_77973_b() instanceof Dislocator)) {
                this.deactivate();
                return;
            }
            TargetPos location = ((Dislocator)stack.func_77973_b()).getTargetPos(stack, this.field_145850_b);
            if (DEContent.dislocator_p2p.isValid(stack) && location != null) {
                location.setYaw(entity.field_70177_z);
                location.setPitch(entity.field_70125_A);
            }
            if (location == null) {
                if (!DEContent.dislocator_p2p.isValid(stack)) {
                    this.deactivate();
                } else if (entity instanceof PlayerEntity) {
                    if (DEContent.dislocator_p2p.isPlayer(stack)) {
                        ChatHelper.sendMessage((PlayerEntity)((PlayerEntity)entity), (ITextComponent)new TranslationTextComponent("info.de.bound_dislocator.cant_find_player").func_240699_a_(TextFormatting.RED));
                    } else {
                        ChatHelper.sendMessage((PlayerEntity)((PlayerEntity)entity), (ITextComponent)new TranslationTextComponent("info.de.bound_dislocator.cant_find_target").func_240699_a_(TextFormatting.RED));
                    }
                }
                this.teleportQ.clear();
                return;
            }
            DEContent.dislocator_p2p.notifyArriving(stack, this.field_145850_b, entity);
            BCoreNetwork.sendSound((World)entity.field_70170_p, (BlockPos)entity.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(entity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
            location.teleport(entity);
            BCoreNetwork.sendSound((World)entity.field_70170_p, (BlockPos)entity.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(entity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
        }
        try {
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (Integer key : this.coolDownMap.keySet()) {
                if (this.coolDownMap.get(key) > 0) {
                    this.coolDownMap.put(key, this.coolDownMap.get(key) - 1);
                    continue;
                }
                toRemove.add(key);
            }
            for (Integer i : toRemove) {
                this.coolDownMap.remove(i);
            }
            toRemove.clear();
            toRemove = new ArrayList();
            for (Integer key : this.arrivalsMap.keySet()) {
                if (this.arrivalsMap.get(key) > 0) {
                    this.arrivalsMap.put(key, this.arrivalsMap.get(key) - 1);
                    continue;
                }
                toRemove.add(key);
            }
            for (Integer i : toRemove) {
                this.arrivalsMap.remove(i);
            }
            toRemove.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.teleportQ.clear();
    }

    private void updateCrystalLogic() {
        boolean boundCrystals;
        this.fxHandler.update();
        boolean bl = boundCrystals = this.active.get() && this.isBound.get() && this.linkedCrystal.get().y != -999;
        if (this.field_145850_b.field_72995_K && boundCrystals && this.remoteCrystalTier.isDirty(true)) {
            this.fxHandler.reloadConnections();
        }
        if (!this.field_145850_b.field_72995_K && boundCrystals) {
            if (DEEventHandler.serverTicks % 10 == 0) {
                TileDislocatorReceptacle remoteTile = this.getRemoteReceptacle();
                ICrystalLink remote = this.getRemoteCrystal();
                if (remoteTile != null && remote instanceof IENetEffectTile) {
                    int i = remote.getLinks().indexOf(remoteTile.func_174877_v());
                    LinkedList<Byte> rates = ((IENetEffectTile)remote).getFlowRates();
                    if (i >= 0 && i < rates.size()) {
                        this.linkedFlowRate.set(((Byte)rates.get(i)).byteValue());
                    } else {
                        this.linkedFlowRate.zero();
                    }
                } else {
                    this.linkedFlowRate.zero();
                }
            }
            if (this.linkedFlowRate.get() != 0 && DEEventHandler.serverTicks % 100 == 0) {
                this.dataManager.forceSync((IManagedData)this.linkedFlowRate);
            }
        } else if (!this.field_145850_b.field_72995_K) {
            this.linkedFlowRate.zero();
        }
    }

    public void setHidden() {
        boolean firstSet = this.hiddenTime == 0;
        this.hiddenTime = 30;
        if (firstSet) {
            this.updateHidden(true);
        }
    }

    private void updateHidden(boolean setHidden) {
        if (this.field_145850_b.field_72995_K && this.hiddenTime > 0) {
            --this.hiddenTime;
            if (this.hiddenTime == 0 || setHidden) {
                long time = System.nanoTime();
                for (BlockPos checkPos : BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 1, 1))) {
                    BlockPos spawn;
                    TileEntity tile = this.field_145850_b.func_175625_s(checkPos);
                    if (!(tile instanceof TilePortal)) continue;
                    BlockPos blockPos = spawn = this.spawnPos.get().y == -999 ? this.field_174879_c : this.getSpawnPos();
                    TilePortal tPortal = (TilePortal)tile;
                    if (!tPortal.getMasterPos().equals((Object)this.field_174879_c) || tPortal.updateTime == time) continue;
                    if (!setHidden) {
                        this.field_145850_b.func_184134_a((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o() + 0.5, (double)spawn.func_177952_p() + 0.5, SoundEvents.field_187625_bm, SoundCategory.BLOCKS, 2.0f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, false);
                    }
                    ((TilePortal)tile).propRenderUpdate(time, !setHidden);
                }
            }
        }
    }

    public boolean onBlockActivated(PlayerEntity player) {
        if (this.field_145850_b.field_72995_K) {
            return !this.ltRedstone.get();
        }
        InventoryUtils.handleHeldStackTransfer((int)0, (IItemHandlerModifiable)this.itemHandler, (PlayerEntity)player);
        return true;
    }

    public void onInventoryChange(int index) {
        ItemStack prev = this.itemHandler.getListenerPrevStack();
        if (DEContent.dislocator_p2p.isValid(prev) && !DEContent.dislocator_p2p.isPlayer(prev)) {
            DislocatorLinkHandler.removeLink(this.field_145850_b, prev);
        }
        this.isBound.set(false);
        if (this.itemHandler.getStackInSlot(0).func_190926_b() && this.active.get()) {
            this.deactivate();
        } else if (!this.itemHandler.getStackInSlot(0).func_190926_b()) {
            this.attemptIgnition();
            this.checkIn();
        }
    }

    private void checkIn() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (DEContent.dislocator_p2p.isValid(stack) && !DEContent.dislocator_p2p.isPlayer(stack)) {
            DislocatorLinkHandler.updateLink(this.field_145850_b, stack, this.field_174879_c, (RegistryKey<World>)this.field_145850_b.func_234923_W_());
            this.isBound.set(true);
        } else {
            this.isBound.set(false);
        }
    }

    public void handleEntityTeleport(Entity entity) {
        if (this.field_145850_b.field_72995_K || this.teleportQ.contains(entity) || this.coolDownMap.containsKey(entity.func_145782_y())) {
            return;
        }
        if (this.arrivalsMap.containsKey(entity.func_145782_y())) {
            if (!(entity instanceof PlayerEntity) || this.arrivalsMap.get(entity.func_145782_y()) < 10) {
                // empty if block
            }
            this.arrivalsMap.put(entity.func_145782_y(), 10);
            return;
        }
        this.coolDownMap.put(entity.func_145782_y(), 10);
        this.teleportQ.add(entity);
    }

    public void deactivate() {
        BlockState state;
        if (!this.field_145850_b.field_72995_K) {
            this.active.set(false);
        }
        if ((state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == DEContent.dislocator_receptacle) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)DislocatorReceptacle.ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
        for (BlockPos checkPos : BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 1, 1))) {
            TileEntity tile = this.field_145850_b.func_175625_s(checkPos);
            if (!(tile instanceof TilePortal) || !((TilePortal)tile).getMasterPos().equals((Object)this.field_174879_c)) continue;
            this.field_145850_b.func_217377_a(tile.func_174877_v(), false);
        }
        this.updateBlock();
    }

    public boolean attemptIgnition() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!(stack.func_77973_b() instanceof Dislocator && ((Dislocator)stack.func_77973_b()).getTargetPos(stack, this.field_145850_b) != null || DEContent.dislocator_p2p.isValid(stack))) {
            return false;
        }
        Pair<Direction.Axis, List<BlockPos>> portalConfiguration = this.scanConfigurations();
        if (portalConfiguration != null) {
            this.igniting = true;
            for (BlockPos portalBlock : (List)portalConfiguration.value()) {
                this.field_145850_b.func_175656_a(portalBlock, (BlockState)DEContent.portal.func_176223_P().func_206870_a(Portal.AXIS, (Comparable)portalConfiguration.key()));
                TileEntity tile = this.field_145850_b.func_175625_s(portalBlock);
                if (!(tile instanceof TilePortal)) continue;
                ((TilePortal)tile).setMasterPos(this.field_174879_c);
            }
            this.active.set(true);
            this.activeAxis.set((Enum)portalConfiguration.key());
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() == DEContent.dislocator_receptacle) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)DislocatorReceptacle.ACTIVE, (Comparable)Boolean.valueOf(true)));
            }
            this.updateBlock();
            this.igniting = false;
            if (DEContent.dislocator_p2p.isValid(stack) && !DEContent.dislocator_p2p.isPlayer(stack)) {
                this.updateSpawnBlock((List)portalConfiguration.value());
                this.updateLinkBlock((List)portalConfiguration.value());
            }
            return true;
        }
        return false;
    }

    private void updateSpawnBlock(List<BlockPos> rawBlocks) {
        HashMap levelMap = new HashMap();
        rawBlocks.forEach(block -> levelMap.computeIfAbsent(block.func_177956_o(), integer -> new ArrayList()).add(block));
        LinkedList levels = new LinkedList(levelMap.keySet());
        levels.sort(Comparator.naturalOrder());
        ArrayList<BlockPos> foundValid = new ArrayList<BlockPos>();
        Iterator iterator = levels.iterator();
        while (iterator.hasNext()) {
            int level = (Integer)iterator.next();
            List blocks = (List)levelMap.get(level);
            for (BlockPos pos : blocks) {
                if (!this.field_145850_b.func_175623_d(pos.func_177984_a()) && this.field_145850_b.func_180495_p(pos.func_177984_a()).func_177230_c() != DEContent.portal) continue;
                foundValid.add(pos);
            }
            if (foundValid.isEmpty()) continue;
            break;
        }
        if (foundValid.isEmpty()) {
            this.spawnPos.set(new Vec3I(0, -999, 0));
            return;
        }
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (BlockPos pos : foundValid) {
            if (pos.func_177958_n() > maxX) {
                maxX = pos.func_177958_n();
            }
            if (pos.func_177956_o() > maxY) {
                maxY = pos.func_177956_o();
            }
            if (pos.func_177952_p() > maxZ) {
                maxZ = pos.func_177952_p();
            }
            if (pos.func_177958_n() < minX) {
                minX = pos.func_177958_n();
            }
            if (pos.func_177956_o() < minY) {
                minY = pos.func_177956_o();
            }
            if (pos.func_177952_p() >= minZ) continue;
            minZ = pos.func_177952_p();
        }
        Vec3D center = new Vec3D((double)(minX + (maxX - minX) / 2) + 0.5, (double)(minY + (maxY - minY) / 2) + 0.5, (double)(minZ + (maxZ - minZ) / 2) + 0.5);
        BlockPos closestPos = (BlockPos)foundValid.get(0);
        double closest = 1.0E7;
        for (BlockPos pos : foundValid) {
            double dist = Utils.getDistanceSq((double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (double)center.x, (double)center.y, (double)center.z);
            if (!(dist < closest)) continue;
            closest = dist;
            closestPos = pos;
        }
        this.setSpawnPos(closestPos);
    }

    private void updateLinkBlock(List<BlockPos> rawBlocks) {
        if (rawBlocks.isEmpty()) {
            this.crystalLinkPos.set(new Vec3I(0, -999, 0));
            return;
        }
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (BlockPos pos : rawBlocks) {
            if (pos.func_177958_n() > maxX) {
                maxX = pos.func_177958_n();
            }
            if (pos.func_177956_o() > maxY) {
                maxY = pos.func_177956_o();
            }
            if (pos.func_177952_p() > maxZ) {
                maxZ = pos.func_177952_p();
            }
            if (pos.func_177958_n() < minX) {
                minX = pos.func_177958_n();
            }
            if (pos.func_177956_o() < minY) {
                minY = pos.func_177956_o();
            }
            if (pos.func_177952_p() >= minZ) continue;
            minZ = pos.func_177952_p();
        }
        Vec3D center = new Vec3D((double)(minX + (maxX - minX) / 2) + 0.5, (double)(minY + (maxY - minY) / 2) + 0.5, (double)(minZ + (maxZ - minZ) / 2) + 0.5);
        BlockPos closestPos = rawBlocks.get(0);
        double closest = 1.0E7;
        for (BlockPos pos : rawBlocks) {
            double dist = Utils.getDistanceSq((double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (double)center.x, (double)center.y, (double)center.z);
            if (!(dist < closest)) continue;
            closest = dist;
            closestPos = pos;
        }
        this.setLinkPos(closestPos);
    }

    private Pair<Direction.Axis, List<BlockPos>> scanConfigurations() {
        List<BlockPos> portalBlocks;
        ArrayList<Object> scanned = new ArrayList<BlockPos>();
        for (BlockPos offset : FacingUtils.AROUND_X) {
            portalBlocks = this.scanFromOrigin(this.field_174879_c.func_177971_a((Vector3i)offset), Direction.Axis.X, scanned);
            if (portalBlocks == null) continue;
            return new Pair((Object)Direction.Axis.X, portalBlocks);
        }
        scanned = new ArrayList();
        for (BlockPos offset : FacingUtils.AROUND_Y) {
            portalBlocks = this.scanFromOrigin(this.field_174879_c.func_177971_a((Vector3i)offset), Direction.Axis.Y, scanned);
            if (portalBlocks == null) continue;
            return new Pair((Object)Direction.Axis.Y, portalBlocks);
        }
        scanned = new ArrayList();
        for (BlockPos offset : FacingUtils.AROUND_Z) {
            portalBlocks = this.scanFromOrigin(this.field_174879_c.func_177971_a((Vector3i)offset), Direction.Axis.Z, scanned);
            if (portalBlocks == null) continue;
            return new Pair((Object)Direction.Axis.Z, portalBlocks);
        }
        return null;
    }

    private List<BlockPos> scanFromOrigin(BlockPos scanOrigin, Direction.Axis scanAxis, List<BlockPos> alreadyScanned) {
        if (!this.field_145850_b.func_175623_d(scanOrigin) || alreadyScanned.contains(scanOrigin)) {
            return null;
        }
        ArrayList<BlockPos> scannedBlocks = new ArrayList<BlockPos>();
        if (this.scanPortal(scanOrigin, scanOrigin, scanAxis, scannedBlocks, alreadyScanned)) {
            return scannedBlocks;
        }
        return null;
    }

    private boolean scanPortal(BlockPos scanPos, BlockPos origin, Direction.Axis scanAxis, List<BlockPos> scanList, List<BlockPos> blackList) {
        Vec3D vec3D = new Vec3D(scanPos);
        Vec3D vec3D2 = new Vec3D(origin);
        if (Utils.getDistanceAtoB((Vec3D)vec3D, (Vec3D)vec3D2) > 100.0) {
            return false;
        }
        scanList.add(scanPos);
        for (Direction facing : FacingUtils.getFacingsAroundAxis((Direction.Axis)scanAxis)) {
            BlockPos nextPos = scanPos.func_177972_a(facing);
            if (scanList.contains(nextPos) || this.isFrame(nextPos)) continue;
            if (this.field_145850_b.func_175623_d(nextPos)) {
                if (this.scanPortal(nextPos, origin, scanAxis, scanList, blackList)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isFrame(BlockPos pos) {
        BlockState state = this.field_145850_b.func_180495_p(pos);
        return state.func_177230_c() == DEContent.infused_obsidian || state.func_177230_c() == DEContent.dislocator_receptacle;
    }

    @Override
    public BlockPos getArrivalPos(String linkID) {
        if (!(this.active.get() && DEContent.dislocator_p2p.isValid(this.itemHandler.getStackInSlot(0)) && DEContent.dislocator_p2p.getLinkID(this.itemHandler.getStackInSlot(0)).equals(linkID))) {
            return null;
        }
        return this.spawnPos.get().y == -999 ? null : this.getSpawnPos();
    }

    @Override
    public void entityArriving(Entity entity) {
        Entity rootEntity = entity.func_184208_bv();
        PassengerHelper passengerHelper = new PassengerHelper(rootEntity);
        passengerHelper.forEach(e -> this.arrivalsMap.put(e.func_145782_y(), 10));
    }

    public void setSpawnPos(BlockPos spawnPos) {
        this.spawnPos.get().set(this.field_174879_c.func_177973_b((Vector3i)spawnPos));
    }

    protected BlockPos getSpawnPos() {
        return this.field_174879_c.func_177973_b((Vector3i)this.spawnPos.get().getPos());
    }

    public void setLinkPos(BlockPos spawnPos) {
        this.crystalLinkPos.get().set(this.field_174879_c.func_177973_b((Vector3i)spawnPos));
    }

    protected BlockPos getLinkPos() {
        return this.field_174879_c.func_177973_b((Vector3i)this.crystalLinkPos.get().getPos());
    }

    public void finishMove(BlockPos pos, HashSet<BlockPos> blocks) {
        for (Direction facing : FacingUtils.getFacingsAroundAxis((Direction.Axis)((Direction.Axis)this.activeAxis.get()))) {
            BlockState state;
            BlockPos np = pos.func_177972_a(facing);
            if (blocks.contains(np) || (state = this.field_145850_b.func_180495_p(np)).func_177230_c() != DEContent.portal) continue;
            TileEntity tile = this.field_145850_b.func_175625_s(np);
            if (tile instanceof TilePortal) {
                ((TilePortal)tile).frameMoving = false;
            }
            blocks.add(np);
            this.finishMove(np, blocks);
        }
    }

    protected void setCrystalPos(BlockPos crystalPos) {
        this.linkedCrystal.get().set(this.field_174879_c.func_177973_b((Vector3i)crystalPos));
    }

    protected BlockPos getCrystalPos() {
        return this.field_174879_c.func_177973_b((Vector3i)this.linkedCrystal.get().getPos());
    }

    private TileDislocatorReceptacle getRemoteReceptacle() {
        return this.getRemoteReceptacle(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TileDislocatorReceptacle getRemoteReceptacle(boolean skipRemoteCheck) {
        MinecraftServer server;
        TileEntity tile;
        if (!this.isBound.get() || !this.active.get()) {
            return null;
        }
        if (this.invalidLinkTime > 0) {
            --this.invalidLinkTime;
            return null;
        }
        if (this.remotePosCache == null) {
            ItemStack stack = this.itemHandler.getStackInSlot(0);
            if (!DEContent.dislocator_p2p.isValid(stack) || DEContent.dislocator_p2p.isPlayer(stack)) return null;
            tile = DislocatorLinkHandler.getTargetTile(this.field_145850_b, stack);
            if (tile instanceof TileDislocatorReceptacle) {
                this.remotePosCache = tile.func_174877_v();
                this.remoteDimCache = tile.func_145831_w().func_234923_W_();
            } else {
                this.invalidLinkTime = 100;
                return null;
            }
        }
        if ((server = this.field_145850_b.func_73046_m()) == null) return null;
        tile = server.func_71218_a(this.remoteDimCache).func_175625_s(this.remotePosCache);
        if (tile instanceof TileDislocatorReceptacle) {
            if (skipRemoteCheck) {
                return (TileDislocatorReceptacle)tile;
            }
            if (((TileDislocatorReceptacle)tile).active.get() && ((TileDislocatorReceptacle)tile).getRemoteReceptacle(true) == this) {
                return (TileDislocatorReceptacle)tile;
            }
        }
        this.remotePosCache = null;
        return null;
    }

    private ICrystalLink getRemoteCrystal() {
        MinecraftServer server;
        TileDislocatorReceptacle tile = this.getRemoteReceptacle();
        if (tile != null && (server = this.field_145850_b.func_73046_m()) != null && tile.linkedCrystal.get().y != -999) {
            TileEntity crystal = server.func_71218_a(this.remoteDimCache).func_175625_s(tile.getCrystalPos());
            if (crystal instanceof IENetEffectTile) {
                this.remoteCrystalTier.set((byte)((IENetEffectTile)crystal).getTier());
                return (ICrystalLink)crystal;
            }
            return null;
        }
        return null;
    }

    @Override
    @Nonnull
    public List<BlockPos> getLinks() {
        if (this.linkedCrystal.get().y != -999) {
            return Collections.singletonList(this.getCrystalPos());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean binderUsed(PlayerEntity player, BlockPos linkTarget, Direction sideClicked) {
        return false;
    }

    @Override
    public boolean createLink(ICrystalLink otherCrystal) {
        this.setCrystalPos(((TileEntity)otherCrystal).func_174877_v());
        return true;
    }

    @Override
    public void breakLink(BlockPos otherCrystal) {
        this.linkedCrystal.set(new Vec3I(0, -999, 0));
    }

    @Override
    public int balanceMode() {
        ICrystalLink remote = this.getRemoteCrystal();
        return remote != null ? remote.balanceMode() : 1;
    }

    @Override
    public int maxLinks() {
        return 1;
    }

    @Override
    public int maxLinkRange() {
        return 32;
    }

    @Override
    public long getEnergyStored() {
        ICrystalLink remote = this.getRemoteCrystal();
        return remote != null ? remote.getEnergyStored() : 0L;
    }

    @Override
    public long getMaxEnergyStored() {
        ICrystalLink remote = this.getRemoteCrystal();
        return remote != null ? remote.getMaxEnergyStored() : 0L;
    }

    @Override
    public void modifyEnergyStored(long energy) {
        ICrystalLink remote = this.getRemoteCrystal();
        if (remote != null) {
            remote.modifyEnergyStored(energy);
        }
    }

    @Override
    public Vec3D getBeamLinkPos(BlockPos linkTo) {
        double dist = FacingUtils.distanceInDirection((BlockPos)this.field_174879_c, (BlockPos)linkTo, (Direction)FacingUtils.getAxisFaces((Direction.Axis)((Direction.Axis)this.activeAxis.get()))[0]);
        Vec3D vec = Vec3D.getCenter((BlockPos)this.getLinkPos());
        Direction facing = dist > 0.0 ? FacingUtils.getAxisFaces((Direction.Axis)((Direction.Axis)this.activeAxis.get()))[0] : FacingUtils.getAxisFaces((Direction.Axis)((Direction.Axis)this.activeAxis.get()))[1];
        vec.add((double)facing.func_82601_c() * 0.35, (double)facing.func_96559_d() * 0.35, (double)facing.func_82599_e() * 0.35);
        return vec;
    }

    @Override
    public boolean renderBeamTermination() {
        return true;
    }

    @Override
    public ENetFXHandler createServerFXHandler() {
        return new ENetFXHandlerServer<TileDislocatorReceptacle>(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ENetFXHandler createClientFXHandler() {
        return new ENetFXHandlerClient<TileDislocatorReceptacle>(this);
    }

    @Override
    public boolean hasStaticFX() {
        return false;
    }

    @Override
    public CrystalFXBase createStaticFX() {
        return null;
    }

    @Override
    public LinkedList<Byte> getFlowRates() {
        return new LinkedList<Byte>(Collections.singletonList(this.linkedFlowRate.get()));
    }

    @Override
    public int getTier() {
        return this.remoteCrystalTier.get();
    }

    @Override
    public int getIDHash() {
        if (!this.hashCached) {
            this.hashID = this.field_174879_c.hashCode();
            this.hashCached = true;
        }
        return this.hashID;
    }

    private static class PassengerHelper {
        public Entity entity;
        public LinkedList<PassengerHelper> passengers = new LinkedList();

        public PassengerHelper(Entity entity) {
            this.entity = entity;
            for (Entity passenger : entity.func_184188_bt()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        public void forEach(Consumer<Entity> action) {
            action.accept(this.entity);
            this.passengers.forEach((? super T helper) -> helper.forEach(action));
        }
    }
}

