/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.inventory.InventoryUtils;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.ItemHandlerIOControl;
import com.brandon3055.brandonscore.inventory.ItemHandlerSlotWrapper;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IActivatableTile;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedDouble;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.blocks.DraconiumChest;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.OreDoublingRegistry;
import com.brandon3055.draconicevolution.inventory.ContainerDraconiumChest;
import com.brandon3055.draconicevolution.items.ItemCore;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileDraconiumChest
extends TileBCore
implements ITickableTileEntity,
IRSSwitchable,
INamedContainerProvider,
IActivatableTile {
    private NonNullList<ItemStack> craftingStacks = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
    public ManagedEnum<AutoSmeltMode> autoSmeltMode = (ManagedEnum)this.register((IManagedData)new ManagedEnum("auto_smelt_mode", (Enum)AutoSmeltMode.OFF, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER}));
    public ManagedEnum<Direction> facing = (ManagedEnum)this.register((IManagedData)new ManagedEnum("facing", (Enum)Direction.NORTH, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public ManagedDouble burnRate = (ManagedDouble)this.register((IManagedData)new ManagedDouble("burn_rate", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER}));
    public ManagedDouble smeltProgress = (ManagedDouble)this.register((IManagedData)new ManagedDouble("smelt_progress", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER}));
    public ManagedBool isSmelting = (ManagedBool)this.register((IManagedData)new ManagedBool("is_smelting", new DataFlags[]{DataFlags.SAVE_BOTH}));
    public ManagedBool furnaceOutputBlocked = (ManagedBool)this.register((IManagedData)new ManagedBool("furnace_output_blocked", new DataFlags[]{DataFlags.SAVE_BOTH}));
    public ManagedInt smeltEnergyPerTick = (ManagedInt)this.register((IManagedData)new ManagedInt("smelt_energy_per_tick", 256, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER}));
    public ManagedInt colour = (ManagedInt)this.register((IManagedData)new ManagedInt("colour", 6553750, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public ManagedShort numPlayersUsing = (ManagedShort)this.register((IManagedData)new ManagedShort("num_players_using", new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", false, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public ManagedByte smeltTime = (ManagedByte)this.register((IManagedData)new ManagedByte("smelt_time", 100, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER}));
    public float prevLidAngle;
    public float lidAngle;
    private int ticksSinceSync;
    public static int LAST_CHEST_SLOT = 259;
    public static int FIRST_FURNACE_SLOT = 260;
    public static int LAST_FURNACE_SLOT = 264;
    public static int CAPACITOR_SLOT = 265;
    public static int CORE_SLOT = 266;
    private boolean autoFeedRun = false;
    private boolean autoFeedScheduled = false;
    public TileItemStackHandler itemHandler = new TileItemStackHandler(267);
    public OPStorage opStorage = new OPStorage(1000000L, 32000L, 0L);
    public SlotRegion[] slotRegions = new SlotRegion[7];
    int itemsSmelted;
    public boolean ioCacheValid;
    private int[][] sidedSlots;
    private boolean[][] canInsert;
    private boolean[][] canExtract;
    private Set<Integer> furnaceInputs;
    private int[] furnaceOutputs;

    public TileDraconiumChest() {
        super(DEContent.tile_draconium_chest);
        this.slotRegions[0] = new SlotRegion(0, 0xFF0000, false);
        this.slotRegions[1] = new SlotRegion(1, 65280, false);
        this.slotRegions[2] = new SlotRegion(2, 255, false);
        this.slotRegions[3] = new SlotRegion(3, 0xFFFF00, false);
        this.slotRegions[4] = new SlotRegion(4, 65535, false);
        this.slotRegions[5] = new SlotRegion(5, 0xFF00FF, false);
        this.slotRegions[6] = new SlotRegion(6, 0, true);
        this.itemsSmelted = 0;
        this.ioCacheValid = false;
        this.sidedSlots = new int[6][];
        this.canInsert = new boolean[6][260];
        this.canExtract = new boolean[6][260];
        this.furnaceInputs = new HashSet<Integer>();
        this.furnaceOutputs = new int[0];
        this.capManager.setManaged("energy", CapabilityOP.OP, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.capManager.setInternalManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler).saveBoth();
        this.itemHandler.setStackValidator(this::isItemValidForSlot);
        this.itemHandler.setContentsChangeListener(this::onSlotContentsChange);
        for (Direction dir : Direction.values()) {
            this.capManager.set(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new ItemHandlerIOControl((IItemHandler)this.itemHandler).setExtractCheck((slot, stack) -> this.canExtractItem(slot, stack, dir)).setInsertCheck((slot, stack) -> this.canInsertItem(slot, stack, dir)), new Direction[]{dir});
        }
    }

    public void func_73660_a() {
        super.tick();
        this.autoFeedRun = false;
        boolean lastActive = this.active.get();
        boolean tileEnabled = this.isTileEnabled();
        if (tileEnabled != lastActive) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)DraconiumChest.ACTIVE, (Comparable)Boolean.valueOf(tileEnabled)));
            this.active.set(tileEnabled);
            this.isSmelting.set(tileEnabled);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.updateEnergy();
            this.updateSmelting();
            if (this.autoFeedScheduled && this.attemptAutoFeed()) {
                this.validateSmelting();
            }
            this.autoFeedScheduled = false;
        }
        this.updateModel();
    }

    public void updateSmelting() {
        if (this.furnaceOutputBlocked.get()) {
            this.burnRate.zero();
            return;
        }
        if (!this.isSmelting.get()) {
            if (this.smeltProgress.get() >= 1.0) {
                this.smeltProgress.dec();
            }
            this.burnRate.zero();
            return;
        }
        if (this.smeltProgress.get() < (double)this.smeltTime.get()) {
            this.burnRate.set(this.getSmeltingSpeed());
            int energyUsage = Math.max((int)(this.burnRate.get() * (double)this.smeltEnergyPerTick.get()), 8);
            this.smeltProgress.add(this.burnRate.get());
            this.opStorage.modifyEnergyStored((long)(-energyUsage));
            return;
        }
        if (!this.smeltItems()) {
            this.furnaceOutputBlocked.set(true);
            return;
        }
        this.smeltProgress.zero();
        this.isSmelting.set(this.canSmelt());
    }

    private boolean smeltItems() {
        this.checkIOCache();
        for (int smeltPass = 0; smeltPass < 5; ++smeltPass) {
            for (int i = FIRST_FURNACE_SLOT; i <= LAST_FURNACE_SLOT; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                ItemStack result = this.getSmeltResult(stack);
                if (result.func_190926_b() || ((AutoSmeltMode)this.autoSmeltMode.get()).keep1Item && stack.func_190916_E() <= 1) continue;
                ItemHandlerSlotWrapper range = new ItemHandlerSlotWrapper((IItemHandlerModifiable)this.itemHandler, this.furnaceOutputs);
                if (!InventoryUtils.insertItem((IItemHandler)range, (ItemStack)result.func_77946_l(), (boolean)true).func_190926_b()) {
                    return false;
                }
                InventoryUtils.insertItem((IItemHandler)range, (ItemStack)result.func_77946_l(), (boolean)false);
                stack.func_190918_g(1);
                if (stack.func_190916_E() <= 0) {
                    this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                }
                ++this.itemsSmelted;
                if (this.itemsSmelted != 5) continue;
                this.itemsSmelted = 0;
                this.attemptAutoFeed();
                return true;
            }
        }
        this.attemptAutoFeed();
        return true;
    }

    private boolean canSmelt() {
        for (int i = FIRST_FURNACE_SLOT; i <= LAST_FURNACE_SLOT; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (this.getSmeltResult(stack).func_190926_b() || ((AutoSmeltMode)this.autoSmeltMode.get()).keep1Item && stack.func_190916_E() <= 1 || !this.active.get()) continue;
            return true;
        }
        return false;
    }

    public ItemStack getSmeltResult(ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.itemHandler.getStackInSlot(CORE_SLOT).func_190926_b()) {
            return OreDoublingRegistry.getDoubledSmeltingResult(stack, this.field_145850_b);
        }
        return OreDoublingRegistry.getSmeltingResult(stack, this.field_145850_b);
    }

    private double getSmeltingSpeed() {
        double eCapacity = (double)this.opStorage.getEnergyStored() / (double)this.opStorage.getMaxEnergyStored();
        return eCapacity > 0.1 ? 1.0 : eCapacity * 10.0;
    }

    private void updateEnergy() {
        if (this.opStorage.getEnergyStored() < this.opStorage.getMaxEnergyStored()) {
            EnergyUtils.transferEnergy((ItemStack)this.itemHandler.getStackInSlot(CAPACITOR_SLOT), (IOPStorage)this.opStorage);
        }
    }

    public void validateSmelting() {
        ItemStack stack = this.itemHandler.getStackInSlot(CORE_SLOT);
        if (stack.func_77973_b() instanceof ItemCore) {
            if (stack.func_77973_b() == DEContent.core_wyvern) {
                this.smeltEnergyPerTick.set(1024);
                this.smeltTime.set((byte)50);
            } else if (stack.func_77973_b() == DEContent.core_awakened) {
                this.smeltEnergyPerTick.set(4069);
                this.smeltTime.set((byte)25);
            } else if (stack.func_77973_b() == DEContent.core_chaotic) {
                this.smeltEnergyPerTick.set(16384);
                this.smeltTime.set((byte)2);
            } else {
                this.smeltEnergyPerTick.set(256);
                this.smeltTime.set((byte)100);
            }
        } else {
            this.smeltEnergyPerTick.set(256);
            this.smeltTime.set((byte)100);
        }
        this.isSmelting.set(this.canSmelt());
        this.furnaceOutputBlocked.set(false);
    }

    public void scheduleAutoFeed() {
        this.autoFeedScheduled = true;
    }

    public boolean attemptAutoFeed() {
        if ((this.autoSmeltMode.get() == AutoSmeltMode.OFF || this.autoFeedRun) && this.active.get()) {
            return false;
        }
        this.checkIOCache();
        this.autoFeedRun = true;
        boolean stacksInserted = false;
        block4: for (int i = 0; i < LAST_CHEST_SLOT; ++i) {
            ItemStack stack;
            if (!this.furnaceInputs.contains(i) || (stack = this.itemHandler.getStackInSlot(i)).func_190926_b() || this.getSmeltResult(stack).func_190926_b()) continue;
            int fullStacks = 0;
            for (int f = FIRST_FURNACE_SLOT; f <= LAST_FURNACE_SLOT; ++f) {
                ItemStack stackInFurnace = this.itemHandler.getStackInSlot(f);
                switch ((AutoSmeltMode)this.autoSmeltMode.get()) {
                    case FILL: 
                    case LOCK: {
                        if (!ItemStack.func_179545_c((ItemStack)stackInFurnace, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)stackInFurnace, (ItemStack)stack) || stackInFurnace.func_190916_E() >= stackInFurnace.func_77976_d()) break;
                        int count = Math.min(stack.func_190916_E(), stackInFurnace.func_77976_d() - stackInFurnace.func_190916_E());
                        stackInFurnace.func_190917_f(count);
                        stack.func_190918_g(count);
                        stacksInserted = true;
                        break;
                    }
                    case ALL: {
                        if (stackInFurnace.func_190926_b()) {
                            this.itemHandler.setStackInSlot(f, stack.func_77946_l());
                            stack = ItemStack.field_190927_a;
                            stacksInserted = true;
                            break;
                        }
                        if (!ItemStack.func_179545_c((ItemStack)stackInFurnace, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)stackInFurnace, (ItemStack)stack) || stackInFurnace.func_190916_E() >= stackInFurnace.func_77976_d()) break;
                        int count = Math.min(stack.func_190916_E(), stackInFurnace.func_77976_d() - stackInFurnace.func_190916_E());
                        stackInFurnace.func_190917_f(count);
                        stack.func_190918_g(count);
                        stacksInserted = true;
                    }
                }
                stackInFurnace = this.itemHandler.getStackInSlot(f);
                if (!stackInFurnace.func_190926_b() && stackInFurnace.func_190916_E() == stackInFurnace.func_77976_d()) {
                    ++fullStacks;
                }
                if (stack.func_190926_b() || stack.func_190916_E() == 0) {
                    this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                    if (fullStacks != 5) continue block4;
                    return stacksInserted;
                }
                if (fullStacks != 5) continue;
                return stacksInserted;
            }
        }
        return stacksInserted;
    }

    public void setAutoSmeltMode(AutoSmeltMode mode) {
        if (this.field_145850_b.field_72995_K) {
            this.sendPacketToServer(output -> output.writeByte(mode.ordinal()), 0);
        }
    }

    public void setColour(int colour) {
        if (this.field_145850_b.field_72995_K) {
            this.sendPacketToServer(output -> output.writeInt(colour), 2);
        }
    }

    public void setRegionState(int region) {
        CompoundNBT compound = new CompoundNBT();
        if (region >= 0 && region < this.slotRegions.length) {
            compound.func_74768_a("regionID", region);
            this.slotRegions[region].toNBT(compound);
            this.sendPacketToServer(output -> output.writeCompoundNBT(compound), 1);
        }
        this.ioCacheValid = false;
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int id) {
        if (id == 0) {
            byte index = data.readByte();
            this.autoSmeltMode.set((Enum)AutoSmeltMode.values()[index]);
            this.scheduleAutoFeed();
            this.validateSmelting();
        } else if (id == 1) {
            CompoundNBT compound = data.readCompoundNBT();
            byte region = compound.func_74771_c("regionID");
            if (region >= 0 && region < this.slotRegions.length) {
                this.slotRegions[region].fromNBT(compound);
                for (SlotRegion r : this.slotRegions) {
                    r.validate();
                }
                this.ioCacheValid = false;
                this.func_70296_d();
                this.scheduleAutoFeed();
                this.validateSmelting();
            }
        } else if (id == 2) {
            this.colour.set(data.readInt());
            this.func_70296_d();
        }
    }

    protected void writeCraftingToNBT(CompoundNBT compound) {
        ListNBT nbttaglist = new ListNBT();
        for (int i = 0; i < this.craftingStacks.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.craftingStacks.get(i);
            if (itemstack.func_190926_b()) continue;
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        if (!nbttaglist.isEmpty()) {
            compound.func_218657_a("CraftingItems", (INBT)nbttaglist);
        }
    }

    protected void readCraftingFromNBT(CompoundNBT compound) {
        ListNBT nbttaglist = compound.func_150295_c("CraftingItems", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.craftingStacks.size()) continue;
            this.craftingStacks.set(j, (Object)ItemStack.func_199557_a((CompoundNBT)nbttagcompound));
        }
    }

    public boolean isItemValidForSlot(int index, @Nonnull ItemStack stack) {
        if (!stack.func_190926_b() && DEOldConfig.chestBlacklist.contains(stack.func_77973_b().getRegistryName().toString())) {
            return false;
        }
        if (index >= FIRST_FURNACE_SLOT && index <= LAST_FURNACE_SLOT) {
            return !this.getSmeltResult(stack).func_190926_b();
        }
        if (index == CAPACITOR_SLOT) {
            return EnergyUtils.canExtractEnergy((ItemStack)stack);
        }
        if (index == CORE_SLOT) {
            return stack.func_77973_b() instanceof ItemCore && stack.func_77973_b() != DEContent.core_draconium;
        }
        return DraconiumChest.isStackValid(stack);
    }

    public ItemStack getStackInCraftingSlot(int i) {
        return (ItemStack)this.craftingStacks.get(i);
    }

    public void setInventoryCraftingSlotContents(int i, @Nonnull ItemStack stack) {
        this.craftingStacks.set(i, (Object)stack);
        if (stack.func_190916_E() > this.itemHandler.getSlotLimit(i)) {
            stack.func_190920_e(this.itemHandler.getSlotLimit(i));
        }
        this.func_70296_d();
    }

    public void onSlotContentsChange(int index) {
        if (index >= FIRST_FURNACE_SLOT && index <= LAST_FURNACE_SLOT || index == CORE_SLOT) {
            this.validateSmelting();
        } else if (this.furnaceOutputBlocked.get()) {
            this.furnaceOutputBlocked.set(false);
        }
        this.scheduleAutoFeed();
    }

    public void writeToItemStack(CompoundNBT compound, boolean willHarvest) {
        super.writeToItemStack(compound, willHarvest);
        this.writeRegions(compound);
        if (this.colour.get() != 6553750) {
            compound.func_74768_a("ChestColour", this.colour.get());
        }
        this.writeCraftingToNBT(compound);
    }

    public void readFromItemStack(CompoundNBT compound) {
        super.readFromItemStack(compound);
        this.readRegions(compound);
        this.readCraftingFromNBT(compound);
    }

    public void writeExtraNBT(CompoundNBT compound) {
        super.writeExtraNBT(compound);
        this.writeRegions(compound);
        this.writeCraftingToNBT(compound);
    }

    public void readExtraNBT(CompoundNBT compound) {
        super.readExtraNBT(compound);
        this.readRegions(compound);
        this.readCraftingFromNBT(compound);
    }

    private void writeRegions(CompoundNBT compound) {
        CompoundNBT regionTag = new CompoundNBT();
        for (SlotRegion region : this.slotRegions) {
            region.toNBT(regionTag);
        }
        compound.func_218657_a("RegionData", (INBT)regionTag);
    }

    private void readRegions(CompoundNBT compound) {
        if (compound.func_74764_b("RegionData")) {
            CompoundNBT regionTag = compound.func_74775_l("RegionData");
            for (SlotRegion region : this.slotRegions) {
                region.fromNBT(regionTag);
            }
        }
    }

    private void checkIOCache() {
        if (this.ioCacheValid) {
            return;
        }
        DataUtils.forEach((Object[])this.slotRegions, region -> region.controledSlots.clear());
        block0: for (int i = 0; i <= LAST_CHEST_SLOT; ++i) {
            SlotRegion[] slotRegionArray = this.slotRegions;
            int n = slotRegionArray.length;
            for (int j = 0; j < n; ++j) {
                SlotRegion region2 = slotRegionArray[j];
                if (!region2.controlsSlot(i)) continue;
                region2.controledSlots.add(i);
                continue block0;
            }
        }
        for (Direction worldFace : Direction.values()) {
            int faceIndex = worldFace.func_176745_a();
            Direction facing = this.getRotatedFacing(worldFace);
            ArrayList<Integer> accessibleSlots = new ArrayList<Integer>();
            ArrayList<Integer> insertSlots = new ArrayList<Integer>();
            ArrayList<Integer> extractSlots = new ArrayList<Integer>();
            for (SlotRegion region3 : this.slotRegions) {
                if (!region3.isActive() || !region3.hasIO(facing)) continue;
                accessibleSlots.addAll(region3.controledSlots);
                if (region3.canExtract(facing)) {
                    extractSlots.addAll(region3.controledSlots);
                }
                if (!region3.canInsert(facing)) continue;
                insertSlots.addAll(region3.controledSlots);
            }
            this.sidedSlots[faceIndex] = DataUtils.intListToArray(accessibleSlots);
            for (int i = 0; i <= LAST_CHEST_SLOT; ++i) {
                this.canInsert[faceIndex][i] = insertSlots.contains(i);
                this.canExtract[faceIndex][i] = extractSlots.contains(i);
            }
        }
        ArrayList<Integer> furnaceInsertSlots = new ArrayList<Integer>();
        ArrayList<Integer> furnaceExtractSlots = new ArrayList<Integer>();
        for (SlotRegion region4 : this.slotRegions) {
            if (!region4.isActive() || !region4.hasIO(null)) continue;
            if (region4.canExtract(null)) {
                furnaceExtractSlots.addAll(region4.controledSlots);
            }
            if (!region4.canInsert(null)) continue;
            furnaceInsertSlots.addAll(region4.controledSlots);
        }
        this.furnaceInputs.clear();
        this.furnaceInputs.addAll(furnaceInsertSlots);
        this.furnaceOutputs = DataUtils.intListToArray(furnaceExtractSlots);
        this.ioCacheValid = true;
    }

    private Direction getRotatedFacing(Direction worldFacing) {
        if (worldFacing == Direction.UP || worldFacing == Direction.DOWN) {
            return worldFacing;
        }
        int rotate = this.facing.get() == Direction.NORTH ? 0 : (this.facing.get() == Direction.EAST ? 1 : (this.facing.get() == Direction.SOUTH ? 2 : 3));
        for (int i = 0; i < rotate; ++i) {
            worldFacing = worldFacing.func_176735_f();
        }
        return worldFacing;
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, Direction direction) {
        this.checkIOCache();
        return index < 260 && this.canInsert[direction.func_176745_a()][index];
    }

    public boolean canExtractItem(int index, ItemStack stack, Direction direction) {
        this.checkIOCache();
        return index < 260 && this.canExtract[direction.func_176745_a()][index];
    }

    private void updateModel() {
        int xCoord = this.field_174879_c.func_177958_n();
        int yCoord = this.field_174879_c.func_177956_o();
        int zCoord = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing.get() != 0 && (this.ticksSinceSync + xCoord + yCoord + zCoord) % 200 == 0) {
            this.numPlayersUsing.zero();
            for (PlayerEntity entityplayer : this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)xCoord - 5.0f), (double)((float)yCoord - 5.0f), (double)((float)zCoord - 5.0f), (double)((float)(xCoord + 1) + 5.0f), (double)((float)(yCoord + 1) + 5.0f), (double)((float)(zCoord + 1) + 5.0f)))) {
                TileDraconiumChest tile;
                if (!(entityplayer.field_71070_bA instanceof ContainerDraconiumChest) || (tile = (TileDraconiumChest)((ContainerDraconiumChest)entityplayer.field_71070_bA).tile) != this) continue;
                this.numPlayersUsing.inc();
            }
        }
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing.get() > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)xCoord + 0.5;
            double d2 = (double)zCoord + 0.5;
            this.field_145850_b.func_184148_a((PlayerEntity)null, d1, (double)yCoord + 0.5, d2, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing.get() == 0 && this.lidAngle > 0.0f || this.numPlayersUsing.get() > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing.get() > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && f2 >= 0.5f) {
                double d3 = (double)xCoord + 0.5;
                double d0 = (double)zCoord + 0.5;
                this.field_145850_b.func_184148_a((PlayerEntity)null, d3, (double)yCoord + 0.5, d0, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public void onPlayerOpenContainer(PlayerEntity player) {
        super.onPlayerOpenContainer(player);
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing.get() < 0) {
                this.numPlayersUsing.zero();
            }
            this.numPlayersUsing.inc();
        }
    }

    public void onPlayerCloseContainer(PlayerEntity player) {
        super.onPlayerCloseContainer(player);
        if (!player.func_175149_v()) {
            this.numPlayersUsing.dec();
        }
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
        }
        return true;
    }

    @Nullable
    public Container createMenu(int currentWindowIndex, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerDraconiumChest(DEContent.container_draconium_chest, currentWindowIndex, playerInventory, this);
    }

    public class SlotRegion {
        public int regionID;
        public int xPos = 0;
        public int yPos = 0;
        public int xSize = 0;
        public int ySize = 0;
        public boolean enabled = false;
        public boolean invalid = false;
        public int colour;
        public final boolean isDefault;
        private Rectangle rectangle = new Rectangle();
        private byte nsweIO = (byte)-1;
        private byte dufIO = (byte)-1;
        public List<Integer> controledSlots = new ArrayList<Integer>();

        public SlotRegion(int regionID, int colour, boolean isDefault) {
            this.regionID = regionID;
            this.colour = colour;
            this.isDefault = isDefault;
        }

        public void toNBT(CompoundNBT compound) {
            if (!this.isDefault) {
                compound.func_74774_a("SR_" + this.regionID + "_xPos", (byte)this.xPos);
                compound.func_74774_a("SR_" + this.regionID + "_yPos", (byte)this.yPos);
                compound.func_74774_a("SR_" + this.regionID + "_xSize", (byte)this.xSize);
                compound.func_74774_a("SR_" + this.regionID + "_ySize", (byte)this.ySize);
                compound.func_74757_a("SR_" + this.regionID + "_Enabled", this.enabled);
                compound.func_74757_a("SR_" + this.regionID + "_Invalid", this.invalid);
            }
            compound.func_74774_a("SR_" + this.regionID + "_nsweIO", this.nsweIO);
            compound.func_74774_a("SR_" + this.regionID + "_dufIO", this.dufIO);
        }

        public void fromNBT(CompoundNBT compound) {
            if (!this.isDefault) {
                this.xPos = compound.func_74771_c("SR_" + this.regionID + "_xPos");
                this.yPos = compound.func_74771_c("SR_" + this.regionID + "_yPos");
                this.xSize = compound.func_74771_c("SR_" + this.regionID + "_xSize");
                this.ySize = compound.func_74771_c("SR_" + this.regionID + "_ySize");
                this.enabled = compound.func_74767_n("SR_" + this.regionID + "_Enabled");
                this.invalid = compound.func_74767_n("SR_" + this.regionID + "_Invalid");
            }
            this.nsweIO = compound.func_74771_c("SR_" + this.regionID + "_nsweIO");
            this.dufIO = compound.func_74771_c("SR_" + this.regionID + "_dufIO");
            if (this.xPos < 0 || this.xPos > 25) {
                this.xPos = 0;
            }
            if (this.yPos < 0 || this.yPos > 9) {
                this.yPos = 0;
            }
            if (this.xSize < 1 || this.xSize > 26 - this.xPos) {
                this.xSize = 0;
            }
            if (this.ySize < 1 || this.ySize > 10 - this.yPos) {
                this.ySize = 0;
            }
            this.validate();
        }

        public Rectangle getRectangle() {
            if (!this.isDefault) {
                this.rectangle.setBounds(this.xPos, this.yPos, this.xSize, this.ySize);
            }
            return this.rectangle;
        }

        public boolean isValid() {
            return this.isDefault || !this.invalid && this.xSize > 0 && this.ySize > 0;
        }

        public boolean validate() {
            this.invalid = false;
            if (this.isDefault) {
                this.invalid = false;
            } else if (this.xSize <= 0 || this.ySize <= 0) {
                this.invalid = true;
            } else {
                for (SlotRegion region : TileDraconiumChest.this.slotRegions) {
                    if (region == this || !region.enabled || !region.getRectangle().intersects(this.getRectangle())) continue;
                    this.invalid = true;
                    break;
                }
            }
            return !this.invalid;
        }

        public int getFaceIO(Direction facing) {
            if (facing == null) {
                return this.getFurnaceIO();
            }
            switch (facing) {
                case DOWN: {
                    return this.dufIO >> 6 & 3;
                }
                case UP: {
                    return this.dufIO >> 4 & 3;
                }
                case NORTH: {
                    return this.nsweIO >> 6 & 3;
                }
                case SOUTH: {
                    return this.nsweIO >> 4 & 3;
                }
                case WEST: {
                    return this.nsweIO >> 2 & 3;
                }
                case EAST: {
                    return this.nsweIO & 3;
                }
            }
            return 0;
        }

        public int getFurnaceIO() {
            return this.dufIO >> 2 & 3;
        }

        public void setFaceIO(Direction facing, int io) {
            if (facing == null) {
                this.setFurnaceIO(io);
                return;
            }
            switch (facing) {
                case DOWN: {
                    this.dufIO = (byte)(this.dufIO & 0x3F | io << 6);
                    return;
                }
                case UP: {
                    this.dufIO = (byte)(this.dufIO & 0xCF | io << 4);
                    return;
                }
                case NORTH: {
                    this.nsweIO = (byte)(this.nsweIO & 0x3F | io << 6);
                    return;
                }
                case SOUTH: {
                    this.nsweIO = (byte)(this.nsweIO & 0xCF | io << 4);
                    return;
                }
                case WEST: {
                    this.nsweIO = (byte)(this.nsweIO & 0xF3 | io << 2);
                    return;
                }
                case EAST: {
                    this.nsweIO = (byte)(this.nsweIO & 0xFC | io);
                }
            }
        }

        public void setFurnaceIO(int io) {
            this.dufIO = (byte)(this.dufIO & 0xF3 | io << 2);
        }

        public boolean controlsSlot(int index) {
            if (this.isDefault) {
                return true;
            }
            int x = index % 26;
            int y = index / 26;
            return this.enabled && this.validate() && this.getRectangle().contains(x, y);
        }

        public boolean isActive() {
            return this.isDefault || this.enabled && this.isValid();
        }

        public boolean hasIO(Direction facing) {
            return this.getFaceIO(facing) > 0;
        }

        public boolean canInsert(Direction facing) {
            return (this.getFaceIO(facing) & 1) == 1;
        }

        public boolean canExtract(Direction facing) {
            return (this.getFaceIO(facing) & 2) == 2;
        }
    }

    public static enum AutoSmeltMode {
        OFF(false, 0),
        FILL(false, 1),
        LOCK(true, 2),
        ALL(false, 3);

        public final boolean keep1Item;
        public final int index;

        private AutoSmeltMode(boolean keep1Item, int index) {
            this.keep1Item = keep1Item;
            this.index = index;
        }

        public AutoSmeltMode next(boolean prev) {
            if (prev) {
                return AutoSmeltMode.values()[this.index - 1 < 0 ? AutoSmeltMode.values().length - 1 : this.index - 1];
            }
            return AutoSmeltMode.values()[this.index + 1 == AutoSmeltMode.values().length ? 0 : this.index + 1];
        }

        public String unlocalizedName() {
            return "gui.draconicevolution.draconium_chest.autofill_" + this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

