/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.brandonscore.lib.IActivatableTile;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.draconicevolution.blocks.machines.EnergyCoreStabilizer;
import com.brandon3055.draconicevolution.blocks.tileentity.IMultiBlockPart;
import com.brandon3055.draconicevolution.blocks.tileentity.TileCoreStructure;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEnergyCoreStabilizer
extends TileBCore
implements ITickableTileEntity,
IMultiBlockPart,
IActivatableTile {
    public final ManagedVec3I coreOffset = (ManagedVec3I)this.register((IManagedData)new ManagedVec3I("core_offset", new Vec3I(0, -1, 0), new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool hasCoreLock = (ManagedBool)this.register((IManagedData)new ManagedBool("has_core_lock", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool isCoreActive = (ManagedBool)this.register((IManagedData)new ManagedBool("is_core_active", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public final ManagedBool isValidMultiBlock = (ManagedBool)this.register((IManagedData)new ManagedBool("is_valid_multi_block", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedEnum<Direction.Axis> multiBlockAxis = (ManagedEnum)this.register((IManagedData)new ManagedEnum("multi_block_axis", (Enum)Direction.Axis.Y, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedEnum<Direction> coreDirection = (ManagedEnum)this.register((IManagedData)new ManagedEnum("core_direction", (Enum)Direction.DOWN, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public float rotation = 0.0f;
    public float rotationSpeed = 0.0f;
    private boolean moveCheckComplete = false;

    public TileEnergyCoreStabilizer() {
        super(DEContent.tile_core_stabilizer);
    }

    public void func_73660_a() {
        super.tick();
        if (this.field_145850_b.field_72995_K && this.hasCoreLock.get() && this.isCoreActive.get()) {
            this.rotation = ClientEventHandler.elapsedTicks;
            this.updateVisual();
            if (this.isValidMultiBlock.get()) {
                this.updateVisual();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateVisual() {
        Vec3D spawn = new Vec3D(this.field_174879_c);
        spawn.add(0.5, 0.5, 0.5);
        double rand = (double)this.field_145850_b.field_73012_v.nextInt(100) / 12.0;
        double randOffset = rand * (Math.PI * 2);
        double offsetX = Math.sin((double)ClientEventHandler.elapsedTicks / 180.0 * Math.PI + randOffset);
        double offsetY = Math.cos((double)ClientEventHandler.elapsedTicks / 180.0 * Math.PI + randOffset);
        if (!this.isValidMultiBlock.get() || this.field_145850_b.field_73012_v.nextBoolean()) {
            double inset;
            double d = this.isValidMultiBlock.get() ? 1.1 : 0.25;
            double d2 = inset = this.isValidMultiBlock.get() ? 1.0 : 0.0;
            if (((Direction)this.coreDirection.get()).func_176740_k() == Direction.Axis.Z) {
                spawn.add(offsetX * d, offsetY * d, (this.field_145850_b.field_73012_v.nextBoolean() ? -0.38 : 0.38) * inset);
            } else if (((Direction)this.coreDirection.get()).func_176740_k() == Direction.Axis.Y) {
                spawn.add(offsetX * d, (this.field_145850_b.field_73012_v.nextBoolean() ? -0.38 : 0.38) * inset, offsetY * d);
            } else if (((Direction)this.coreDirection.get()).func_176740_k() == Direction.Axis.X) {
                spawn.add((this.field_145850_b.field_73012_v.nextBoolean() ? -0.38 : 0.38) * inset, offsetY * d, offsetX * d);
            }
            Vec3D target = new Vec3D(this.field_174879_c).subtract(this.coreOffset.get().getPos()).add(0.5, 0.5, 0.5);
            this.field_145850_b.func_195594_a((IParticleData)new IntParticleType.IntParticleData((ParticleType)DEParticles.energy_core, new int[]{1, (int)(randOffset * 100.0), this.isValidMultiBlock.get() ? 1 : 0}), spawn.x, spawn.y, spawn.z, target.x, target.y, target.z);
        } else {
            if (((Direction)this.coreDirection.get()).func_176740_k() == Direction.Axis.Z) {
                spawn.add(offsetX * 1.2, offsetY * 1.2, this.field_145850_b.field_73012_v.nextBoolean() ? -0.38 : 0.38);
            } else if (((Direction)this.coreDirection.get()).func_176740_k() == Direction.Axis.Y) {
                spawn.add(offsetX * 1.2, this.field_145850_b.field_73012_v.nextBoolean() ? -0.38 : 0.38, offsetY * 1.2);
            } else if (((Direction)this.coreDirection.get()).func_176740_k() == Direction.Axis.X) {
                spawn.add(this.field_145850_b.field_73012_v.nextBoolean() ? -0.38 : 0.38, offsetY * 1.2, offsetX * 1.2);
            }
            Vec3D target = new Vec3D(this.field_174879_c).add(0.5, 0.5, 0.5);
            this.field_145850_b.func_195594_a((IParticleData)new IntParticleType.IntParticleData((ParticleType)DEParticles.energy_core, new int[]{0}), spawn.x, spawn.y, spawn.z, target.x, target.y, target.z);
        }
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        TileEnergyCore core = this.getCore();
        if (core == null) {
            core = this.findCore();
        }
        if (core != null) {
            core.onStructureClicked(this.field_145850_b, this.field_174879_c, state, player);
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.de.coreNotFound.txt").func_240699_a_(TextFormatting.DARK_RED), Util.field_240973_b_);
        }
        return true;
    }

    public boolean isStabilizerValid(int coreTier, TileEnergyCore core) {
        if (coreTier < 5 && !this.isValidMultiBlock.get()) {
            return true;
        }
        if (coreTier >= 5 && this.isValidMultiBlock.get()) {
            BlockPos offset = this.field_174879_c.func_177973_b((Vector3i)core.func_174877_v());
            Direction direction = Direction.func_176737_a((float)offset.func_177958_n(), (float)offset.func_177956_o(), (float)offset.func_177952_p()).func_176734_d();
            return direction.func_176740_k() == this.multiBlockAxis.get();
        }
        return false;
    }

    public void onPlaced() {
        if (this.field_145850_b.field_72995_K || this.checkAndFormMultiBlock()) {
            return;
        }
        for (Direction facing1 : Direction.values()) {
            BlockPos search = this.field_174879_c.func_177982_a(facing1.func_82601_c(), facing1.func_96559_d(), facing1.func_82599_e());
            TileEntity stabilizer = this.field_145850_b.func_175625_s(search);
            if (stabilizer instanceof TileEnergyCoreStabilizer && ((TileEnergyCoreStabilizer)stabilizer).checkAndFormMultiBlock()) {
                return;
            }
            for (Direction facing2 : Direction.values()) {
                BlockPos s2;
                if (facing2 == facing1 || facing2 == facing1.func_176734_d() || !((stabilizer = this.field_145850_b.func_175625_s(s2 = search.func_177982_a(facing2.func_82601_c(), facing2.func_96559_d(), facing2.func_82599_e()))) instanceof TileEnergyCoreStabilizer) || !((TileEnergyCoreStabilizer)stabilizer).checkAndFormMultiBlock()) continue;
                return;
            }
        }
    }

    private boolean checkAxisValid(Direction.Axis axis) {
        for (BlockPos offset : FacingUtils.getAroundAxis((Direction.Axis)axis)) {
            if (this.isAvailable(this.field_174879_c.func_177971_a((Vector3i)offset))) continue;
            return false;
        }
        return true;
    }

    private boolean checkAndFormMultiBlock() {
        if (this.hasCoreLock.get() && this.getCore() != null && this.getCore().active.get()) {
            return false;
        }
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (!this.checkAxisValid(axis)) continue;
            this.buildMultiBlock(axis);
            return true;
        }
        return false;
    }

    private boolean isAvailable(BlockPos pos) {
        if (this.isValidMultiBlock.get()) {
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            return tile instanceof TileCoreStructure && ((TileCoreStructure)tile).getController() == this;
        }
        TileEntity stabilizer = this.field_145850_b.func_175625_s(pos);
        return stabilizer instanceof TileEnergyCoreStabilizer && (!((TileEnergyCoreStabilizer)stabilizer).hasCoreLock.get() || ((TileEnergyCoreStabilizer)stabilizer).getCore() == null || !((TileEnergyCoreStabilizer)stabilizer).getCore().active.get());
    }

    private void buildMultiBlock(Direction.Axis axis) {
        for (BlockPos offset : FacingUtils.getAroundAxis((Direction.Axis)axis)) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177971_a((Vector3i)offset), DEContent.energy_core_structure.func_176223_P());
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vector3i)offset));
            if (!(tile instanceof TileCoreStructure)) continue;
            ((TileCoreStructure)tile).blockName.set("draconicevolution:energy_core_stabilizer");
            ((TileCoreStructure)tile).setController(this);
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)EnergyCoreStabilizer.LARGE, (Comparable)Boolean.valueOf(true)));
        this.isValidMultiBlock.set(true);
        this.multiBlockAxis.set((Enum)axis);
    }

    public void deFormStructure() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == DEContent.energy_core_stabilizer) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)EnergyCoreStabilizer.LARGE, (Comparable)Boolean.valueOf(false)));
        }
        this.isValidMultiBlock.set(false);
        if (this.getCore() != null) {
            this.getCore().deactivateCore();
        }
        for (BlockPos offset : FacingUtils.getAroundAxis((Direction.Axis)((Direction.Axis)this.multiBlockAxis.get()))) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vector3i)offset));
            if (!(tile instanceof TileCoreStructure)) continue;
            ((TileCoreStructure)tile).revert();
        }
    }

    @Override
    public boolean validateStructure() {
        if (this.checkAxisValid((Direction.Axis)this.multiBlockAxis.get())) {
            return true;
        }
        this.deFormStructure();
        return false;
    }

    @Override
    public boolean isStructureValid() {
        return this.isValidMultiBlock.get();
    }

    @Override
    public IMultiBlockPart getController() {
        return this;
    }

    public TileEnergyCore findCore() {
        if (this.getCore() != null) {
            return this.getCore();
        }
        for (Direction facing : Direction.values()) {
            for (int i = 0; i < 16; ++i) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(facing.func_82601_c() * i, facing.func_96559_d() * i, facing.func_82599_e() * i));
                if (!(tile instanceof TileEnergyCore)) continue;
                TileEnergyCore core = (TileEnergyCore)tile;
                core.validateStructure();
                if (core.active.get()) continue;
                return core;
            }
        }
        return null;
    }

    public TileEnergyCore getCore() {
        if (this.hasCoreLock.get()) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.getCorePos());
            if (tile instanceof TileEnergyCore) {
                return (TileEnergyCore)tile;
            }
            this.hasCoreLock.set(false);
        }
        return null;
    }

    private BlockPos getCorePos() {
        return this.field_174879_c.func_177973_b((Vector3i)this.coreOffset.get().getPos());
    }

    public void setCore(TileEnergyCore core) {
        BlockPos offset = this.field_174879_c.func_177973_b((Vector3i)core.func_174877_v());
        this.coreOffset.set(new Vec3I(offset));
        this.hasCoreLock.set(true);
        this.coreDirection.set((Enum)Direction.func_176737_a((float)offset.func_177958_n(), (float)offset.func_177956_o(), (float)offset.func_177952_p()).func_176734_d());
        this.updateBlock();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72321_a(1.0, 1.0, 1.0);
    }
}

