/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.brandonscore.inventory.ItemHandlerIOControl;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IActivatableTile;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedFloat;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedResource;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.lib.datamanager.ManagedTextComponent;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.DraconicAPI;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.api.crafting.IFusionInventory;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.IFusionStateMachine;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingInjector;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.tile.fxhandlers.ITileFXHandler;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.ContainerFusionCraftingCore;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileFusionCraftingCore
extends TileBCore
implements IFusionInventory,
IFusionStateMachine,
ITickableTileEntity,
INamedContainerProvider,
IActivatableTile,
IChangeListener {
    private final ManagedEnum<IFusionStateMachine.FusionState> fusionState = (ManagedEnum)this.register((IManagedData)new ManagedEnum("fusion_state", (Enum)IFusionStateMachine.FusionState.START, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedResource activeRecipe = (ManagedResource)this.register((IManagedData)new ManagedResource("active_recipe", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedBool crafting = (ManagedBool)this.register((IManagedData)new ManagedBool("is_crafting", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private final ManagedInt fusionCounter = (ManagedInt)this.register((IManagedData)new ManagedInt("fusion_counter", new DataFlags[]{DataFlags.SAVE_NBT}));
    public final ManagedTextComponent userStatus = (ManagedTextComponent)this.register((IManagedData)new ManagedTextComponent("user_status", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public final ManagedFloat craftAnimProgress = (ManagedFloat)this.register((IManagedData)new ManagedFloat("craft_anim_progress", new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedShort craftAnimLength = (ManagedShort)this.register((IManagedData)new ManagedShort("craft_anim_length", new DataFlags[]{DataFlags.SYNC_TILE}));
    public final ManagedFloat progress = (ManagedFloat)this.register((IManagedData)new ManagedFloat("progress", -1.0f, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
    public TileItemStackHandler itemHandler = new TileItemStackHandler(2);
    public ITileFXHandler fxHandler;
    private List<IFusionInjector> injectorCache = null;
    private List<BlockPos> injectorPositions = new ArrayList<BlockPos>();
    private IFusionRecipe recipeCache = null;
    private TechLevel minTierCache = null;

    public TileFusionCraftingCore() {
        super(DEContent.tile_crafting_core);
        this.capManager.setInternalManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler).saveBoth();
        this.capManager.set(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new ItemHandlerIOControl((IItemHandler)this.itemHandler).setInsertCheck((slot, stack) -> slot == 0).setExtractCheck((slot, stack) -> slot == 1), new Direction[0]);
        this.itemHandler.setContentsChangeListener(i -> this.localInventoryChange());
        this.itemHandler.setStackValidator((slot, stack) -> slot == 0);
        this.fxHandler = DraconicEvolution.proxy.createFusionFXHandler(this);
        this.activeRecipe.addValueListener(e -> {
            this.recipeCache = null;
        });
    }

    public void startCraft() {
        if (this.isCrafting()) {
            this.inventoryChanged();
            return;
        }
        this.updateInjectors();
        IFusionRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(DraconicAPI.FUSION_RECIPE_TYPE, (IInventory)this, this.field_145850_b).orElse(null);
        this.setActiveRecipe(recipe);
        if (recipe == null || !recipe.canStartCraft(this, this.field_145850_b, null)) {
            return;
        }
        this.setCounter(0);
        this.setFusionState(IFusionStateMachine.FusionState.START);
        this.crafting.set(true);
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int id) {
        this.startCraft();
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
        if (id == 0) {
            this.injectorPositions.clear();
            int count = data.readShort();
            for (int i = 0; i < count; ++i) {
                this.injectorPositions.add(data.readPos());
            }
            this.injectorCache = null;
        } else if (id == 1) {
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197627_t, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 1.0, 0.0, 0.0);
            this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, DESounds.fusionComplete, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
            for (int i = 0; i < 100; ++i) {
                double velX = (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.1;
                double velY = (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.1;
                double velZ = (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 0.1;
                this.field_145850_b.func_195594_a((IParticleData)new IntParticleType.IntParticleData((ParticleType)DEParticles.energy_basic, new int[]{0, 255, 255, 64}), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, velX, velY, velZ);
            }
        }
    }

    public void func_73660_a() {
        super.tick();
        if (this.field_145850_b.field_72995_K) {
            this.fxHandler.tick();
        }
        if (this.crafting.get() && !this.field_145850_b.field_72995_K) {
            IFusionRecipe recipe = this.getActiveRecipe();
            if (recipe != null) {
                recipe.tickFusionState(this, this, this.field_145850_b);
            } else {
                this.cancelCraft();
            }
        }
    }

    public boolean updateInjectors() {
        this.minTierCache = null;
        if (this.isCrafting() || this.field_145850_b.field_72995_K) {
            return true;
        }
        this.injectorCache = null;
        ArrayList<BlockPos> oldPositions = new ArrayList<BlockPos>(this.injectorPositions);
        this.injectorPositions.clear();
        int range = DEConfig.fusionInjectorRange;
        int radius = 1;
        List searchTiles = Streams.concat((Stream[])new Stream[]{BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(-range, -radius, -radius), (BlockPos)this.field_174879_c.func_177982_a(range, radius, radius)), BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(-radius, -range, -radius), (BlockPos)this.field_174879_c.func_177982_a(radius, range, radius)), BlockPos.func_218281_b((BlockPos)this.field_174879_c.func_177982_a(-radius, -radius, -range), (BlockPos)this.field_174879_c.func_177982_a(radius, radius, range))}).map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).filter(e -> e instanceof TileFusionCraftingInjector).map(e -> (TileFusionCraftingInjector)e).collect(Collectors.toList());
        for (TileFusionCraftingInjector tile : searchTiles) {
            Vec3D dirVec = new Vec3D(tile.func_174877_v()).subtract(this.field_174879_c);
            double dist = Utils.getCardinalDistance((BlockPos)tile.func_174877_v(), (BlockPos)this.field_174879_c);
            if (dist <= (double)DEConfig.fusionInjectorMinDist) {
                this.setFusionStatus(-1.0, (ITextComponent)new TranslationTextComponent("fusion_status.draconicevolution.injector_close").func_240699_a_(TextFormatting.RED));
                this.injectorPositions.clear();
                return false;
            }
            if (Direction.func_176737_a((float)((int)dirVec.x), (float)((int)dirVec.y), (float)((int)dirVec.z)) != tile.getRotation().func_176734_d() || !tile.setCore(this)) continue;
            BlockPos pos = tile.func_174877_v();
            Direction facing = tile.getRotation();
            ArrayList checkList = Lists.newArrayList((Iterable)BlockPos.func_218278_a((BlockPos)pos.func_177972_a(facing), (BlockPos)pos.func_177967_a(facing, FacingUtils.distanceInDirection((BlockPos)pos, (BlockPos)this.field_174879_c, (Direction)facing) - 1)));
            boolean obstructed = false;
            for (BlockPos bp : checkList) {
                if (this.field_145850_b.func_175623_d(bp) || !this.field_145850_b.func_180495_p(bp).func_200132_m() && !(this.field_145850_b.func_175625_s(bp) instanceof TileFusionCraftingInjector)) continue;
                obstructed = true;
                tile.setCore(null);
                break;
            }
            if (obstructed) continue;
            this.injectorPositions.add(tile.func_174877_v());
        }
        this.dirtyBlock();
        if (!oldPositions.equals(this.injectorPositions)) {
            this.sendPacketToChunk(e -> {
                e.writeShort(this.injectorPositions.size());
                this.injectorPositions.forEach(arg_0 -> ((MCDataOutput)e).writePos(arg_0));
            }, 0);
        }
        return true;
    }

    public void inventoryChanged() {
        if (!this.updateInjectors()) {
            return;
        }
        if (this.isCrafting()) {
            IFusionRecipe recipe = this.getActiveRecipe();
            if (recipe == null || !recipe.matches(this, this.field_145850_b)) {
                this.cancelCraft();
            }
        } else if (!this.field_145850_b.field_72995_K) {
            IFusionRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(DraconicAPI.FUSION_RECIPE_TYPE, (IInventory)this, this.field_145850_b).orElse(null);
            if (recipe != null) {
                recipe.canStartCraft(this, this.field_145850_b, e -> this.setFusionStatus(-1.0, (ITextComponent)e));
            } else {
                this.setFusionStatus(-1.0, (ITextComponent)new TranslationTextComponent("fusion_status.draconicevolution.no_recipe"));
            }
            this.setActiveRecipe(recipe);
        }
    }

    private void localInventoryChange() {
        this.updateBlock();
        this.inventoryChanged();
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player instanceof ServerPlayerEntity) {
            this.updateInjectors();
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
        }
        return true;
    }

    @Nullable
    public Container createMenu(int currentWindowIndex, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerFusionCraftingCore(currentWindowIndex, player.field_71071_by, this, GuiLayoutFactories.FUSION_CRAFTING_CORE);
    }

    @Override
    @Nonnull
    public ItemStack getCatalystStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    @Override
    @Nonnull
    public ItemStack getOutputStack() {
        return this.itemHandler.getStackInSlot(1);
    }

    @Override
    public void setCatalystStack(@Nonnull ItemStack stack) {
        this.itemHandler.setStackInSlot(0, stack);
    }

    @Override
    public void setOutputStack(@Nonnull ItemStack stack) {
        this.itemHandler.setStackInSlot(1, stack);
    }

    @Override
    public List<IFusionInjector> getInjectors() {
        if (this.injectorCache == null) {
            this.injectorCache = this.injectorPositions.stream().map(arg_0 -> ((World)this.field_145850_b).func_175625_s(arg_0)).filter(e -> e instanceof IFusionInjector).map(e -> (IFusionInjector)e).collect(Collectors.toList());
        }
        return this.injectorCache;
    }

    @Override
    public TechLevel getMinimumTier() {
        if (this.minTierCache == null) {
            this.minTierCache = this.getInjectors().stream().filter(e -> !e.getInjectorStack().func_190926_b()).sorted(Comparator.comparing(e -> e.getInjectorTier().index)).map(IFusionInjector::getInjectorTier).findFirst().orElse(TechLevel.DRACONIUM);
        }
        return this.minTierCache;
    }

    public void onNeighborChange(BlockPos neighbor) {
        super.onNeighborChange(neighbor);
        this.updateInjectors();
    }

    @Override
    public IFusionStateMachine.FusionState getFusionState() {
        return (IFusionStateMachine.FusionState)this.fusionState.get();
    }

    @Override
    public void setFusionState(IFusionStateMachine.FusionState state) {
        this.fusionState.set((Enum)state);
    }

    @Override
    public void completeCraft() {
        this.crafting.set(false);
        this.inventoryChanged();
        this.sendPacketToChunk(e -> {}, 1);
    }

    @Override
    public void cancelCraft() {
        this.crafting.set(false);
        this.getInjectors().forEach(e -> e.setEnergyRequirement(0L, 0L));
        this.setFusionStatus(-1.0, (ITextComponent)new TranslationTextComponent("fusion_status.draconicevolution.canceled"));
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), DESounds.fusionComplete, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        this.inventoryChanged();
    }

    @Override
    public int getCounter() {
        return this.fusionCounter.get();
    }

    @Override
    public void setCounter(int count) {
        this.fusionCounter.set(count);
    }

    @Override
    public void setFusionStatus(double progress, ITextComponent stateText) {
        this.progress.set((float)progress);
        this.userStatus.set(stateText);
    }

    @Override
    public void setCraftAnimation(float progress, int length) {
        this.craftAnimProgress.set(progress);
        this.craftAnimLength.set((short)length);
    }

    public boolean isCrafting() {
        return this.crafting.get();
    }

    @Nullable
    public IFusionRecipe getActiveRecipe() {
        IRecipe recipe;
        if (this.recipeCache == null && this.activeRecipe.get() != null && (recipe = (IRecipe)this.field_145850_b.func_199532_z().func_215367_a(this.activeRecipe.get()).orElse(null)) instanceof IFusionRecipe) {
            this.recipeCache = (IFusionRecipe)recipe;
        }
        return this.recipeCache;
    }

    public void setActiveRecipe(@Nullable IFusionRecipe recipe) {
        this.recipeCache = recipe;
        this.activeRecipe.set(recipe == null ? null : recipe.func_199560_c());
    }

    public int getComparatorOutput() {
        if (!this.getOutputStack().func_190926_b()) {
            return 15;
        }
        if (this.crafting.get()) {
            return 1 + this.getFusionState().ordinal();
        }
        IFusionRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(DraconicAPI.FUSION_RECIPE_TYPE, (IInventory)this, this.field_145850_b).orElse(null);
        if (recipe != null && recipe.canStartCraft(this, this.field_145850_b, null)) {
            return 1;
        }
        return 0;
    }

    public void writeExtraNBT(CompoundNBT compound) {
        super.writeExtraNBT(compound);
        compound.func_197644_a("injector_positions", this.injectorPositions.stream().mapToLong(BlockPos::func_218275_a).toArray());
    }

    public void readExtraNBT(CompoundNBT compound) {
        super.readExtraNBT(compound);
        this.injectorPositions = Arrays.stream(compound.func_197645_o("injector_positions")).mapToObj(BlockPos::func_218283_e).collect(Collectors.toList());
        this.injectorCache = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-16, -16, -16), this.field_174879_c.func_177982_a(17, 17, 17));
    }
}

