/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedLong;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.draconicevolution.api.crafting.IFusionInjector;
import com.brandon3055.draconicevolution.blocks.machines.CraftingInjector;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingCore;
import com.brandon3055.draconicevolution.init.DEContent;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileFusionCraftingInjector
extends TileBCore
implements IFusionInjector {
    public final ManagedLong energy = (ManagedLong)this.register((IManagedData)new ManagedLong("energy", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.SYNC_ON_SET}));
    public final ManagedLong energyRequired = (ManagedLong)this.register((IManagedData)new ManagedLong("energy_required", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.SYNC_ON_SET}));
    public final ManagedLong chargeRate = (ManagedLong)this.register((IManagedData)new ManagedLong("charge_rate", new DataFlags[]{DataFlags.SAVE_NBT}));
    public final ManagedBool singleItem = (ManagedBool)this.register((IManagedData)new ManagedBool("single_item", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.SYNC_ON_SET}));
    public final ManagedVec3I corePos = (ManagedVec3I)this.register((IManagedData)new ManagedVec3I("core_pos", new Vec3I(0, -9999, 0), new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.SYNC_ON_SET}));
    public TileItemStackHandler itemHandler = new TileItemStackHandler(1);
    private TechLevel techLevelCache = null;

    public TileFusionCraftingInjector() {
        super(DEContent.tile_crafting_injector);
        this.capManager.setManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler, new Direction[0]).saveBoth().syncTile();
        this.itemHandler.setPerSlotLimit(() -> this.singleItem.get() ? 1 : 64);
        this.itemHandler.setContentsChangeListener(i -> this.inventoryChange());
        this.capManager.set(CapabilityOP.OP, (Object)new OPStorage(0L){

            public long receiveOP(long maxReceive, boolean simulate) {
                long opStored = this.getOPStored();
                long received = Math.max(Math.min(this.getMaxOPStored() - opStored, Math.min(maxReceive, TileFusionCraftingInjector.this.chargeRate.get())), 0L);
                if (!simulate) {
                    TileFusionCraftingInjector.this.energy.add(received);
                }
                return received;
            }

            public boolean canReceive() {
                return true;
            }

            public long getOPStored() {
                return TileFusionCraftingInjector.this.energy.get();
            }

            public long getMaxOPStored() {
                return TileFusionCraftingInjector.this.energyRequired.get();
            }
        }, new Direction[0]);
    }

    public boolean setCore(@Nullable TileFusionCraftingCore core) {
        if (core == null) {
            this.corePos.set(new Vec3I(0, -9999, 0));
        } else {
            this.corePos.set(new Vec3I(core.func_174877_v()));
        }
        this.setEnergyRequirement(0L, 0L);
        return true;
    }

    @Nullable
    public TileFusionCraftingCore getCore() {
        if (this.corePos.get().y == -9999 || this.field_145850_b == null) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.corePos.get().getPos());
        return tile instanceof TileFusionCraftingCore ? (TileFusionCraftingCore)tile : null;
    }

    @Override
    public TechLevel getInjectorTier() {
        if (this.techLevelCache == null) {
            Block block = this.func_195044_w().func_177230_c();
            this.techLevelCache = block instanceof CraftingInjector ? ((CraftingInjector)block).getTechLevel() : TechLevel.DRACONIUM;
        }
        return this.techLevelCache;
    }

    @Override
    public ItemStack getInjectorStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    @Override
    public void setInjectorStack(ItemStack stack) {
        this.itemHandler.setStackInSlot(0, stack);
    }

    @Override
    public long getInjectorEnergy() {
        return this.energy.get();
    }

    @Override
    public void setInjectorEnergy(long energy) {
        this.energy.set(energy);
    }

    @Override
    public void setEnergyRequirement(long maxEnergy, long chargeRate) {
        this.energyRequired.set(maxEnergy);
        this.chargeRate.set(chargeRate);
    }

    @Override
    public long getEnergyRequirement() {
        return this.energyRequired.get();
    }

    @Override
    public boolean validate() {
        return !this.func_145837_r() && this.field_145850_b != null && this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }

    public Direction getRotation() {
        BlockState state = this.func_195044_w();
        return state.func_177230_c() instanceof CraftingInjector ? (Direction)state.func_177229_b((Property)CraftingInjector.FACING) : Direction.UP;
    }

    private void inventoryChange() {
        TileFusionCraftingCore core = this.getCore();
        if (core != null) {
            core.inventoryChanged();
        }
        this.updateBlock();
    }

    public void onDestroyed() {
        TileFusionCraftingCore core = this.getCore();
        if (!this.getInjectorStack().func_190926_b() && core != null) {
            core.cancelCraft();
        }
    }
}

