/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.inventory.ItemHandlerIOControl;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IActivatableTile;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.machines.Generator;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import com.brandon3055.draconicevolution.lib.ISidedTileHandler;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileGenerator
extends TileBCore
implements ITickableTileEntity,
IRSSwitchable,
INamedContainerProvider,
IActivatableTile {
    private ISidedTileHandler soundHandler = DraconicEvolution.proxy.createGeneratorSoundHandler(this);
    public final ManagedInt fuelValue = (ManagedInt)this.register((IManagedData)new ManagedInt("fuel_value", 1, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER}));
    public final ManagedInt fuelRemaining = (ManagedInt)this.register((IManagedData)new ManagedInt("fuel_remaining", 0, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER}));
    public final ManagedInt productionRate = (ManagedInt)this.register((IManagedData)new ManagedInt("prod_rate", 0, new DataFlags[]{DataFlags.SYNC_CONTAINER}));
    public final ManagedEnum<Mode> mode = (ManagedEnum)this.register((IManagedData)new ManagedEnum("mode", (Enum)Mode.NORMAL, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", false, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    private double consumptionBuffer = 0.0;
    private double productionBuffer = 0.0;
    public float rotation = 0.0f;
    public float rotationSpeed = 0.0f;
    public TileItemStackHandler itemHandler = new TileItemStackHandler(4);
    public OPStorage opStorage = new OPStorage(100000L, 0L, 32000L);

    public TileGenerator() {
        super(DEContent.tile_generator);
        this.capManager.setManaged("energy", CapabilityOP.OP, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.capManager.setInternalManaged("inventory", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (INBTSerializable)this.itemHandler).saveBoth();
        this.itemHandler.setStackValidator((slot, stack) -> slot > 2 || ForgeHooks.getBurnTime((ItemStack)stack) > 0);
        this.setupPowerSlot((IItemHandler)this.itemHandler, 3, (IOPStorage)this.opStorage, true);
        this.capManager.set(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new ItemHandlerIOControl((IItemHandler)this.itemHandler).setExtractCheck(this::canExtractItem), new Direction[0]);
        this.installIOTracker(this.opStorage);
    }

    public void func_73660_a() {
        super.tick();
        if (this.field_145850_b.field_72995_K) {
            this.rotationSpeed = this.active.get() ? ((Mode)this.mode.get()).animFanSpeed : 0.0f;
            this.rotation += this.rotationSpeed;
            this.updateSoundAndFX();
            return;
        }
        boolean last = this.active.get();
        this.active.set(this.fuelRemaining.get() > 0 && this.opStorage.getOPStored() < this.opStorage.getMaxOPStored() && this.isTileEnabled());
        if (this.active.get() != last) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)Generator.ACTIVE, (Comparable)Boolean.valueOf(this.active.get())));
        }
        if (this.active.get()) {
            double genRate = 1.0 - (double)this.opStorage.getOPStored() / (double)this.opStorage.getMaxOPStored();
            genRate = Math.min(1.0, genRate * 4.0);
            double energy = Math.max(1.0, genRate * (double)((Mode)this.mode.get()).powerOutput);
            double fuel = energy / (double)((Mode)this.mode.get()).energyPerFuelUnit;
            this.consumptionBuffer += fuel;
            if ((double)this.fuelRemaining.get() < this.consumptionBuffer) {
                this.tryRefuel();
                if ((double)this.fuelRemaining.get() < this.consumptionBuffer) {
                    this.consumptionBuffer = this.fuelRemaining.get();
                    energy = this.consumptionBuffer * (double)((Mode)this.mode.get()).energyPerFuelUnit;
                }
            }
            this.productionRate.set((int)energy);
            this.productionBuffer += energy;
            if (this.consumptionBuffer >= 1.0) {
                this.fuelRemaining.subtract((int)this.consumptionBuffer);
                this.consumptionBuffer %= 1.0;
            }
            if (this.productionBuffer >= 1.0) {
                this.opStorage.modifyEnergyStored((long)((int)this.productionBuffer));
                this.productionBuffer %= 1.0;
            }
        } else {
            this.productionRate.set(0);
        }
        if (this.isTileEnabled() && this.fuelRemaining.get() <= 0) {
            this.tryRefuel();
        }
        this.opStorage.modifyEnergyStored(-this.sendEnergyToAll(this.opStorage.getMaxExtract(), this.opStorage.getOPStored()));
    }

    public void tryRefuel() {
        for (int i = 0; i < 3; ++i) {
            int itemBurnTime;
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.func_190926_b() || (itemBurnTime = ForgeHooks.getBurnTime((ItemStack)stack)) <= 0) continue;
            if (stack.func_190916_E() == 1) {
                stack = stack.func_77973_b().getContainerItem(stack);
            } else {
                stack.func_190918_g(1);
            }
            this.itemHandler.setStackInSlot(i, stack);
            this.fuelValue.set(itemBurnTime);
            this.fuelRemaining.add(itemBurnTime);
            return;
        }
    }

    private boolean canExtractItem(int slot, ItemStack stack) {
        return slot == 3 && EnergyUtils.isFullyOrInvalid((ItemStack)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateSoundAndFX() {
        Direction enumfacing;
        this.soundHandler.tick();
        if (!this.active.get() || this.field_174879_c.func_177951_i((Vector3i)Minecraft.func_71410_x().field_71439_g.func_233580_cy_()) > 256.0) {
            return;
        }
        Random rand = this.field_145850_b.field_73012_v;
        double p = 0.0625;
        if (rand.nextInt(17 - ((Mode)this.mode.get()).index * 4) == 0) {
            enumfacing = (Direction)this.func_195044_w().func_177229_b((Property)Generator.FACING);
            double pgx = p * 7.5 + (double)rand.nextInt(6) * p;
            double pgy = 0.3;
            double pgz = 0.5;
            double outOffset = 0.48;
            switch (enumfacing) {
                case WEST: {
                    this.spawnGrillParticle(rand, (double)this.field_174879_c.func_177958_n() + pgz - outOffset, (double)this.field_174879_c.func_177956_o() + pgy, (double)this.field_174879_c.func_177952_p() + pgx);
                    break;
                }
                case EAST: {
                    this.spawnGrillParticle(rand, (double)this.field_174879_c.func_177958_n() + pgz + outOffset, (double)this.field_174879_c.func_177956_o() + pgy, (double)this.field_174879_c.func_177952_p() + (1.0 - pgx));
                    break;
                }
                case NORTH: {
                    this.spawnGrillParticle(rand, (double)this.field_174879_c.func_177958_n() + (1.0 - pgx), (double)this.field_174879_c.func_177956_o() + pgy, (double)this.field_174879_c.func_177952_p() + pgz - outOffset);
                    break;
                }
                case SOUTH: {
                    this.spawnGrillParticle(rand, (double)this.field_174879_c.func_177958_n() + pgx, (double)this.field_174879_c.func_177956_o() + pgy, (double)this.field_174879_c.func_177952_p() + pgz + outOffset);
                }
            }
        }
        if (rand.nextInt(5 - ((Mode)this.mode.get()).index) == 0) {
            enumfacing = (Direction)this.func_195044_w().func_177229_b((Property)Generator.FACING);
            double pex = p * 3.0 + (double)rand.nextInt(5) * p;
            double pey = p * 6.5;
            double pez = 0.5;
            double exhaustOffset = 0.4;
            double exhaustVelocity = 0.02 + (0.08 + rand.nextDouble() * 0.02) * ((double)((Mode)this.mode.get()).index / 4.0);
            switch (enumfacing) {
                case WEST: {
                    this.spawnExhaustParticle(rand, (double)this.field_174879_c.func_177958_n() + (1.0 - pex), (double)this.field_174879_c.func_177956_o() + pey, (double)this.field_174879_c.func_177952_p() + pez - exhaustOffset, new Vec3D(0.0, 0.0, -exhaustVelocity));
                    break;
                }
                case EAST: {
                    this.spawnExhaustParticle(rand, (double)this.field_174879_c.func_177958_n() + pex, (double)this.field_174879_c.func_177956_o() + pey, (double)this.field_174879_c.func_177952_p() + pez + exhaustOffset, new Vec3D(0.0, 0.0, exhaustVelocity));
                    break;
                }
                case NORTH: {
                    this.spawnExhaustParticle(rand, (double)this.field_174879_c.func_177958_n() + pez + exhaustOffset, (double)this.field_174879_c.func_177956_o() + pey, (double)this.field_174879_c.func_177952_p() + (1.0 - pex), new Vec3D(exhaustVelocity, 0.0, 0.0));
                    break;
                }
                case SOUTH: {
                    this.spawnExhaustParticle(rand, (double)this.field_174879_c.func_177958_n() + pez - exhaustOffset, (double)this.field_174879_c.func_177956_o() + pey, (double)this.field_174879_c.func_177952_p() + pex, new Vec3D(-exhaustVelocity, 0.0, 0.0));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnGrillParticle(Random rand, double x, double y, double z) {
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0.0, 0.0, 0.0);
        if (this.mode.get() != Mode.PERFORMANCE_PLUS && rand.nextInt(8) == 0) {
            this.field_145850_b.func_195594_a((IParticleData)new IntParticleType.IntParticleData((ParticleType)DEParticles.flame, new int[]{127}), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnExhaustParticle(Random rand, double x, double y, double z, Vec3D velocity) {
        if (rand.nextBoolean()) {
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, velocity.x, velocity.y, velocity.z);
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, velocity.x, velocity.y, velocity.z);
        } else {
            this.field_145850_b.func_195594_a((IParticleData)new IntParticleType.IntParticleData((ParticleType)DEParticles.flame, new int[]{64, (int)((0.1 + rand.nextDouble() * 0.05) * 255.0)}), x, y, z, velocity.x, velocity.y, velocity.z);
        }
    }

    @Nullable
    public Container createMenu(int currentWindowIndex, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerBCTile(DEContent.container_generator, currentWindowIndex, player.field_71071_by, (TileBCore)this, GuiLayoutFactories.GENERATOR_LAYOUT);
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
        }
        return true;
    }

    public static enum Mode {
        ECO_PLUS(0, 50, 5, 0.3f),
        ECO(1, 15, 20, 0.4f),
        NORMAL(2, 10, 40, 0.6f),
        PERFORMANCE(3, 8, 80, 0.8f),
        PERFORMANCE_PLUS(4, 5, 300, 1.0f);

        public final int index;
        public final int energyPerFuelUnit;
        public final int powerOutput;
        private float animFanSpeed;

        private Mode(int index, int energyPerFuelUnit, int powerOutput, float animFanSpeed) {
            this.index = index;
            this.energyPerFuelUnit = energyPerFuelUnit;
            this.powerOutput = powerOutput;
            this.animFanSpeed = animFanSpeed;
        }

        public Mode next(boolean prev) {
            if (prev) {
                return Mode.values()[this.index - 1 < 0 ? Mode.values().length - 1 : this.index - 1];
            }
            return Mode.values()[this.index + 1 == Mode.values().length ? 0 : this.index + 1];
        }

        public int getEfficiency() {
            return (int)((float)this.energyPerFuelUnit / 10.0f * 100.0f);
        }

        public String unlocalizedName() {
            return "gui.draconicevolution.generator.mode_" + this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

