/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.draconicevolution.blocks.Portal;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class TilePortal
extends TileBCore {
    private final ManagedVec3I masterPos = (ManagedVec3I)this.register((IManagedData)new ManagedVec3I("master_pos", new Vec3I(0, -9999, 0), new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    public boolean frameMoving = false;
    public boolean disabled = false;
    public long updateTime = 0L;

    public TilePortal(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TilePortal() {
        super(DEContent.tile_portal);
    }

    public void propRenderUpdate(long triggerTime, boolean reignite) {
    }

    public void validatePortal() {
        if (this.masterPos.get().y == -9999 || this.frameMoving) {
            return;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.getMasterPos());
        if (tile instanceof TileDislocatorReceptacle) {
            if (((TileDislocatorReceptacle)tile).igniting) {
                return;
            }
            if (!((TileDislocatorReceptacle)tile).active.get()) {
                this.field_145850_b.func_217377_a(this.field_174879_c, false);
                return;
            }
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            for (Direction facing : FacingUtils.getFacingsAroundAxis((Direction.Axis)((Direction.Axis)state.func_177229_b(Portal.AXIS)))) {
                BlockState checkPos = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing));
                if (checkPos.func_177230_c() == DEContent.portal || checkPos.func_177230_c() == DEContent.infused_obsidian || checkPos.func_177230_c() == DEContent.dislocator_receptacle) continue;
                ((TileDislocatorReceptacle)tile).deactivate();
                this.field_145850_b.func_217377_a(this.field_174879_c, false);
            }
            this.dataManager.detectAndSendChanges();
        } else {
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
    }

    public void setMasterPos(BlockPos masterPos) {
        this.masterPos.get().set(this.field_174879_c.func_177973_b((Vector3i)masterPos));
    }

    protected BlockPos getMasterPos() {
        return this.field_174879_c.func_177973_b((Vector3i)this.masterPos.get().getPos());
    }

    public TileDislocatorReceptacle getMaster() {
        TileEntity tile = this.field_145850_b.func_175625_s(this.getMasterPos());
        return tile instanceof TileDislocatorReceptacle ? (TileDislocatorReceptacle)tile : null;
    }
}

