/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.flowgate;

import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFlowGate;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.GuiLayoutFactories;
import com.brandon3055.draconicevolution.lib.WTFException;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;

public class TileFluidGate
extends TileFlowGate
implements IFluidHandler {
    public TileFluidGate() {
        super(DEContent.tile_fluid_gate);
    }

    @Override
    public String getUnits() {
        return "MB/t";
    }

    public int getTanks() {
        LazyOptional opHandler;
        TileEntity tile = this.getTarget();
        if (tile != null && (opHandler = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getDirection().func_176734_d())).isPresent()) {
            ((IFluidHandler)opHandler.orElseThrow(WTFException::new)).getTanks();
        }
        return 0;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        LazyOptional opHandler;
        TileEntity tile = this.getTarget();
        if (tile != null && (opHandler = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getDirection().func_176734_d())).isPresent()) {
            ((IFluidHandler)opHandler.orElseThrow(WTFException::new)).getTankCapacity(tank);
        }
        return 0;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        LazyOptional opHandler;
        TileEntity tile = this.getTarget();
        if (tile != null && (opHandler = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getDirection().func_176734_d())).isPresent()) {
            IFluidHandler handler = (IFluidHandler)opHandler.orElseThrow(WTFException::new);
            int transfer = (int)Math.min(this.getFlow(), (long)handler.fill(resource, action));
            if (transfer < resource.getAmount()) {
                FluidStack newStack = resource.copy();
                newStack.setAmount(transfer);
                resource.shrink(transfer);
                return handler.fill(newStack, action);
            }
            return handler.fill(resource, action);
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Override
    public String getPeripheralName() {
        return "fluid_gate";
    }

    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerBCTile(DEContent.container_flow_gate, id, player.field_71071_by, (TileBCore)this, (ContainerSlotLayout.LayoutFactory)SneakyUtils.unsafeCast(GuiLayoutFactories.PLAYER_ONLY_LAYOUT));
    }

    public ITextComponent func_200200_C_() {
        return super.func_200200_C_();
    }

    public boolean onBlockActivated(BlockState state, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, (BlockPos)this.field_174879_c);
        }
        return true;
    }
}

