/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiScreen;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.IGuiTemplate;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.TGuiBase;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.draconicevolution.client.DESprites;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.DislocatorAdvanced;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class GuiDislocator
extends ModularGuiScreen {
    private final PlayerEntity player;
    private List<DislocatorAdvanced.DislocatorTarget> targetList = new ArrayList<DislocatorAdvanced.DislocatorTarget>();
    private LinkedList<TargetElement> targetElements = new LinkedList();
    private GuiScrollElement scrollElement;
    private int selectedIndex = 0;
    private int lastAdded = -1;
    private int fuel = 0;
    private boolean editAdded = false;
    private static double lastPos = 0.0;
    private boolean posLoaded = false;
    private boolean draggingTarget = false;
    private boolean blinkMode = false;
    protected GuiToolkit<GuiDislocator> toolkit = new GuiToolkit((Screen)this, 220, 177).setTranslationPrefix("gui.draconicevolution.dislocator");

    public GuiDislocator(ITextComponent title, PlayerEntity player) {
        super(title);
        this.player = player;
    }

    public void addElements(GuiElementManager manager) {
        TGuiBase temp = new TGuiBase((Screen)this);
        temp.background = GuiTexture.newDynamicTexture((int)this.xSize(), (int)this.ySize(), () -> BCSprites.getThemed((String)"background_dynamic"));
        temp.background.onReload(guiTex -> guiTex.setPos(this.guiLeft(), this.guiTop()));
        this.toolkit.loadTemplate((IGuiTemplate)temp);
        int bgPad = 5;
        int scrollBarWidth = 10;
        GuiBorderedRect posBG = (GuiBorderedRect)((GuiBorderedRect)((GuiBorderedRect)new GuiBorderedRect().set3DGetters(GuiToolkit.Palette.Slot::fill, GuiToolkit.Palette.Slot::accentDark, GuiToolkit.Palette.Slot::accentLight).setBorderColourL(GuiToolkit.Palette.Slot::border3D).setSize(122, 157)).setXPos(temp.background.xPos() + bgPad + scrollBarWidth + 1)).setMaxYPos(temp.background.maxYPos() - bgPad, false);
        temp.background.addChild((GuiElement)posBG);
        GuiSlideControl scrollBar = (GuiSlideControl)((GuiSlideControl)((GuiSlideControl)this.toolkit.createVanillaScrollBar().setPos(temp.background.xPos() + bgPad, posBG.yPos())).setMaxYPos(temp.background.maxYPos() - bgPad, true)).setXSize(scrollBarWidth);
        this.scrollElement = new GuiScrollElement().setListMode(GuiScrollElement.ListMode.VERT_LOCK_POS_WIDTH).setListSpacing(1).setInsets(1, 1, 1, 1);
        ((GuiScrollElement)((GuiScrollElement)((GuiScrollElement)((GuiScrollElement)posBG.addChild((GuiElement)this.scrollElement)).setPos((GuiElement)posBG)).setSize(posBG.getInsetRect())).bindSize((GuiElement)posBG, true)).setVerticalScrollBar(scrollBar).setStandardScrollBehavior();
        GuiBorderedRect infoBG = (GuiBorderedRect)((GuiBorderedRect)((GuiBorderedRect)((GuiBorderedRect)temp.background.addChild((GuiElement)new GuiBorderedRect())).set3DGetters(GuiToolkit.Palette.Slot::fill, GuiToolkit.Palette.Slot::accentDark, GuiToolkit.Palette.Slot::accentLight).setBorderColourL(GuiToolkit.Palette.Slot::border3D).setPos(posBG.maxXPos() + 2, posBG.yPos())).setMaxXPos(temp.background.maxXPos() - bgPad, true)).setHoverText(e -> new String[]{TextFormatting.AQUA + this.getTarget().getName(), TextFormatting.GOLD + "X: " + (int)this.getTarget().getX(), TextFormatting.GOLD + "Y: " + (int)this.getTarget().getY(), TextFormatting.GOLD + "Z: " + (int)this.getTarget().getY(), TextFormatting.GOLD + (GuiDislocator.func_231173_s_() ? this.getTarget().getDimension().func_240901_a_().toString() : this.getTarget().getDimension().func_240901_a_().func_110623_a())});
        GuiLabel xLabel = (GuiLabel)((GuiLabel)((GuiLabel)((GuiLabel)((GuiLabel)infoBG.addChild((GuiElement)new GuiLabel().setAlignment(GuiAlign.LEFT).setShadowStateSupplier(() -> BCConfig.darkMode))).setDisplaySupplier(() -> "X: " + (int)this.getTarget().getX()).setPos(infoBG.xPos() + 2, infoBG.yPos() + 2)).setYSize(8)).setTextColGetter(GuiToolkit.Palette.Slot::text).setMaxXPos(infoBG.maxXPos() - 1, true)).setEnabledCallback(() -> this.selectedIndex >= 0 && this.selectedIndex < this.targetList.size());
        GuiLabel yLabel = (GuiLabel)((GuiLabel)((GuiLabel)((GuiLabel)((GuiLabel)infoBG.addChild((GuiElement)new GuiLabel().setAlignment(GuiAlign.LEFT).setShadowStateSupplier(() -> BCConfig.darkMode))).setDisplaySupplier(() -> "Y: " + (int)this.getTarget().getY()).setPos(infoBG.xPos() + 2, xLabel.maxYPos() + 2)).setYSize(8)).setTextColGetter(GuiToolkit.Palette.Slot::text).setMaxXPos(infoBG.maxXPos() - 1, true)).setEnabledCallback(() -> this.selectedIndex >= 0 && this.selectedIndex < this.targetList.size());
        GuiLabel zLabel = (GuiLabel)((GuiLabel)((GuiLabel)((GuiLabel)((GuiLabel)infoBG.addChild((GuiElement)new GuiLabel().setAlignment(GuiAlign.LEFT).setShadowStateSupplier(() -> BCConfig.darkMode))).setDisplaySupplier(() -> "Z: " + (int)this.getTarget().getY()).setPos(infoBG.xPos() + 2, yLabel.maxYPos() + 2)).setYSize(8)).setTextColGetter(GuiToolkit.Palette.Slot::text).setMaxXPos(infoBG.maxXPos() - 1, true)).setEnabledCallback(() -> this.selectedIndex >= 0 && this.selectedIndex < this.targetList.size());
        GuiLabel dimLabel = (GuiLabel)((GuiLabel)((GuiLabel)((GuiLabel)((GuiLabel)infoBG.addChild((GuiElement)new GuiLabel().setAlignment(GuiAlign.LEFT).setShadowStateSupplier(() -> BCConfig.darkMode))).setDisplaySupplier(() -> this.getTarget().getDimension().func_240901_a_().func_110623_a()).setPos(infoBG.xPos() + 2, zLabel.maxYPos() + 2)).setYSize(8)).setTextColGetter(GuiToolkit.Palette.Slot::text).setMaxXPos(infoBG.maxXPos() - 1, true)).setEnabledCallback(() -> this.selectedIndex >= 0 && this.selectedIndex < this.targetList.size());
        infoBG.setMaxYPos(dimLabel.maxYPos() + 2, true);
        GuiButton setHere = ((GuiButton)((GuiButton)((GuiButton)((GuiButton)this.toolkit.createButton(this.toolkit.i18n("update"), temp.background, true).setHoverText(this.toolkit.i18n("update.info"))).setPos(posBG.maxXPos() + 2, infoBG.maxYPos() + 2)).setMaxXPos(temp.background.maxXPos() - bgPad, true)).setYSize(15)).onPressed(() -> DraconicNetwork.sendDislocatorMessage(7, output -> output.writeVarInt(this.selectedIndex))).setDisabledStateSupplier(() -> !this.hasTarget() || this.getTarget().isLocked());
        GuiButton fuel1 = ((GuiButton)((GuiButton)((GuiButton)((GuiButton)this.toolkit.createButton("+1", temp.background, true, 0.0).setHoverText(this.toolkit.i18n("fuel_add_1.info"))).setXPos(posBG.maxXPos() + 2)).setSize(18, 13)).setMaxYPos(temp.background.maxYPos() - bgPad - 1, false)).onPressed(() -> DraconicNetwork.sendDislocatorMessage(6, output -> output.writeBoolean(false).writeBoolean(false)));
        GuiButton fuel16 = ((GuiButton)((GuiButton)((GuiButton)this.toolkit.createButton("+16", temp.background, true, 0.0).setHoverText(this.toolkit.i18n("fuel_add_16.info"))).setSize(24, 13)).setPos(fuel1.maxXPos() + 1, fuel1.yPos())).onPressed(() -> DraconicNetwork.sendDislocatorMessage(6, output -> output.writeBoolean(true).writeBoolean(false)));
        GuiButton fuelAll = ((GuiButton)((GuiButton)((GuiButton)((GuiButton)this.toolkit.createButton("All", temp.background, true, 0.0).setHoverText(this.toolkit.i18n("fuel_add_all.info"))).setYSize(13)).setPos(fuel16.maxXPos() + 1, fuel16.yPos())).setMaxXPos(temp.background.maxXPos() - bgPad - 1, true)).onPressed(() -> DraconicNetwork.sendDislocatorMessage(6, output -> output.writeBoolean(false).writeBoolean(true)));
        temp.background.addBackGroundChild(((GuiBorderedRect)new GuiBorderedRect().setFillColour(-16777216).setPos(fuel1.xPos() - 1, fuel1.yPos() - 1)).setMaxPos(fuelAll.maxXPos() + 1, fuelAll.maxYPos() + 1, true));
        GuiBorderedRect fuelBG = (GuiBorderedRect)((GuiBorderedRect)((GuiBorderedRect)((GuiBorderedRect)((GuiBorderedRect)temp.background.addChild((GuiElement)new GuiBorderedRect())).set3DGetters(GuiToolkit.Palette.Slot::fill, GuiToolkit.Palette.Slot::accentDark, GuiToolkit.Palette.Slot::accentLight).setBorderColourL(GuiToolkit.Palette.Slot::border3D).setYSize(14)).setXPos(posBG.maxXPos() + 2)).setMaxYPos(fuel1.yPos() - 4, false)).setMaxXPos(temp.background.maxXPos() - bgPad, true);
        GuiLabel fuelLabel = (GuiLabel)((GuiLabel)((GuiLabel)((GuiLabel)((GuiLabel)fuelBG.addChild((GuiElement)new GuiLabel().setAlignment(GuiAlign.LEFT).setShadowStateSupplier(() -> BCConfig.darkMode))).setDisplaySupplier(() -> this.toolkit.i18n("fuel") + " " + this.fuel).setHoverText(this.toolkit.i18n("fuel.info"))).setPos(posBG.maxXPos() + 4, fuelBG.yPos())).setMaxXPos(temp.background.maxXPos() - bgPad, true)).setTextColGetter(GuiToolkit.Palette.Slot::text).setYSize(14);
        int subWidth = 18;
        GuiButton addButton = ((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)this.toolkit.createButton(this.toolkit.i18n("add"), temp.background, true).setHoverText(this.toolkit.i18n("add.info"))).setYSize(15)).setXPos(posBG.maxXPos() + 2)).setMaxYPos(fuelBG.yPos() - 3, false)).setMaxXPos(temp.background.maxXPos() - bgPad - subWidth, true)).onPressed(() -> this.addNew(0));
        addButton.addChild(((GuiBorderedRect)new GuiBorderedRect().setFillColour(-16777216).setPos(addButton.maxXPos(), addButton.yPos())).setSize(subWidth, addButton.ySize()));
        ((GuiButton)((GuiButton)((GuiButton)((GuiButton)this.toolkit.createButton("", (GuiElement)addButton, true, 0.0).setHoverText(this.toolkit.i18n("add_top.info"))).setSize(subWidth - 1, 6)).setXPos(addButton.maxXPos())).setYPos(addButton.yPos() + 1)).onPressed(() -> this.addNew(1)).addChild(new GuiTexture(8, 8, DESprites.get("dislocator/add_top")).onReload(GuiTexture::centerOnParent));
        ((GuiButton)((GuiButton)((GuiButton)((GuiButton)this.toolkit.createButton("", (GuiElement)addButton, true, 0.0).setHoverText(this.toolkit.i18n("add_bottom.info"))).setSize(subWidth - 1, 6)).setXPos(addButton.maxXPos())).setMaxYPos(addButton.maxYPos() - 1, false)).onPressed(() -> this.addNew(2)).addChild(new GuiTexture(8, 8, DESprites.get("dislocator/add_bottom")).onReload(GuiTexture::centerOnParent));
        ((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)this.toolkit.createButton("", (GuiElement)addButton, true).setHoverText(this.toolkit.i18n("right_click_mode.info"))).setDisplaySupplier(() -> this.toolkit.i18n("mode_" + (this.blinkMode ? "blink" : "tp"))).setWrap(true).setYSize(24)).setXPos(addButton.xPos())).setMaxXPos(temp.background.maxXPos() - bgPad, true)).setMaxYPos(addButton.yPos() - 2, false)).onPressed(() -> DraconicNetwork.sendDislocatorMessage(5, output -> output.writeBoolean(!this.blinkMode)));
        manager.onTick(this::detectChanges);
    }

    private boolean hasTarget() {
        return this.selectedIndex >= 0 && this.selectedIndex < this.targetList.size();
    }

    private DislocatorAdvanced.DislocatorTarget getTarget() {
        return (DislocatorAdvanced.DislocatorTarget)((Object)DataUtils.safeGet(this.targetList, (int)this.selectedIndex, () -> new DislocatorAdvanced.DislocatorTarget(0.0, 0.0, 0.0, (RegistryKey<World>)World.field_234918_g_)));
    }

    private void addNew(int mode) {
        String tempName = (int)this.player.func_226277_ct_() + " " + (int)this.player.func_226278_cu_() + " " + (int)this.player.func_226281_cx_();
        this.lastAdded = mode == 0 ? this.selectedIndex + 1 : (mode == 1 ? 0 : this.targetList.size());
        DraconicNetwork.sendDislocatorMessage(0, output -> output.writeByte(mode).writeVarInt(this.lastAdded).writeString(tempName));
    }

    private void detectChanges() {
        ItemStack stack = DislocatorAdvanced.findDislocator(this.player);
        if (stack.func_190926_b() || !this.player.func_70089_S()) {
            this.func_231175_as__();
            return;
        }
        int lastSize = this.targetList.size();
        this.targetList = DEContent.dislocator_advanced.getTargetList(stack);
        int count = Math.max(12, this.targetList.size());
        if (this.lastAdded != -1 && this.targetList.size() != lastSize) {
            this.editAdded = true;
        }
        double lastPos = this.scrollElement.getVerticalScrollBar().getRawPos();
        while (this.targetElements.size() > count) {
            this.scrollElement.removeElement((GuiElement)this.targetElements.removeLast());
            this.scrollElement.reloadElement();
        }
        while (this.targetElements.size() < count) {
            TargetElement newElement = new TargetElement(this.targetElements.size());
            this.targetElements.addLast(newElement);
            this.scrollElement.addElement((GuiElement)newElement);
            this.scrollElement.reloadElement();
        }
        this.scrollElement.getVerticalScrollBar().updateRawPos(lastPos);
        this.selectedIndex = DEContent.dislocator_advanced.getSelectedIndex(stack);
        this.fuel = DEContent.dislocator_advanced.getFuel(stack);
        this.blinkMode = DEContent.dislocator_advanced.getBlinkMode(stack);
        if (this.editAdded && this.lastAdded == 0) {
            this.scrollElement.getVerticalScrollBar().updateRawPos(0.0);
        } else if (this.editAdded && this.lastAdded == this.targetList.size() - 1) {
            this.scrollElement.getVerticalScrollBar().updateRawPos(1.0);
        }
        if (!this.posLoaded) {
            this.scrollElement.getVerticalScrollBar().updateRawPos(GuiDislocator.lastPos);
            this.scrollElement.getVerticalScrollBar().addInputListener(e -> {
                lastPos = e.getRawPos();
            });
            this.posLoaded = true;
        }
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(mStack);
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
    }

    private class TargetElement
    extends GuiElement<TargetElement> {
        private int index;
        private GuiTextField field;
        private GuiButton lock;
        private GuiButton delete;
        private int clickTime = 99;
        private boolean mousePressed = false;
        private boolean dragging = false;
        boolean lastTickTarget = false;

        public TargetElement(int index) {
            this.index = index;
            this.setYSize(12);
            this.setHoverText(e -> new String[]{TextFormatting.AQUA + this.getName(), TextFormatting.GRAY + GuiDislocator.this.toolkit.i18n("right_click_tp"), TextFormatting.GRAY + GuiDislocator.this.toolkit.i18n("double_click_name"), TextFormatting.GRAY + GuiDislocator.this.toolkit.i18n("must_unlock"), TextFormatting.GRAY + GuiDislocator.this.toolkit.i18n("drag_to_move")});
        }

        private boolean hasTarget() {
            return this.index >= 0 && this.index < GuiDislocator.this.targetList.size();
        }

        private DislocatorAdvanced.DislocatorTarget getTarget() {
            return (DislocatorAdvanced.DislocatorTarget)((Object)GuiDislocator.this.targetList.get(this.index));
        }

        private boolean isLocked() {
            return this.hasTarget() && this.getTarget().isLocked();
        }

        private String getName() {
            return this.hasTarget() ? this.getTarget().getName() : "[error]";
        }

        private void setName(String name) {
            DraconicNetwork.sendDislocatorMessage(2, e -> e.writeVarInt(this.index).writeString(name));
        }

        public void addChildElements() {
            this.lock = (GuiButton)((GuiButton)((GuiButton)((GuiButton)GuiDislocator.this.toolkit.createIconButton((GuiElement)this, 8, 8, () -> DESprites.get("dislocator/" + (this.isLocked() ? "locked" : "unlocked"))).setHoverText(GuiDislocator.this.toolkit.i18n("edit_lock.info"))).setXPosMod(() -> this.maxXPos() - 9)).setYPosMod(() -> this.yPos() + 2)).onPressed(() -> DraconicNetwork.sendDislocatorMessage(3, e -> e.writeVarInt(this.index).writeBoolean(!this.isLocked()))).setEnabledCallback(this::hasTarget);
            this.delete = (GuiButton)((GuiButton)((GuiButton)((GuiButton)GuiDislocator.this.toolkit.createIconButton((GuiElement)this, 8, 8, DESprites.getter("dislocator/delete")).setHoverText(GuiDislocator.this.toolkit.i18n("delete.info"))).setXPosMod(() -> this.lock.xPos() - 9)).setYPosMod(() -> this.yPos() + 2)).onPressed(() -> DraconicNetwork.sendDislocatorMessage(1, e -> e.writeVarInt(this.index))).setEnabledCallback(() -> this.hasTarget() && !this.isLocked());
            this.field = (GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)GuiDislocator.this.toolkit.createTextField((GuiElement)this, false).setChangeListener(this::setName).setPos(this.xPos() + 1, this.yPos() + 2)).setYSize(10)).setXSize(100)).setCanFocus(false).setReturnListener(() -> this.field.setFocused(false)).setEnabledCallback(this::hasTarget);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            boolean ret = false;
            if (!this.hasTarget() || button == 2) {
                return false;
            }
            boolean mouseOver = this.field.isMouseOver(mouseX, mouseY);
            if (mouseOver && button == 1) {
                DraconicNetwork.sendDislocatorMessage(8, e -> e.writeVarInt(this.index));
                GuiDislocator.this.func_231175_as__();
                return true;
            }
            if (mouseOver && button == 0 && !this.getTarget().isLocked()) {
                if (this.clickTime <= 10) {
                    this.field.setFocused(true);
                    ret = true;
                } else {
                    this.clickTime = 0;
                }
            }
            ret = ret || super.mouseClicked(mouseX, mouseY, button);
            this.mousePressed = mouseOver;
            if (!ret && mouseOver && this.index != GuiDislocator.this.selectedIndex) {
                DraconicNetwork.sendDislocatorMessage(4, e -> e.writeVarInt(this.index));
                return true;
            }
            return ret;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double dragX, double dragY) {
            if (this.mousePressed && !this.isMouseOver(mouseX, mouseY)) {
                this.dragging = GuiDislocator.this.draggingTarget = true;
            }
            return super.mouseDragged(mouseX, mouseY, clickedMouseButton, dragX, dragY);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            TargetElement hovered;
            if (this.dragging && (hovered = this.getHovered((int)mouseX, (int)mouseY)) != null) {
                int moveIndex = mouseY > (double)hovered.yPos() + (double)hovered.ySize() / 2.0 ? hovered.index + 1 : hovered.index;
                DraconicNetwork.sendDislocatorMessage(10, e -> e.writeVarInt(moveIndex));
            }
            this.dragging = this.mousePressed = (GuiDislocator.this.draggingTarget = false);
            return super.mouseReleased(mouseX, mouseY, button);
        }

        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            boolean selected = false;
            boolean hovered = false;
            if (this.hasTarget() && (this.dragging || !GuiDislocator.this.draggingTarget)) {
                DislocatorAdvanced.DislocatorTarget target = this.getTarget();
                int margin = target.isLocked() ? 10 : 18;
                hovered = mouseX < this.maxXPos() - margin && this.hoverTime > 0;
                selected = this.index == GuiDislocator.this.selectedIndex;
            }
            RenderMaterial mat = DESprites.get("dislocator/slot");
            RenderMaterial matSelect = DESprites.get("dislocator/slot_selected");
            IRenderTypeBuffer.Impl getter = minecraft.func_228019_au_().func_228487_b_();
            this.drawSprite(getter.getBuffer(BCSprites.GUI_TYPE), this.xPos(), this.yPos(), (selected ? matSelect : mat).func_229314_c_());
            if (hovered && !selected) {
                getter.func_228461_a_();
                this.drawSprite(getter.getBuffer(BCSprites.GUI_TYPE), this.xPos(), this.yPos(), matSelect.func_229314_c_(), 0x30FFFFFF);
            }
            getter.func_228461_a_();
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
            if (this.lock.isMouseOver((double)mouseX, (double)mouseY) || this.delete.isEnabled() && this.delete.isMouseOver((double)mouseX, (double)mouseY)) {
                this.hoverTime = 0;
            }
        }

        public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            if (this.dragging) {
                int yPos = MathHelper.clip((int)(mouseY - 6), (int)this.getParent().yPos(), (int)(this.getParent().maxYPos() - 12));
                IRenderTypeBuffer.Impl getter = minecraft.func_228019_au_().func_228487_b_();
                TargetElement hovered = this.getHovered(mouseX, mouseY);
                if (hovered != null) {
                    int y = mouseY > hovered.yPos() + hovered.ySize() / 2 ? hovered.maxYPos() : hovered.yPos() - 1;
                    this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos(), y, this.xSize(), 3.0, 0x6000FF00);
                    getter.func_228461_a_();
                }
                this.drawSprite(getter.getBuffer(BCSprites.GUI_TYPE), this.xPos(), yPos, DESprites.get("dislocator/slot_selected").func_229314_c_(), 0x60FFFFFF);
                getter.func_228461_a_();
                return true;
            }
            if (GuiDislocator.this.draggingTarget) {
                return false;
            }
            return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
        }

        private TargetElement getHovered(int mouseX, int mouseY) {
            for (TargetElement element : GuiDislocator.this.targetElements) {
                if ((element == this || !element.isMouseOver(mouseX, mouseY)) && !element.isMouseOver(mouseX, mouseY + 1) && !element.isMouseOver(mouseX, mouseY - 1)) continue;
                return element;
            }
            return null;
        }

        public boolean onUpdate() {
            boolean hasTarget = this.hasTarget();
            if (hasTarget) {
                if (!this.field.isFocused()) {
                    this.field.setTextQuietly(this.getTarget().getName());
                }
            } else {
                this.field.setTextQuietly("");
            }
            ++this.clickTime;
            this.lastTickTarget = hasTarget;
            if (GuiDislocator.this.lastAdded == this.index && GuiDislocator.this.editAdded) {
                GuiDislocator.this.lastAdded = -1;
                GuiDislocator.this.editAdded = false;
                this.field.setFocused(true);
                this.field.setCursorPositionEnd();
                this.field.setSelectionPos(0);
            }
            return super.onUpdate();
        }

        public boolean isHoverTextEnabled() {
            return this.hasTarget();
        }
    }
}

