/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiEnergyBar;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiPickColourDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiSlotRender;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.IGuiTemplate;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.TGuiBase;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDraconiumChest;
import com.brandon3055.draconicevolution.client.DESprites;
import com.brandon3055.draconicevolution.client.model.ModelDraconiumChest;
import com.brandon3055.draconicevolution.inventory.ContainerDraconiumChest;
import java.awt.Point;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiDraconiumChest
extends ModularGuiContainer<ContainerDraconiumChest> {
    protected GuiToolkit<GuiDraconiumChest> toolkit = new GuiToolkit((Screen)this, 500, 288).setTranslationPrefix("gui.draconicevolution.draconium_chest");
    private final TileDraconiumChest tile;
    public static final ResourceLocation DRACONIUM_CHEST = new ResourceLocation("draconicevolution", "textures/block/draconium_chest.png");
    public static ModelDraconiumChest chest = new ModelDraconiumChest(RenderType::func_228634_a_);

    public GuiDraconiumChest(ContainerDraconiumChest container, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)container, inv, titleIn);
        this.tile = (TileDraconiumChest)container.tile;
    }

    public void addElements(GuiElementManager manager) {
        TGuiBase template = new TGuiBase((Screen)this);
        template.background = GuiTexture.newDynamicTexture((int)this.xSize(), (int)this.ySize(), () -> BCSprites.getThemed((String)"background_dynamic"));
        template.background.onReload(guiTex -> guiTex.setPos(this.guiLeft(), this.guiTop()));
        this.toolkit.loadTemplate((IGuiTemplate)template);
        template.addPlayerSlots(true, false, false);
        this.toolkit.createSlots(template.background, 26, 10, 0).setPos(this.guiLeft() + 16, this.guiTop() + 14);
        this.toolkit.createSlots(template.background, 5, 1, 0).setPos(this.guiLeft() + 50, this.guiTop() + 206);
        GuiFurnaceFlames flames = new GuiFurnaceFlames(template.background, this.guiLeft() + 51, this.guiTop() + 226, this.tile);
        template.energyBar = (GuiEnergyBar)((GuiEnergyBar)((GuiEnergyBar)((GuiEnergyBar)this.toolkit.createEnergyBar(template.background, (IOPStorage)this.tile.opStorage).setHorizontal(true).setPos(this.guiLeft() + 37, this.guiTop() + 247)).setYSize(14)).setMaxXPos(this.toolkit.guiLeft() + 100, true)).setXSize(120);
        new GuiChestEnergy(template.background, template.energyBar.xPos() - 21, template.energyBar.yPos() + 17);
        new GuiCoreSlot(template.background, this.guiLeft() + 22, this.guiTop() + 206);
        this.toolkit.createSlots(template.background, 3, 3, 0).setPos(this.guiLeft() + 339, this.guiTop() + 206);
        new GuiCraftingResultSlot(template.background, this.guiLeft() + 429, this.guiTop() + 220);
        new GuiCraftingArrow(template.background, this.guiLeft() + 400, this.guiTop() + 225);
        this.toolkit.createRSSwitch(template.background, (IRSSwitchable)this.tile).setPos(template.themeButton.xPos(), template.themeButton.yPos() + 24);
        new GuiAutofillButton(template.background, template.themeButton.xPos(), template.themeButton.yPos() + 36, this.tile);
        new GuiColorPicker(template, template.themeButton.xPos(), template.themeButton.yPos() + 48, this.tile);
        template.infoPanel = this.toolkit.createInfoPanel(template.background, false);
        template.infoPanel.setOrigin(() -> new Point(template.themeButton.xPos(), template.themeButton.maxYPos()));
        template.infoPanel.setEnabled(false);
        template.infoPanel.addLabeledValue(TextFormatting.GOLD + this.toolkit.i18n("smelt_energy"), 6, 11, () -> TextFormatting.GRAY + this.tile.smeltEnergyPerTick.get() + " OP/t", true);
        template.infoPanel.addLabeledValue(TextFormatting.GOLD + this.toolkit.i18n("smelt_speed"), 6, 11, () -> TextFormatting.GRAY + 10000 / this.tile.smeltTime.get() + " %", true);
    }

    public class GuiColorPicker
    extends GuiButton {
        public GuiColorPicker(TGuiBase template, int xPos, int yPos, TileDraconiumChest tile) {
            super(xPos, yPos);
            this.setPos(xPos, yPos);
            GuiToolkit.addHoverHighlight((GuiElement)this);
            this.setHoverTextDelay(10);
            this.setSize(12, 12);
            GuiTexture icon = (GuiTexture)new GuiTexture(12, 12, DESprites.get("draconium_chest/color_picker")).setPos(xPos, yPos);
            icon.setYPosMod(() -> ((GuiColorPicker)this).yPos());
            this.setHoverText(element -> TextFormatting.WHITE + I18n.func_135052_a((String)"gui.draconicevolution.draconium_chest.color_picker.info", (Object[])new Object[0]));
            GuiPickColourDialog colorPicker = new GuiPickColourDialog(template.themeButton.xPos(), template.themeButton.yPos() + 48, template.background);
            colorPicker.setIncludeAlpha(false);
            colorPicker.setColour(tile.colour.get());
            this.addChild((GuiElement)icon);
            colorPicker.setColourSelectListener(color -> {
                tile.setColour((int)color);
                colorPicker.setColour(color.intValue());
            });
            this.onButtonPressed(pressed -> {
                if (colorPicker.isVisible()) {
                    colorPicker.close();
                } else {
                    colorPicker.show();
                }
            });
            this.addChild((GuiElement)colorPicker);
            template.background.addChild((GuiElement)this);
            colorPicker.close();
        }
    }

    public static class GuiFurnaceFlames
    extends GuiTexture {
        public GuiFurnaceFlames(GuiElement parent, int xPos, int yPos, TileDraconiumChest tile) {
            super(88, 15, () -> DESprites.get("draconium_chest/furnace_" + (tile.isSmelting.get() ? "on" : "off")));
            this.setPos(xPos, yPos);
            parent.addChild((GuiElement)this);
        }

        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    public static class GuiCraftingArrow
    extends GuiTexture {
        public GuiCraftingArrow(GuiElement parent, int xPos, int yPos) {
            super(22, 15, () -> DESprites.get("draconium_chest/crafting_arrow_" + (BCConfig.darkMode ? "dark" : "light")));
            this.setPos(xPos, yPos);
            parent.addChild((GuiElement)this);
        }
    }

    public static class GuiCraftingResultSlot
    extends GuiTexture {
        public GuiCraftingResultSlot(GuiElement parent, int xPos, int yPos) {
            super(26, 26, () -> DESprites.get("draconium_chest/crafting_field_" + (BCConfig.darkMode ? "dark" : "light")));
            this.setPos(xPos, yPos);
            parent.addChild((GuiElement)this);
        }
    }

    public static class GuiCoreSlot
    extends GuiSlotRender {
        public GuiCoreSlot(GuiElement parent, int xPos, int yPos) {
            super(xPos, yPos);
            parent.addChild((GuiElement)this);
            GuiTexture core = (GuiTexture)new GuiTexture(16, 16, DESprites.get("draconium_chest/core")).setPos(xPos + 1, yPos + 1);
            this.addChild((GuiElement)core);
        }
    }

    public static class GuiAutofillButton
    extends GuiButton {
        public GuiAutofillButton(GuiElement parent, int xPos, int yPos, TileDraconiumChest tile) {
            this.setPos(xPos, yPos);
            GuiToolkit.addHoverHighlight((GuiElement)this);
            this.setHoverTextDelay(10);
            this.setSize(12, 12);
            GuiTexture icon = (GuiTexture)new GuiTexture(12, 12, () -> DESprites.get("draconium_chest/autofill_" + ((TileDraconiumChest.AutoSmeltMode)tile.autoSmeltMode.get()).toString().toLowerCase(Locale.ENGLISH))).setPos(xPos, yPos);
            icon.setYPosMod(() -> ((GuiAutofillButton)this).yPos());
            this.setHoverText(element -> TextFormatting.WHITE + I18n.func_135052_a((String)(((TileDraconiumChest.AutoSmeltMode)tile.autoSmeltMode.get()).unlocalizedName() + ".info"), (Object[])new Object[0]));
            this.onButtonPressed(pressed -> tile.setAutoSmeltMode(((TileDraconiumChest.AutoSmeltMode)tile.autoSmeltMode.get()).next(Screen.func_231173_s_() || pressed == 1)));
            this.addChild((GuiElement)icon);
            parent.addChild((GuiElement)this);
        }
    }

    public static class GuiChestEnergy
    extends GuiSlotRender {
        public GuiChestEnergy(GuiElement parent, int xPos, int yPos) {
            super(xPos, yPos);
            parent.addChild((GuiElement)this);
            GuiTexture capacitor = (GuiTexture)new GuiTexture(16, 16, BCSprites.get((String)"slots/energy")).setPos(this.xPos() + 1, this.yPos() + 1);
            this.addChild((GuiElement)capacitor);
            GuiTexture arrow = new GuiTexture(-14, 14, BCSprites.get((String)"item_charge/right_discharge"));
            arrow.setPos(this.xPos() + 18, this.yPos() - arrow.ySize() - 1);
            this.addChild((GuiElement)arrow);
        }
    }
}

