/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.IGuiTemplate;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.TBasicMachine;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.inventory.ContainerSlotLayout;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGenerator;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiGenerator
extends ModularGuiContainer<ContainerBCTile<TileGenerator>> {
    private static final RenderType modelType = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/generator/generator_2.png"));
    private static final CCModel storageModel;
    public PlayerEntity player;
    private TileGenerator tile;
    protected GuiToolkit<GuiGenerator> toolkit = new GuiToolkit((Screen)this, GuiToolkit.GuiLayout.DEFAULT).setTranslationPrefix("gui.draconicevolution.generator");

    public GuiGenerator(ContainerBCTile<TileGenerator> container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.tile = (TileGenerator)container.tile;
        this.player = playerInventory.field_70458_d;
    }

    public void addElements(GuiElementManager manager) {
        TBasicMachine template = (TBasicMachine)this.toolkit.loadTemplate((IGuiTemplate)new TBasicMachine((Screen)this, (TileBCore)this.tile));
        template.background.addChild((GuiElement)new StorageRenderer());
        GuiElement fuelSlots = this.toolkit.createSlots(template.background, 3, 1, 0, (x, y) -> ((ContainerBCTile)this.container).getSlotLayout().getSlotData(ContainerSlotLayout.SlotType.TILE_INV, x.intValue()), BCSprites.get((String)"slots/fuel"));
        fuelSlots.zOffset += 100.0;
        fuelSlots.setPos(this.guiLeft() + 64, this.guiTop() + 28);
        template.addEnergyBar((IOPStorage)this.tile.opStorage);
        template.addEnergyItemSlot(true, ((ContainerBCTile)this.container).getSlotLayout().getSlotData(ContainerSlotLayout.SlotType.TILE_INV, 3));
        GuiButton modeButton = this.toolkit.createButton("", template.background);
        modeButton.setDisplaySupplier(() -> I18n.func_135052_a((String)((TileGenerator.Mode)this.tile.mode.get()).unlocalizedName(), (Object[])new Object[0]));
        modeButton.setHoverText(element -> TextFormatting.BLUE + I18n.func_135052_a((String)(((TileGenerator.Mode)this.tile.mode.get()).unlocalizedName() + ".info"), (Object[])new Object[0]));
        modeButton.onButtonPressed(pressed -> {
            TileGenerator.Mode cfr_ignored_0 = (TileGenerator.Mode)this.tile.mode.set((Enum)((TileGenerator.Mode)this.tile.mode.get()).next(GuiGenerator.func_231173_s_() || pressed == 1));
        });
        modeButton.setSize(80, 14);
        modeButton.zOffset += 100.0;
        modeButton.getChildElements().forEach(e -> e.zOffset += 100.0);
        modeButton.setPos(template.playerSlots.maxXPos() - modeButton.xSize(), template.playerSlots.yPos() - modeButton.ySize() + 8);
        template.infoPanel.addLabeledValue(TextFormatting.GOLD + this.toolkit.i18n("fuel_efficiency"), 6, 11, () -> TextFormatting.GRAY + ((TileGenerator.Mode)this.tile.mode.get()).getEfficiency() + "%", true);
        template.infoPanel.addLabeledValue(TextFormatting.GOLD + this.toolkit.i18n("output_power"), 6, 11, () -> TextFormatting.GRAY + this.tile.productionRate.get() + " / " + ((TileGenerator.Mode)this.tile.mode.get()).powerOutput + " OP/t", true);
        template.infoPanel.addLabeledValue(TextFormatting.GOLD + this.toolkit.i18n("current_fuel_value"), 6, 11, () -> TextFormatting.GRAY + (this.tile.fuelRemaining.get() == 0 ? "n/a" : this.tile.fuelRemaining.get() + " / " + this.tile.fuelValue.get()), true);
    }

    static {
        Map map = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/block/generator/generator_storage.obj"), (int)7, null);
        storageModel = CCModel.combine(map.values());
        storageModel.computeNormals();
    }

    private class StorageRenderer
    extends GuiElement<StorageRenderer> {
        private StorageRenderer() {
        }

        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            MatrixStack mStack = new MatrixStack();
            IRenderTypeBuffer.Impl getter = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            ccrs.bind(modelType, (IRenderTypeBuffer)getter);
            Matrix4 mat = new Matrix4(mStack);
            mat.translate((double)(GuiGenerator.this.guiLeft() + 90), (double)(GuiGenerator.this.guiTop() + 45), 50.0);
            float mx = ((float)(mouseX - GuiGenerator.this.guiLeft()) / (float)GuiGenerator.this.xSize() - 0.5f) * 0.1f;
            float my = ((float)(mouseY - GuiGenerator.this.guiTop()) / (float)GuiGenerator.this.ySize() - 0.5f) * 0.1f;
            mat.apply((Transformation)new Rotation(2.61799387799145, 1.0, 0.0, 0.0).with((Transformation)new Rotation(0.17453292519943, (double)(-my), (double)(1.0f + mx), 0.0)));
            mat.scale(7.5);
            storageModel.render(ccrs, new IVertexOperation[]{mat});
            getter.func_228461_a_();
        }
    }
}

