/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.HudConfigGui;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.IGuiTemplate;
import com.brandon3055.brandonscore.client.gui.modulargui.templates.TGuiBase;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleGrid;
import com.brandon3055.draconicevolution.client.gui.ModuleGridRenderer;
import com.brandon3055.draconicevolution.inventory.ContainerModularItem;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiModularItem
extends ModularGuiContainer<ContainerModularItem> {
    private static AtomicBoolean infoExpanded = new AtomicBoolean(true);
    private ModuleGrid grid;
    private GuiToolkit<GuiModularItem> toolkit;
    private ModuleGridRenderer gridRenderer;
    private GuiToolkit.InfoPanel infoPanel;

    public GuiModularItem(ContainerModularItem container, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)container, inv, titleIn);
        this.grid = container.getGrid();
        int maxGridWidth = 226;
        int maxGridHeight = 145;
        int minXPadding = 30;
        int yPadding = 112;
        int cellSize = Math.min(Math.min(maxGridWidth / this.grid.getWidth(), maxGridHeight / this.grid.getHeight()), 16);
        int width = Math.max(218, cellSize * this.grid.getWidth() + minXPadding);
        int height = yPadding + cellSize * this.grid.getHeight();
        this.grid.setCellSize(cellSize);
        this.toolkit = new GuiToolkit((Screen)this, width, height);
    }

    public void addElements(GuiElementManager manager) {
        TGuiBase template = new TGuiBase((Screen)this);
        template.background = GuiTexture.newDynamicTexture((int)this.xSize(), (int)this.ySize(), () -> BCSprites.getThemed((String)"background_dynamic"));
        template.background.onReload(guiTex -> guiTex.setPos(this.guiLeft(), this.guiTop()));
        this.toolkit.loadTemplate((IGuiTemplate)template);
        template.title.setInsets(0, 14, 0, 12);
        template.addPlayerSlots(true, true, true);
        this.infoPanel = template.infoPanel;
        this.infoPanel.setExpandedHolder(infoExpanded);
        this.gridRenderer = new ModuleGridRenderer(((ContainerModularItem)this.container).getGrid(), this.field_213127_e);
        this.gridRenderer.setYPos(template.title.maxYPos() + 3);
        this.toolkit.centerX((GuiElement)this.gridRenderer, template.background, 0);
        template.background.addChild((GuiElement)this.gridRenderer);
        this.grid.setPosition(this.gridRenderer.xPos() - this.guiLeft(), this.gridRenderer.yPos() - this.guiTop());
        this.grid.setOnGridChange(this::updateInfoPanel);
        GuiElement equipModSlots = this.toolkit.createEquipModSlots(template.background, this.field_213127_e.field_70458_d, true, e -> e.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent());
        equipModSlots.setPos(template.background.xPos() - 28, template.background.yPos());
        GuiButton itemConfig = this.toolkit.createThemedIconButton(template.background, "item_config");
        itemConfig.onReload(e -> {
            GuiButton cfr_ignored_0 = (GuiButton)e.setRelPos(template.background, 3, 3);
        });
        itemConfig.setHoverText(I18n.func_135052_a((String)"gui.draconicevolution.modular_item.open_item_config.info", (Object[])new Object[0]));
        itemConfig.onPressed(() -> DraconicNetwork.sendOpenItemConfig(false));
        GuiButton hudConfig = this.toolkit.createIconButton(template.background, 16, 9, 16, 8, BCSprites.themedGetter((String)"hud_button"));
        hudConfig.onReload(e -> {
            GuiButton cfr_ignored_0 = (GuiButton)e.setPos(itemConfig.maxXPos() + 1, itemConfig.yPos());
        });
        hudConfig.setHoverText(I18n.func_135052_a((String)"hud.draconicevolution.open_hud_config", (Object[])new Object[0]));
        hudConfig.onPressed(() -> this.field_230706_i_.func_147108_a((Screen)new HudConfigGui()));
        this.updateInfoPanel();
    }

    private void updateInfoPanel() {
        this.infoPanel.clear();
        TechLevel techLevel = ((ContainerModularItem)this.container).getModuleHost().getHostTechLevel();
        StringBuilder gridName = new StringBuilder();
        gridName.append(this.grid.getWidth()).append("x").append(this.grid.getHeight());
        gridName.append(" ");
        gridName.append(techLevel.getDisplayName().func_230531_f_().func_240699_a_(techLevel.getTextColour()).getString());
        gridName.append(" ");
        gridName.append(I18n.func_135052_a((String)"gui.draconicevolution.modular_item.module_grid", (Object[])new Object[0]));
        this.infoPanel.addDynamicLabel(gridName::toString, 12);
        LinkedHashMap<ITextComponent, ITextComponent> nameStatMap = new LinkedHashMap<ITextComponent, ITextComponent>();
        this.grid.getModuleHost().addInformation(nameStatMap, ((ContainerModularItem)this.container).getModuleContext(), false);
        for (ITextComponent name : nameStatMap.keySet()) {
            this.infoPanel.addLabeledValue(TextFormatting.GOLD + name.getString(), 6, 10, () -> TextFormatting.GRAY + ((ITextComponent)nameStatMap.get(name)).getString(), true);
        }
        this.reloadGui();
    }

    public void func_146982_a(ItemStack stack, int x, int y, String altText) {
        if (this.gridRenderer.renderStackOverride(stack, x, y, altText)) {
            return;
        }
        super.func_146982_a(stack, x, y, altText);
    }

    protected void drawSlotOverlay(Slot slot, boolean occluded) {
        if (slot.func_75216_d() && slot.func_75211_c().getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent()) {
            int y = slot.field_75221_f;
            int x = slot.field_75223_e;
            int light = -268971;
            int dark = -763643;
            IRenderTypeBuffer.Impl getter = this.field_230706_i_.func_228019_au_().func_228487_b_();
            GuiHelperOld.drawShadedRect((IVertexBuilder)getter.getBuffer(GuiHelperOld.TRANS_TYPE), (double)(x - 1), (double)(y - 1), (double)18.0, (double)18.0, (double)1.0, (int)0, (int)dark, (int)light, (int)GuiElement.midColour((int)light, (int)dark), (double)0.0);
            if (slot.func_75211_c() == ((ContainerModularItem)this.container).hostStack) {
                GuiHelperOld.drawBorderedRect((IVertexBuilder)getter.getBuffer(GuiHelperOld.TRANS_TYPE), (double)x, (double)y, (double)16.0, (double)16.0, (double)1.0, (int)0x50FF0000, (int)-65536, (double)0.0);
            }
            getter.func_228461_a_();
        }
    }
}

