/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular.itemconfig;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.ThemedElements;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiManipulable;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.GuiConfigurableItem;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyElement;
import com.brandon3055.draconicevolution.inventory.ContainerConfigurableItem;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.client.settings.KeyModifier;

public class PropertyContainer
extends GuiManipulable {
    private int setXPos = 0;
    private int setYPos = 0;
    private int timeSinceMove = 0;
    private int expandedHeight = 0;
    private int prevUserHeight = 0;
    private final boolean isGroup;
    protected String boundKey = "";
    private String defaultName = "Group";
    private boolean binding = false;
    private boolean removed = false;
    protected boolean isPreset = false;
    private boolean semiTrans = false;
    private boolean collapsed = false;
    protected boolean globalKeyBind = false;
    private GuiButton applyPreset;
    private final GuiElement<?> parent;
    protected KeyModifier modifier = KeyModifier.NONE;
    private GuiTextField groupName;
    private PropertyElement dropTargetElement = null;
    private GuiScrollElement scrollElement;
    private PropertyContainer dropTarget = null;
    private Rectangle cancelZone = null;
    private final GuiConfigurableItem gui;
    public LinkedList<PropertyData> dataList = new LinkedList();
    public LinkedHashMap<PropertyData, PropertyElement> dataElementMap = new LinkedHashMap();
    boolean isCopy = false;
    private float animHeight = 0.0f;
    private float animDistance = 0.0f;

    public PropertyContainer(GuiConfigurableItem gui, boolean isGroup) {
        this.gui = gui;
        this.parent = gui == null ? null : gui.advancedContainer;
        this.isGroup = isGroup;
        this.setSize(150, this.getMinSize().height);
        if (isGroup) {
            this.setResizeBorders(3);
        } else {
            this.setHResizeBorders(1);
        }
        this.setCanResizeV(() -> !this.collapsed);
        this.setEnableCursors(true);
        this.setCapturesClicks(true);
    }

    public void setCancelZone(Rectangle cancelZone) {
        this.cancelZone = cancelZone;
    }

    public void addChildElements() {
        this.scrollElement = GuiConfigurableItem.createPropertyList();
        if (this.isGroup) {
            this.scrollElement.setPos(this.xPos() + 3, this.yPos() + 3 + 9);
            this.scrollElement.onReload(e -> {
                GuiScrollElement cfr_ignored_0 = (GuiScrollElement)e.setMaxPos(this.maxXPos() - 3, this.maxYPos() - 3, true);
            });
            this.scrollElement.setEnabledCallback(() -> this.scrollElement.ySize() > 10 && !this.applyPreset.isEnabled());
            GuiButton toggleHidden = this.gui.toolkit.createIconButton((GuiElement)this, 8, () -> BCSprites.getThemed((String)(this.collapsed ? "expand_content" : "collapse_content")));
            toggleHidden.setPos(this.xPos() + 2, this.yPos() + 2);
            toggleHidden.onPressed(this::toggleCollapsed);
            toggleHidden.setHoverText(e -> {
                if (this.isPreset) {
                    return I18n.func_135052_a((String)"gui.draconicevolution.item_config.edit_preset.info", (Object[])new Object[0]);
                }
                return I18n.func_135052_a((String)("gui.draconicevolution.item_config." + (this.collapsed ? "expand_group" : "collapse_group") + ".info"), (Object[])new Object[0]);
            });
            GuiElement dragZone = this.gui.toolkit.createHighlightIcon((GuiElement)this, 8, 8, 2, 2, () -> Screen.func_231173_s_() ? BCSprites.getThemed((String)"copy") : (Screen.func_231172_r_() ? BCSprites.get((String)"delete") : BCSprites.getThemed((String)"reposition")), e -> e.getHoverTime() > 0 || this.dragPos);
            dragZone.setHoverText(e -> this.dragPos ? Collections.emptyList() : I18n.func_135052_a((String)(Screen.func_231173_s_() ? "gui.draconicevolution.item_config.copy_group.info" : (Screen.func_231172_r_() ? "gui.draconicevolution.item_config.delete_group.info" : "gui.draconicevolution.item_config.move_group.info")), (Object[])new Object[0]));
            dragZone.setHoverTextDelay(10);
            dragZone.onReload(e -> e.setMaxXPos(this.maxXPos() - 2, false).setYPos(this.yPos() + 2));
            this.setDragZone((arg_0, arg_1) -> ((GuiElement)dragZone).isMouseOver(arg_0, arg_1));
            GuiButton togglePreset = this.gui.toolkit.createIconButton((GuiElement)this, 8, BCSprites.themedGetter((String)"preset_icon"));
            GuiBorderedRect hoverRect = GuiToolkit.addHoverHighlight((GuiElement)togglePreset, (int)2, (int)2);
            togglePreset.setHoverText(I18n.func_135052_a((String)"gui.draconicevolution.item_config.toggle_preset.info", (Object[])new Object[0]));
            togglePreset.onReload(e -> {
                GuiButton cfr_ignored_0 = (GuiButton)((GuiButton)e.setMaxXPos(dragZone.xPos() - 2, false)).setYPos(this.yPos() + 2);
            });
            togglePreset.onPressed(this::togglePreset);
            togglePreset.addChild(((ThemedElements.ShadedRect)new ThemedElements.ShadedRect(true, false).setPosAndSize((GuiElement)hoverRect)).setEnabledCallback(() -> this.isPreset));
            GuiButton globalBinding = this.gui.toolkit.createIconButton((GuiElement)this, 8, BCSprites.themedGetter((String)"global_key_icon"));
            hoverRect = GuiToolkit.addHoverHighlight((GuiElement)globalBinding, (int)2, (int)2);
            globalBinding.setHoverText(I18n.func_135052_a((String)"gui.draconicevolution.item_config.toggle_global_binding.info", (Object[])new Object[0]));
            globalBinding.onReload(e -> {
                GuiButton cfr_ignored_0 = (GuiButton)((GuiButton)e.setMaxXPos(togglePreset.xPos() - 2, false)).setYPos(this.yPos() + 2);
            });
            globalBinding.onPressed(() -> {
                this.globalKeyBind = !this.globalKeyBind;
                this.gui.savePropertyConfig();
            });
            globalBinding.addChild(((ThemedElements.ShadedRect)new ThemedElements.ShadedRect(true, false).setPosAndSize((GuiElement)hoverRect)).setEnabledCallback(() -> this.globalKeyBind));
            globalBinding.setEnabledCallback(() -> !this.boundKey.isEmpty() && this.isPreset);
            this.groupName = new GuiTextField();
            this.groupName.setPos(this.xPos() + 12, this.yPos() + 2);
            this.groupName.onReload(e -> {
                GuiTextField cfr_ignored_0 = (GuiTextField)e.setMaxPos(globalBinding.isEnabled() ? globalBinding.xPos() - 2 : togglePreset.xPos() - 2, e.yPos() + 8, true);
            });
            this.groupName.setText(this.defaultName);
            this.groupName.setChangeListener(this.gui::savePropertyConfig);
            this.groupName.setEnableBackgroundDrawing(false);
            this.groupName.setBlinkingCursor(true);
            this.groupName.setTextColor(GuiToolkit.Palette.BG::text);
            this.groupName.setShadowSupplier(() -> BCConfig.darkMode);
            this.groupName.setCursorColor(-1);
            this.groupName.onFinishEdit(this.gui::savePropertyConfig);
            this.addChild((GuiElement)this.groupName);
            GuiButton bindButton = this.gui.toolkit.createBorderlessButton((GuiElement)this, "");
            bindButton.setHoverText(I18n.func_135052_a((String)"gui.draconicevolution.item_config.set_key_bind.info", (Object[])new Object[0]));
            bindButton.setHoverTextDelay(10);
            ((GuiButton)bindButton.setYSize(12)).setYPos(this.yPos() + 11);
            bindButton.onReload(e -> {
                GuiButton cfr_ignored_0 = (GuiButton)((GuiButton)e.setText(this.getBindingName()).setXSize(Math.min((this.xSize() - 3) / 2, this.fontRenderer.func_78256_a(bindButton.getDisplayString()) + 6))).setMaxXPos(this.maxXPos() - 2, false);
            });
            bindButton.onPressed(() -> {
                this.boundKey = "";
                this.modifier = KeyModifier.NONE;
                this.binding = !this.binding;
                this.gui.savePropertyConfig();
                this.reloadElement();
            });
            this.addChild((GuiElement)bindButton);
            this.applyPreset = this.gui.toolkit.createBorderlessButton((GuiElement)this, "gui.draconicevolution.item_config.apply_preset");
            this.applyPreset.setEnabledCallback(() -> this.isPreset && this.collapsed && this.ySize() == this.getTargetHeight());
            ((GuiButton)this.applyPreset.setPos(this.xPos() + 2, this.yPos() + 11)).setYSize(12);
            this.applyPreset.onReload(e -> {
                GuiButton cfr_ignored_0 = (GuiButton)e.setMaxXPos(bindButton.xPos(), true);
            });
            this.applyPreset.setTextColGetter((hovering, disabled) -> GuiToolkit.Palette.Ctrl.textH((boolean)hovering));
            this.applyPreset.onPressed(() -> this.dataElementMap.keySet().forEach(data -> {
                this.applyData((PropertyData)data);
                this.gui.updateAnimations.add(new GuiConfigurableItem.UpdateAnim((PropertyData)data));
            }));
            GuiToolkit.addHoverHighlight((GuiElement)this.applyPreset);
            bindButton.setEnabledCallback(() -> this.applyPreset.isEnabled());
            this.addChild((GuiElement)this.applyPreset);
        } else {
            this.scrollElement.setPos(this.xPos() + 1, this.yPos() + 1);
            this.scrollElement.onReload(e -> {
                GuiScrollElement cfr_ignored_0 = (GuiScrollElement)e.setMaxPos(this.maxXPos() - 1, this.maxYPos() - 1, true);
            });
        }
        this.addChild((GuiElement)this.scrollElement);
    }

    protected boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.binding) {
            this.modifier = KeyModifier.NONE;
            if (keyCode == 256) {
                this.boundKey = "";
                this.binding = false;
                this.reloadElement();
                this.gui.savePropertyConfig();
                return true;
            }
            KeyModifier activeMod = KeyModifier.getActiveModifier();
            InputMappings.Input input = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
            this.boundKey = input.toString();
            if (activeMod.matches(input)) {
                this.reloadElement();
                this.gui.savePropertyConfig();
                return true;
            }
            this.modifier = activeMod;
            this.binding = false;
            this.gui.savePropertyConfig();
            this.reloadElement();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private String getBindingName() {
        if (this.binding) {
            return ">" + (this.boundKey.isEmpty() ? "   " : I18n.func_135052_a((String)InputMappings.func_197955_a((String)this.boundKey).func_197935_d(), (Object[])new Object[0])) + "<";
        }
        if (this.boundKey.isEmpty()) {
            return I18n.func_135052_a((String)"gui.draconicevolution.item_config.not_bound", (Object[])new Object[0]);
        }
        InputMappings.Input keyCode = InputMappings.func_197955_a((String)this.boundKey);
        return this.modifier.getCombinedName(keyCode, () -> ((InputMappings.Input)keyCode).func_237520_d_()).getString();
    }

    protected boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.binding) {
            this.binding = false;
            this.reloadElement();
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public void reloadElement() {
        if (this.dataList.size() != this.dataElementMap.size()) {
            this.scrollElement.clearElements();
            this.dataList.forEach(e -> this.scrollElement.addElement((GuiElement)this.dataElementMap.computeIfAbsent((PropertyData)e, this::createElementFor)));
            this.scrollElement.reloadElement();
        }
        super.reloadElement();
        this.setPos(this.setXPos, this.setYPos);
        this.validatePosition();
    }

    private void togglePreset() {
        this.collapsed = this.isPreset = !this.isPreset;
        this.gui.savePropertyConfig();
    }

    private void toggleCollapsed() {
        boolean bl = this.collapsed = !this.collapsed;
        if (!this.collapsed) {
            this.parent.bringToForeground((GuiElement)this);
            this.gui.propertyContainers.remove((Object)this);
            this.gui.propertyContainers.add(this);
        }
        this.gui.savePropertyConfig();
    }

    public void addProperty(PropertyData data) {
        this.addProperty(data, null, false);
    }

    public void addProperty(PropertyData data, @Nullable PropertyData relativeTo, boolean addBefore) {
        if (relativeTo == null || !this.dataList.contains(relativeTo)) {
            this.dataList.add(data);
        } else if (addBefore) {
            this.dataList.add(this.dataList.indexOf(relativeTo), data);
        } else {
            this.dataList.add(this.dataList.indexOf(relativeTo) + 1, data);
        }
        boolean willResize = this.ySize() == this.getMaxSize().height;
        this.scrollElement.clearElements();
        this.dataList.forEach(e -> this.scrollElement.addElement((GuiElement)this.dataElementMap.computeIfAbsent((PropertyData)e, this::createElementFor)));
        if (willResize) {
            this.setYSize(this.getMaxSize().height);
            this.prevUserHeight = this.expandedHeight = this.getMaxSize().height;
            this.reloadElement();
            this.scrollElement.reloadElement();
        }
    }

    private PropertyElement createElementFor(PropertyData data) {
        GuiButton dragZone;
        PropertyElement element = new PropertyElement(data, this.gui, true);
        element.setOpacitySupplier(() -> this.semiTrans ? 0x60000000 : -16777216);
        element.setEnableToolTip(() -> !this.isDragging);
        data.setChangeListener(() -> {
            if (!this.isPreset) {
                this.applyData(data);
                this.gui.updateAnimations.add(new GuiConfigurableItem.UpdateAnim(data));
            }
        });
        element.dragZone = dragZone = this.gui.toolkit.createIconButton((GuiElement)element, 8, 8, () -> Screen.func_231173_s_() ? BCSprites.get((String)"dark/copy") : (Screen.func_231172_r_() ? BCSprites.get((String)"delete") : BCSprites.get((String)"reposition_gray")));
        dragZone.setHoverText(e -> this.dragPos ? Collections.emptyList() : I18n.func_135052_a((String)(Screen.func_231173_s_() ? "gui.draconicevolution.item_config.copy_group.info" : (Screen.func_231172_r_() ? "gui.draconicevolution.item_config.delete_group.info" : "gui.draconicevolution.item_config.move_group.info")), (Object[])new Object[0]));
        dragZone.onReload(e -> {
            GuiButton cfr_ignored_0 = (GuiButton)((GuiButton)e.setMaxXPos(element.maxXPos() - 1, false)).setYPos(element.yPos() + 1);
        });
        if (!this.isGroup) {
            dragZone.setDisabled(true);
            this.setDragZone((arg_0, arg_1) -> ((GuiButton)dragZone).isMouseOver(arg_0, arg_1));
            this.setEnabledCallback(() -> DEConfig.configUiShowUnavailable || data.isGlobal || data.isPropertyAvailable());
        } else {
            element.setEnabledCallback(() -> DEConfig.configUiShowUnavailable || data.isGlobal || data.isPropertyAvailable());
            dragZone.onPressed(() -> {
                if (!Screen.func_231173_s_()) {
                    boolean willResize = this.ySize() == this.getMaxSize().height;
                    this.dataList.remove(data);
                    this.dataElementMap.remove(data);
                    this.scrollElement.clearElements();
                    this.dataList.forEach(e -> this.scrollElement.addElement((GuiElement)this.dataElementMap.computeIfAbsent((PropertyData)e, this::createElementFor)));
                    if (willResize) {
                        this.setYSize(this.getMaxSize().height);
                        this.prevUserHeight = this.expandedHeight = this.getMaxSize().height;
                    }
                    this.scrollElement.reloadElement();
                }
                if (!Screen.func_231172_r_()) {
                    PropertyContainer newContainer = new PropertyContainer(this.gui, false);
                    newContainer.setXSize(Math.max(element.xSize(), newContainer.getMinSize().width));
                    this.gui.toolkit.placeInside((GuiElement)newContainer, (GuiElement)element, GuiToolkit.LayoutPos.TOP_RIGHT, 0, 0);
                    newContainer.updatePosition();
                    this.parent.addChild((GuiElement)newContainer);
                    newContainer.addProperty(data.copy());
                    newContainer.isCopy = true;
                    newContainer.startDragging();
                }
            });
        }
        return element;
    }

    private void applyData(PropertyData data) {
        data.sendToServer();
    }

    public void inventoryUpdate() {
        this.dataElementMap.keySet().forEach(e -> e.pullData((ContainerConfigurableItem)this.gui.func_212873_a_(), !this.isPreset && !e.isGlobal));
    }

    protected boolean onStartMove(double mouseX, double mouseY) {
        if (this.dragZone.validate(mouseX, mouseY) && !this.isCopy) {
            if (Screen.func_231173_s_()) {
                PropertyContainer newGroup = new PropertyContainer(this.gui, this.isGroup);
                newGroup.isCopy = true;
                this.gui.propertyContainers.add(newGroup);
                this.gui.advancedContainer.addChild((GuiElement)newGroup);
                this.dataList.forEach(e -> newGroup.addProperty(e.copy()));
                newGroup.expandedHeight = this.expandedHeight;
                newGroup.prevUserHeight = this.prevUserHeight;
                newGroup.isPreset = this.isPreset;
                newGroup.collapsed = this.collapsed;
                newGroup.globalKeyBind = this.globalKeyBind;
                if (this.isGroup) {
                    newGroup.groupName.setText(this.groupName.getText());
                }
                newGroup.setSize((GuiElement)this);
                ((GuiManipulable)newGroup.setMaxXPos((int)mouseX + 5, false)).setYPos((int)mouseY - 5);
                newGroup.updatePosition();
                newGroup.startDragging();
                return true;
            }
            if (Screen.func_231172_r_()) {
                this.removed = true;
                this.parent.removeChild((GuiElement)this);
                this.gui.propertyContainers.remove((Object)this);
                return true;
            }
        }
        this.isCopy = false;
        return false;
    }

    protected boolean onStartManipulation(double mouseX, double mouseY) {
        this.parent.removeChild((GuiElement)this);
        this.parent.modularGui.getManager().addChild((GuiElement)this, 300, false);
        this.modifyZOffset(300.0);
        this.gui.propertyContainers.remove((Object)this);
        this.gui.propertyContainers.add(this);
        if (this.dragPos) {
            this.semiTrans = true;
        }
        return false;
    }

    protected void onManipulated(double mouseX, double mouseY) {
        this.getChildElements().forEach(GuiElement::reloadElement);
        if (!this.collapsed) {
            this.expandedHeight = this.ySize();
        }
        if (this.dropTarget != null) {
            if (!this.dropTarget.isMouseOver(mouseX, mouseY)) {
                this.dropTarget = null;
                this.dropTargetElement = null;
            } else {
                this.dropTargetElement = this.dropTarget.dataElementMap.values().stream().filter(e -> e.isMouseOver(mouseX, mouseY)).findAny().orElse(null);
            }
        } else {
            for (PropertyContainer element : this.gui.propertyContainers) {
                if (element == this) continue;
                Rectangle other = element.getRect();
                if (this.isGroup || !GuiHelperOld.isInRect((int)(other.x + 8), (int)(other.y + 8), (int)(other.width - 16), (int)(other.height - 16), (double)mouseX, (double)mouseY)) continue;
                this.dropTarget = element;
                this.dropTargetElement = element.dataElementMap.values().stream().filter(e -> e.isMouseOver(mouseX, mouseY)).findAny().orElse(null);
            }
        }
        this.timeSinceMove = 0;
    }

    protected void onFinishManipulation(double mouseX, double mouseY) {
        if (this.removed) {
            return;
        }
        this.updatePosition();
        this.parent.modularGui.getManager().removeChild((GuiElement)this);
        this.parent.addChild((GuiElement)this);
        this.displayZLevel = 0;
        this.modifyZOffset(-300.0);
        this.semiTrans = false;
        if (!this.collapsed) {
            this.prevUserHeight = this.ySize();
        }
        if (this.dropTarget != null && !this.dataList.isEmpty()) {
            if (this.dropTarget.isGroup) {
                this.parent.removeChild((GuiElement)this);
                this.gui.propertyContainers.remove((Object)this);
                boolean before = this.dropTargetElement != null && mouseY < (double)this.dropTargetElement.yPos() + (double)this.dropTargetElement.ySize() / 2.0;
                this.dropTarget.addProperty(this.dataList.get(0), this.dropTargetElement == null ? null : this.dropTargetElement.data, before);
            } else if (this.dropTargetElement != null) {
                this.parent.removeChild((GuiElement)this.dropTarget);
                this.parent.removeChild((GuiElement)this);
                this.gui.propertyContainers.remove((Object)this.dropTarget);
                this.gui.propertyContainers.remove((Object)this);
                PropertyContainer newGroup = new PropertyContainer(this.gui, true);
                ((GuiManipulable)newGroup.setRelPos(this.dropTargetElement, -2, -12)).setXSize(this.dropTargetElement.xSize());
                newGroup.updatePosition();
                this.gui.propertyContainers.add(newGroup);
                this.parent.addChild((GuiElement)newGroup);
                newGroup.addProperty(this.dropTargetElement.data);
                newGroup.addProperty(this.dataList.get(0), this.dropTargetElement.data, mouseY < (double)this.dropTargetElement.yPos() + (double)this.dropTargetElement.ySize() / 2.0);
            } else {
                this.dropTarget = null;
            }
        }
        this.gui.savePropertyConfig();
    }

    protected void onFinishMove(double mouseX, double mouseY) {
        if (this.gui.deleteZone.isMouseOver(mouseX, mouseY) || this.cancelZone != null && this.cancelZone.contains(mouseX, mouseY)) {
            this.removed = true;
            this.parent.modularGui.getManager().removeChild((GuiElement)this);
            this.gui.propertyContainers.remove((Object)this);
        }
        this.cancelZone = null;
    }

    public Dimension getMinSize() {
        return new Dimension(80, 22 + (this.isGroup ? 15 : 2));
    }

    public Dimension getMaxSize() {
        int count = DEConfig.configUiShowUnavailable ? this.dataElementMap.size() : (int)this.dataElementMap.keySet().stream().filter(PropertyData::isPropertyAvailable).count();
        int maxY = MathHelper.clip((int)(count * 22 + (this.isGroup ? 15 : 2)), (int)24, (int)300);
        return new Dimension(250, maxY);
    }

    protected void validateMove(Rectangle previous, double mouseX, double mouseY) {
        if (!DEConfig.configUiEnableSnapping) {
            return;
        }
        Rectangle newPos = this.getRect();
        Rectangle originalPos = new Rectangle(newPos);
        for (PropertyContainer element : this.gui.propertyContainers) {
            Rectangle other;
            if (element == this || !newPos.intersects(other = element.getRect()) || previous.intersects(other)) continue;
            if (!this.isGroup && GuiHelperOld.isInRect((int)(other.x + 8), (int)(other.y + 8), (int)(other.width - 16), (int)(other.height - 16), (double)mouseX, (double)mouseY)) {
                this.setPos(originalPos.x, originalPos.y);
                return;
            }
            Rectangle2D intersection = newPos.createIntersection(other);
            if (intersection.getWidth() / (double)newPos.width < intersection.getHeight() / (double)newPos.height) {
                this.translate((int)(intersection.getWidth() * (double)(previous.x < other.x ? -1 : 1)), 0);
            } else {
                this.translate(0, (int)(intersection.getHeight() * (double)(previous.y < other.y ? -1 : 1)));
            }
            newPos = this.getRect();
        }
    }

    private int getTargetHeight() {
        if (!this.isDragging && this.prevUserHeight != this.expandedHeight && this.prevUserHeight <= this.getMaxSize().height) {
            this.expandedHeight = this.prevUserHeight;
        }
        if (this.expandedHeight == 0) {
            this.expandedHeight = this.ySize();
        } else if (this.expandedHeight > this.getMaxSize().height) {
            this.expandedHeight = this.getMaxSize().height;
        }
        return this.collapsed ? (this.isPreset ? 25 : 12) : this.expandedHeight;
    }

    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.dropTarget != null && this.timeSinceMove > 10) {
            if (!this.dropTarget.isGroup) {
                this.drawHoveringTextString(Collections.singletonList(I18n.func_135052_a((String)"gui.draconicevolution.item_config.drop_create_group.info", (Object[])new Object[0])), mouseX, mouseY, (FontRenderer)this.fontRenderer);
            } else {
                this.drawHoveringTextString(Collections.singletonList(I18n.func_135052_a((String)"gui.draconicevolution.item_config.add_to_group.info", (Object[])new Object[0])), mouseX, mouseY, (FontRenderer)this.fontRenderer);
            }
            return true;
        }
        if (this.dragPos && this.gui.deleteZone.isMouseOver((double)mouseX, (double)mouseY)) {
            this.drawHoveringTextString(Collections.singletonList(I18n.func_135052_a((String)"gui.draconicevolution.item_config.drop_to_delete.info", (Object[])new Object[0])), mouseX, mouseY, (FontRenderer)this.fontRenderer);
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        int targetHeight = this.getTargetHeight();
        if (targetHeight != this.ySize()) {
            if (this.animDistance == 0.0f) {
                this.animDistance = targetHeight - this.ySize();
                this.animHeight = this.ySize();
                if (Math.abs(this.animDistance) <= 3.0f) {
                    this.animHeight = targetHeight;
                    this.setYSize((int)this.animHeight);
                    this.animDistance = 0.0f;
                }
            }
            this.animHeight = MathHelper.approachLinear((float)this.animHeight, (float)targetHeight, (float)(Math.abs(this.animDistance) * 0.15f * partialTicks));
            if (this.animDistance > 0.0f && this.animHeight > (float)targetHeight) {
                this.animHeight = targetHeight;
            } else if (this.animDistance < 0.0f && this.animHeight < (float)targetHeight) {
                this.animHeight = targetHeight;
            }
            this.setYSize((int)this.animHeight);
            this.reloadElement();
            if (this.animHeight == (float)targetHeight) {
                this.scrollElement.reloadElement();
            }
        } else {
            this.animHeight = targetHeight;
            this.animDistance = 0.0f;
        }
        IRenderTypeBuffer.Impl getter = minecraft.func_228019_au_().func_228487_b_();
        if (this.dropTarget != null) {
            double zLevel = this.getRenderZLevel() - 10.0f;
            this.zOffset -= zLevel;
            if (this.dropTargetElement != null) {
                Rectangle rect = this.dropTargetElement.getRect();
                if ((double)mouseY < (double)rect.y + (double)rect.height / 2.0) {
                    this.drawGradientRect((IRenderTypeBuffer)getter, rect.x, rect.y, rect.x + rect.width, rect.y + 6, -16711936, 65280);
                } else {
                    this.drawGradientRect((IRenderTypeBuffer)getter, rect.x, rect.y + rect.height - 6, rect.x + rect.width, rect.y + rect.height, 65280, -16711936);
                }
            } else {
                this.drawGradientRect((IRenderTypeBuffer)getter, this.dropTarget.xPos() + 3, this.dropTarget.yPos() + 13, this.dropTarget.maxXPos() - 3, this.dropTarget.yPos() + 15, -16711936, 65280);
                this.drawGradientRect((IRenderTypeBuffer)getter, this.dropTarget.xPos() + 3, this.dropTarget.maxYPos() - 6, this.dropTarget.maxXPos() - 3, this.dropTarget.maxYPos() - 3, 65280, -16711936);
            }
            this.zOffset += zLevel;
        }
        int alpha = this.semiTrans ? 0x60000000 : -16777216;
        RenderMaterial mat = BCSprites.getThemed((String)"borderless_bg_dynamic_small");
        this.drawDynamicSprite(mat.func_229311_a_((IRenderTypeBuffer)getter, e -> BCSprites.GUI_TYPE), mat.func_229314_c_(), this.xPos(), this.yPos(), this.xSize(), this.ySize(), 2, 2, 2, 2, 0xFFFFFF | alpha);
        int contentPos = this.yPos() + 2 + 9;
        int contentHeight = this.ySize() - 4 - 9;
        if (this.isGroup && contentHeight > 0 && !this.applyPreset.isEnabled()) {
            int light = (BCConfig.darkMode ? 0x5B5B5B : 0xFFFFFF) | alpha;
            int dark = (BCConfig.darkMode ? 0x282828 : 0x505050) | alpha;
            this.drawShadedRect((IRenderTypeBuffer)getter, this.xPos() + 2, contentPos, this.xSize() - 4, contentHeight, 1.0, 0, dark, light, PropertyContainer.midColour((int)light, (int)dark));
            if (this.dataList.isEmpty()) {
                this.drawCustomString((FontRenderer)this.fontRenderer, I18n.func_135052_a((String)"gui.draconicevolution.item_config.drop_prop_here", (Object[])new Object[0]), this.xPos() + 3, this.yPos() + 13, this.xSize() - 6, GuiToolkit.Palette.BG.text(), GuiAlign.CENTER, GuiAlign.TextRotation.NORMAL, false, true, BCConfig.darkMode);
            }
        }
        getter.func_228461_a_();
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        if (this.dragPos && this.gui.deleteZone.isMouseOver((double)mouseX, (double)mouseY)) {
            this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos() + 1, this.yPos() + 1, this.xSize() - 2, this.ySize() - 3, -2130739072);
            getter.func_228461_a_();
        }
    }

    public boolean onUpdate() {
        ++this.timeSinceMove;
        return super.onUpdate();
    }

    public void updatePosition() {
        this.setXPos = this.xPos();
        this.setYPos = this.yPos();
    }

    public CompoundNBT serialize() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("group", this.isGroup);
        if (this.isGroup) {
            nbt.func_74757_a("preset", this.isPreset);
            nbt.func_74757_a("collapsed", this.collapsed);
            nbt.func_74778_a("name", this.groupName.getText());
            nbt.func_74768_a("user_height", this.prevUserHeight);
            nbt.func_74757_a("global_key", this.globalKeyBind);
            if (!this.boundKey.isEmpty()) {
                nbt.func_74778_a("binding", this.boundKey);
                nbt.func_74768_a("modifier", this.modifier.ordinal());
            }
        }
        nbt.func_74768_a("x_pos", this.setXPos);
        nbt.func_74768_a("y_pos", this.setYPos);
        nbt.func_74768_a("x_size", this.xSize());
        nbt.func_74768_a("y_size", this.expandedHeight);
        nbt.func_218657_a("data", (INBT)this.dataList.stream().map(PropertyData::serialize).collect(Collectors.toCollection(ListNBT::new)));
        return nbt;
    }

    public static PropertyContainer deserialize(GuiConfigurableItem gui, CompoundNBT nbt) {
        boolean isGroup = nbt.func_74767_n("group");
        PropertyContainer container = new PropertyContainer(gui, isGroup);
        if (isGroup) {
            container.isPreset = nbt.func_74767_n("preset");
            container.collapsed = nbt.func_74767_n("collapsed");
            container.defaultName = nbt.func_74779_i("name");
            container.prevUserHeight = nbt.func_74762_e("user_height");
            container.boundKey = nbt.func_74779_i("binding");
            container.modifier = KeyModifier.values()[nbt.func_74762_e("modifier")];
            container.globalKeyBind = nbt.func_74767_n("global_key");
        }
        container.setXPos = nbt.func_74762_e("x_pos");
        container.setYPos = nbt.func_74762_e("y_pos");
        container.setXSize(nbt.func_74762_e("x_size"));
        container.expandedHeight = nbt.func_74762_e("y_size");
        container.setYSize(container.expandedHeight);
        container.dataList.addAll(nbt.func_150295_c("data", 10).stream().map(e -> (CompoundNBT)e).map(PropertyData::deserialize).filter(Objects::nonNull).collect(Collectors.toList()));
        return container;
    }
}

