/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modular.itemconfig;

import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.GuiToolkit;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.ThemedElements;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiSelectDialog;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.GuiConfigurableItem;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyContainer;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class PropertyElement
extends GuiElement<PropertyElement> {
    protected PropertyData data;
    private boolean advanced;
    private GuiConfigurableItem gui;
    private GuiLabel label;
    private GuiLabel valueLabel;
    private GuiButton decrement;
    private GuiButton increment;
    private GuiButton valueButton;
    private GuiButton globalButton;
    private GuiSlideControl slider;
    private Supplier<Boolean> enableToolTip = () -> true;
    private Supplier<Integer> opacitySupplier = () -> -16777216;
    private int index = 0;
    protected GuiElement<?> dragZone;

    public PropertyElement(PropertyData data, GuiConfigurableItem gui, boolean advanced) {
        this.data = data;
        this.gui = gui;
        this.advanced = advanced;
        this.setHoverTextDelay(10);
        this.setYSize(22);
    }

    public void setEnableToolTip(Supplier<Boolean> enableToolTip) {
        this.enableToolTip = enableToolTip;
    }

    public void setOpacitySupplier(Supplier<Integer> opacitySupplier) {
        this.opacitySupplier = opacitySupplier;
    }

    public void addChildElements() {
        this.label = (GuiLabel)this.addChild((GuiElement)new GuiLabel(this.data.displayName));
        this.label.setTextColour(TextFormatting.GOLD);
        this.label.setShadow(false);
        ((GuiLabel)this.label.setYSize(10)).setPos(this.xPos() + 10, this.yPos());
        this.label.onReload(e -> {
            GuiLabel cfr_ignored_0 = (GuiLabel)e.setMaxXPos(this.maxXPos() - 10, true);
        });
        this.label.setHoverTextDelay(10);
        this.label.setHoverText(e -> this.enableToolTip.get() != false ? this.data.toolTip : Collections.emptyList());
        this.valueButton = (GuiButton)this.addChild((GuiElement)new GuiButton());
        ((GuiButton)((GuiButton)this.valueButton.setYSize(10)).setYPos(10)).setXSizeMod(() -> ((PropertyElement)this).xSize());
        this.valueButton.setInsets(0, 4, 0, 0);
        this.valueButton.setTextColour(TextFormatting.DARK_AQUA, TextFormatting.AQUA);
        this.valueButton.setEnabled(this.data.type == ConfigProperty.Type.BOOLEAN || this.data.type == ConfigProperty.Type.ENUM);
        this.valueButton.onPressed(this::valueClicked);
        this.valueButton.setClickEnabled(false);
        this.decrement = this.gui.toolkit.createIconButton((GuiElement)this, 10, 12, "dark/arrow_left");
        this.increment = this.gui.toolkit.createIconButton((GuiElement)this, 10, 12, "dark/arrow_right");
        this.decrement.onReload(() -> {
            GuiButton cfr_ignored_0 = (GuiButton)this.decrement.setPos(this.xPos() + 1, this.yPos() + 10);
        });
        this.increment.onReload(() -> {
            GuiButton cfr_ignored_0 = (GuiButton)((GuiButton)this.increment.setMaxXPos(this.maxXPos() - 1, false)).setYPos(this.yPos() + 10);
        });
        this.decrement.setEnabled(this.data.type != ConfigProperty.Type.BOOLEAN);
        this.increment.setEnabled(this.data.type != ConfigProperty.Type.BOOLEAN);
        this.increment.onPressed(() -> this.data.increment(1));
        this.decrement.onPressed(() -> this.data.increment(-1));
        this.slider = (GuiSlideControl)this.addChild((GuiElement)new GuiSlideControl());
        this.slider.setBackgroundElement((GuiElement)new SliderBackground());
        this.slider.onReload(() -> ((GuiSlideControl)((GuiSlideControl)((GuiSlideControl)((GuiSlideControl)this.slider.setYSize(10)).setYPos(this.yPos() + 10)).setXPos(this.decrement.maxXPos())).setMaxXPos(this.increment.xPos(), true)).setSliderSize(4).updateElements());
        this.slider.setInsets(1, 1, 1, 1);
        this.slider.setEnabled(this.data.type == ConfigProperty.Type.DECIMAL || this.data.type == ConfigProperty.Type.INTEGER);
        this.slider.setDefaultSlider(-2039584, -7274497, -2039584, -7274497);
        this.slider.addScrollCheck((e, e1, e2) -> false);
        this.slider.setRange(this.data.minValue, this.data.maxValue);
        this.slider.setInputListener(e -> this.data.updateNumberValue(e.getPosition(), !e.isDragging()));
        this.valueLabel = (GuiLabel)this.addChild((GuiElement)new GuiLabel());
        this.valueLabel.setDisplaySupplier(() -> this.data.displayValue);
        ((GuiLabel)((GuiLabel)this.valueLabel.setYSize(10)).setYPos(10)).setXSizeMod(() -> ((PropertyElement)this).xSize());
        this.valueLabel.setTextColour(TextFormatting.DARK_AQUA, TextFormatting.AQUA);
        this.valueLabel.setMidTrim(true);
        if (this.advanced && this.data.propUniqueName == null) {
            this.globalButton = this.gui.toolkit.createIconButton((GuiElement)this, 8, 8, () -> BCSprites.get((String)(this.data.isGlobal ? "dark/global_icon" : "dark/global_icon_inactive")));
            this.globalButton.setHoverText(I18n.func_135052_a((String)"gui.draconicevolution.item_config.global.info", (Object[])new Object[0]));
            this.globalButton.addChild(((GuiBorderedRect)((GuiBorderedRect)new GuiBorderedRect().setShadeColours(0, -12545984, -4456517).setRelPos((GuiElement)this.globalButton, -1, -1)).setSize(10, 10)).setEnabledCallback(() -> this.data.isGlobal));
            this.globalButton.onReload(e -> {
                GuiButton cfr_ignored_0 = (GuiButton)e.setPos(this.xPos() + 1, this.yPos() + 1);
            });
            this.globalButton.onPressed(() -> this.data.toggleGlobal());
        }
        this.detectValueChanges();
    }

    public void reloadElement() {
        super.reloadElement();
        GuiElement parent = this.getParent();
        if (parent != null) {
            if (parent.getParent() instanceof PropertyContainer && ((PropertyContainer)parent.getParent()).dataList.contains(this.data)) {
                this.index = ((PropertyContainer)parent.getParent()).dataList.indexOf(this.data);
            } else if (parent.getChildElements().contains((Object)this)) {
                this.index = parent.getChildElements().indexOf((Object)this);
            }
        }
    }

    private void valueClicked() {
        if (this.data.type == ConfigProperty.Type.BOOLEAN) {
            this.data.toggleBooleanValue();
            GuiButton.playGenericClick();
        } else if (this.data.type == ConfigProperty.Type.ENUM && this.data.enumValueOptions.size() > 1) {
            GuiSelectDialog dialog = new GuiSelectDialog((GuiElement)this);
            dialog.setRendererBuilder(e -> {
                GuiLabel label = ((GuiLabel)new GuiLabel(this.data.getEnumDisplayName((int)e)).setYSize(10)).setTextColour(TextFormatting.DARK_AQUA, TextFormatting.AQUA);
                GuiToolkit.addHoverHighlight((GuiElement)label, (int)16, (int)0);
                return label;
            });
            dialog.addItem((Object)this.data.enumValueIndex);
            dialog.addItems((Collection)this.data.enumValueOptions.stream().filter(e -> e != this.data.enumValueIndex).collect(Collectors.toList()));
            dialog.setInsets(1, 1, 1, 1);
            dialog.setSize(this.increment.xPos() - this.decrement.maxXPos(), Math.min(120, this.data.enumValueOptions.size() * 10 + 3));
            dialog.getScrollElement().setVerticalScrollBar(((GuiSlideControl)((GuiSlideControl)((GuiSlideControl)new GuiSlideControl(GuiSlideControl.SliderRotation.VERTICAL).setPos(dialog.maxXPos() - 7, dialog.yPos() + 1)).setSize(7, dialog.ySize() - 2)).setInsets(0, 0, 0, 0)).setParentScroll(true).setBackgroundElement((GuiElement)new GuiBorderedRect().setFillColours(PropertyElement.mixColours((int)ThemedElements.getBgFill(), (int)-535818224, (boolean)true), PropertyElement.mixColours((int)ThemedElements.getBgFill(), (int)-1341124592, (boolean)true)).setBorderColour(0)).setSliderElement((GuiElement)new ThemedElements.ScrollBar(false)));
            dialog.addBackGroundChild((GuiElement)((GuiBorderedRect)new GuiBorderedRect().setSize((GuiElement)dialog)).setBorderColour(0xFF000000 | TextFormatting.DARK_AQUA.func_211163_e()).setFillColour(-15724528));
            this.gui.toolkit.placeOutside((GuiElement)dialog, (GuiElement)this, GuiToolkit.LayoutPos.BOTTOM_CENTER, 0, -13);
            dialog.setBlockOutsideClicks(true);
            dialog.normalizePosition();
            dialog.setSelectionListener(newIndex -> {
                this.data.updateEnumValue((int)newIndex);
                GuiButton.playGenericClick();
            });
            dialog.setCloseOnSelection(true);
            dialog.show();
        }
    }

    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        IRenderTypeBuffer.Impl getter = minecraft.func_228019_au_().func_228487_b_();
        this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), (this.index % 2 == 0 ? 0x202020 : 0x101010) | this.opacitySupplier.get());
        if (this.advanced && this.gui.hoveredProvider != null && this.gui.hoveredProvider.getProviderName().equals(this.data.providerName)) {
            if (this.data.isGlobal) {
                this.drawBorderedRect((IRenderTypeBuffer)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), 1.0, 0, -2130706688);
            } else if (this.gui.hoveredProvider.getProviderID().equals(this.data.providerID)) {
                this.drawBorderedRect((IRenderTypeBuffer)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), 1.0, 0, -2147418368);
            }
        }
        getter.func_228461_a_();
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        if (!this.data.isPropertyAvailable() && !this.data.isGlobal) {
            this.zOffset += 10.0;
            this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), -2130739072);
            this.zOffset -= 10.0;
            getter.func_228461_a_();
        }
    }

    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.isMouseOver(mouseX, mouseY) && !this.data.isProviderAvailable && !this.data.isGlobal) {
            this.drawHoveringText(Collections.singletonList(I18n.func_135052_a((String)"gui.draconicevolution.item_config.provider_unavailable", (Object[])new Object[0])), mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
            return true;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!(this.data.isProviderAvailable || this.data.isGlobal || this.globalButton != null && this.globalButton.isMouseOver(mouseX, mouseY) || this.dragZone != null && this.dragZone.isMouseOver(mouseX, mouseY))) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void detectValueChanges() {
        if (this.slider.isEnabled()) {
            this.slider.setRange(this.data.minValue, this.data.maxValue);
            if (!this.slider.isDragging()) {
                if (this.data.type == ConfigProperty.Type.DECIMAL && this.slider.getPosition() != this.data.decimalValue) {
                    this.slider.updatePos(this.data.decimalValue);
                } else if (this.data.type == ConfigProperty.Type.INTEGER && this.slider.getPosition() != (double)this.data.integerValue) {
                    this.slider.updatePos((double)this.data.integerValue);
                }
            }
        }
    }

    public boolean onUpdate() {
        this.detectValueChanges();
        if (this.advanced && this.label.isMouseOver(this.getMouseX(), this.getMouseY())) {
            this.gui.hoveredData = this.data;
        }
        return super.onUpdate();
    }

    private class SliderBackground
    extends GuiElement<SliderBackground> {
        private SliderBackground() {
        }

        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            IRenderTypeBuffer.Impl getter = minecraft.func_228019_au_().func_228487_b_();
            if (this.isMouseOver(mouseX, mouseY) || PropertyElement.this.slider.isDragging()) {
                this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos(), this.yPos(), this.xSize(), this.ySize(), 1615289194);
            }
            this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos(), (float)this.yPos() + (float)this.ySize() / 2.0f - 1.0f, this.xSize(), 2.0, -8355712);
            this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos(), this.yPos(), 1.0, this.ySize(), -8355712);
            this.drawColouredRect((IRenderTypeBuffer)getter, this.xPos() + this.xSize() - 1, this.yPos(), 1.0, this.ySize(), -8355712);
            getter.func_228461_a_();
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }
    }
}

