/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.handler;

import codechicken.lib.reflect.ObfMapping;
import codechicken.lib.reflect.ReflectionManager;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.ShaderProgramBuilder;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.ProcessHandlerClient;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.lib.DelayedExecutor;
import com.brandon3055.brandonscore.lib.Pair;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.api.energy.ICrystalBinder;
import com.brandon3055.draconicevolution.handlers.BinderHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.lwjgl.opengl.GL11;

public class ClientEventHandler {
    public static Map<PlayerEntity, Pair<Float, Integer>> playerShieldStatus = new HashMap<PlayerEntity, Pair<Float, Integer>>();
    public static ObfMapping splashTextMapping = new ObfMapping("net/minecraft/client/gui/GuiMainMenu", "field_110353_x");
    public static FloatBuffer winPos = GLAllocation.func_74529_h((int)3);
    public static volatile int elapsedTicks;
    public static boolean playerHoldingWrench;
    public static Minecraft mc;
    private static Random rand;
    public static IBakedModel shieldModel;
    public static BlockPos explosionPos;
    public static double explosionAnimation;
    public static int explosionTime;
    public static boolean explosionRetreating;
    public static ShaderProgram explosionShader;
    public static final Matrix4 MODELVIEW;
    public static final Matrix4 PROJECTION;
    public static final IntBuffer VIEWPORT;

    @SubscribeEvent
    public void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (explosionPos != null && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            mc = Minecraft.func_71410_x();
            this.updateExplosionAnimation(mc, (World)ClientEventHandler.mc.field_71441_e, event.getWindow(), mc.func_184121_ak());
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.type != TickEvent.Type.CLIENT || event.side != LogicalSide.CLIENT) {
            return;
        }
        ++elapsedTicks;
        if (explosionPos != null) {
            this.updateExplosion();
        }
        playerShieldStatus.entrySet().removeIf(entry -> elapsedTicks - (Integer)((Pair)entry.getValue()).value() > 5);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            playerHoldingWrench = !player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ICrystalBinder || !player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ICrystalBinder;
        }
    }

    @SubscribeEvent
    public void renderPlayerEvent(RenderPlayerEvent.Post event) {
        if (!DEOldConfig.disableShieldHitEffect && playerShieldStatus.containsKey(event.getPlayer())) {
            if (shieldModel == null) {
                // empty if block
            }
            RenderSystem.pushMatrix();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.disableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.disableLighting();
            float p = ((Float)playerShieldStatus.get(event.getPlayer()).key()).floatValue();
            ClientPlayerEntity viewingPlayer = Minecraft.func_71410_x().field_71439_g;
            int i = 5 - (elapsedTicks - (Integer)playerShieldStatus.get(event.getPlayer()).value());
            if (viewingPlayer != event.getPlayer()) {
                double translationXLT = event.getPlayer().field_70169_q - viewingPlayer.field_70169_q;
                double translationYLT = event.getPlayer().field_70167_r - viewingPlayer.field_70167_r;
                double translationZLT = event.getPlayer().field_70166_s - viewingPlayer.field_70166_s;
                double translationX = translationXLT + (event.getPlayer().func_226277_ct_() - viewingPlayer.func_226277_ct_() - translationXLT) * (double)event.getPartialRenderTick();
                double translationY = translationYLT + (event.getPlayer().func_226278_cu_() - viewingPlayer.func_226278_cu_() - translationYLT) * (double)event.getPartialRenderTick();
                double translationZ = translationZLT + (event.getPlayer().func_226281_cx_() - viewingPlayer.func_226281_cx_() - translationZLT) * (double)event.getPartialRenderTick();
                RenderSystem.translated((double)translationX, (double)(translationY + 1.1), (double)translationZ);
            } else {
                RenderSystem.translated((double)0.0, (double)1.15, (double)0.0);
            }
            RenderSystem.scaled((double)1.0, (double)1.5, (double)1.0);
            RenderSystem.enableCull();
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
            RenderSystem.enableLighting();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.popMatrix();
        }
    }

    @SubscribeEvent
    public void guiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof MainMenuScreen && rand.nextInt(150) == 0) {
            try {
                String s = rand.nextBoolean() ? "Icosahedrons proudly brought to you by CCL!!!" : Utils.addCommas((long)Long.MAX_VALUE) + " RF!!!!";
                ReflectionManager.setField((ObfMapping)splashTextMapping, (Object)event.getGui(), (Object)s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void renderWorldEvent(RenderWorldLastEvent event) {
        if (event.isCanceled()) {
            return;
        }
        MODELVIEW.set(event.getMatrixStack().func_227866_c_().func_227870_a_());
        PROJECTION.set(event.getProjectionMatrix());
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        World world = player.func_130014_f_();
        ItemStack stack = player.func_184614_ca();
        ItemStack offStack = player.func_184592_cb();
        Minecraft mc = Minecraft.func_71410_x();
        float partialTicks = event.getPartialTicks();
        try {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ICrystalBinder) {
                BinderHandler.renderWorldOverlay(player, event.getMatrixStack(), world, stack, mc, partialTicks);
                return;
            }
            if (!stack.func_190926_b() && offStack.func_77973_b() instanceof ICrystalBinder) {
                BinderHandler.renderWorldOverlay(player, event.getMatrixStack(), world, offStack, mc, partialTicks);
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!(mc.field_71476_x instanceof BlockRayTraceResult)) {
            return;
        }
    }

    public static void triggerExplosionEffect(BlockPos pos) {
        explosionPos = pos;
        explosionRetreating = false;
        explosionAnimation = 0.0;
        explosionTime = 0;
        ProcessHandlerClient.addProcess((IProcess)new DelayedExecutor(5, new Object[0]){

            public void execute(Object[] args) {
                Minecraft.func_71410_x().field_71438_f.func_72712_a();
            }
        });
    }

    private void updateExplosion() {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        ++explosionTime;
        if (!explosionRetreating) {
            if ((explosionAnimation += 0.05) >= 1.0) {
                explosionAnimation = 1.0;
                explosionRetreating = true;
            }
        } else {
            if (explosionAnimation <= 0.0) {
                explosionAnimation = 0.0;
                explosionPos = null;
                return;
            }
            explosionAnimation -= 0.01;
        }
    }

    private void updateExplosionAnimation(Minecraft mc, World world, MainWindow resolution, float partialTick) {
        float screenY;
        GL11.glGetIntegerv((int)2978, (IntBuffer)VIEWPORT);
        Entity entity = mc.func_175606_aa();
        float x = (float)(entity.field_70169_q + (entity.func_226277_ct_() - entity.field_70169_q) * (double)partialTick);
        float y = (float)(entity.field_70167_r + (entity.func_226278_cu_() - entity.field_70167_r) * (double)partialTick);
        float z = (float)(entity.field_70166_s + (entity.func_226281_cx_() - entity.field_70166_s) * (double)partialTick);
        Vector3 targetPos = Vector3.fromBlockPosCenter((BlockPos)explosionPos);
        targetPos.subtract((double)x, (double)y, (double)z);
        Vector3 winPos = ClientEventHandler.gluProject(targetPos, MODELVIEW, PROJECTION, VIEWPORT);
        boolean behind = winPos.z > 1.0;
        float screenX = behind ? -1.0f : (float)winPos.x / (float)resolution.func_198105_m();
        float f = screenY = behind ? -1.0f : (float)winPos.y / (float)resolution.func_198083_n();
        if (!DEConfig.reactorShaders || explosionRetreating) {
            float alpha = explosionAnimation <= 0.0 ? 0.0f : (explosionRetreating ? (float)explosionAnimation - partialTick * 0.003f : (float)explosionAnimation + partialTick * 0.2f);
            GuiHelperOld.drawColouredRect((int)0, (int)0, (int)resolution.func_198107_o(), (int)resolution.func_198087_p(), (int)(0xFFFFFF | (int)(alpha * 255.0f) << 24));
        } else {
            UniformCache uniforms = explosionShader.pushCache();
            uniforms.glUniform2f("screenPos", screenX, screenY);
            uniforms.glUniform1f("intensity", (float)explosionAnimation);
            uniforms.glUniform2f("screenSize", (float)resolution.func_198105_m(), (float)resolution.func_198083_n());
            explosionShader.use();
            explosionShader.popCache(uniforms);
            GuiHelperOld.drawColouredRect((int)0, (int)0, (int)resolution.func_198107_o(), (int)resolution.func_198087_p(), (int)-1);
            explosionShader.release();
        }
    }

    private static Vector3 gluProject(Vector3 obj, Matrix4 modelMatrix, Matrix4 projMatrix, IntBuffer viewport) {
        Vector4f o = new Vector4f((float)obj.x, (float)obj.y, (float)obj.z, 1.0f);
        ClientEventHandler.multMatrix(modelMatrix, o);
        ClientEventHandler.multMatrix(projMatrix, o);
        if (o.func_195915_d() == 0.0f) {
            return Vector3.ZERO.copy();
        }
        o.setW(1.0f / o.func_195915_d() * 0.5f);
        o.setX(o.func_195910_a() * o.func_195915_d() + 0.5f);
        o.setY(o.func_195913_b() * o.func_195915_d() + 0.5f);
        o.setZ(o.func_195914_c() * o.func_195915_d() + 0.5f);
        Vector3 winPos = new Vector3();
        winPos.z = o.func_195914_c();
        winPos.x = o.func_195910_a() * (float)viewport.get(viewport.position() + 2) + (float)viewport.get(viewport.position() + 0);
        winPos.y = o.func_195913_b() * (float)viewport.get(viewport.position() + 3) + (float)viewport.get(viewport.position() + 1);
        return winPos;
    }

    private static void multMatrix(Matrix4 mat, Vector4f vec) {
        double x = mat.m00 * (double)vec.func_195910_a() + mat.m01 * (double)vec.func_195913_b() + mat.m02 * (double)vec.func_195914_c() + mat.m03 * (double)vec.func_195915_d();
        double y = mat.m10 * (double)vec.func_195910_a() + mat.m11 * (double)vec.func_195913_b() + mat.m12 * (double)vec.func_195914_c() + mat.m13 * (double)vec.func_195915_d();
        double z = mat.m20 * (double)vec.func_195910_a() + mat.m21 * (double)vec.func_195913_b() + mat.m22 * (double)vec.func_195914_c() + mat.m23 * (double)vec.func_195915_d();
        double w = mat.m30 * (double)vec.func_195910_a() + mat.m31 * (double)vec.func_195913_b() + mat.m32 * (double)vec.func_195914_c() + mat.m33 * (double)vec.func_195915_d();
        vec.func_195911_a((float)x, (float)y, (float)z, (float)w);
    }

    static {
        playerHoldingWrench = false;
        rand = new Random();
        shieldModel = null;
        explosionPos = null;
        explosionAnimation = 0.0;
        explosionTime = 0;
        explosionRetreating = false;
        explosionShader = ShaderProgramBuilder.builder().addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/explosion_overlay.frag")).uniform("screenPos", UniformType.VEC2).uniform("intensity", UniformType.FLOAT).uniform("screenSize", UniformType.VEC2)).build();
        MODELVIEW = new Matrix4();
        PROJECTION = new Matrix4();
        VIEWPORT = GLAllocation.func_74524_c((int)64).asIntBuffer();
    }
}

