/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.buffer.VBORenderType;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.ShaderProgramBuilder;
import codechicken.lib.render.shader.ShaderRenderType;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;

public class RenderModularChestpeice
extends ToolRenderBase {
    public static ShaderProgram coreShader = ShaderProgramBuilder.builder().addShader("vert", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.VERTEX).source(new ResourceLocation("draconicevolution", "shaders/common.vert"))).addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/crystal_core.frag")).uniform("time", UniformType.FLOAT).uniform("baseColour", UniformType.VEC3).uniform("tier", UniformType.INT)).whenUsed(cache -> cache.glUniform1f("time", ((float)BCClientEventHandler.elapsedTicks + Minecraft.func_71410_x().func_184121_ak()) / 20.0f)).build();
    private CCModel centralGemModel;
    private VBORenderType centralGemVBOType;

    public RenderModularChestpeice(TechLevel techLevel) {
        super(techLevel, "chestpeice");
        Map model = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/item/equipment/chestpeice.obj"), (int)4, null);
        this.baseModel = CCModel.combine(Collections.singletonList(model.get("base_model"))).backfacedCopy();
        this.materialModel = ((CCModel)model.get("chevrons")).backfacedCopy();
        this.gemModel = ((CCModel)model.get("power_crystals")).backfacedCopy();
        this.centralGemModel = ((CCModel)model.get("crystal_core")).backfacedCopy();
        this.initBaseVBO();
        this.initMaterialVBO();
        this.initGemVBO();
        this.centralGemVBOType = new VBORenderType(this.shaderParentType, DefaultVertexFormats.field_181712_l, (format, builder) -> {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((IVertexBuilder)builder, format);
            this.centralGemModel.render(ccrs, new IVertexOperation[0]);
        });
    }

    @Override
    public void renderTool(CCRenderState ccrs, ItemStack stack, ItemCameraTransforms.TransformType transform, Matrix4 mat, MatrixStack mStack, IRenderTypeBuffer getter, boolean gui, int packedLight) {
        mat.translate(0.5, 1.05, 0.5);
        mat.rotate(3.1415926535897403, Vector3.Z_POS);
        mat.scale(1.95);
        if (gui) {
            getter.getBuffer((RenderType)this.guiBaseVBOType.withMatrix(mat).withLightMap(packedLight));
        } else {
            getter.getBuffer((RenderType)this.baseVBOType.withMatrix(mat).withLightMap(packedLight));
        }
        if (this.techLevel == TechLevel.CHAOTIC && DEConfig.toolShaders) {
            getter.getBuffer((RenderType)this.materialChaosVBOType.withMatrix(mat).withLightMap(packedLight).withState((RenderState)RenderModularChestpeice.getShaderType(this.chaosType, chaosShader)));
        } else if (gui) {
            getter.getBuffer((RenderType)this.guiMaterialVBOType.withMatrix(mat).withLightMap(packedLight));
        } else {
            getter.getBuffer((RenderType)this.materialVBOType.withMatrix(mat).withLightMap(packedLight));
        }
        if (DEConfig.toolShaders) {
            ModuleHost host;
            ShieldControlEntity shieldControl;
            int shieldColour = -1;
            LazyOptional optionalHost = stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
            if (!stack.func_190926_b() && optionalHost.isPresent() && (shieldControl = (ShieldControlEntity)(host = (ModuleHost)optionalHost.orElseThrow(IllegalStateException::new)).getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null)) != null) {
                shieldColour = shieldControl.getShieldColour();
            }
            getter.getBuffer((RenderType)this.gemVBOType.withMatrix(mat).withLightMap(packedLight).withState((RenderState)RenderModularChestpeice.getShaderType(this.shaderParentType, this.techLevel, gemShader)));
            getter.getBuffer((RenderType)this.centralGemVBOType.withMatrix(mat).withLightMap(packedLight).withState((RenderState)RenderModularChestpeice.getShaderType(this.shaderParentType, this.techLevel, shieldColour, coreShader)));
        } else {
            getter.getBuffer((RenderType)this.gemVBOType.withMatrix(mat).withLightMap(packedLight));
            getter.getBuffer((RenderType)this.centralGemVBOType.withMatrix(mat).withLightMap(packedLight));
        }
    }

    @Override
    public IModelTransform getModelTransform() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public static ShaderRenderType getShaderType(RenderType parent, TechLevel techLevel, int colour, ShaderProgram shader) {
        UniformCache uniforms = shader.pushCache();
        uniforms.glUniform1i("tier", techLevel.index);
        uniforms.glUniform3f("baseColour", (float)(colour >> 16 & 0xFF) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f);
        return new ShaderRenderType(parent, shader, uniforms);
    }
}

