/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.colour.Colour;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.ShaderProgramBuilder;
import codechicken.lib.render.shader.ShaderRenderType;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalDirectIO;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class RenderTileEnergyCrystal
extends TileEntityRenderer<TileCrystalBase> {
    public static ShaderProgram crystalShader = ShaderProgramBuilder.builder().addShader("vert", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.VERTEX).source(new ResourceLocation("draconicevolution", "shaders/energy_crystal.vert"))).addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/energy_crystal.frag")).uniform("time", UniformType.FLOAT).uniform("mipmap", UniformType.FLOAT).uniform("type", UniformType.INT).uniform("angle", UniformType.VEC2)).whenUsed(cache -> cache.glUniform1f("time", ((float)ClientEventHandler.elapsedTicks + Minecraft.func_71410_x().func_184121_ak()) / 50.0f)).build();
    private static final RenderType fallBackType = RenderType.func_228632_a_((String)"fall_back_type", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/models/crystal_no_shader.png"), false, false)).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    private static final RenderType fallBackOverlayType = RenderType.func_228644_e_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/models/crystal_base.png"));
    private static final RenderType crystalBaseType = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/models/crystal_base.png"));
    private final CCModel crystalFull;
    private final CCModel crystalHalf;
    private final CCModel crystalBase;
    private static float[] r = new float[]{0.0f, 0.55f, 1.0f};
    private static float[] g = new float[]{0.35f, 0.3f, 0.572f};
    private static float[] b = new float[]{0.65f, 0.9f, 0.172f};

    public RenderTileEnergyCrystal(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        Map map = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/block/crystal.obj"), (int)7, null);
        this.crystalFull = CCModel.combine(map.values());
        map = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/block/crystal_half.obj"), (int)7, null);
        this.crystalHalf = (CCModel)map.get("Crystal");
        this.crystalBase = (CCModel)map.get("Base");
    }

    public void render(TileCrystalBase te, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        int tier = te.getTier();
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        double x = player.func_226277_ct_() - ((double)te.func_174877_v().func_177958_n() + 0.5);
        double y = player.func_226278_cu_() - ((double)te.func_174877_v().func_177956_o() + 0.5);
        double z = player.func_226281_cx_() - ((double)te.func_174877_v().func_177952_p() + 0.5);
        BlockPos pos = te.func_174877_v();
        double mm = codechicken.lib.math.MathHelper.clip((double)((x * x + y * y + z * z - 5.0) / 512.0), (double)0.0, (double)1.0);
        float xrot = (float)Math.atan2(x + 0.5, z + 0.5);
        float dist = (float)Utils.getDistanceAtoB((double)Vec3D.getCenter((BlockPos)pos).x, (double)Vec3D.getCenter((BlockPos)pos).z, (double)Minecraft.func_71410_x().field_71439_g.func_226277_ct_(), (double)Minecraft.func_71410_x().field_71439_g.func_226281_cx_());
        float yrot = (float)MathHelper.func_181159_b((double)dist, (double)(y + 0.5));
        if (te instanceof TileCrystalDirectIO) {
            ccrs.bind(crystalBaseType, getter);
            mat.translate(0.5, 1.0, 0.5);
            mat.scale(-0.5);
            mat.apply(Rotation.sideOrientation((int)((Direction)((TileCrystalDirectIO)te).facing.get()).func_176734_d().func_176745_a(), (int)0).at(new Vector3(0.0, 1.0, 0.0)));
            this.crystalBase.render(ccrs, new IVertexOperation[]{mat});
            mat.rotate((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), new Vector3(0.0, 1.0, 0.0));
            ccrs.baseColour = Colour.packRGBA((double)r[tier], (double)g[tier], (double)b[tier], (double)1.0);
            if (DEConfig.crystalShaders) {
                UniformCache uniforms = crystalShader.pushCache();
                uniforms.glUniform1f("mipmap", (float)mm);
                uniforms.glUniform1i("type", tier);
                uniforms.glUniform2f("angle", xrot / -3.125f, yrot / 3.125f);
                ccrs.bind((RenderType)new ShaderRenderType(fallBackType, crystalShader, uniforms), getter);
                this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
            } else {
                ccrs.bind(fallBackType, getter);
                this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
                ccrs.baseColour = -1;
                ccrs.bind(fallBackOverlayType, getter);
                this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
            }
        } else {
            ccrs.baseColour = Colour.packRGBA((double)r[tier], (double)g[tier], (double)b[tier], (double)1.0);
            mat.translate(Vector3.CENTER);
            mat.rotate(3.1415926535897403, new Vector3(1.0, 0.0, 0.0));
            mat.scale(-0.5);
            mat.rotate((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), new Vector3(0.0, 1.0, 0.0));
            if (DEConfig.crystalShaders) {
                UniformCache uniforms = crystalShader.pushCache();
                uniforms.glUniform1f("mipmap", (float)mm);
                uniforms.glUniform1i("type", tier);
                uniforms.glUniform2f("angle", xrot / -3.125f, yrot / 3.125f);
                ccrs.bind((RenderType)new ShaderRenderType(fallBackType, crystalShader, uniforms), getter);
                this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
            } else {
                ccrs.bind(fallBackType, getter);
                this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
                ccrs.baseColour = -1;
                ccrs.bind(fallBackOverlayType, getter);
                this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
            }
        }
        ToolRenderBase.endBatch(getter);
    }
}

