/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.render.TESRBase;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePlacedItem;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.google.common.base.Joiner;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;

public class RenderTilePlacedItem
extends TESRBase<TilePlacedItem> {
    public RenderTilePlacedItem(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TilePlacedItem te, double x, double y, double z, float partialTicks, int destroyStage) {
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        ItemStack[] stacks = new ItemStack[]{te.inventory.func_70301_a(0), te.inventory.func_70301_a(1), te.inventory.func_70301_a(2), te.inventory.func_70301_a(3)};
        int index = 0;
        List<IndexedCuboid6> cuboids = te.getCachedRenderCuboids();
        for (IndexedCuboid6 cuboid : cuboids) {
            ItemStack stack;
            if (index == 4) {
                LogHelper.bigError("Detected illegal render state for placed item at " + te.func_174877_v() + " Index: " + index, new Object[0]);
                LogHelper.error("Tile NBT Dump: " + te.func_189515_b(new CompoundNBT()));
                LogHelper.error("Cuboid List: " + cuboids.size() + " " + Joiner.on((String)", ").join(cuboids));
                LogHelper.error("Thread: " + Thread.currentThread().getName());
                index = 3;
            }
            if (!(stack = stacks[(Integer)cuboid.data - 1]).func_190926_b()) {
                RenderSystem.pushMatrix();
                Vector3 center = cuboid.center();
                RenderSystem.translated((double)(center.x - 0.5), (double)(center.y - 0.5), (double)(center.z - 0.5));
                if (te.facing.func_176740_k() == Direction.Axis.Y) {
                    RenderSystem.rotatef((float)90.0f, (float)te.facing.func_96559_d(), (float)0.0f, (float)0.0f);
                } else if (te.facing.func_176740_k() == Direction.Axis.X) {
                    RenderSystem.rotatef((float)90.0f, (float)0.0f, (float)(-te.facing.func_82601_c()), (float)0.0f);
                } else if (te.facing == Direction.SOUTH) {
                    RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                RenderSystem.rotatef((float)((float)te.rotation[index].get() * 22.5f), (float)0.0f, (float)0.0f, (float)-1.0f);
                if ((stack.func_77973_b().func_77616_k(stack) || te.altRenderMode.get() && !(stack.func_77973_b() instanceof BlockItem)) && cuboids.size() == 1) {
                    RenderSystem.scalef((float)0.8f, (float)0.8f, (float)0.8f);
                    RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else if (stack.func_77973_b() instanceof BlockItem) {
                    float f = 0.72f;
                    RenderSystem.scalef((float)f, (float)f, (float)f);
                    if (te.altRenderMode.get()) {
                        RenderSystem.translated((double)0.0, (double)0.0, (double)-0.2);
                    } else {
                        RenderSystem.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                } else {
                    RenderSystem.scalef((float)0.45f, (float)0.45f, (float)0.45f);
                    RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                RenderSystem.popMatrix();
            }
            ++index;
        }
        RenderSystem.popMatrix();
    }
}

