/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.command;

import codechicken.lib.raytracer.RayTracer;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DETags;
import com.brandon3055.draconicevolution.lib.WTFException;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CommandMakeRecipe {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"gen_recipe").requires(cs -> cs.func_197034_c(3))).then(Commands.func_197057_a((String)"fusion").executes(CommandMakeRecipe::genFusion))).then(Commands.func_197057_a((String)"crafting").executes(CommandMakeRecipe::genCrafting)));
    }

    private static int genFusion(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        BlockRayTraceResult result = RayTracer.retrace((PlayerEntity)player, (double)10.0, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.OUTLINE);
        if (result.func_216346_c() != RayTraceResult.Type.BLOCK) {
            throw new CommandException((ITextComponent)new StringTextComponent("No chest found.\nYou must be looking at a single chest with the recipe laid out on the far left and the result in the center slot.\nFor fusion recipes all slots other than center are ingredients except row 2, slot 2 which is the catalyst."));
        }
        BlockPos pos = result.func_216350_a();
        IItemHandler handler = CommandMakeRecipe.getInventory(player.field_70170_p, pos);
        String recipe = CommandMakeRecipe.getFusionRecipe(handler);
        while (player.func_184592_cb().func_77973_b() == Items.field_151153_ao && player.field_70170_p.func_175625_s(pos = pos.func_177984_a()) instanceof ChestTileEntity) {
            handler = CommandMakeRecipe.getInventory(player.field_70170_p, pos);
            recipe = recipe + "\n\n" + CommandMakeRecipe.getFusionRecipe(handler);
        }
        BrandonsCore.proxy.setClipboardString(recipe);
        ChatHelper.sendMessage((PlayerEntity)player, (ITextComponent)new StringTextComponent("Recipe copied to clipboard"));
        return 0;
    }

    private static int genCrafting(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        return 0;
    }

    private static String getFusionRecipe(IItemHandler handler) {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        ItemStack result = ItemStack.field_190927_a;
        ItemStack catalyst = ItemStack.field_190927_a;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (i == 13) {
                result = stack;
                continue;
            }
            if (i == 10) {
                catalyst = stack;
                continue;
            }
            if (stack.func_190926_b()) continue;
            ingredients.add(stack);
        }
        if (result.func_190926_b()) {
            throw new CommandException((ITextComponent)new StringTextComponent("Result slot (center of chest) is empty"));
        }
        if (catalyst.func_190926_b()) {
            throw new CommandException((ITextComponent)new StringTextComponent("Catalyst slot (row 2 column 2) is empty"));
        }
        StringBuilder recipeCode = new StringBuilder();
        if (result.func_190916_E() > 1) {
            recipeCode.append(String.format("FusionRecipeBuilder.fusionRecipe(%s, %s)", CommandMakeRecipe.getItem(result, true), result.func_190916_E())).append("\n");
        } else {
            recipeCode.append(String.format("FusionRecipeBuilder.fusionRecipe(%s)", CommandMakeRecipe.getItem(result))).append("\n");
        }
        if (catalyst.func_190916_E() > 1) {
            recipeCode.append(String.format(".catalyst(%s, %s)", catalyst.func_190916_E(), CommandMakeRecipe.getIngredient(catalyst, true))).append("\n");
        } else {
            recipeCode.append(String.format(".catalyst(%s)", CommandMakeRecipe.getIngredient(catalyst))).append("\n");
        }
        recipeCode.append(".energy(energyvalue)").append("\n");
        recipeCode.append(".techLevel(tecklevel)").append("\n");
        for (ItemStack stack : ingredients) {
            recipeCode.append(String.format(".ingredient(%s)", CommandMakeRecipe.getIngredient(stack, true))).append("\n");
        }
        recipeCode.append(String.format(".build(consumer, folder(\"tools\", " + CommandMakeRecipe.getItem(result, true) + "));", result.func_77973_b().getRegistryName()));
        return recipeCode.toString();
    }

    public static Map<ResourceLocation, String> getFields() {
        HashMap<ResourceLocation, String> names = new HashMap<ResourceLocation, String>();
        try {
            for (Field field : DEContent.class.getFields()) {
                if (field.get(null) != null && Item.class.isAssignableFrom(field.getType()) && (field.getModifiers() & 9) != 0) {
                    names.put(((Item)field.get(null)).getRegistryName(), "DEContent." + field.getName());
                }
                if (field.get(null) == null || !Block.class.isAssignableFrom(field.getType()) || (field.getModifiers() & 9) == 0) continue;
                names.put(((Block)field.get(null)).getRegistryName(), "DEContent." + field.getName());
            }
            for (Field field : Items.class.getFields()) {
                if (!Item.class.isAssignableFrom(field.getType()) || (field.getModifiers() & 9) == 0) continue;
                names.put(((Item)field.get(null)).getRegistryName(), "Items." + field.getName());
            }
            for (Field field : Blocks.class.getFields()) {
                if (!Block.class.isAssignableFrom(field.getType()) || (field.getModifiers() & 9) == 0) continue;
                names.put(((Block)field.get(null)).getRegistryName(), "Blocks." + field.getName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CommandException((ITextComponent)new StringTextComponent("An error occurred while getting items"));
        }
        return names;
    }

    public static Map<ResourceLocation, String> getTags() {
        HashMap<ResourceLocation, String> names = new HashMap<ResourceLocation, String>();
        try {
            for (Field field2 : Tags.Items.class.getFields()) {
                if (!ITag.INamedTag.class.isAssignableFrom(field2.getType()) || (field2.getModifiers() & 9) == 0) continue;
                names.put(((ITag.INamedTag)field2.get(null)).func_230234_a_(), "Tags.Items." + field2.getName());
            }
            for (Field field2 : DETags.Items.class.getFields()) {
                if (!ITag.INamedTag.class.isAssignableFrom(field2.getType()) || (field2.getModifiers() & 9) == 0) continue;
                names.put(((ITag.INamedTag)field2.get(null)).func_230234_a_(), "DETags.Items." + field2.getName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CommandException((ITextComponent)new StringTextComponent("An error occurred while getting tags"));
        }
        ArrayList<String> tagPrefixes = new ArrayList<String>();
        tagPrefixes.add("forge:dusts/");
        tagPrefixes.add("forge:nuggets/");
        tagPrefixes.add("forge:ingots/");
        tagPrefixes.add("forge:gems/");
        tagPrefixes.add("forge:storage_blocks/");
        tagPrefixes.add("forge:rods/");
        tagPrefixes.add("forge:glass/");
        tagPrefixes.add("forge:glass_panes/");
        tagPrefixes.add("forge:ores/");
        HashMap<ResourceLocation, String> tagMap = new HashMap<ResourceLocation, String>();
        names.forEach((name, field) -> {
            for (String prefix : tagPrefixes) {
                if (!name.toString().startsWith(prefix)) continue;
                tagMap.put((ResourceLocation)name, (String)field);
                break;
            }
        });
        return tagMap;
    }

    public static String getItem(ItemStack stack, boolean ignnoreSize) {
        ResourceLocation key;
        Map<ResourceLocation, String> fields = CommandMakeRecipe.getFields();
        if (fields.containsKey(key = stack.func_77973_b().getRegistryName())) {
            if (stack.func_190916_E() > 1 && !ignnoreSize) {
                return "new ItemStack(" + fields.get(key) + ", " + stack.func_190916_E() + ")";
            }
            return fields.get(key);
        }
        throw new CommandException((ITextComponent)new StringTextComponent("Failed to locate item field for key: " + key));
    }

    public static String getItem(ItemStack stack) {
        return CommandMakeRecipe.getItem(stack, false);
    }

    public static String getIngredient(ItemStack stack, boolean ignoreSize) {
        Map<ResourceLocation, String> tags = CommandMakeRecipe.getTags();
        for (ResourceLocation tag : stack.func_77973_b().getTags()) {
            if (!tags.containsKey(tag)) continue;
            if (stack.func_190916_E() > 1 && !ignoreSize) {
                return "IngredientStack.fromTag(" + tags.get(tag) + ", " + stack.func_190916_E() + ")";
            }
            return tags.get(tag);
        }
        String item = CommandMakeRecipe.getItem(stack);
        if (stack.func_190916_E() > 1 && !ignoreSize) {
            return "IngredientStack.fromItems(" + stack.func_190916_E() + "," + item + ")";
        }
        return item;
    }

    public static String getIngredient(ItemStack stack) {
        return CommandMakeRecipe.getIngredient(stack, false);
    }

    private static IItemHandler getInventory(World world, BlockPos pos) {
        LazyOptional optional;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ChestTileEntity && (optional = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            IItemHandler handler = (IItemHandler)optional.orElseThrow(WTFException::new);
            if (handler.getSlots() != 27) {
                throw new CommandException((ITextComponent)new StringTextComponent("Must be a single chest with result in center slot"));
            }
            return handler;
        }
        throw new CommandException((ITextComponent)new StringTextComponent("No chest found.\nYou must be looking at a single chest with the recipe laid out on the far left and the result in the center slot.\nFor fusion recipes all slots other than center are ingredients except row 2, slot 2 which is the catalyst."));
    }
}

