/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.datagen;

import com.brandon3055.draconicevolution.blocks.machines.EnergyPylon;
import com.brandon3055.draconicevolution.blocks.machines.Generator;
import com.brandon3055.draconicevolution.blocks.machines.Grinder;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.function.Function;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockStateGenerator
extends BlockStateProvider {
    private static final Logger LOGGER = LogManager.getLogger();

    public BlockStateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "draconicevolution", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)DEContent.block_draconium);
        this.simpleBlock((Block)DEContent.block_draconium_awakened, (ModelFile)this.models().cubeBottomTop("awakened_draconium_block", this.modLoc("block/awakened_draconium_block_side"), this.modLoc("block/awakened_draconium_block"), this.modLoc("block/awakened_draconium_block")));
        this.simpleBlock((Block)DEContent.ore_draconium_end);
        this.simpleBlock((Block)DEContent.ore_draconium_nether);
        this.simpleBlock((Block)DEContent.ore_draconium_overworld);
        this.simpleBlock((Block)DEContent.infused_obsidian);
        this.simpleBlock((Block)DEContent.energy_core);
        this.simpleBlock((Block)DEContent.energy_core_stabilizer, (ModelFile)this.models().getExistingFile(this.modLoc("block/energy_core_stabilizer")));
        this.simpleBlock((Block)DEContent.creative_op_capacitor);
        this.simpleBlock((Block)DEContent.stabilized_spawner, (ModelFile)this.models().getExistingFile(this.modLoc("block/stabilized_spawner")));
        this.simpleBlock((Block)DEContent.particle_generator, (ModelFile)this.models().getExistingFile(this.modLoc("block/particle_generator")));
        this.simpleBlock((Block)DEContent.crafting_core, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/fusion_crafting_core")));
        this.simpleBlock((Block)DEContent.dislocation_inhibitor, (ModelFile)this.models().cubeBottomTop("dislocation_inhibitor", this.modLoc("block/dislocation_inhibitor"), this.modLoc("block/parts/machine_top"), this.modLoc("block/parts/machine_top")));
        this.directionalBlock((Block)DEContent.crafting_injector_basic, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/crafting_injector_draconium")));
        this.directionalBlock((Block)DEContent.crafting_injector_wyvern, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/crafting_injector_wyvern")));
        this.directionalBlock((Block)DEContent.crafting_injector_awakened, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/crafting_injector_draconic")));
        this.directionalBlock((Block)DEContent.crafting_injector_chaotic, (ModelFile)this.models().getExistingFile(this.modLoc("block/crafting/crafting_injector_chaotic")));
        this.directionalFromNorth((Block)DEContent.fluid_gate, (ModelFile)this.models().getExistingFile(this.modLoc("block/fluid_gate")));
        this.directionalFromNorth((Block)DEContent.flux_gate, (ModelFile)this.models().getExistingFile(this.modLoc("block/flux_gate")));
        this.directionalBlock((Block)DEContent.potentiometer, (ModelFile)this.models().getExistingFile(this.modLoc("block/potentiometer")));
        this.simpleBlock((Block)DEContent.energy_transfuser, (ModelFile)this.models().getExistingFile(this.modLoc("block/energy_transfuser")));
        this.dummyBlock((Block)DEContent.crystal_io_basic);
        this.dummyBlock((Block)DEContent.crystal_io_wyvern);
        this.dummyBlock((Block)DEContent.crystal_io_draconic);
        this.dummyBlock((Block)DEContent.crystal_relay_basic);
        this.dummyBlock((Block)DEContent.crystal_relay_wyvern);
        this.dummyBlock((Block)DEContent.crystal_relay_draconic);
        this.dummyBlock((Block)DEContent.crystal_wireless_basic);
        this.dummyBlock((Block)DEContent.crystal_wireless_wyvern);
        this.dummyBlock((Block)DEContent.crystal_wireless_draconic);
        this.dummyBlock((Block)DEContent.energy_core_structure);
        this.dummyBlock((Block)DEContent.chaos_crystal);
        this.dummyBlock((Block)DEContent.chaos_crystal_part);
        this.dummyBlock((Block)DEContent.draconium_chest);
        this.dummyBlock((Block)DEContent.reactor_core);
        this.dummyBlock((Block)DEContent.reactor_stabilizer);
        this.dummyBlock((Block)DEContent.reactor_injector);
        this.getVariantBuilder((Block)DEContent.energy_pylon).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeBottomTop((Boolean)state.func_177229_b((Property)EnergyPylon.OUTPUT) != false ? "energy_pylon_output" : "energy_pylon_input", this.modLoc("block/energy_pylon/energy_pylon_" + ((Boolean)state.func_177229_b((Property)EnergyPylon.OUTPUT) != false ? "output" : "input")), this.modLoc("block/energy_pylon/energy_pylon_active_face"), this.modLoc("block/energy_pylon/energy_pylon_active_face"))).build());
        ModelFile.ExistingModelFile modelGenerator = this.models().getExistingFile(this.modLoc("block/generator/generator"));
        ModelFile.ExistingModelFile modelGeneratorFlame = this.models().getExistingFile(this.modLoc("block/generator/generator_flame"));
        MultiPartBlockStateBuilder generatorBuilder = this.getMultipartBuilder((Block)DEContent.generator);
        for (Direction dir : FenceGateBlock.field_185512_D.func_177700_c()) {
            int angle = (int)dir.func_176734_d().func_185119_l();
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)generatorBuilder.part().modelFile((ModelFile)modelGenerator).rotationY(angle).addModel()).condition((Property)Generator.FACING, (Comparable[])new Direction[]{dir}).end().part().modelFile((ModelFile)modelGeneratorFlame).rotationY(angle).addModel()).condition((Property)Generator.FACING, (Comparable[])new Direction[]{dir}).condition((Property)Generator.ACTIVE, (Comparable[])new Boolean[]{true}).end();
        }
        ModelFile.ExistingModelFile modelGrinder = this.models().getExistingFile(this.modLoc("block/grinder/grinder"));
        ModelFile.ExistingModelFile modelGrinderActive = this.models().getExistingFile(this.modLoc("block/grinder/grinder_eyes"));
        MultiPartBlockStateBuilder grinderBuilder = this.getMultipartBuilder((Block)DEContent.grinder);
        for (Direction dir : Direction.field_176754_o) {
            int angle = (int)dir.func_176734_d().func_185119_l();
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)grinderBuilder.part().modelFile((ModelFile)modelGrinder).rotationY(angle).addModel()).condition((Property)Grinder.FACING, (Comparable[])new Direction[]{dir}).end().part().modelFile((ModelFile)modelGrinderActive).rotationY(angle).addModel()).condition((Property)Grinder.FACING, (Comparable[])new Direction[]{dir}).condition((Property)Grinder.ACTIVE, (Comparable[])new Boolean[]{true}).end();
        }
    }

    private void dummyBlock(Block block) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("dummy", "block")).texture("particle", "minecraft:block/glass");
        this.simpleBlock(block, (ModelFile)model);
    }

    public void directionalFromNorth(Block block, ModelFile model) {
        this.directionalFromNorth(block, model, 180);
    }

    public void directionalFromNorth(Block block, ModelFile model, int angleOffset) {
        this.directionalFromNorth(block, (BlockState $) -> model, angleOffset);
    }

    public void directionalFromNorth(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.directionalFromNorth(block, modelFunc, 180);
    }

    public void directionalFromNorth(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 90 : (dir == Direction.UP ? -90 : 0)).rotationY(dir.func_176740_k().func_200128_b() ? 0 : ((int)dir.func_185119_l() + angleOffset) % 360).build();
        });
    }

    public String func_200397_b() {
        return "Draconic Evolution Blockstates";
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$3(ModelFile barrelOpen, ModelFile barrel, BlockState state) {
        return (Boolean)state.func_177229_b((Property)BarrelBlock.field_220093_b) != false ? barrelOpen : barrel;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$2(ModelFile furnaceLit, ModelFile furnace, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.func_177229_b((Property)FurnaceBlock.field_220091_b) != false ? furnaceLit : furnace).rotationY((int)((Direction)state.func_177229_b((Property)FurnaceBlock.field_220090_a)).func_176734_d().func_185119_l()).build();
    }

    private static /* synthetic */ void lambda$registerStatesAndModels$1(Direction dir, ModelBuilder.ElementBuilder.FaceBuilder face) {
        face.texture("#" + dir.func_176610_l()).cullface(dir);
    }
}

