/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.datagen;

import codechicken.lib.util.SneakyUtils;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEModules;
import java.io.File;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.commons.io.FileUtils;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "draconicevolution", existingFileHelper);
    }

    protected void registerModels() {
        this.blockItem((Block)DEContent.generator, this.modLoc("block/generator/generator"));
        this.blockItem((Block)DEContent.grinder, this.modLoc("block/grinder/grinder"));
        this.blockItem((Block)DEContent.energy_pylon, this.modLoc("block/energy_pylon_input"));
        this.blockItem((Block)DEContent.crafting_injector_basic);
        this.blockItem((Block)DEContent.crafting_injector_wyvern);
        this.blockItem((Block)DEContent.crafting_injector_awakened);
        this.blockItem((Block)DEContent.crafting_injector_chaotic);
        this.blockItem((Block)DEContent.crafting_core, this.modLoc("block/crafting/fusion_crafting_core"));
        this.blockItem((Block)DEContent.crafting_injector_basic, this.modLoc("block/crafting/crafting_injector_draconium"));
        this.blockItem((Block)DEContent.crafting_injector_wyvern, this.modLoc("block/crafting/crafting_injector_wyvern"));
        this.blockItem((Block)DEContent.crafting_injector_awakened, this.modLoc("block/crafting/crafting_injector_draconic"));
        this.blockItem((Block)DEContent.crafting_injector_chaotic, this.modLoc("block/crafting/crafting_injector_chaotic"));
        this.blockItem((Block)DEContent.fluid_gate);
        this.blockItem((Block)DEContent.flux_gate);
        this.blockItem((Block)DEContent.potentiometer);
        this.blockItem((Block)DEContent.disenchanter);
        this.blockItem((Block)DEContent.energy_transfuser, this.modLoc("block/energy_transfuser"));
        this.blockItem((Block)DEContent.dislocator_pedestal);
        this.blockItem((Block)DEContent.dislocator_receptacle);
        this.blockItem((Block)DEContent.creative_op_capacitor);
        this.blockItem((Block)DEContent.entity_detector);
        this.blockItem((Block)DEContent.entity_detector_advanced);
        this.blockItem((Block)DEContent.stabilized_spawner);
        this.blockItem((Block)DEContent.celestial_manipulator);
        this.blockItem((Block)DEContent.draconium_chest);
        this.blockItem((Block)DEContent.particle_generator);
        this.blockItem((Block)DEContent.placed_item);
        this.blockItem((Block)DEContent.portal);
        this.blockItem((Block)DEContent.chaos_crystal);
        this.blockItem((Block)DEContent.energy_core);
        this.blockItem((Block)DEContent.energy_core_stabilizer);
        this.blockItem((Block)DEContent.energy_core_structure);
        this.blockItem((Block)DEContent.reactor_core);
        this.blockItem((Block)DEContent.reactor_stabilizer);
        this.blockItem((Block)DEContent.reactor_injector);
        this.blockItem((Block)DEContent.rain_sensor);
        this.blockItem((Block)DEContent.dislocation_inhibitor);
        this.blockItem((Block)DEContent.ore_draconium_overworld);
        this.blockItem((Block)DEContent.ore_draconium_nether);
        this.blockItem((Block)DEContent.ore_draconium_end);
        this.blockItem((Block)DEContent.block_draconium);
        this.blockItem((Block)DEContent.block_draconium_awakened);
        this.blockItem((Block)DEContent.infused_obsidian);
        this.dummyModel((Block)DEContent.crystal_io_basic);
        this.dummyModel((Block)DEContent.crystal_io_wyvern);
        this.dummyModel((Block)DEContent.crystal_io_draconic);
        this.dummyModel((Block)DEContent.crystal_relay_basic);
        this.dummyModel((Block)DEContent.crystal_relay_wyvern);
        this.dummyModel((Block)DEContent.crystal_relay_draconic);
        this.dummyModel((Block)DEContent.crystal_wireless_basic);
        this.dummyModel((Block)DEContent.crystal_wireless_wyvern);
        this.dummyModel((Block)DEContent.crystal_wireless_draconic);
        this.simpleItem(DEContent.dust_draconium, "item/components");
        this.simpleItem(DEContent.dust_draconium_awakened, "item/components");
        this.simpleItem(DEContent.ingot_draconium, "item/components");
        this.simpleItem(DEContent.ingot_draconium_awakened, "item/components");
        this.simpleItem(DEContent.nugget_draconium, "item/components");
        this.simpleItem(DEContent.nugget_draconium_awakened, "item/components");
        this.simpleItem((Item)DEContent.core_draconium, "item/components");
        this.simpleItem((Item)DEContent.core_wyvern, "item/components");
        this.simpleItem((Item)DEContent.core_awakened, "item/components");
        this.simpleItem((Item)DEContent.core_chaotic, "item/components");
        this.simpleItem(DEContent.energy_core_wyvern, "item/components");
        this.simpleItem(DEContent.energy_core_draconic, "item/components");
        this.simpleItem(DEContent.energy_core_chaotic, "item/components");
        this.simpleItem(DEContent.dragon_heart, "item/components");
        this.simpleItem(DEContent.module_core, "item/components");
        this.dummyModel(DEContent.chaos_shard);
        this.dummyModel(DEContent.chaos_frag_small);
        this.dummyModel(DEContent.chaos_frag_medium);
        this.dummyModel(DEContent.chaos_frag_large);
        this.dummyModel(DEContent.reactor_prt_stab_frame);
        this.dummyModel(DEContent.reactor_prt_in_rotor);
        this.dummyModel(DEContent.reactor_prt_out_rotor);
        this.dummyModel(DEContent.reactor_prt_rotor_full);
        this.dummyModel(DEContent.reactor_prt_focus_ring);
        this.dummyModel((Block)DEContent.draconium_chest);
        this.dummyModel((Block)DEContent.reactor_core);
        this.dummyModel((Block)DEContent.reactor_stabilizer);
        this.dummyModel((Block)DEContent.reactor_injector);
        this.dummyModel((Item)DEContent.mob_soul);
        this.simpleItem((Item)DEContent.magnet);
        this.simpleItem((Item)DEContent.magnet_advanced);
        this.simpleItem(DEContent.dislocator);
        this.simpleItem(DEContent.dislocator_advanced);
        this.simpleItem(DEContent.crystal_binder);
        this.simpleItem(DEContent.info_tablet);
        File textures = new File("/home/brandon3055/Development/WorkSpaces/1.16/BrandonsMods/Draconic-Evolution/src/main/resources/assets/draconicevolution/textures");
        DEModules.moduleItemMap.forEach((module, item) -> {
            String name = Objects.requireNonNull(module.getRegistryName()).func_110623_a();
            File itemTexture = new File(textures, "item/modules/" + name + ".png");
            File moduleTexture = new File(textures, "module/" + name + ".png");
            if (!itemTexture.exists()) {
                SneakyUtils.sneaky(() -> FileUtils.copyFile((File)new File(textures, "item/modules/blank_" + name.substring(0, name.indexOf("_")) + ".png"), (File)itemTexture));
            }
            if (!moduleTexture.exists()) {
                SneakyUtils.sneaky(() -> FileUtils.copyFile((File)itemTexture, (File)moduleTexture));
            }
            this.simpleItem((Item)item, new ResourceLocation("draconicevolution", "item/modules/" + name));
        });
        this.simpleItem((Item)DEContent.capacitor_wyvern, "item/tools");
        this.simpleItem((Item)DEContent.capacitor_draconic, "item/tools");
        this.simpleItem((Item)DEContent.capacitor_chaotic, "item/tools");
        this.simpleItem((Item)DEContent.capacitor_creative, "item/tools");
        this.simpleItem((Item)DEContent.shovel_wyvern, "item/tools");
        this.simpleItem((Item)DEContent.shovel_draconic, "item/tools");
        this.simpleItem((Item)DEContent.shovel_chaotic, "item/tools");
        this.simpleItem((Item)DEContent.pickaxe_wyvern, "item/tools");
        this.simpleItem((Item)DEContent.pickaxe_draconic, "item/tools");
        this.simpleItem((Item)DEContent.pickaxe_chaotic, "item/tools");
        this.simpleItem((Item)DEContent.hoe_wyvern, "item/tools");
        this.simpleItem((Item)DEContent.hoe_draconic, "item/tools");
        this.simpleItem((Item)DEContent.hoe_chaotic, "item/tools");
        this.simpleItem((Item)DEContent.axe_wyvern, "item/tools");
        this.simpleItem((Item)DEContent.axe_draconic, "item/tools");
        this.simpleItem((Item)DEContent.axe_chaotic, "item/tools");
        this.simpleItem((Item)DEContent.bow_wyvern, "item/tools");
        this.simpleItem((Item)DEContent.bow_draconic, "item/tools");
        this.simpleItem((Item)DEContent.bow_chaotic, "item/tools");
        this.simpleItem((Item)DEContent.sword_wyvern, "item/tools");
        this.simpleItem((Item)DEContent.sword_draconic, "item/tools");
        this.simpleItem((Item)DEContent.sword_chaotic, "item/tools");
        this.simpleItem((Item)DEContent.staff_draconic, "item/tools");
        this.simpleItem((Item)DEContent.staff_chaotic, "item/tools");
        this.simpleItem((Item)DEContent.chestpiece_wyvern, "item/tools");
        this.simpleItem((Item)DEContent.chestpiece_draconic, "item/tools");
        this.simpleItem((Item)DEContent.chestpiece_chaotic, "item/tools");
    }

    private void simpleItem(Item item) {
        this.simpleItem(item, "item");
    }

    private void simpleItem(Item item, String textureFolder) {
        ResourceLocation reg = item.getRegistryName();
        this.simpleItem(item, new ResourceLocation(reg.func_110624_b(), textureFolder + "/" + reg.func_110623_a()));
    }

    private void simpleItem(Item item, ResourceLocation texture) {
        ResourceLocation reg = item.getRegistryName();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(reg.func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
    }

    private void blockItem(Block block) {
        if (block == null) {
            return;
        }
        ResourceLocation reg = block.getRegistryName();
        this.blockItem(block, new ResourceLocation(reg.func_110624_b(), "block/" + reg.func_110623_a()));
    }

    private void blockItem(Block block, ResourceLocation blockModel) {
        if (block == null) {
            return;
        }
        ResourceLocation reg = block.getRegistryName();
        ((ItemModelBuilder)this.getBuilder(reg.func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile(blockModel));
    }

    private void dummyModel(Block block) {
        this.dummyModel(block.func_199767_j());
    }

    private void dummyModel(Item item) {
        ((ItemModelBuilder)this.getBuilder(item.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/generated"));
    }

    public String func_200397_b() {
        return "Draconic Evolution Item Models";
    }
}

