/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianPartEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.entity.guardian.control.IPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseManager;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.Logger;

public class DraconicGuardianEntity
extends MobEntity
implements IMob {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    public static final DataParameter<Integer> PHASE = EntityDataManager.func_187226_a(DraconicGuardianEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> CRYSTAL_ID = EntityDataManager.func_187226_a(DraconicGuardianEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> SHIELD_POWER = EntityDataManager.func_187226_a(DraconicGuardianEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Optional<BlockPos>> ORIGIN = EntityDataManager.func_187226_a(DraconicGuardianEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final EntityPredicate PLAYER_INVADER_CONDITION = new EntityPredicate().func_221013_a(64.0);
    public final double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    private final DraconicGuardianPartEntity[] dragonParts;
    public final DraconicGuardianPartEntity dragonPartHead;
    private final DraconicGuardianPartEntity dragonPartNeck;
    private final DraconicGuardianPartEntity dragonPartBody;
    private final DraconicGuardianPartEntity dragonPartTail1;
    private final DraconicGuardianPartEntity dragonPartTail2;
    private final DraconicGuardianPartEntity dragonPartTail3;
    private final DraconicGuardianPartEntity dragonPartRightWing;
    private final DraconicGuardianPartEntity dragonPartLeftWing;
    public float prevAnimTime;
    public float animTime;
    public boolean slowed;
    public int deathTicks;
    public float yRotA;
    @Nullable
    public GuardianCrystalEntity closestGuardianCrystal;
    @Nullable
    private GuardianFightManager fightManager;
    private final PhaseManager phaseManager;
    private int growlTime = 100;
    private PathPoint[] pathPoints = new PathPoint[24];
    private final PathHeap pathFindQueue = new PathHeap();
    private double speedMult = 1.0;
    public float dpm = 0.0f;
    private float lastDamage;
    private int hitCoolDown;

    public DraconicGuardianEntity(EntityType<?> type, World world) {
        super(DEContent.draconicGuardian, world);
        this.dragonPartHead = new DraconicGuardianPartEntity(this, "head", 1.0f, 1.0f);
        this.dragonPartNeck = new DraconicGuardianPartEntity(this, "neck", 3.0f, 3.0f);
        this.dragonPartBody = new DraconicGuardianPartEntity(this, "body", 5.0f, 3.0f);
        this.dragonPartTail1 = new DraconicGuardianPartEntity(this, "tail", 2.0f, 2.0f);
        this.dragonPartTail2 = new DraconicGuardianPartEntity(this, "tail", 2.0f, 2.0f);
        this.dragonPartTail3 = new DraconicGuardianPartEntity(this, "tail", 2.0f, 2.0f);
        this.dragonPartRightWing = new DraconicGuardianPartEntity(this, "wing", 4.0f, 2.0f);
        this.dragonPartLeftWing = new DraconicGuardianPartEntity(this, "wing", 4.0f, 2.0f);
        this.dragonParts = new DraconicGuardianPartEntity[]{this.dragonPartHead, this.dragonPartNeck, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartRightWing, this.dragonPartLeftWing};
        this.func_70606_j(this.func_110138_aP());
        this.field_70145_X = true;
        this.field_70158_ak = true;
        this.phaseManager = new PhaseManager(this);
    }

    public void func_233627_a_(float strength, double ratioX, double ratioZ) {
    }

    public void setFightManager(GuardianFightManager fightManager) {
        this.fightManager = fightManager;
    }

    public void setArenaOrigin(BlockPos arenaOrigin) {
        this.field_70180_af.func_187227_b(ORIGIN, Optional.ofNullable(arenaOrigin));
    }

    public BlockPos getArenaOrigin() {
        return ((Optional)this.field_70180_af.func_187225_a(ORIGIN)).orElse(null);
    }

    public AttributeModifierManager func_233645_dx_() {
        return super.func_233645_dx_();
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, (double)DEConfig.guardianHealth);
    }

    public float getShieldPower() {
        return ((Float)this.field_70180_af.func_187225_a(SHIELD_POWER)).floatValue();
    }

    public void setShieldPower(float shieldPower) {
        this.field_70180_af.func_187227_b(SHIELD_POWER, (Object)Float.valueOf(shieldPower));
        GuardianFightManager manager = this.getFightManager();
        if (manager != null) {
            manager.guardianUpdate(this);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(PHASE, (Object)PhaseType.HOVER.getId());
        this.func_184212_Q().func_187214_a(CRYSTAL_ID, (Object)-1);
        this.func_184212_Q().func_187214_a(SHIELD_POWER, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(ORIGIN, Optional.empty());
    }

    public void func_70071_h_() {
        GuardianFightManager manager;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.getShieldPower() < (float)DEConfig.guardianShield && (manager = this.getFightManager()) != null && manager.getNumAliveCrystals() > 0) {
            this.setShieldPower(Math.min((float)DEConfig.guardianShield, this.getShieldPower() + (float)DEConfig.guardianShield / 200.0f));
        }
        if (this.hitCoolDown > 0) {
            --this.hitCoolDown;
        }
    }

    public double[] getMovementOffsets(int index, float partialTicks) {
        if (this.func_233643_dh_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - index & 0x3F;
        int j = this.ringBufferIndex - index - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = net.minecraft.util.math.MathHelper.func_76138_g((double)(this.ringBuffer[j][0] - d0));
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = net.minecraft.util.math.MathHelper.func_219803_d((double)partialTicks, (double)this.ringBuffer[i][2], (double)this.ringBuffer[j][2]);
        return adouble;
    }

    public void func_70636_d() {
        this.speedMult = MathHelper.approachLinear((double)this.speedMult, (double)this.phaseManager.getCurrentPhase().getGuardianSpeed(), (double)0.1);
        if (this.field_70170_p.field_72995_K) {
            this.func_70606_j(this.func_110143_aJ());
            if (!this.func_174814_R()) {
                float f = net.minecraft.util.math.MathHelper.func_76134_b((float)(this.animTime * ((float)Math.PI * 2)));
                float f1 = net.minecraft.util.math.MathHelper.func_76134_b((float)(this.prevAnimTime * ((float)Math.PI * 2)));
                if (f1 <= -0.3f && f >= -0.3f) {
                    this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187524_aN, this.func_184176_by(), 5.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
                }
                if (!this.phaseManager.getCurrentPhase().getIsStationary() && --this.growlTime < 0) {
                    this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187525_aO, this.func_184176_by(), 2.5f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
                    this.growlTime = 200 + this.field_70146_Z.nextInt(200);
                }
            }
        }
        this.prevAnimTime = this.animTime;
        if (this.func_233643_dh_()) {
            float randX = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float randY = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float randZ = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_() + (double)randX, this.func_226278_cu_() + 2.0 + (double)randY, this.func_226281_cx_() + (double)randZ, 0.0, 0.0, 0.0);
        } else {
            this.updateDragonEnderCrystal();
            Vector3d vector3d4 = this.func_213322_ci();
            float f12 = 0.2f / (net.minecraft.util.math.MathHelper.func_76133_a((double)DraconicGuardianEntity.func_213296_b((Vector3d)vector3d4)) * 10.0f + 1.0f);
            this.animTime = this.phaseManager.getCurrentPhase().getIsStationary() ? (this.animTime += 0.1f) : (this.slowed ? (this.animTime += f12 * 0.5f) : (this.animTime += (f12 *= (float)Math.pow(2.0, vector3d4.field_72448_b))));
            this.field_70177_z = net.minecraft.util.math.MathHelper.func_76142_g((float)this.field_70177_z);
            if (this.func_175446_cd()) {
                this.animTime = 0.5f;
            } else {
                if (this.ringBufferIndex < 0) {
                    for (int i = 0; i < this.ringBuffer.length; ++i) {
                        this.ringBuffer[i][0] = this.field_70177_z;
                        this.ringBuffer[i][1] = this.func_226278_cu_();
                    }
                }
                if (++this.ringBufferIndex == this.ringBuffer.length) {
                    this.ringBufferIndex = 0;
                }
                this.ringBuffer[this.ringBufferIndex][0] = this.field_70177_z;
                this.ringBuffer[this.ringBufferIndex][1] = this.func_226278_cu_();
                if (this.field_70170_p.field_72995_K) {
                    if (this.field_70716_bi > 0) {
                        double d7 = this.func_226277_ct_() + (this.field_184623_bh - this.func_226277_ct_()) / (double)this.field_70716_bi;
                        double d0 = this.func_226278_cu_() + (this.field_184624_bi - this.func_226278_cu_()) / (double)this.field_70716_bi;
                        double d1 = this.func_226281_cx_() + (this.field_184625_bj - this.func_226281_cx_()) / (double)this.field_70716_bi;
                        double d2 = net.minecraft.util.math.MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
                        this.field_70177_z = (float)((double)this.field_70177_z + d2 / (double)this.field_70716_bi);
                        this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
                        --this.field_70716_bi;
                        this.func_70107_b(d7, d0, d1);
                        this.func_70101_b(this.field_70177_z, this.field_70125_A);
                    }
                    this.phaseManager.getCurrentPhase().clientTick();
                } else {
                    IPhase iphase = this.phaseManager.getCurrentPhase();
                    iphase.serverTick();
                    if (this.phaseManager.getCurrentPhase() != iphase) {
                        iphase = this.phaseManager.getCurrentPhase();
                        iphase.serverTick();
                    }
                    this.phaseManager.globalServerTick();
                    Vector3d targetLocation = iphase.getTargetLocation();
                    if (targetLocation != null) {
                        double tRelX = targetLocation.field_72450_a - this.func_226277_ct_();
                        double tRelY = targetLocation.field_72448_b - this.func_226278_cu_();
                        double tRelZ = targetLocation.field_72449_c - this.func_226281_cx_();
                        double distanceSq = tRelX * tRelX + tRelY * tRelY + tRelZ * tRelZ;
                        float maxRiseOrFall = iphase.getMaxRiseOrFall();
                        double distanceXZ = net.minecraft.util.math.MathHelper.func_76133_a((double)(tRelX * tRelX + tRelZ * tRelZ));
                        if (distanceXZ > 0.0) {
                            tRelY = this.phaseManager.getCurrentPhase().highVerticalAgility() ? net.minecraft.util.math.MathHelper.func_151237_a((double)tRelY, (double)(-maxRiseOrFall), (double)maxRiseOrFall) : net.minecraft.util.math.MathHelper.func_151237_a((double)(tRelY / distanceXZ), (double)(-maxRiseOrFall), (double)maxRiseOrFall);
                        }
                        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, tRelY * 0.01, 0.0));
                        this.field_70177_z = net.minecraft.util.math.MathHelper.func_76142_g((float)this.field_70177_z);
                        double relTargetAngle = net.minecraft.util.math.MathHelper.func_151237_a((double)net.minecraft.util.math.MathHelper.func_76138_g((double)(180.0 - net.minecraft.util.math.MathHelper.func_181159_b((double)tRelX, (double)tRelZ) * 57.2957763671875 - (double)this.field_70177_z)), (double)-50.0, (double)50.0);
                        if (Math.abs(relTargetAngle) < 5.0) {
                            relTargetAngle *= this.speedMult * 5.0;
                        }
                        Vector3d targetVector = targetLocation.func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()).func_72432_b();
                        Vector3d vector3d2 = new Vector3d((double)net.minecraft.util.math.MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), this.func_213322_ci().field_72448_b, (double)(-net.minecraft.util.math.MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))))).func_72432_b();
                        float f8 = Math.max(((float)vector3d2.func_72430_b(targetVector) + 0.5f) / 1.5f, 0.0f);
                        this.yRotA *= 0.8f;
                        this.yRotA = (float)((double)this.yRotA + relTargetAngle * (double)iphase.getYawFactor());
                        this.field_70177_z += this.yRotA * 0.1f;
                        float f9 = (float)(2.0 / (distanceSq + 1.0));
                        float f10 = 0.06f;
                        this.func_213309_a(f10 * (f8 * f9 + (1.0f - f9)), new Vector3d(0.0, 0.0, -1.0));
                        if (this.slowed) {
                            this.func_213315_a(MoverType.SELF, this.func_213322_ci().func_186678_a((double)0.8f).func_186678_a(this.speedMult));
                        } else {
                            this.func_213315_a(MoverType.SELF, this.func_213322_ci().func_186678_a(this.speedMult));
                        }
                        Vector3d vector3d3 = this.func_213322_ci().func_72432_b();
                        double d6 = 0.8 + 0.15 * (vector3d3.func_72430_b(vector3d2) + 1.0) / 2.0;
                        this.func_213317_d(this.func_213322_ci().func_216372_d(d6, (double)0.91f, d6));
                    }
                }
                this.field_70761_aq = this.field_70177_z;
                Vector3d[] avector3d = new Vector3d[this.dragonParts.length];
                for (int j = 0; j < this.dragonParts.length; ++j) {
                    avector3d[j] = new Vector3d(this.dragonParts[j].func_226277_ct_(), this.dragonParts[j].func_226278_cu_(), this.dragonParts[j].func_226281_cx_());
                }
                float f15 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f16 = net.minecraft.util.math.MathHelper.func_76134_b((float)f15);
                float f2 = net.minecraft.util.math.MathHelper.func_76126_a((float)f15);
                float f17 = this.field_70177_z * ((float)Math.PI / 180);
                float f3 = net.minecraft.util.math.MathHelper.func_76126_a((float)f17);
                float f18 = net.minecraft.util.math.MathHelper.func_76134_b((float)f17);
                this.setPartPosition(this.dragonPartBody, f3 * 0.5f, 0.0, -f18 * 0.5f);
                this.setPartPosition(this.dragonPartRightWing, f18 * 4.5f, 2.0, f3 * 4.5f);
                this.setPartPosition(this.dragonPartLeftWing, f18 * -4.5f, 2.0, f3 * -4.5f);
                if (!this.field_70170_p.field_72995_K && this.field_70737_aN == 0) {
                    this.collideWithEntities(this.field_70170_p.func_175674_a((Entity)this, this.dragonPartRightWing.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0), EntityPredicates.field_188444_d));
                    this.collideWithEntities(this.field_70170_p.func_175674_a((Entity)this, this.dragonPartLeftWing.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0), EntityPredicates.field_188444_d));
                    this.attackEntitiesInList(this.field_70170_p.func_175674_a((Entity)this, this.dragonPartHead.func_174813_aQ().func_186662_g(1.0), EntityPredicates.field_188444_d));
                    this.attackEntitiesInList(this.field_70170_p.func_175674_a((Entity)this, this.dragonPartNeck.func_174813_aQ().func_186662_g(1.0), EntityPredicates.field_188444_d));
                }
                float f4 = net.minecraft.util.math.MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f19 = net.minecraft.util.math.MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f5 = this.getHeadAndNeckYOffset();
                this.setPartPosition(this.dragonPartHead, f4 * 6.5f * f16, f5 + f2 * 6.5f, -f19 * 6.5f * f16);
                this.setPartPosition(this.dragonPartNeck, f4 * 5.5f * f16, f5 + f2 * 5.5f, -f19 * 5.5f * f16);
                double[] adouble = this.getMovementOffsets(5, 1.0f);
                for (int k = 0; k < 3; ++k) {
                    DraconicGuardianPartEntity enderdragonpartentity = null;
                    if (k == 0) {
                        enderdragonpartentity = this.dragonPartTail1;
                    }
                    if (k == 1) {
                        enderdragonpartentity = this.dragonPartTail2;
                    }
                    if (k == 2) {
                        enderdragonpartentity = this.dragonPartTail3;
                    }
                    double[] adouble1 = this.getMovementOffsets(12 + k * 2, 1.0f);
                    float f7 = this.field_70177_z * ((float)Math.PI / 180) + this.simplifyAngle(adouble1[0] - adouble[0]) * ((float)Math.PI / 180);
                    float f20 = net.minecraft.util.math.MathHelper.func_76126_a((float)f7);
                    float f21 = net.minecraft.util.math.MathHelper.func_76134_b((float)f7);
                    float f22 = 1.5f;
                    float f23 = (float)(k + 1) * 2.0f;
                    this.setPartPosition(enderdragonpartentity, -(f3 * 1.5f + f20 * f23) * f16, adouble1[1] - adouble[1] - (double)((f23 + 1.5f) * f2) + 1.5, (f18 * 1.5f + f21 * f23) * f16);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.slowed = this.destroyBlocksInAABB(this.dragonPartHead.func_174813_aQ()) | this.destroyBlocksInAABB(this.dragonPartNeck.func_174813_aQ()) | this.destroyBlocksInAABB(this.dragonPartBody.func_174813_aQ());
                    if (this.fightManager != null) {
                        this.fightManager.guardianUpdate(this);
                    }
                }
                for (int l = 0; l < this.dragonParts.length; ++l) {
                    this.dragonParts[l].field_70169_q = avector3d[l].field_72450_a;
                    this.dragonParts[l].field_70167_r = avector3d[l].field_72448_b;
                    this.dragonParts[l].field_70166_s = avector3d[l].field_72449_c;
                    this.dragonParts[l].field_70142_S = avector3d[l].field_72450_a;
                    this.dragonParts[l].field_70137_T = avector3d[l].field_72448_b;
                    this.dragonParts[l].field_70136_U = avector3d[l].field_72449_c;
                }
            }
        }
    }

    private void setPartPosition(DraconicGuardianPartEntity part, double offsetX, double offsetY, double offsetZ) {
        part.func_70107_b(this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
    }

    private float getHeadAndNeckYOffset() {
        if (this.phaseManager.getCurrentPhase().getIsStationary()) {
            return -1.0f;
        }
        double[] adouble = this.getMovementOffsets(5, 1.0f);
        double[] adouble1 = this.getMovementOffsets(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    private void updateDragonEnderCrystal() {
        if (this.closestGuardianCrystal != null) {
            if (!this.closestGuardianCrystal.func_70089_S()) {
                this.closestGuardianCrystal = null;
            } else if (this.field_70173_aa % 10 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70606_j(this.func_110143_aJ() + 1.0f);
            }
        }
        if (this.field_70146_Z.nextInt(10) == 0 && !this.field_70170_p.field_72995_K) {
            if (this.fightManager != null) {
                this.closestGuardianCrystal = this.fightManager.getCrystals().stream().min(Comparator.comparingDouble(arg_0 -> ((DraconicGuardianEntity)this).func_70068_e(arg_0))).orElse(null);
            } else {
                List list = this.field_70170_p.func_217357_a(GuardianCrystalEntity.class, this.func_174813_aQ().func_186662_g(32.0));
                GuardianCrystalEntity crystal = null;
                double d0 = Double.MAX_VALUE;
                for (GuardianCrystalEntity endercrystalentity1 : list) {
                    double d1 = endercrystalentity1.func_70068_e((Entity)this);
                    if (!(d1 < d0)) continue;
                    d0 = d1;
                    crystal = endercrystalentity1;
                }
                this.closestGuardianCrystal = crystal;
            }
            this.func_184212_Q().func_187227_b(CRYSTAL_ID, (Object)(this.closestGuardianCrystal == null ? -1 : this.closestGuardianCrystal.func_145782_y()));
        }
    }

    private void collideWithEntities(List<Entity> entities) {
        double d0 = (this.dragonPartBody.func_174813_aQ().field_72340_a + this.dragonPartBody.func_174813_aQ().field_72336_d) / 2.0;
        double d1 = (this.dragonPartBody.func_174813_aQ().field_72339_c + this.dragonPartBody.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            double d2 = entity.func_226277_ct_() - d0;
            double d3 = entity.func_226281_cx_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.func_70024_g(d2 / d4 * 4.0, (double)0.2f, d3 / d4 * 4.0);
            if (this.phaseManager.getCurrentPhase().getIsStationary() || ((LivingEntity)entity).func_142015_aE() >= entity.field_70173_aa - 2) continue;
            entity.func_70097_a((DamageSource)new EntityDamageSource("draconicevolution.draconic_guardian", (Entity)this), 15.0f);
            this.func_174815_a((LivingEntity)this, entity);
        }
    }

    private void attackEntitiesInList(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.func_70097_a((DamageSource)new EntityDamageSource("draconicevolution.draconic_guardian", (Entity)this), 20.0f);
            this.func_174815_a((LivingEntity)this, entity);
        }
    }

    private float simplifyAngle(double angle) {
        return (float)net.minecraft.util.math.MathHelper.func_76138_g((double)angle);
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB area) {
        int i = net.minecraft.util.math.MathHelper.func_76128_c((double)area.field_72340_a);
        int j = net.minecraft.util.math.MathHelper.func_76128_c((double)area.field_72338_b);
        int k = net.minecraft.util.math.MathHelper.func_76128_c((double)area.field_72339_c);
        int l = net.minecraft.util.math.MathHelper.func_76128_c((double)area.field_72336_d);
        int i1 = net.minecraft.util.math.MathHelper.func_76128_c((double)area.field_72337_e);
        int j1 = net.minecraft.util.math.MathHelper.func_76128_c((double)area.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                    Block block = blockstate.func_177230_c();
                    if (blockstate.isAir((IBlockReader)this.field_70170_p, blockpos) || blockstate.func_185904_a() == Material.field_151581_o) continue;
                    if (ForgeHooks.canEntityDestroy((World)this.field_70170_p, (BlockPos)blockpos, (LivingEntity)this) && !BlockTags.field_219754_W.func_230235_a_((Object)block) && block != Blocks.field_196653_dH && block != Blocks.field_196575_bC) {
                        flag1 = this.field_70170_p.func_217377_a(blockpos, false) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + this.field_70146_Z.nextInt(l - i + 1), j + this.field_70146_Z.nextInt(i1 - j + 1), k + this.field_70146_Z.nextInt(j1 - k + 1));
            this.field_70170_p.func_217379_c(2008, blockpos1, 0);
        }
        return flag;
    }

    public boolean attackEntityPartFrom(DraconicGuardianPartEntity part, DamageSource source, float damage) {
        if (this.phaseManager.getCurrentPhase().getType() == PhaseType.DYING) {
            return false;
        }
        float shieldPower = this.getShieldPower();
        if (shieldPower > 0.0f) {
            BCoreNetwork.sendSound((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (SoundEvent)DESounds.shieldStrike, (SoundCategory)SoundCategory.HOSTILE, (float)20.0f, (float)(this.field_70146_Z.nextFloat() * 0.2f + 0.9f), (boolean)false);
        }
        if (this.hitCoolDown > 0 && damage < this.lastDamage * 1.1f) {
            this.lastDamage = damage;
            return false;
        }
        this.lastDamage = damage;
        this.hitCoolDown = 5;
        if (this.fightManager != null && !this.fightManager.onGuardianAttacked(this, source, damage)) {
            this.phaseManager.getCurrentPhase().onAttacked(source, damage, shieldPower, false);
            return false;
        }
        damage = this.phaseManager.getCurrentPhase().onAttacked(source, damage, shieldPower, true);
        if (damage > 500.0f) {
            damage = 500.0f;
        }
        if ((shieldPower -= Math.min(shieldPower, damage)) > 0.0f) {
            this.setShieldPower(shieldPower);
            return true;
        }
        damage -= this.getShieldPower();
        this.setShieldPower(0.0f);
        if (damage > 100.0f) {
            damage = 100.0f;
        }
        if (part != this.dragonPartHead) {
            damage = damage / 4.0f + Math.min(damage, 1.0f);
        }
        if (damage < 0.01f) {
            return false;
        }
        if (source.func_76346_g() instanceof PlayerEntity || source.func_94541_c()) {
            this.attackDragonFrom(source, damage);
            if (this.func_233643_dh_() && !this.phaseManager.getCurrentPhase().getIsStationary()) {
                this.func_70606_j(1.0f);
                this.phaseManager.setPhase(PhaseType.DYING);
            }
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
            this.attackEntityPartFrom(this.dragonPartBody, source, amount);
        }
        return false;
    }

    protected boolean attackDragonFrom(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    public void func_174812_G() {
        this.func_70106_y();
        if (this.fightManager != null) {
            this.fightManager.guardianUpdate(this);
            this.fightManager.processDragonDeath(this);
        }
    }

    protected void func_70609_aI() {
        if (this.fightManager != null) {
            this.fightManager.guardianUpdate(this);
        }
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_() + (double)f, this.func_226278_cu_() + 2.0 + (double)f1, this.func_226281_cx_() + (double)f2, 0.0, 0.0, 0.0);
        }
        boolean flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e);
        int xpAmount = 24000;
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0 && flag) {
                this.dropExperience(net.minecraft.util.math.MathHelper.func_76141_d((float)((float)xpAmount * 0.08f)));
            }
            if (this.deathTicks == 1 && !this.func_174814_R()) {
                this.field_70170_p.func_175669_a(1028, this.func_233580_cy_(), 0);
            }
        }
        this.func_213315_a(MoverType.SELF, new Vector3d(0.0, (double)0.1f, 0.0));
        this.field_70177_z += 20.0f;
        this.field_70761_aq = this.field_70177_z;
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            if (flag) {
                this.dropExperience(net.minecraft.util.math.MathHelper.func_76141_d((float)((float)xpAmount * 0.2f)));
            }
            if (this.fightManager != null) {
                this.fightManager.processDragonDeath(this);
            }
            this.func_70106_y();
        }
    }

    private void dropExperience(int xp) {
        while (xp > 0) {
            int i = ExperienceOrbEntity.func_70527_a((int)xp);
            xp -= i;
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), i));
        }
    }

    public int initPathPoints(boolean regenerate) {
        if (this.pathPoints[0] == null || regenerate) {
            if (this.getArenaOrigin() == null) {
                this.setArenaOrigin(this.func_233580_cy_());
            }
            BlockPos arenaOrigin = this.getArenaOrigin();
            for (int i = 0; i < 24; ++i) {
                float loopPos = (float)i / 24.0f;
                float angle = loopPos * 360.0f;
                int pointX = MathHelper.floor((double)(70.0 * Math.cos((double)angle * 0.017453292519943)));
                int pointZ = MathHelper.floor((double)(70.0 * Math.sin((double)angle * 0.017453292519943)));
                int pointY = Math.max(arenaOrigin.func_177956_o() + 40, this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(pointX, 0, pointZ)).func_177956_o());
                this.pathPoints[i] = new PathPoint(arenaOrigin.func_177958_n() + pointX, pointY, arenaOrigin.func_177952_p() + pointZ);
            }
        }
        return this.getNearestPpIdx(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public int getNearestPpIdx(double x, double y, double z) {
        float f = 10000.0f;
        int i = 0;
        PathPoint pathpoint = new PathPoint(net.minecraft.util.math.MathHelper.func_76128_c((double)x), net.minecraft.util.math.MathHelper.func_76128_c((double)y), net.minecraft.util.math.MathHelper.func_76128_c((double)z));
        int j = 0;
        if (this.fightManager == null || this.fightManager.getNumAliveCrystals() == 0) {
            j = 12;
        }
        for (int k = j; k < 24; ++k) {
            float f1;
            if (this.pathPoints[k] == null || !((f1 = this.pathPoints[k].func_75832_b(pathpoint)) < f)) continue;
            f = f1;
            i = k;
        }
        return i;
    }

    @Nullable
    public Path findPath(int startIdx, int finishIdx, @Nullable PathPoint andThen) {
        for (int i = 0; i < 24; ++i) {
            PathPoint pathpoint = this.pathPoints[i];
            pathpoint.field_75842_i = false;
            pathpoint.field_75834_g = 0.0f;
            pathpoint.field_75836_e = 0.0f;
            pathpoint.field_75833_f = 0.0f;
            pathpoint.field_75841_h = null;
            pathpoint.field_75835_d = -1;
        }
        PathPoint startPoint = this.pathPoints[startIdx];
        PathPoint endPoint = this.pathPoints[finishIdx];
        startPoint.field_75836_e = 0.0f;
        startPoint.field_75834_g = startPoint.field_75833_f = startPoint.func_75829_a(endPoint);
        this.pathFindQueue.func_75848_a();
        this.pathFindQueue.func_75849_a(startPoint);
        PathPoint nextPoint = startPoint;
        int startIndex = 0;
        while (!this.pathFindQueue.func_75845_e()) {
            PathPoint testPoint = this.pathFindQueue.func_75844_c();
            if (testPoint.equals((Object)endPoint)) {
                if (andThen != null) {
                    andThen.field_75841_h = endPoint;
                    endPoint = andThen;
                }
                return this.makePath(startPoint, endPoint);
            }
            if (testPoint.func_75832_b(endPoint) < nextPoint.func_75832_b(endPoint)) {
                nextPoint = testPoint;
            }
            testPoint.field_75842_i = true;
            int testPointIntex = 0;
            for (int l = 0; l < 24; ++l) {
                if (this.pathPoints[l] != testPoint) continue;
                testPointIntex = l;
                break;
            }
            for (int index = startIndex; index < 24; ++index) {
                PathPoint pathpoint3 = this.pathPoints[index];
                if (pathpoint3.field_75842_i) continue;
                float f = testPoint.field_75836_e + testPoint.func_75829_a(pathpoint3);
                if (pathpoint3.func_75831_a() && !(f < pathpoint3.field_75836_e)) continue;
                pathpoint3.field_75841_h = testPoint;
                pathpoint3.field_75836_e = f;
                pathpoint3.field_75833_f = pathpoint3.func_75829_a(endPoint);
                if (pathpoint3.func_75831_a()) {
                    this.pathFindQueue.func_75850_a(pathpoint3, pathpoint3.field_75836_e + pathpoint3.field_75833_f);
                    continue;
                }
                pathpoint3.field_75834_g = pathpoint3.field_75836_e + pathpoint3.field_75833_f;
                this.pathFindQueue.func_75849_a(pathpoint3);
            }
        }
        if (nextPoint == startPoint) {
            return null;
        }
        LOGGER.debug("Failed to find path from {} to {}", (Object)startIdx, (Object)finishIdx);
        if (andThen != null) {
            andThen.field_75841_h = nextPoint;
            nextPoint = andThen;
        }
        return this.makePath(startPoint, nextPoint);
    }

    private Path makePath(PathPoint start, PathPoint finish) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint = finish;
        list.add(0, finish);
        while (pathpoint.field_75841_h != null) {
            pathpoint = pathpoint.field_75841_h;
            list.add(0, pathpoint);
        }
        return new Path((List)list, new BlockPos(finish.field_75839_a, finish.field_75837_b, finish.field_75838_c), true);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("dragon_phase", this.phaseManager.getCurrentPhase().getType().getId());
        if (this.getArenaOrigin() != null) {
            compound.func_218657_a("arena_origin", (INBT)NBTUtil.func_186859_a((BlockPos)this.getArenaOrigin()));
        }
        compound.func_74776_a("shield_power", this.getShieldPower());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("dragon_phase")) {
            this.phaseManager.setPhase(PhaseType.getById(compound.func_74762_e("dragon_phase")));
        }
        if (compound.func_74764_b("arena_origin")) {
            this.setArenaOrigin(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("arena_origin")));
        }
        if (this.field_70170_p instanceof ServerWorld) {
            this.fightManager = WorldEntityHandler.getWorldEntities().stream().filter(e -> e instanceof GuardianFightManager).map(e -> (GuardianFightManager)((Object)e)).filter(e -> this.func_110124_au().equals(e.getGuardianUniqueId())).findFirst().orElse(null);
            if (this.fightManager != null) {
                this.setArenaOrigin(this.fightManager.getArenaOrigin());
            }
        } else {
            this.fightManager = null;
        }
        if (compound.func_150297_b("shield_power", 5)) {
            this.setShieldPower(compound.func_74760_g("shield_power"));
        }
    }

    public void func_70623_bb() {
    }

    public DraconicGuardianPartEntity[] getDragonParts() {
        return this.dragonParts;
    }

    public boolean func_70067_L() {
        return false;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187521_aK;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187526_aP;
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadPartYOffset(int p_184667_1_, double[] spineEndOffsets, double[] headPartOffsets) {
        IPhase iphase = this.phaseManager.getCurrentPhase();
        PhaseType<? extends IPhase> phasetype = iphase.getType();
        double d0 = iphase.getIsStationary() ? (double)p_184667_1_ : (p_184667_1_ == 6 ? 0.0 : headPartOffsets[1] - spineEndOffsets[1]);
        return (float)d0;
    }

    public Vector3d getHeadLookVec(float partialTicks) {
        Vector3d vector3d;
        IPhase iphase = this.phaseManager.getCurrentPhase();
        PhaseType<? extends IPhase> phasetype = iphase.getType();
        if (iphase.getIsStationary()) {
            float f4 = this.field_70125_A;
            float f5 = 1.5f;
            this.field_70125_A = -45.0f;
            vector3d = this.func_70676_i(partialTicks);
            this.field_70125_A = f4;
        } else {
            vector3d = this.func_70676_i(partialTicks);
        }
        return vector3d;
    }

    public void onCrystalAttacked(GuardianCrystalEntity crystal, BlockPos pos, DamageSource dmgSrc, float damage, boolean destroyed) {
        PlayerEntity playerentity = dmgSrc.func_76346_g() instanceof PlayerEntity ? (PlayerEntity)dmgSrc.func_76346_g() : this.field_70170_p.func_217359_a(PLAYER_INVADER_CONDITION, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        if (crystal == this.closestGuardianCrystal && destroyed) {
            this.attackEntityPartFrom(this.dragonPartHead, DamageSource.func_188405_b((LivingEntity)playerentity), 10.0f);
        }
        this.phaseManager.getCurrentPhase().onCrystalAttacked(crystal, pos, dmgSrc, playerentity, damage, destroyed);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (PHASE.equals(key) && this.field_70170_p.field_72995_K) {
            this.phaseManager.setPhase(PhaseType.getById((Integer)this.func_184212_Q().func_187225_a(PHASE)));
        } else if (CRYSTAL_ID.equals(key) && this.field_70170_p.field_72995_K) {
            Entity entity;
            int id = (Integer)this.func_184212_Q().func_187225_a(CRYSTAL_ID);
            this.closestGuardianCrystal = id == -1 ? null : ((entity = this.field_70170_p.func_73045_a(id)) instanceof GuardianCrystalEntity ? (GuardianCrystalEntity)entity : null);
        }
        super.func_184206_a(key);
    }

    public PhaseManager getPhaseManager() {
        return this.phaseManager;
    }

    @Nullable
    public GuardianFightManager getFightManager() {
        return this.fightManager;
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        if (effectInstanceIn.func_188419_a().func_188408_i()) {
            return super.func_195064_c(effectInstanceIn);
        }
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Nullable
    public DraconicGuardianPartEntity[] getParts() {
        return this.dragonParts;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return super.func_213297_N();
    }
}

