/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.damage.DraconicIndirectEntityDamage;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class GuardianProjectileEntity
extends DamagingProjectileEntity
implements IEntityAdditionalSpawnData {
    private Vector3d target;
    private double splashRange = 15.0;
    private double power = 10.0;
    private DamageSource damageSource = new DamageSource("damage.draconicevolution.guardian_projectile").func_151518_m().func_76348_h().func_82726_p().func_94540_d();
    private double closestApproach;

    public GuardianProjectileEntity(EntityType<?> type, World world) {
        super(DEContent.guardianProjectile, world);
    }

    public GuardianProjectileEntity(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ, Vector3d target, double splashRange, double power) {
        super(DEContent.guardianProjectile, shooter, accelX, accelY, accelZ, worldIn);
        double accelDotProduct;
        this.target = target;
        this.splashRange = splashRange;
        this.power = power;
        this.damageSource = new DraconicIndirectEntityDamage("draconicevolution.guardian_projectile", (Entity)this, (Entity)shooter, TechLevel.CHAOTIC).func_151518_m().func_76348_h().func_82726_p().func_94540_d();
        if (target != null) {
            this.closestApproach = this.func_195048_a(target);
        }
        if ((accelDotProduct = (double)MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ))) != 0.0) {
            this.field_70232_b = accelX / accelDotProduct * 0.3;
            this.field_70233_c = accelY / accelDotProduct * 0.3;
            this.field_70230_d = accelZ / accelDotProduct * 0.3;
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        Entity shooter = this.func_234616_v_();
        if (!(result.func_216346_c() == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)result).func_216348_a().func_70028_i(shooter) || this.field_70170_p.field_72995_K)) {
            this.detonate();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.target != null) {
            double distSq = this.func_195048_a(this.target);
            if (distSq <= 1.0) {
                this.detonate();
            } else if (distSq < this.closestApproach) {
                this.closestApproach = distSq;
            } else if (this.field_70173_aa > 5) {
                this.detonate();
            }
        }
    }

    private void detonate() {
        GuardianFightManager manager;
        List list = this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(this.splashRange), EntityPredicates.field_188444_d);
        Entity shooter = this.func_234616_v_();
        for (LivingEntity entity : list) {
            double distance;
            double df;
            if (entity == shooter || (df = 1.0 - (distance = (double)entity.func_70032_d((Entity)this)) / this.power) <= 0.0) continue;
            float damage = (int)(((df *= (double)Explosion.func_222259_a((Vector3d)this.func_213303_ch(), (Entity)entity)) * df + df) / 2.0 * 6.0 * this.power + 1.0);
            entity.func_70097_a(this.damageSource, damage);
        }
        boolean destroy = false;
        if (shooter instanceof DraconicGuardianEntity && (manager = ((DraconicGuardianEntity)shooter).getFightManager()) != null && this.func_233580_cy_().func_177956_o() > manager.getArenaOrigin().func_177956_o() + 20) {
            destroy = true;
        }
        this.field_70170_p.func_217385_a(shooter, (double)this.func_233580_cy_().func_177958_n(), (double)this.func_233580_cy_().func_177956_o(), (double)this.func_233580_cy_().func_177952_p(), 8.0f, destroy ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
        DraconicNetwork.sendImpactEffect(this.field_70170_p, this.func_233580_cy_(), 0);
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197616_i;
    }

    protected boolean func_184564_k() {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
    }

    public void readSpawnData(PacketBuffer additionalData) {
    }
}

