/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import javax.annotation.Nullable;
import net.minecraft.util.math.vector.Vector3d;

public class ApproachPositionPhase
extends Phase {
    private Vector3d targetLocation;
    private PhaseType<?> nextPhase;
    private int startDistance = 0;

    public ApproachPositionPhase(DraconicGuardianEntity guardisn) {
        super(guardisn);
    }

    public PhaseType<ApproachPositionPhase> getType() {
        return PhaseType.APPROACH_POSITION;
    }

    public ApproachPositionPhase setTargetLocation(Vector3d targetLocation) {
        this.targetLocation = targetLocation;
        return this;
    }

    public ApproachPositionPhase setNextPhase(PhaseType<?> nextPhase) {
        this.nextPhase = nextPhase;
        return this;
    }

    @Override
    public void initPhase() {
        this.targetLocation = null;
        this.nextPhase = null;
        this.startDistance = -1;
    }

    @Override
    public void serverTick() {
        double distanceSqr;
        if (this.targetLocation == null || this.nextPhase == null) {
            this.debug("Cancel Approach: (Invalid)");
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
            return;
        }
        if (this.startDistance == -1) {
            this.startDistance = (int)Math.max(Math.sqrt(this.guardian.func_195048_a(this.targetLocation)), 32.0);
        }
        if ((distanceSqr = this.targetLocation.func_186679_c(this.guardian.func_226277_ct_(), this.guardian.func_226278_cu_(), this.guardian.func_226281_cx_())) > (double)((this.startDistance + 64) * (this.startDistance + 64))) {
            this.debug("Cancel Approach: (Moving away from target)");
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
            return;
        }
        if (distanceSqr < 25.0) {
            this.debug("Approach Complete");
            this.guardian.getPhaseManager().setPhase(this.nextPhase);
        }
    }

    @Override
    @Nullable
    public Vector3d getTargetLocation() {
        return this.targetLocation;
    }

    @Override
    public double getGuardianSpeed() {
        if (this.targetLocation == null) {
            return 1.0;
        }
        double td = this.guardian.func_195048_a(this.targetLocation);
        double distMod = td > 1024.0 ? 1.0 : Math.sqrt(td) / 32.0;
        return 0.2 + 2.0 * distMod;
    }

    @Override
    public boolean highVerticalAgility() {
        return true;
    }
}

