/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.api.ITeleportEndPoint;
import com.brandon3055.draconicevolution.entity.PersistentItemEntity;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class DislocatorLinkHandler
extends WorldSavedData {
    private static final String SAVE_DATA_NAME = "DECustomData";
    public Map<String, LinkData> linkDataMap = new HashMap<String, LinkData>();

    public DislocatorLinkHandler(String name) {
        super(name);
    }

    @Nullable
    public static DislocatorLinkHandler getDataInstance(World world) {
        if (world instanceof ServerWorld) {
            return (DislocatorLinkHandler)world.func_73046_m().func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(() -> new DislocatorLinkHandler(SAVE_DATA_NAME), SAVE_DATA_NAME);
        }
        return null;
    }

    public static void updateLink(World world, ItemStack stack, BlockPos pos, RegistryKey<World> dimension) {
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(world);
        if (data == null || world.field_72995_K || !DEContent.dislocator_p2p.isValid(stack)) {
            return;
        }
        String linkID = DEContent.dislocator_p2p.getLinkID(stack);
        LinkData link = data.linkDataMap.computeIfAbsent(linkID, s -> new LinkData(linkID, data));
        link.setTarget(pos, dimension);
    }

    public static void updateLink(World world, ItemStack stack, PlayerEntity player) {
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(world);
        if (data == null || world.field_72995_K || !DEContent.dislocator_p2p.isValid(stack)) {
            return;
        }
        String linkID = DEContent.dislocator_p2p.getLinkID(stack);
        LinkData link = data.linkDataMap.computeIfAbsent(linkID, s -> new LinkData(linkID, data));
        link.setTarget(player.func_146103_bH().getId().toString());
    }

    public static void removeLink(World world, ItemStack stack) {
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(world);
        if (data == null || world.field_72995_K || !DEContent.dislocator_p2p.isValid(stack)) {
            return;
        }
        String linkID = DEContent.dislocator_p2p.getLinkID(stack);
        data.linkDataMap.remove(linkID);
        data.func_76185_a();
    }

    public static Vec3D getLinkPos(World world, ItemStack stack) {
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(world);
        if (data == null || !DEContent.dislocator_p2p.isValid(stack)) {
            return null;
        }
        if (DEContent.dislocator_p2p.isPlayer(stack)) {
            return DislocatorLinkHandler.getPlayerPos(ItemNBTHelper.getString((ItemStack)stack, (String)"PlayerLink", (String)"null"), world);
        }
        String linkID = DEContent.dislocator_p2p.getLinkToID(stack);
        LinkData link = data.linkDataMap.get(linkID);
        if (link != null) {
            if (link.isPlayer) {
                return DislocatorLinkHandler.getAndValidatePlayerPos(world, data, link, linkID);
            }
            return DislocatorLinkHandler.getTileOrEntityPos(link, linkID);
        }
        return null;
    }

    public static Vec3D getLinkPos(World world, String linkID) {
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(world);
        if (data == null) {
            return null;
        }
        LinkData link = data.linkDataMap.get(linkID);
        if (link != null) {
            if (link.isPlayer) {
                return DislocatorLinkHandler.getAndValidatePlayerPos(world, data, link, linkID);
            }
            return DislocatorLinkHandler.getTileOrEntityPos(link, linkID);
        }
        return null;
    }

    public static TileEntity getTargetTile(World world, ItemStack stack) {
        String linkID;
        LinkData link;
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance(world);
        if (data == null || !DEContent.dislocator_p2p.isValid(stack)) {
            return null;
        }
        if (!DEContent.dislocator_p2p.isPlayer(stack) && (link = data.linkDataMap.get(linkID = DEContent.dislocator_p2p.getLinkToID(stack))) != null && !link.isPlayer) {
            MinecraftServer server = BrandonsCore.proxy.getMCServer();
            if (server == null) {
                return null;
            }
            ServerWorld targetWorld = server.func_71218_a(link.dimension);
            TileEntity tile = targetWorld.func_175625_s(link.pos);
            if (tile instanceof ITeleportEndPoint) {
                return tile;
            }
        }
        return null;
    }

    private static Vec3D getAndValidatePlayerPos(World world, DislocatorLinkHandler data, LinkData link, String linkID) {
        if (world.func_73046_m() == null) {
            return null;
        }
        PlayerList players = world.func_73046_m().func_184103_al();
        ServerPlayerEntity player = players.func_177451_a(UUID.fromString(link.playerUUID));
        boolean flag = DataUtils.firstMatch((Iterable)player.field_71071_by.field_70462_a, stack -> DEContent.dislocator_p2p.isValid((ItemStack)stack) && DEContent.dislocator_p2p.getLinkID((ItemStack)stack).equals(linkID)) != null;
        boolean bl = flag = flag || DataUtils.firstMatch((Iterable)player.field_71071_by.field_184439_c, stack -> DEContent.dislocator_p2p.isValid((ItemStack)stack) && DEContent.dislocator_p2p.getLinkID((ItemStack)stack).equals(linkID)) != null;
        if (!flag) {
            data.linkDataMap.remove(linkID);
            data.func_76185_a();
            return null;
        }
        return new Vec3D((Entity)player);
    }

    private static Vec3D getTileOrEntityPos(LinkData link, String linkID) {
        MinecraftServer server = BrandonsCore.proxy.getMCServer();
        if (server == null) {
            return null;
        }
        ServerWorld targetWorld = server.func_71218_a(link.dimension);
        TileEntity tile = targetWorld.func_175625_s(link.pos);
        if (tile instanceof ITeleportEndPoint) {
            BlockPos tilePos = ((ITeleportEndPoint)tile).getArrivalPos(linkID);
            if (tilePos == null) {
                return null;
            }
            return new Vec3D((double)tilePos.func_177958_n() + 0.5, (double)tilePos.func_177956_o() + 0.2, (double)tilePos.func_177952_p() + 0.5);
        }
        AxisAlignedBB bb = new AxisAlignedBB(link.pos, link.pos.func_177982_a(1, 1, 1));
        bb.func_186662_g(5.0);
        List items = targetWorld.func_217357_a(PersistentItemEntity.class, bb);
        for (PersistentItemEntity item : items) {
            String l;
            ItemStack i = item.func_92059_d();
            if (!DEContent.dislocator_p2p.isValid(i) || !(l = DEContent.dislocator_p2p.getLinkID(i)).equals(linkID)) continue;
            return new Vec3D((Entity)item);
        }
        return null;
    }

    public static LinkData getLink(ItemStack stack, ServerWorld world) {
        DislocatorLinkHandler data = DislocatorLinkHandler.getDataInstance((World)world);
        if (data == null || !DEContent.dislocator_p2p.isValid(stack)) {
            return null;
        }
        return data.linkDataMap.get(DEContent.dislocator_p2p.getLinkToID(stack));
    }

    public static Vec3D getPlayerPos(String playerID, World world) {
        if (world.func_73046_m() == null) {
            return null;
        }
        PlayerList players = world.func_73046_m().func_184103_al();
        ServerPlayerEntity player = players.func_177451_a(UUID.fromString(playerID));
        return player == null ? null : new Vec3D((Entity)player);
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.linkDataMap.clear();
        ListNBT dataList = nbt.func_150295_c("LinkList", 10);
        dataList.forEach(nbtBase -> {
            LinkData data = new LinkData(this).fromNBT((CompoundNBT)nbtBase);
            this.linkDataMap.put(data.linkID, data);
        });
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT dataList = new ListNBT();
        this.linkDataMap.forEach((id, linkData) -> dataList.add((Object)linkData.toNBT(new CompoundNBT())));
        compound.func_218657_a("LinkList", (INBT)dataList);
        return compound;
    }

    public static class LinkData {
        private String linkID;
        public DislocatorLinkHandler handler;
        public BlockPos pos = new BlockPos(0, 128, 0);
        public RegistryKey<World> dimension;
        private String playerUUID;
        public boolean isPlayer = false;

        public LinkData(DislocatorLinkHandler handler) {
            this.handler = handler;
        }

        public LinkData(String linkID, DislocatorLinkHandler handler) {
            this.linkID = linkID;
            this.handler = handler;
        }

        public void setTarget(BlockPos pos, RegistryKey<World> dimension) {
            this.pos = pos;
            this.dimension = dimension;
            this.isPlayer = false;
            this.handler.func_76185_a();
        }

        public void setTarget(String playerUUID) {
            this.playerUUID = playerUUID;
            this.isPlayer = true;
            this.handler.func_76185_a();
        }

        public CompoundNBT toNBT(CompoundNBT compound) {
            compound.func_74778_a("LinkID", this.linkID);
            compound.func_74757_a("IsPlayer", this.isPlayer);
            compound.func_74778_a("Dim", this.dimension.func_240901_a_().toString());
            if (this.isPlayer) {
                compound.func_74778_a("PlayerID", this.playerUUID);
            } else {
                compound.func_74772_a("Pos", this.pos.func_218275_a());
            }
            return compound;
        }

        public LinkData fromNBT(CompoundNBT compound) {
            this.linkID = compound.func_74779_i("LinkID");
            this.isPlayer = compound.func_74767_n("IsPlayer");
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("Dim")));
            if (this.isPlayer) {
                this.playerUUID = compound.func_74779_i("PlayerID");
            } else {
                this.pos = BlockPos.func_218283_e((long)compound.func_74763_f("Pos"));
            }
            return this;
        }
    }
}

