/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.IOPStorageModifiable;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.JumpData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.entities.FlightEntity;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.api.modules.entities.UndyingEntity;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import com.brandon3055.draconicevolution.items.equipment.ModularChestpiece;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="draconicevolution", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModularArmorEventHandler {
    private static final EquipmentSlotType[] ARMOR_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.FEET, EquipmentSlotType.LEGS, EquipmentSlotType.CHEST, EquipmentSlotType.HEAD};
    public static final UUID WALK_SPEED_UUID = UUID.fromString("0ea6ce8e-d2e8-11e5-ab30-625662870761");
    private static final DamageSource KILL_COMMAND = new DamageSource("administrative.kill").func_76359_i().func_76348_h().func_151518_m();
    public static Map<PlayerEntity, Boolean> playersWithFlight = new WeakHashMap<PlayerEntity, Boolean>();
    public static List<UUID> playersWithUphillStep = new ArrayList<UUID>();

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityAttacked(LivingAttackEvent event) {
        if (event.isCanceled() || event.getAmount() <= 0.0f || event.getEntityLiving().field_70170_p.field_72995_K || event.getSource() == KILL_COMMAND) {
            return;
        }
        if (event.getAmount() == Float.MAX_VALUE && event.getSource() == DamageSource.field_76380_i) {
            event.setCanceled(true);
            event.getEntityLiving().func_70097_a(KILL_COMMAND, Float.MAX_VALUE);
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        ItemStack chestStack = ModularChestpiece.getChestpiece(entity);
        LazyOptional optionalHost = chestStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
        if (chestStack.func_190926_b() || !optionalHost.isPresent()) {
            return;
        }
        ModuleHost host = (ModuleHost)optionalHost.orElseThrow(IllegalStateException::new);
        if (host.getEntitiesByType(ModuleTypes.UNDYING).anyMatch(module -> ((UndyingEntity)module).tryBlockDamage(event))) {
            return;
        }
        ShieldControlEntity shieldControl = host.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null);
        if (shieldControl == null) {
            return;
        }
        shieldControl.tryBlockDamage(event);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityDamaged(LivingDamageEvent event) {
        if (event.isCanceled() || event.getAmount() <= 0.0f || event.getEntityLiving().field_70170_p.field_72995_K || event.getSource() == KILL_COMMAND) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        ItemStack chestStack = ModularChestpiece.getChestpiece(entity);
        LazyOptional optionalHost = chestStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
        if (chestStack.func_190926_b() || !optionalHost.isPresent()) {
            return;
        }
        ModuleHost host = (ModuleHost)optionalHost.orElseThrow(IllegalStateException::new);
        if (host.getEntitiesByType(ModuleTypes.UNDYING).anyMatch(module -> ((UndyingEntity)module).tryBlockDamage(event))) {
            return;
        }
        ShieldControlEntity shieldControl = host.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null);
        if (shieldControl == null) {
            return;
        }
        shieldControl.tryBlockDamage(event);
    }

    @SubscribeEvent
    public static void onEntityFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntityLiving();
        float jumpBoost = ModularArmorEventHandler.getJumpBoost(entity, true);
        if (jumpBoost > 0.0f) {
            event.setDistance(Math.max(0.0f, event.getDistance() - (jumpBoost *= 2.0f)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.isCanceled() || event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        ArrayList<UndyingEntity> undyingModules = new ArrayList<UndyingEntity>();
        if (entity instanceof PlayerEntity) {
            EquipmentSlotType[] player = (EquipmentSlotType[])entity;
            NonNullList stacks = player.field_71071_by.field_70462_a;
            for (int i = 0; i < stacks.size(); ++i) {
                ModularArmorEventHandler.getUndyingEntities((ItemStack)stacks.get(i), undyingModules, (EquipmentSlotType)(player.field_71071_by.field_70461_c == i ? EquipmentSlotType.MAINHAND : null), false);
            }
            for (EquipmentSlotType slot : ARMOR_SLOTS) {
                ModularArmorEventHandler.getUndyingEntities((ItemStack)player.field_71071_by.field_70460_b.get(slot.func_188454_b()), undyingModules, slot, false);
            }
            for (ItemStack stack : player.field_71071_by.field_184439_c) {
                ModularArmorEventHandler.getUndyingEntities(stack, undyingModules, EquipmentSlotType.OFFHAND, false);
            }
            for (ItemStack stack : EquipmentManager.getAllItems(entity)) {
                ModularArmorEventHandler.getUndyingEntities(stack, undyingModules, null, true);
            }
        } else if (EquipmentManager.equipModLoaded()) {
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                ModularArmorEventHandler.getUndyingEntities(entity.func_184582_a(slot), undyingModules, slot, true);
            }
        }
        if (undyingModules.isEmpty() || event.getSource() == KILL_COMMAND) {
            return;
        }
        boolean blocked = undyingModules.stream().sorted(Comparator.comparing(e -> e.getModule().getModuleTechLevel().index)).anyMatch(e -> e.tryBlockDeath(event));
        if (blocked) {
            event.setCanceled(true);
        }
    }

    private static void getUndyingEntities(ItemStack stack, List<UndyingEntity> entities, EquipmentSlotType slot, boolean inEquipModSlot) {
        LazyOptional optional = stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IModularItem && ((IModularItem)stack.func_77973_b()).isEquipped(stack, slot, inEquipModSlot)) {
            optional.ifPresent(host -> entities.addAll(host.getModuleEntities().stream().filter(e -> e instanceof UndyingEntity).map(e -> (UndyingEntity)e).collect(Collectors.toList())));
        }
    }

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ArmorAbilities armorAbilities = new ArmorAbilities();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            NonNullList stacks = player.field_71071_by.field_70462_a;
            for (int i = 0; i < stacks.size(); ++i) {
                ModularArmorEventHandler.tryTickStack((ItemStack)stacks.get(i), (LivingEntity)player, (EquipmentSlotType)(player.field_71071_by.field_70461_c == i ? EquipmentSlotType.MAINHAND : null), armorAbilities, false);
            }
            for (EquipmentSlotType slot : ARMOR_SLOTS) {
                ModularArmorEventHandler.tryTickStack((ItemStack)player.field_71071_by.field_70460_b.get(slot.func_188454_b()), (LivingEntity)player, slot, armorAbilities, false);
            }
            for (ItemStack stack2 : player.field_71071_by.field_184439_c) {
                ModularArmorEventHandler.tryTickStack(stack2, (LivingEntity)player, EquipmentSlotType.OFFHAND, armorAbilities, false);
            }
            if (EquipmentManager.equipModLoaded()) {
                EquipmentManager.findItems(e -> e.func_77973_b() instanceof IModularItem, entity).forEach(stack -> ModularArmorEventHandler.tryTickStack(stack, (LivingEntity)player, null, armorAbilities, true));
            }
        } else {
            for (PlayerEntity slot : EquipmentSlotType.values()) {
                ModularArmorEventHandler.tryTickStack(entity.func_184582_a((EquipmentSlotType)slot), entity, (EquipmentSlotType)slot, armorAbilities, false);
            }
        }
        if (entity.field_70170_p.field_72995_K) {
            boolean hasHighStep;
            ItemStack chestStack = ModularChestpiece.getChestpiece(entity);
            LazyOptional optional = chestStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
            boolean hasHost = !chestStack.func_190926_b() && optional.isPresent();
            boolean highStepListed = playersWithUphillStep.contains(entity.func_110124_au()) && entity.field_70138_W >= 1.0f;
            boolean bl = hasHighStep = hasHost && ((ModuleHost)optional.orElseThrow(IllegalStateException::new)).getEntitiesByType(ModuleTypes.HILL_STEP).findAny().isPresent();
            if (hasHighStep && !highStepListed) {
                playersWithUphillStep.add(entity.func_110124_au());
                entity.field_70138_W = 1.0625f;
            }
            if (!hasHighStep && highStepListed) {
                playersWithUphillStep.remove(entity.func_110124_au());
                entity.field_70138_W = 0.6f;
            }
        }
        Attribute speedAttr = Attributes.field_233821_d_;
        double speedModifier = 0.0;
        if (armorAbilities.data != null) {
            speedModifier = armorAbilities.data.getSpeedMultiplier();
            if (entity.func_70051_ag() && armorAbilities.speedSettingRun != -1.0f) {
                speedModifier = Math.min(speedModifier, (double)armorAbilities.speedSettingRun);
            } else if (armorAbilities.speedSetting != -1.0f) {
                speedModifier = Math.min(speedModifier, (double)armorAbilities.speedSetting);
            }
        }
        AttributeModifier currentModifier = entity.func_110148_a(speedAttr).func_111127_a(WALK_SPEED_UUID);
        if (speedModifier > 0.0) {
            if (currentModifier == null) {
                entity.func_110148_a(speedAttr).func_233767_b_(new AttributeModifier(WALK_SPEED_UUID, speedAttr.func_233754_c_(), speedModifier, AttributeModifier.Operation.MULTIPLY_BASE));
            } else if (currentModifier.func_111164_d() != speedModifier) {
                entity.func_110148_a(speedAttr).func_111124_b(currentModifier);
                entity.func_110148_a(speedAttr).func_233767_b_(new AttributeModifier(WALK_SPEED_UUID, speedAttr.func_233754_c_(), speedModifier, AttributeModifier.Operation.MULTIPLY_BASE));
            }
            if (!entity.func_233570_aj_() && entity.func_184187_bx() == null) {
                entity.field_70747_aH = 0.02f + 0.02f * (float)speedModifier;
            }
        } else if (currentModifier != null) {
            entity.func_110148_a(speedAttr).func_111124_b(currentModifier);
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            boolean canFly = true;
            boolean noPower = false;
            if (armorAbilities.creativeFlight && armorAbilities.flightPower != null && !player.field_71075_bZ.field_75098_d) {
                canFly = armorAbilities.flightPower.getOPStored() >= (long)EquipCfg.creativeFlightEnergy;
                boolean bl = noPower = !canFly;
                if (canFly && player.field_71075_bZ.field_75100_b && !entity.field_70170_p.field_72995_K) {
                    if (armorAbilities.flightPower instanceof IOPStorageModifiable) {
                        ((IOPStorageModifiable)armorAbilities.flightPower).modifyEnergyStored((long)(-EquipCfg.creativeFlightEnergy));
                    } else {
                        armorAbilities.flightPower.extractOP((long)EquipCfg.creativeFlightEnergy, false);
                    }
                }
            }
            if (armorAbilities.creativeFlight && canFly) {
                player.field_71075_bZ.field_75101_c = true;
                playersWithFlight.put(player, true);
            } else {
                if (!playersWithFlight.containsKey(player)) {
                    playersWithFlight.put(player, false);
                }
                if (playersWithFlight.get(player).booleanValue() && !entity.field_70170_p.field_72995_K) {
                    playersWithFlight.put(player, false);
                    if (!player.field_71075_bZ.field_75098_d) {
                        boolean wasFlying = player.field_71075_bZ.field_75100_b;
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                        player.func_71016_p();
                        if (wasFlying && noPower) {
                            player.func_226566_ei_();
                        }
                    }
                }
                if (player.field_70170_p.field_72995_K && playersWithFlight.get(player).booleanValue()) {
                    playersWithFlight.put(player, false);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                    }
                }
            }
        }
    }

    private static float getJumpBoost(LivingEntity entity, boolean max) {
        ModuleHost host;
        JumpData jumpData;
        ItemStack chestStack = ModularChestpiece.getChestpiece(entity);
        LazyOptional optional = chestStack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
        if (optional.isPresent() && (jumpData = (host = (ModuleHost)optional.orElseThrow(IllegalStateException::new)).getModuleData(ModuleTypes.JUMP_BOOST)) != null) {
            double jump = jumpData.getMultiplier();
            if (max) {
                return (float)jump;
            }
            if (entity.func_70051_ag()) {
                if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasDecimal("jump_boost_run")) {
                    jump = Math.min(jump, ((PropertyProvider)((Object)host)).getDecimal("jump_boost_run").getValue());
                }
            } else if (host instanceof PropertyProvider && ((PropertyProvider)((Object)host)).hasDecimal("jump_boost")) {
                jump = Math.min(jump, ((PropertyProvider)((Object)host)).getDecimal("jump_boost").getValue());
            }
            return (float)jump;
        }
        return 0.0f;
    }

    private static void tryTickStack(ItemStack stack, LivingEntity entity, EquipmentSlotType slot, ArmorAbilities abilities, boolean equipMod) {
        if (stack.func_77973_b() instanceof IModularItem) {
            ((IModularItem)stack.func_77973_b()).handleTick(stack, entity, slot, equipMod);
            if (slot != null && slot.func_188453_a() == EquipmentSlotType.Group.ARMOR || equipMod) {
                LazyOptional optional = stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY);
                optional.ifPresent(host -> ModularArmorEventHandler.gatherArmorProps(stack, host, entity, abilities));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntityLiving();
        float jumpBoost = ModularArmorEventHandler.getJumpBoost(entity, false);
        if (jumpBoost > 0.0f && !entity.func_225608_bj_()) {
            entity.func_70024_g(0.0, (double)(0.1f * (jumpBoost + 1.0f)), 0.0);
        }
    }

    public static void gatherArmorProps(ItemStack stack, ModuleHost host, LivingEntity entity, ArmorAbilities abilities) {
        FlightEntity flight;
        SpeedData speed = host.getModuleData(ModuleTypes.SPEED);
        if (speed != null) {
            abilities.addSpeedData(speed, host);
        }
        if ((flight = (FlightEntity)host.getEntitiesByType(ModuleTypes.FLIGHT).map(e -> (FlightEntity)e).findAny().orElse(null)) != null) {
            LazyOptional optional = stack.getCapability(DECapabilities.OP_STORAGE);
            abilities.addFlightData(flight, optional.isPresent() ? (IOPStorage)optional.orElseThrow(IllegalStateException::new) : null);
        }
    }

    private static class ArmorAbilities {
        private float speedSetting = -1.0f;
        private float speedSettingRun = -1.0f;
        private SpeedData data;
        private boolean elytraFlight = false;
        private boolean creativeFlight = false;
        private IOPStorage flightPower = null;

        private ArmorAbilities() {
        }

        private void addSpeedData(SpeedData data, ModuleHost host) {
            SpeedData speedData = this.data = this.data == null ? data : this.data.combine(data);
            if (host instanceof PropertyProvider) {
                if (((PropertyProvider)((Object)host)).hasDecimal("run_speed")) {
                    if (this.speedSettingRun == -1.0f) {
                        this.speedSettingRun = 0.0f;
                    }
                    this.speedSettingRun = (float)((double)this.speedSettingRun + ((PropertyProvider)((Object)host)).getDecimal("run_speed").getValue());
                }
                if (((PropertyProvider)((Object)host)).hasDecimal("walk_speed")) {
                    if (this.speedSetting == -1.0f) {
                        this.speedSetting = 0.0f;
                    }
                    this.speedSetting = (float)((double)this.speedSetting + ((PropertyProvider)((Object)host)).getDecimal("walk_speed").getValue());
                }
            }
        }

        private void addFlightData(FlightEntity entity, IOPStorage flightPower) {
            this.elytraFlight = this.elytraFlight || entity.getElytraEnabled();
            boolean bl = this.creativeFlight = this.creativeFlight || entity.getCreativeEnabled();
            if (flightPower != null && (this.flightPower == null || flightPower.getOPStored() > this.flightPower.getOPStored())) {
                this.flightPower = flightPower;
            }
        }
    }
}

