/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.init;

import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.StandardConfigFile;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.lib.BaseModule;
import com.brandon3055.draconicevolution.init.DEModules;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.ResourceLocation;

public class ModuleCfg {
    private static ConfigTag moduleStats;
    private static Integer[] WYVERN_TOOLS;
    private static Integer[] DRACONIC_TOOLS;
    private static Integer[] CHAOTIC_TOOLS;
    private static Integer[] DRACONIC_STAFF;
    private static Integer[] CHAOTIC_STAFF;
    private static Integer[] WYVERN_CHESTPIECE;
    private static Integer[] DRACONIC_CHESTPIECE;
    private static Integer[] CHAOTIC_CHESTPIECE;
    private static Integer[] WYVERN_CAPACITOR;
    private static Integer[] DRACONIC_CAPACITOR;
    private static Integer[] CHAOTIC_CAPACITOR;
    public static int[] wyvernTools;
    public static int[] draconicTools;
    public static int[] chaoticTools;
    public static int[] draconicStaff;
    public static int[] chaoticStaff;
    public static int[] wyvernChestpiece;
    public static int[] draconicChestpiece;
    public static int[] chaoticChestpiece;
    public static int[] wyvernCapacitor;
    public static int[] draconicCapacitor;
    public static int[] chaoticCapacitor;
    public static boolean removeInvalidModules;

    public static void loadConfig(ConfigTag configTag) {
        ModuleCfg.loadModuleStatsConfig();
        ConfigTag moduleTag = configTag.getTag("Module Grids");
        moduleTag.setComment(new String[]{"These settings allow you to override the base module grid sizes for DE's modular items.", "The format is:", "\tI:\"configTag\" <", "\t\twidth", "\t\theight", "\t>", "Leave blank to use the internal default value.", "This value is listed in each properties description but may not be valid if this config was generated by a previous version of DE.", "Please note reducing grid size will not remove modules from existing items but will instead leave modules in an invalid state where they are", "still fully functional but installed outside of the grid bounds."});
        moduleTag.getTag("removeInvalidModules").setComment(new String[]{"(read category description)", "Setting this to true will cause invalid modules to be deleted from the module grid."}).setDefaultBoolean(false).setSyncCallback((tag, type) -> {
            removeInvalidModules = tag.getBoolean();
        });
        moduleTag.getTag("wyvernTools").setComment("Internal Default Value: " + WYVERN_TOOLS[0] + " x " + WYVERN_TOOLS[1]).setDefaultIntList(Collections.emptyList()).setSyncCallback((tag, type) -> {
            wyvernTools = ModuleCfg.getSize(tag, WYVERN_TOOLS);
        });
        moduleTag.getTag("draconicTools").setComment("Internal Default Value: " + DRACONIC_TOOLS[0] + " x " + DRACONIC_TOOLS[1]).setDefaultIntList(Collections.emptyList()).setSyncCallback((tag, type) -> {
            draconicTools = ModuleCfg.getSize(tag, DRACONIC_TOOLS);
        });
        moduleTag.getTag("chaoticTools").setComment("Internal Default Value: " + CHAOTIC_TOOLS[0] + " x " + CHAOTIC_TOOLS[1]).setDefaultIntList(Collections.emptyList()).setSyncCallback((tag, type) -> {
            chaoticTools = ModuleCfg.getSize(tag, CHAOTIC_TOOLS);
        });
        moduleTag.getTag("draconicStaff").setComment("Internal Default Value: " + DRACONIC_STAFF[0] + " x " + DRACONIC_STAFF[1]).setDefaultIntList(Collections.emptyList()).setSyncCallback((tag, type) -> {
            draconicStaff = ModuleCfg.getSize(tag, DRACONIC_STAFF);
        });
        moduleTag.getTag("chaoticStaff").setComment("Internal Default Value: " + CHAOTIC_STAFF[0] + " x " + CHAOTIC_STAFF[1]).setDefaultIntList(Collections.emptyList()).setSyncCallback((tag, type) -> {
            chaoticStaff = ModuleCfg.getSize(tag, CHAOTIC_STAFF);
        });
        moduleTag.getTag("wyvernChestpiece").setComment("Internal Default Value: " + WYVERN_CHESTPIECE[0] + " x " + WYVERN_CHESTPIECE[1]).setDefaultIntList(Collections.emptyList()).setSyncCallback((tag, type) -> {
            wyvernChestpiece = ModuleCfg.getSize(tag, WYVERN_CHESTPIECE);
        });
        moduleTag.getTag("draconicChestpiece").setComment("Internal Default Value: " + DRACONIC_CHESTPIECE[0] + " x " + DRACONIC_CHESTPIECE[1]).setDefaultIntList(Collections.emptyList()).setSyncCallback((tag, type) -> {
            draconicChestpiece = ModuleCfg.getSize(tag, DRACONIC_CHESTPIECE);
        });
        moduleTag.getTag("chaoticChestpiece").setComment("Internal Default Value: " + CHAOTIC_CHESTPIECE[0] + " x " + CHAOTIC_CHESTPIECE[1]).setDefaultIntList(Collections.emptyList()).setSyncCallback((tag, type) -> {
            chaoticChestpiece = ModuleCfg.getSize(tag, CHAOTIC_CHESTPIECE);
        });
        moduleTag.getTag("wyvernCapacitor").setComment("Internal Default Value: " + WYVERN_CAPACITOR[0] + " x " + WYVERN_CAPACITOR[1]).setDefaultIntList(Collections.emptyList()).setSyncCallback((tag, type) -> {
            wyvernCapacitor = ModuleCfg.getSize(tag, WYVERN_CAPACITOR);
        });
        moduleTag.getTag("draconicCapacitor").setComment("Internal Default Value: " + DRACONIC_CAPACITOR[0] + " x " + DRACONIC_CAPACITOR[1]).setDefaultIntList(Collections.emptyList()).setSyncCallback((tag, type) -> {
            draconicCapacitor = ModuleCfg.getSize(tag, DRACONIC_CAPACITOR);
        });
        moduleTag.getTag("chaoticCapacitor").setComment("Internal Default Value: " + CHAOTIC_CAPACITOR[0] + " x " + CHAOTIC_CAPACITOR[1]).setDefaultIntList(Collections.emptyList()).setSyncCallback((tag, type) -> {
            chaoticCapacitor = ModuleCfg.getSize(tag, CHAOTIC_CAPACITOR);
        });
        moduleTag.setSyncToClient();
    }

    private static int[] getSize(ConfigTag tag, Integer[] defaultValue) {
        List tagValue = tag.getIntList();
        return DataUtils.toPrimitive((Integer[])(tagValue.size() == 2 ? tagValue.toArray(new Integer[0]) : defaultValue));
    }

    public static int toolWidth(TechLevel techLevel) {
        switch (techLevel) {
            case WYVERN: {
                return wyvernTools[0];
            }
            case DRACONIC: {
                return draconicTools[0];
            }
            case CHAOTIC: {
                return chaoticTools[0];
            }
        }
        return 1;
    }

    public static int toolHeight(TechLevel techLevel) {
        switch (techLevel) {
            case WYVERN: {
                return wyvernTools[1];
            }
            case DRACONIC: {
                return draconicTools[1];
            }
            case CHAOTIC: {
                return chaoticTools[1];
            }
        }
        return 1;
    }

    public static int staffWidth(TechLevel techLevel) {
        switch (techLevel) {
            case DRACONIC: {
                return draconicStaff[0];
            }
            case CHAOTIC: {
                return chaoticStaff[0];
            }
        }
        return 1;
    }

    public static int staffHeight(TechLevel techLevel) {
        switch (techLevel) {
            case DRACONIC: {
                return draconicStaff[1];
            }
            case CHAOTIC: {
                return chaoticStaff[1];
            }
        }
        return 1;
    }

    public static int chestpieceWidth(TechLevel techLevel) {
        switch (techLevel) {
            case WYVERN: {
                return wyvernChestpiece[0];
            }
            case DRACONIC: {
                return draconicChestpiece[0];
            }
            case CHAOTIC: {
                return chaoticChestpiece[0];
            }
        }
        return 1;
    }

    public static int chestpieceHeight(TechLevel techLevel) {
        switch (techLevel) {
            case WYVERN: {
                return wyvernChestpiece[1];
            }
            case DRACONIC: {
                return draconicChestpiece[1];
            }
            case CHAOTIC: {
                return chaoticChestpiece[1];
            }
        }
        return 1;
    }

    public static int capacitorWidth(TechLevel techLevel) {
        switch (techLevel) {
            case WYVERN: {
                return wyvernCapacitor[0];
            }
            case DRACONIC: {
                return draconicCapacitor[0];
            }
            case CHAOTIC: {
                return chaoticCapacitor[0];
            }
        }
        return 1;
    }

    public static int capacitorHeight(TechLevel techLevel) {
        switch (techLevel) {
            case WYVERN: {
                return wyvernCapacitor[1];
            }
            case DRACONIC: {
                return draconicCapacitor[1];
            }
            case CHAOTIC: {
                return chaoticCapacitor[1];
            }
        }
        return 1;
    }

    private static void loadModuleStatsConfig() {
        moduleStats = new StandardConfigFile(Paths.get("./config/brandon3055/ModuleStats.cfg", new String[0])).load();
        moduleStats.setSyncToClient();
        moduleStats.setSyncCallback((configTag, syncType) -> DEModules.moduleItemMap.keySet().forEach(BaseModule::reloadData));
    }

    public static void saveStateConfig() {
        moduleStats.save();
    }

    public static ConfigTag getModuleTag(ResourceLocation moduleName) {
        ConfigTag tag = moduleStats.getTag(moduleName.toString());
        return tag;
    }

    public static boolean getOverride(ConfigTag tag) {
        if (tag.hasTag("override")) {
            return tag.getTag("override").getBoolean();
        }
        return tag.getTag("override").setComment("Set this to true if you wish to override this module's default stats.").setDefaultBoolean(false).getBoolean();
    }

    public static long getModuleLong(Module<?> module, String tagName, long defaultValue) {
        ConfigTag tag = ModuleCfg.getModuleTag(Objects.requireNonNull(module.getRegistryName()));
        boolean override = ModuleCfg.getOverride(tag);
        ConfigTag longTag = tag.getTag(tagName).setDefaultLong(defaultValue);
        if (!override) {
            longTag.setLong(defaultValue);
        }
        return longTag.getLong();
    }

    public static int getModuleInt(Module<?> module, String tagName, int defaultValue) {
        ConfigTag tag = ModuleCfg.getModuleTag(Objects.requireNonNull(module.getRegistryName()));
        boolean override = ModuleCfg.getOverride(tag);
        ConfigTag valueTag = tag.getTag(tagName).setDefaultInt(defaultValue);
        if (!override) {
            valueTag.setInt(defaultValue);
        }
        return valueTag.getInt();
    }

    public static double getModuleDouble(Module<?> module, String tagName, double defaultValue) {
        ConfigTag tag = ModuleCfg.getModuleTag(Objects.requireNonNull(module.getRegistryName()));
        boolean override = ModuleCfg.getOverride(tag);
        ConfigTag valueTag = tag.getTag(tagName).setDefaultDouble(defaultValue);
        if (!override) {
            valueTag.setDouble(defaultValue);
        }
        return valueTag.getDouble();
    }

    static {
        WYVERN_TOOLS = new Integer[]{4, 4};
        DRACONIC_TOOLS = new Integer[]{6, 5};
        CHAOTIC_TOOLS = new Integer[]{8, 6};
        DRACONIC_STAFF = new Integer[]{8, 6};
        CHAOTIC_STAFF = new Integer[]{10, 8};
        WYVERN_CHESTPIECE = new Integer[]{6, 5};
        DRACONIC_CHESTPIECE = new Integer[]{8, 6};
        CHAOTIC_CHESTPIECE = new Integer[]{10, 8};
        WYVERN_CAPACITOR = new Integer[]{4, 4};
        DRACONIC_CAPACITOR = new Integer[]{5, 5};
        CHAOTIC_CAPACITOR = new Integer[]{8, 6};
        removeInvalidModules = false;
    }
}

