/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.init;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class OreDoublingRegistry {
    public static Map<String, ItemStack> oreRecipes = new HashMap<String, ItemStack>();
    public static Map<ItemStack, ItemStack> stackToStackRecipes = new HashMap<ItemStack, ItemStack>();

    public static void init() {
    }

    public static void registerOreResult(String ore, ItemStack result) {
        oreRecipes.put(ore, result);
    }

    public static void registerResult(ItemStack input, ItemStack result) {
        stackToStackRecipes.put(input, result);
    }

    public static ItemStack getDoubledSmeltingResult(ItemStack stack, World world) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190916_E() != 1) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
        }
        if (stackToStackRecipes.containsKey(stack)) {
            return stackToStackRecipes.get(stack);
        }
        FurnaceRecipe recipe = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new RecipeWrapper((IItemHandlerModifiable)new Wrap(stack)), world).orElse(null);
        return recipe == null ? ItemStack.field_190927_a : recipe.func_77572_b((IInventory)new RecipeWrapper((IItemHandlerModifiable)new Wrap(stack)));
    }

    public static ItemStack getSmeltingResult(ItemStack stack, World world) {
        FurnaceRecipe recipe = world.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new RecipeWrapper((IItemHandlerModifiable)new Wrap(stack)), world).orElse(null);
        return recipe == null ? ItemStack.field_190927_a : recipe.func_77572_b((IInventory)new RecipeWrapper((IItemHandlerModifiable)new Wrap(stack)));
    }

    private static void registerDEOverrides() {
        OreDoublingRegistry.registerOreResult("sand", new ItemStack((IItemProvider)Blocks.field_150359_w, 2));
        OreDoublingRegistry.registerOreResult("cobblestone", new ItemStack((IItemProvider)Blocks.field_150348_b, 2));
        OreDoublingRegistry.registerOreResult("netherrack", new ItemStack((IItemProvider)Items.field_196154_dH, 2));
        OreDoublingRegistry.registerOreResult("cobblestone", new ItemStack((IItemProvider)Blocks.field_150348_b, 2));
        OreDoublingRegistry.registerResult(new ItemStack((IItemProvider)Items.field_151119_aD), new ItemStack((IItemProvider)Items.field_151118_aC, 2));
        OreDoublingRegistry.registerResult(new ItemStack((IItemProvider)Blocks.field_150434_aF), new ItemStack((IItemProvider)Items.field_222079_lj, 2));
    }

    private static class Wrap
    implements IItemHandlerModifiable {
        private ItemStack stack;

        public Wrap(ItemStack stack) {
            this.stack = stack;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.stack;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }
    }
}

