/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.jei;

import codechicken.lib.render.buffer.TransformingVertexBuilder;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.utils.GuiHelperOld;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.crafting.IFusionRecipe;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.jei.RecipeCategoryUids;
import com.brandon3055.draconicevolution.utils.ResourceHelperDE;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class FusionRecipeCategory
implements IRecipeCategory<IFusionRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private int xSize = 164;
    private int ySize = 111;

    public FusionRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ResourceHelperDE.getResource("textures/gui/jei_fusion_background.png"), 0, 0, this.xSize, this.ySize);
        this.localizedName = I18n.func_135052_a((String)DEContent.crafting_core.func_149739_a(), (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)DEContent.crafting_core));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return RecipeCategoryUids.FUSION_CRAFTING;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends IFusionRecipe> getRecipeClass() {
        return IFusionRecipe.class;
    }

    public void draw(IFusionRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71466_p != null) {
            TechLevel tier = recipe.getRecipeTier();
            int colour = tier.index == 0 ? 0x5050FF : (tier.index == 1 ? 0x8000FF : (tier.index == 2 ? 0xFF6600 : 0x505050));
            GuiHelperOld.drawCenteredString((FontRenderer)mc.field_71466_p, (MatrixStack)matrixStack, (String)I18n.func_135052_a((String)("gui.draconicevolution.fusion_craft.tier." + recipe.getRecipeTier().name().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]), (int)(this.xSize / 2), (int)5, (int)colour, (boolean)false);
            GuiHelperOld.drawCenteredString((FontRenderer)mc.field_71466_p, (MatrixStack)matrixStack, (String)I18n.func_135052_a((String)"gui.draconicevolution.fusion_craft.energy_cost", (Object[])new Object[0]), (int)(this.xSize / 2), (int)(this.ySize - 20), (int)0x4444FF, (boolean)false);
            GuiHelperOld.drawCenteredString((FontRenderer)mc.field_71466_p, (MatrixStack)matrixStack, (String)(Utils.addCommas((long)recipe.getEnergyCost()) + " OP"), (int)(this.xSize / 2), (int)(this.ySize - 10), (int)0x44AAFF, (boolean)false);
        }
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        TransformingVertexBuilder builder = new TransformingVertexBuilder(buffer.getBuffer(GuiHelperOld.TRANS_TYPE), matrixStack);
        GuiHelperOld.drawBorderedRect((IVertexBuilder)builder, (double)((double)this.xSize / 2.0 - 10.0), (double)22.0, (double)20.0, (double)66.0, (double)1.0, (int)0x40FFFFFF, (int)-16711681, (double)0.0);
        if (recipe.func_192400_c().size() > 16) {
            GuiHelperOld.drawBorderedRect((IVertexBuilder)builder, (double)3.0, (double)3.0, (double)18.0, (double)106.0, (double)1.0, (int)0x40FFFFFF, (int)-5635841, (double)0.0);
            GuiHelperOld.drawBorderedRect((IVertexBuilder)builder, (double)23.0, (double)3.0, (double)18.0, (double)106.0, (double)1.0, (int)0x40FFFFFF, (int)-5635841, (double)0.0);
            GuiHelperOld.drawBorderedRect((IVertexBuilder)builder, (double)(this.xSize - 21), (double)3.0, (double)18.0, (double)106.0, (double)1.0, (int)0x40FFFFFF, (int)-5635841, (double)0.0);
            GuiHelperOld.drawBorderedRect((IVertexBuilder)builder, (double)(this.xSize - 41), (double)3.0, (double)18.0, (double)106.0, (double)1.0, (int)0x40FFFFFF, (int)-5635841, (double)0.0);
        } else {
            GuiHelperOld.drawBorderedRect((IVertexBuilder)builder, (double)12.0, (double)3.0, (double)20.0, (double)106.0, (double)1.0, (int)0x40FFFFFF, (int)-5635841, (double)0.0);
            GuiHelperOld.drawBorderedRect((IVertexBuilder)builder, (double)(this.xSize - 32), (double)3.0, (double)20.0, (double)106.0, (double)1.0, (int)0x40FFFFFF, (int)-5635841, (double)0.0);
        }
        buffer.func_228461_a_();
    }

    public void setIngredients(IFusionRecipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> recipeIngredients = new ArrayList<Ingredient>();
        recipeIngredients.add(recipe.getCatalyst());
        recipeIngredients.addAll((Collection<Ingredient>)recipe.func_192400_c());
        ingredients.setInputIngredients(recipeIngredients);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout layout, IFusionRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup stackGroup = layout.getItemStacks();
        stackGroup.init(0, true, this.xSize / 2 - 9, this.ySize / 2 - 9 - 23);
        stackGroup.init(1, false, this.xSize / 2 - 9, this.ySize / 2 - 9 + 23);
        NonNullList<Ingredient> ingreds = recipe.func_192400_c();
        int nColumns = ingreds.size() > 16 ? 4 : 2;
        int xc = this.xSize / 2 - 9;
        int yc = this.ySize / 2 - 9;
        int rows = (int)Math.ceil((double)ingreds.size() / (double)nColumns);
        for (int i = 0; i < ingreds.size(); ++i) {
            int side;
            int n = side = i % nColumns >= nColumns / 2 ? 1 : -1;
            int offset = nColumns == 2 ? 0 : (i % 2 == 0 ? -1 : 1);
            int row = i / nColumns;
            int xPos = xc + side * (60 + offset * 10);
            int yPos = yc;
            if (rows > 1) {
                yPos = yc - 42 + 84 / (rows - 1) * row;
            }
            stackGroup.init(2 + i, true, xPos, yPos);
        }
        stackGroup.set(ingredients);
    }
}

